<div class="relative w-full bg-black bg-opacity-80">
    <div id="attendanceModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
        <div class="w-[70rem] p-2 mt-10 bg-white rounded-lg shadow-lg">
            <div class="flex flex-col px-5 py-4 bg-white rounded-2xl">
                <div class="flex items-center justify-between pb-4 border-b border-gray-200">
                    <h4 class="text-sm font-medium text-gray-900">Add Attendance</h4>
                    <button class="block cursor-pointer close-modal-button" onclick="closeModal('attendanceModal')">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path d="M7.75732 7.75739L16.2426 16.2427M16.2426 7.75739L7.75732 16.2427" stroke="black"
                                stroke-width="1.6" stroke-linecap="round" />
                        </svg>
                    </button>
                </div>
                <div class="w-full mx-2 my-5 bg-white border border-gray-200 ">


                    <div class="grid grid-cols-1 gap-10 text-xs md:grid-cols-2 ">
                        <!-- <form action="{{ route('attendance.import') }}" method="POST" enctype="multipart/form-data"
                            class="p-5 border-2 border-black">
                            @csrf
                            <p class="my-2 font-bold">Option 1</p>
                            <div class="flex flex-col ">
                                <div class="mb-4">
                                    <label for="department_id" class="block text-gray-700">Choose Department</label>
                                    <select name="department_id"
                                        class="block w-auto mt-1 border-2 border-black rounded-md shadow-sm md:w-full sm:text-sm"
                                        required>
                                        <option value="" disabled selected>Select Department</option>
                                        @foreach ($client as $department)
<option value="{{ $department->id }}">{{ $department->department_name }}
                                            </option>
@endforeach
                                    </select>

                                </div>
                                <div class="mb-4">
                                    <label for="file" class="block text-gray-700">Upload File:</label>
                                    <input type="file" name="file" id="file"
                                        class="block w-auto mt-1 border-gray-300 rounded-md shadow-sm" required>
                                    @error('file')
    <div class="mt-1 text-sm text-red-500">{{ $message }}</div>
@enderror
                                </div>
                                <div class="flex justify-end ">
                                    <button type="submit"
                                        class="px-4 py-2 text-white bg-blue-500 rounded">Import</button>
                                </div>
                            </div>
                            <div class="text-center">
                                <p>Excel Format: <a class="text-blue-600"
                                        href={{ asset('img/employee_attendance_sheet.xlsx') }}>Download</a>
                                </p>
                            </div>

                        </form> -->


                        <form id="formImport2" action="{{ route('2.import') }}" method="POST"
                            enctype="multipart/form-data" class="p-5 border-2 border-black">
                            @csrf
                            <p class="my-2 font-bold">Option 2</p>
                            <div class="flex flex-col ">
                                <div>
                                    <div class="mb-4">
                                        <label for="selection_type" class="block text-gray-700">Import type</label>
                                        <select id="selection_type" name="selection_type"
                                            class="block w-auto mt-1 border-2 border-black rounded-md shadow-sm md:w-full sm:text-sm"
                                            required>
                                            <option value="" disabled selected>Select Type</option>
                                            <option value="department">Per Department</option>
                                            <option value="store">Per Store</option>
                                        </select>
                                    </div>

                                    {{-- Department Dropdown --}}
                                    <div class="mb-4 hidden" id="department_select_wrapper">
                                        <label for="department_id" class="block text-gray-700">Choose Department</label>
                                        <select id="department_id" name="department_id"
                                            class="block w-auto mt-1 border-2 border-black rounded-md shadow-sm md:w-full sm:text-sm">
                                            <option value="" disabled selected>Select Department</option>
                                            @foreach ($client as $department)
                                                <option value="{{ $department->id }}">{{ $department->department_name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>

                                    {{-- Store Dropdown --}}
                                    <div class="mb-4 hidden" id="store_select_wrapper">
                                        <label for="store_id" class="block text-gray-700">Choose Store</label>
                                        <select id="store_id" name="store_id"
                                            class="block w-auto mt-1 border-2 border-black rounded-md shadow-sm md:w-full sm:text-sm">
                                            <option value="" disabled selected>Select Store</option>
                                            @foreach ($stores as $store)
                                                <option value="{{ $store->id }}">{{ $store->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <script>
                                        document.addEventListener("DOMContentLoaded", function() {
                                            const selectionType = document.getElementById("selection_type");
                                            const departmentWrapper = document.getElementById("department_select_wrapper");
                                            const storeWrapper = document.getElementById("store_select_wrapper");

                                            selectionType.addEventListener("change", function() {
                                                if (this.value === "department") {
                                                    departmentWrapper.classList.remove("hidden");
                                                    storeWrapper.classList.add("hidden");
                                                } else if (this.value === "store") {
                                                    storeWrapper.classList.remove("hidden");
                                                    departmentWrapper.classList.add("hidden");
                                                } else {
                                                    departmentWrapper.classList.add("hidden");
                                                    storeWrapper.classList.add("hidden");
                                                }
                                            });
                                        });
                                    </script>
                                    <div class="mb-4">
                                        <label for="file" class="block text-gray-700">Choose an Excel or CSV
                                            file</label>
                                        <input type="file" name="file" id="file"
                                            class="block w-auto mt-1 border-gray-300 rounded-md shadow-sm md:w-full sm:text-sm">
                                        @error('file')
                                            <span class="text-red-500">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="flex items-center justify-end gap-2">

                                    <button type="submit" id="importButton"
                                        class="flex items-center justify-center px-4 py-2 font-bold text-white bg-blue-500 rounded hover:bg-blue-700">
                                        <span id="buttonText">Import</span>
                                        <span id="loadingIndicator" class="hidden ml-2">
                                            <svg class="w-5 h-5 text-white animate-spin"
                                                xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                                                <circle class="opacity-25" cx="12" cy="12" r="10"
                                                    stroke="currentColor" stroke-width="4"></circle>
                                                <path class="opacity-75" fill="currentColor"
                                                    d="M4 12a8 8 0 018-8v4l3.5-3.5L12 0v4a8 8 0 01-8 8z"></path>
                                            </svg>
                                        </span>
                                    </button>


                                </div>
                            </div>
                            <div class="text-center">
                                <p>Excel Format: <a class="text-blue-600"
                                        href={{ asset('uploads/attendance_data_1001.xlsx') }}>Download</a>
                                </p>
                            </div>
                        </form>
                    </div>







                    <form action="{{ route('attendance.store') }}" method="POST">
                        @csrf
                        <div class="grid grid-cols-2 gap-4">
                            <div class="mt-4">
                                <label for="employee_id"
                                    class="block mb-2 text-sm font-medium text-gray-700">Employee</label>
                                <select name="employee_id" id="employee_id"
                                    class="mt-1 block w-full border-2 border-black h-10 rounded-md shadow-sm @error('employee_id') border-red-500 @enderror"
                                    required>
                                    <option value="" disabled selected>Select an employee</option>
                                    @foreach ($employees as $employee)
                                        <option value="{{ $employee->id }}">
                                            {{ $employee->first_name }} {{ $employee->middle_name }}
                                            {{ $employee->last_name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('employee_id')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="mt-4">
                                <label for="client_id" class="block mb-2 text-sm font-medium text-gray-700">Select
                                    Client</label>
                                <select name="department_id" id="client_id"
                                    class="mt-1 block w-full border-2 border-black h-10 rounded-md shadow-sm @error('client_id') border-red-500 @enderror">
                                    <option value="">Select Client</option>
                                </select>
                                @error('client_id')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="mt-4">
                                <label for="date" class="block text-sm font-medium text-gray-700">Date</label>
                                <input type="date" name="date" id="date"
                                    class="mt-1 block w-full border-2 border-black h-10 rounded-md shadow-sm @error('date') border-red-500 @enderror"
                                    required>
                                @error('date')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="mt-4">
                                <label for="time_in" class="block text-sm font-medium text-gray-700">Time In</label>
                                <input type="time" name="time_in" id="time_in"
                                    class="mt-1 block w-full border-2 border-black h-10 rounded-md shadow-sm @error('time_in') border-red-500 @enderror"
                                    required>
                                @error('time_in')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="mt-4">
                                <label for="time_out" class="block text-sm font-medium text-gray-700">Time Out</label>
                                <input type="time" name="time_out" id="time_out"
                                    class="mt-1 block w-full border-2 border-black h-10 rounded-md shadow-sm @error('time_out') border-red-500 @enderror"
                                    required>
                                @error('time_out')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>

                            <div class="mt-4">
                                <label for="notes" class="block text-sm font-medium text-gray-700">Notes</label>
                                <input type="text" name="notes" id="notes"
                                    class="mt-1 block w-full border-2 border-black h-10 rounded-md shadow-sm @error('notes') border-red-500 @enderror"
                                    maxlength="255">
                                @error('notes')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        <div class="flex justify-center ">
                            <button type="submit" class="px-4 py-2 mt-4 text-white bg-green-600 rounded-md">Create
                                Attendance</button>
                        </div>

                        <script>
                            document.addEventListener('DOMContentLoaded', function() {
                                // Initialize Select2 on client_id and employee_id
                                $('#client_id').select2({
                                    placeholder: "Select Client",
                                    allowClear: true,
                                    width: '100%' // Ensure it takes the full width
                                });

                                $('#employee_id').select2({
                                    placeholder: "Select Employee",
                                    allowClear: true,
                                    width: '100%' // Ensure it takes the full width
                                });
                            });
                        </script>



                        <script>
                            // Initialize select2
                            document.addEventListener('DOMContentLoaded', function() {
                                $('#employee_id').select2({
                                    placeholder: "Select Employee",
                                    allowClear: true,
                                    width: '100%' // Ensure it takes the full width
                                });

                                $('#client_id').select2({
                                    placeholder: "Select Client",
                                    allowClear: true,
                                    width: '100%' // Ensure it takes the full width
                                });

                                // When employee is selected, fetch clients for that employee
                                $('#employee_id').change(function() {
                                    const employeeId = $(this).val(); // Get selected employee's ID

                                    if (employeeId) {
                                        // Send an AJAX request to get the clients for the selected employee
                                        $.ajax({
                                            url: "{{ route('clients.by.employee') }}", // The route we defined in web.php
                                            type: 'GET',
                                            data: {
                                                employee_id: employeeId // Pass the employee ID
                                            },
                                            success: function(response) {
                                                let clientSelect = $('#client_id');
                                                clientSelect.empty(); // Clear the existing options
                                                clientSelect.append(
                                                    '<option value="">Select Client</option>'); // Default option

                                                // Add the clients to the dropdown
                                                response.forEach(function(client) {
                                                    clientSelect.append('<option value = "' + client.id +
                                                        '">' + client.name + '</option>'
                                                    ); // Assuming 'name' is the client property
                                                });

                                                clientSelect.trigger('change'); // Reinitialize select2 after update
                                            },
                                            error: function(xhr, status, error) {
                                                console.error('Error fetching clients:', error);
                                            }
                                        });
                                    }
                                });
                            });
                        </script>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function openModal(modalId) {
        var modal = document.getElementById(modalId);
        modal.classList.remove('hidden');
        modal.classList.add('flex');
    }

    // Function to close a modal
    function closeModal(modalId) {
        var modal = document.getElementById(modalId);
        modal.classList.add('hidden');
        modal.classList.remove('flex');
    }
</script>
