@extends('layouts.sidebar')
@section('title', 'Attendance')
@section('content')
    <div>
        <a href="{{ route('attendance.index') }}">
            < Back </a>
    </div>
    <div class="mx-auto mt-20 cotainer max-w-screen-2xl">
        <div class="py-2 text-xl font-bold text-center border-2 border-b-4 border-black">
            EMPLOYEE ATTENDANCE LOG
        </div>
        <div class="flex justify-end mt-5"> <a href="#" id="exportPdfBtn"
                class="flex-shrink-0 px-4 py-2 bg-green-600 text-white rounded-md font-semibold hover:bg-green-700 transition">
                Export PDF
            </a></div>
        <div class="flex items-center gap-10 mx-10 mt-5">
            <div class="flex flex-col items-center gap-3 md:flex-row">
                <div class="px-2 w-[4.5rem] text-white bg-black rounded-md">ID No:</div>
                <div>{{ $dtr?->dtr_id ?? ($dtr?->employee_id ?? 'N/A') }}</div>
            </div>
            <div class="flex flex-col items-center gap-3 md:flex-row">
                <div class="px-2 w-[4.5rem] text-white bg-black rounded-md">Dept:</div>
                <div>{{ $department->department_name }}</div>
            </div>
        </div>
        <div class="flex flex-col items-center gap-3 mx-10 mt-5 md:flex-row">
            <div class="px-2 w-[4.5rem] text-white bg-black rounded-md">Name:</div>
            <div>{{ $employee->first_name }} {{ $employee->middle_name }} {{ $employee->last_name }}</div>
        </div>
        <div class="mt-10">
            <div class="flex flex-wrap items-center justify-between gap-5 mb-5 mr-3">
                <!-- Date Filter -->
                <div class="flex items-end gap-3 flex-shrink-0">
                    <div class="flex flex-col gap-1">
                        <label for="startDate" class="text-sm font-semibold">Start Date</label>
                        <input type="date" id="startDate" class="border rounded px-2 py-1">
                    </div>
                    <div class="flex flex-col gap-1">
                        <label for="endDate" class="text-sm font-semibold">End Date</label>
                        <input type="date" id="endDate" class="border rounded px-2 py-1">
                    </div>
                    <button id="filterDateBtn"
                        class="px-4 py-2 text-white bg-blue-600 rounded-md font-semibold hover:bg-blue-700 transition">
                        Filter
                    </button>
                </div>
                <form id="approveAttendanceForm" class="flex-shrink-0">
                    @csrf
                    <input type="hidden" id="employee_id" name="employee_id" value="{{ $employee->id }}" required>
                    <input type="hidden" id="department_id" name="department_id" value="{{ $department->id }}" required>
                    <button type="submit"
                        class="w-40 rounded-md py-2 bg-blue-600 text-white font-semibold hover:bg-blue-700 transition">
                        Approve All
                    </button>
                </form>
            </div>

            <!-- Approve All Script -->
            <script>
                document.getElementById("approveAttendanceForm").addEventListener("submit", function(event) {
                    event.preventDefault();

                    let employeeId = document.getElementById("employee_id").value;
                    let departmentId = document.getElementById("department_id").value;

                    axios.post("{{ route('attendance.approve') }}", {
                            employee_id: employeeId,
                            department_id: departmentId,
                            _token: "{{ csrf_token() }}"
                        })
                        .then(response => {
                            $('#agencyTable').DataTable().ajax.reload(null, false);
                        })
                        .catch(error => {
                            alert(error.response?.data?.message || "An error occurred.");
                        });
                });
            </script>
            <table id="agencyTable" data-echo="true" data-table-selector="#myTable"
                class="min-w-full bg-white border border-gray-200 rounded shadow-md ">
                <thead>
                    <tr class="text-sm leading-normal text-white  bg-[#1d1d1d]">
                        <th>Selfie</th>
                        <th>Date</th>
                        <th>Time In</th>
                        <th>Break Out</th>
                        <th>Break In</th>
                        <th>Time Out</th>
                        <th>OT In</th>
                        <th>OT Out</th>
                        <th>Hours</th>

                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody class="text-sm font-light text-center text-gray-600">
                    <!-- DataTables will populate this body -->
                </tbody>
                <tfoot>
                    <tr class="text-sm font-medium text-gray-800 bg-gray-100">
                        <td colspan="7" class="font-bold text-right">Total Hours Worked:</td>
                        <td class="text-center" id="totalHoursWorked">0</td>
                        <td colspan="1" class="font-bold text-right"></td>

                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
    <script>
        document.querySelectorAll('[data-echo="true"]').forEach((el) => {
            const selector = el.getAttribute('data-table-selector');
            setupRealtimeAttendance(selector);
        });
    </script>
    <script>
        $(document).ready(function() {
            var employeeId = "{{ $employee->id ?? '' }}";
            var departmentId = "{{ $department->id ?? '' }}";

            if (!employeeId || !departmentId) {
                console.error("Missing employee_id or department_id");
                return;
            }

            var table = $('#agencyTable').DataTable({
                processing: true,
                serverSide: true,
                pageLength: 20,
                ajax: {
                    url: "{{ route('summaryattendance', ['employee_id' => '__EMPLOYEE_ID__', 'department_id' => '__DEPARTMENT_ID__']) }}"
                        .replace('__EMPLOYEE_ID__', employeeId)
                        .replace('__DEPARTMENT_ID__', departmentId),
                    data: function(d) {
                        d.startDate = $('#startDate').val();
                        d.endDate = $('#endDate').val();
                    }
                },
                columns: [{
                        data: 'selfie21',
                        name: 'selfie21'
                    }, {
                        data: 'date',
                        name: 'date'
                    },
                    {
                        data: 'time_in',
                        name: 'time_in',
                        render: function(data, type, row) {
                            let value = data ? data : '';
                            return `<input type="time" class="editable-input time-in" data-id="${row.id}" value="${value}">`;
                        }
                    },
                    {
                        data: 'break_out',
                        name: 'break_out',
                        render: function(data, type, row) {
                            let value = data ? data : '';
                            return `<input type="time" class="editable-input break-out" data-id="${row.id}" value="${value}">`;
                        }
                    },
                    {
                        data: 'break_in',
                        name: 'break_in',
                        render: function(data, type, row) {
                            let value = data ? data : '';
                            return `<input type="time" class="editable-input break-in" data-id="${row.id}" value="${value}">`;
                        }
                    },
                    {
                        data: 'time_out',
                        name: 'time_out',
                        render: function(data, type, row) {
                            let value = data ? data : '';
                            return `<input type="time" class="editable-input time-out" data-id="${row.id}" value="${value}">`;
                        }
                    },
                    {
                        data: 'ot_in',
                        name: 'ot_in',
                        render: function(data, type, row) {
                            let value = data ? data : '';
                            return `<input type="time" class="editable-input ot-in" data-id="${row.id}" value="${value}">`;
                        }
                    },
                    {
                        data: 'ot_out',
                        name: 'ot_out',
                        render: function(data, type, row) {
                            let value = data ? data : '';
                            return `<input type="time" class="editable-input ot-out" data-id="${row.id}" value="${value}">`;
                        }
                    },
                    {
                        data: 'hours_worked',
                        name: 'hours_worked'
                    },

                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ],
                footerCallback: function(row, data, start, end, display) {
                    var api = this.api();
                    var totalMinutes = api
                        .column(8, {
                            page: 'current'
                        }) // Target the "Hours Worked" column (index 3)
                        .data()
                        .reduce(function(acc, val) {
                            // Extract hours and minutes from the string
                            var match = val.match(/(\d+)\s*hrs\s*(\d*)\s*mins?/);
                            var hours = match ? parseInt(match[1]) : 0;
                            var minutes = match && match[2] ? parseInt(match[2]) : 0;

                            return acc + (hours * 60) + minutes; // Convert to total minutes
                        }, 0);

                    // Convert total minutes back to hours and minutes
                    var totalHours = Math.floor(totalMinutes / 60);
                    var remainingMinutes = totalMinutes % 60;

                    // Update the footer with the total hours and minutes
                    $('#totalHoursWorked').html(totalHours + ' hrs ' + remainingMinutes + ' mins');
                }


            });

            $('#filterDateBtn').on('click', function() {
                table.ajax.reload();
            });
            $('#exportPdfBtn').on('click', function(e) {
                e.preventDefault();
                let startDate = $('#startDate').val();
                let endDate = $('#endDate').val();
                let url = "{{ route('attendance.pdf') }}" +
                    `?startDate=${startDate}&endDate=${endDate}&employee_id={{ $employee->id }}&department_id={{ $department->id }}`;
                window.open(url, '_blank');
            });
            // Handle inline edit and save changes
            $(document).on('change', '.editable-input', function() {
                var recordId = $(this).data('id'); // Get the row ID
                var field = ''; // Variable to hold the field name
                var newValue = $(this).val(); // Get the new value

                // Determine which field is being edited based on class
                if ($(this).hasClass('time-in')) {
                    field = 'time_in';
                } else if ($(this).hasClass('time-out')) {
                    field = 'time_out';
                } else if ($(this).hasClass('break-in')) {
                    field = 'break_in';
                } else if ($(this).hasClass('break-out')) {
                    field = 'break_out';
                } else if ($(this).hasClass('ot-in')) {
                    field = 'ot_in';
                } else if ($(this).hasClass('ot-out')) {
                    field = 'ot_out';
                }

                // CSRF token setup (in case meta tag is missing)
                var csrfToken = $('meta[name="csrf-token"]').attr('content');

                // Send AJAX request to update the value
                $.ajax({
                    url: "{{ route('update.attendance') }}", // Adjust to your update route
                    method: "POST",
                    headers: {
                        'X-CSRF-TOKEN': csrfToken // Set CSRF token in request header
                    },
                    data: {
                        _token: csrfToken,
                        id: recordId,
                        field: field,
                        value: newValue
                    },
                    success: function(response) {
                        console.log("✅ Success:", response.message);
                        table.ajax.reload(null, false); // Reload the table data
                    },
                    error: function(xhr) {
                        console.error("❌ Error updating record:", xhr.responseText);
                    }
                });
            });

        });

        function printAttendance() {
            let content = document.querySelector('.mx-auto.mt-20').innerHTML;
            let original = document.body.innerHTML;
            document.body.innerHTML = content;
            window.print();
            document.body.innerHTML = original;
            location.reload();
        }
    </script>
    <style>
        @media print {
            body * {
                visibility: hidden;
            }

            .mx-auto.mt-20,
            .mx-auto.mt-20 * {
                visibility: visible;
            }

            .mx-auto.mt-20 {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
            }

            button,
            input,
            form {
                display: none !important;
            }
        }
    </style>

    <!-- Delete Modal -->
    <div id="deleteModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
        <div class="bg-white rounded-lg shadow-lg p-6 w-auto md:w-[30rem] mt-20">
            <h2 class="mb-4 text-lg font-bold">Delete Record</h2>
            <p>Are you sure you want to delete this record?</p>
            <form id="deleteForm">
                @csrf
                <input type="hidden" id="deleteRecordId" name="id">
                <div class="flex justify-end mt-6">
                    <button type="button" onclick="closeModal('deleteModal')"
                        class="px-4 py-2 mr-2 text-gray-700 bg-gray-200 rounded">Cancel</button>
                    <button type="submit" class="px-4 py-2 text-white bg-red-600 rounded">Delete</button>
                </div>
            </form>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            // Open Delete Modal
            window.openDeleteModal = function(recordId) {
                $('#deleteRecordId').val(recordId);
                $('#deleteModal').removeClass('hidden');
            };

            // Submit Delete Form
            $('#deleteForm').on('submit', function(e) {
                e.preventDefault();
                let recordId = $('#deleteRecordId').val();
                let deleteUrl = "{{ route('attendance.destroy', ':id') }}".replace(':id', recordId);

                $.ajax({
                    url: deleteUrl,
                    type: "DELETE",
                    data: {
                        _token: "{{ csrf_token() }}"
                    },
                    success: function(response) {
                        if (response.success) {
                            $('#successModal').removeClass('hidden'); // Show success modal
                            $('#deleteForm')[0].reset(); // Reset form
                            $('#deleteModal').addClass('hidden'); // Close modal
                            $('#agencyTable').DataTable().ajax.reload(null,
                                false); // Reload table without resetting pagination
                        }
                    },
                    error: function(xhr) {
                        alert('Error deleting record.');
                    }
                });
            });

            // Close Modal Function
            window.closeModal = function(modalId) {
                $('#' + modalId).addClass('hidden');
            };
        });
    </script>

    <div id="approveModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-black bg-opacity-50">
        <div class="p-6 mt-20 bg-white rounded-lg shadow-lg">
            <h2 class="mb-4 text-lg font-bold">Approve DTR</h2>
            <p>Are you sure you want to approve this DTR?</p>
            <div class="flex justify-end gap-4 mt-4">
                <button onclick="closeApproveModal('approveModal')"
                    class="px-4 py-2 text-white bg-gray-500 rounded-md">Cancel</button>
                <button id="confirmApproveBtn" class="px-4 py-2 text-white bg-green-600 rounded-md">Approve</button>
            </div>
        </div>
    </div>
    <script>
        let selectedAttendanceId = null;

        // Open modal and store attendanceId
        function openApproveModal(attendanceId) {
            selectedAttendanceId = attendanceId;
            document.getElementById('approveModal').classList.remove('hidden');
        }

        // Close modal
        function closeApproveModal(id) {
            document.getElementById(id).classList.add('hidden');
            selectedAttendanceId = null;
        }

        // Approve function with axios
        function approveDTR() {
            if (!selectedAttendanceId) return;

            axios.post("{{ route('attendance.approve') }}", {
                    id: selectedAttendanceId,
                    _token: "{{ csrf_token() }}"
                })
                .then(response => {

                    document.getElementById('approveModal').classList.add('hidden');
                    $('#agencyTable').DataTable().ajax.reload(null, false);
                    $('#successapprove').removeClass('hidden'); // Show success modal
                })
                .catch(error => {
                    alert(error.response?.data?.message || "An error occurred.");
                });
        }

        // Attach approveDTR function to confirm button
        document.getElementById('confirmApproveBtn').addEventListener('click', approveDTR);
    </script>

    <div id="successapprove" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-black bg-opacity-50">
        <div class="p-5 mt-20 bg-white rounded-lg shadow-lg w-96">
            <h2 class="text-lg font-bold text-center">Success</h2>
            <p class="mt-2 text-center text-gray-700">successfully Approved!</p>
            <div class="mt-4 text-center">
                <button onclick="closeApproveModal('successapprove')"
                    class="px-4 py-2 text-white bg-blue-500 rounded-lg hover:bg-blue-700">
                    OK
                </button>
            </div>
        </div>
    </div>


@endsection
