<div id="secondDiv" class="hidden overflow-auto border-2 border-black rounded-md ">
    <div class="flex items-center justify-start px-2 text-xs"> <button id="showFirst"
            class="w-[10rem]  py-2 mt-2 text-white bg-blue-500 rounded-md">Show Per Employee
            Dtr</button></div>
    <div class="p-2 ">

        <div class="flex flex-wrap items-center justify-end gap-4 p-4 ">
            <div class="flex flex-col">
                <label for="start_date" class="text-sm font-medium text-gray-700">Start Date</label>
                <input type="date" id="start_date"
                    class="w-48 p-2 mt-1 text-gray-900 border border-gray-300 rounded-lg shadow-sm focus:ring-blue-500 focus:border-blue-500">
            </div>

            <div class="flex flex-col">
                <label for="end_date" class="text-sm font-medium text-gray-700">End Date</label>
                <input type="date" id="end_date"
                    class="w-48 p-2 mt-1 text-gray-900 border border-gray-300 rounded-lg shadow-sm focus:ring-blue-500 focus:border-blue-500">
            </div>

            <button id="updateStatusBtn"
                class="px-6 py-2 mt-6 text-white transition duration-300 bg-blue-600 rounded-lg shadow-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-400">
                Remove Check
            </button>
        </div>
        <table id="agencyTable" class="min-w-full bg-white border border-gray-200 rounded shadow-md ">
            <thead>
                <tr class="text-sm leading-normal text-white  bg-[#1d1d1d]">
                    <th>Employee ID</th>
                    <th>Client Name</th>
                    <th>Name Employee</th>
                    <th>Date</th>
                    <th>Time In</th>
                    <th>Break Out</th>
                    <th>Break In</th>
                    <th>Time Out</th>
                    <th>Notes</th>
                    <th>status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody class="text-sm font-light text-center text-gray-600">
                <!-- DataTables will populate this body -->
            </tbody>
        </table>
    </div>
</div>



<div id="firstDiv" class="overflow-auto border-2 border-black rounded-md ">
    <div class="flex items-center justify-start px-2 text-xs"> <button id="showSecond"
            class="w-[10rem]  py-2 mt-2 text-white bg-blue-500 rounded-md">Show All Dtr</button>
    </div>
    <div class="p-2 ">
        <table id="employeefordtrTable" class="min-w-full bg-white border border-gray-200 rounded shadow-md ">
            <thead>
                <tr class="text-sm leading-normal text-white  bg-[#1d1d1d]">
                    <th>Employee ID</th>
                    <th>Client Name</th>
                    <th>Name Employee</th>
                    <th>Period</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody class="text-sm font-light text-center text-gray-600">
                <!-- DataTables will populate this body -->
            </tbody>
        </table>
    </div>
</div>
<script>
    $(document).ready(function() {
        // Initialize DataTable
        var table = $('#employeefordtrTable').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('employeefordtr') }}",
            columns: [{
                    data: 'employee_id',
                    name: 'employee_id'
                },
                {
                    data: 'client_name',
                    name: 'client_name'
                },
                {
                    data: function(row) {
                        return row.employee.first_name + ' ' + (row.employee.middle_name ??
                            '') + ' ' + row.employee.last_name;
                    },
                    name: 'first_name'
                },
                {
                    data: 'period',
                    name: 'period'
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                }
            ]
        });
    });
</script>
