@extends('layouts.sidebar')
@section('title', 'Deduction')
@section('content')
    @if (in_array('Manage Attendance', $privileges))

        <div class="flex flex-col items-center justify-between gap-5 mb-5 mr-10 text-sm md:flex-row ">
            <div>
                <p class="font-bold">
                    @if (request()->routeIs('deduction'))
                        Deductions
                    @else
                        Earnings
                    @endif
                </p>
            </div>
            <div class="flex items-center justify-end gap-5">
                <div>
                    <span>Excel Template:<a href="{{ asset('uploads/Deduction_SAMPLE (Aug 1-15, 2024).xlsx') }}"
                            target="_black" class="text-blue-500"> Download
                        </a></span>
                </div>
                <button id="reopenFailedRowsModal" class="hidden px-4 py-2 text-white bg-red-500 rounded-md ">
                    Reopen Failed Rows
                </button>
                <button id="openModalButton" onclick="openModal('adjustmentModal')"
                    class="px-4 py-2 text-white bg-gray-800 rounded-md hover:bg-blue-600 focus:outline-none focus:ring-2 focus:ring-blue-400 focus:ring-opacity-50">

                    @if (request()->routeIs('deduction'))
                        Add Deduction
                    @else
                        Add Earnings
                    @endif

                </button>
            </div>
        </div>

        @if (session('success'))
            <div class="p-4 mb-4 text-white bg-green-500">
                {{ session('success') }}
            </div>
        @endif



        <!-- Failed Rows Modal -->
        <div id="failedRowsModal"
            class="fixed inset-0 z-50 flex items-center justify-center hidden bg-gray-800 bg-opacity-50">
            <div class="bg-white p-5 rounded-lg shadow-lg w-3/4 overflow-auto h-[40rem]">

                <div class="flex justify-between gap-5 pb-2 mt-3">
                    <div>
                        <h2 class="mb-3 text-xl font-semibold">Import Failed Rows</h2>
                    </div>
                    <div> <button id="printFailedRowsModal" onclick="printTable('#failedRowsModal')"
                            class="px-4 py-2 text-white bg-blue-500 rounded">Print</button>
                        <button id="closeFailedRowsModal" onclick="closeModal('#failedRowsModal')"
                            class="px-4 py-2 text-white bg-red-500 rounded hover:bg-red-700">
                            Close
                        </button>
                    </div>
                </div>
                <div class="overflow-x-auto">
                    <table class="min-w-full text-sm bg-white border text-nowrap">
                        <thead>
                            <tr class="bg-gray-200">

                                <th class="px-3 border-2 border-black">Message</th>
                            </tr>
                        </thead>
                        <tbody id="failedRowsBody"></tbody>
                    </table>
                </div>

                <!-- Buttons -->

            </div>
        </div>

        <div class="p-2 border-2 border-black rounded-md "> <!-- DataTable -->
            <table id="agencyTable" class="min-w-full bg-white border border-collapse border-gray-200 rounded shadow-md">
                <thead>
                    <tr class="text-sm leading-normal text-white bg-[#1d1d1d]">
                        <th>Name</th>
                        <th>Department Name</th>
                        <th>Pay Period Start</th>
                        <th>Pay Period End</th>

                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody class="text-sm font-light text-center text-gray-600"></tbody>
            </table>
        </div>

        <!-- jQuery & DataTables -->

        @include('Admin.Attendance.deduction_earnings.modal')





        <script>
            $(document).on('change', '.status-checkbox', function() {
                let checkbox = $(this);
                let attendanceId = checkbox.data('id');
                let newStatus = checkbox.is(':checked') ? 1 : null;

                $.ajax({
                    url: "{{ route('ptsr.update-status', ':id') }}".replace(':id', attendanceId),
                    type: "POST",
                    data: {
                        status: newStatus,
                        _token: "{{ csrf_token() }}"
                    },
                    success: function(response) {
                        alert(response.message);
                        $('#agencyTable').DataTable().ajax.reload(null,
                            false); // Reload table without resetting pagination
                    },
                    error: function(error) {
                        console.log(error);
                    }
                });
            });
        </script>






    @endif
@endsection
