@extends('layouts.sidebar')
@section('title', 'Attendance')
@section('content')
    @if (in_array('Manage Attendance', $privileges))

        @include('Admin.Attendance.incomplete.modal')
        <div class="flex justify-between py-5">
            <h1 class="mb-4 text-2xl font-bold">Attendace</h1>
            <button type="button"
                class="modal-button py-2.5 px-5 text-xs bg-black text-white rounded cursor-pointer font-semibold text-center shadow-xs transition-all duration-500 hover:bg-indigo-700"
                data-pd-overlay="#subscribe-form-modal" data-modal-target="subscribe-form-modal"
                data-modal-toggle="subscribe-form-modal">
                Add Agency
            </button>
        </div>
        @if (session('success'))
            <div class="p-4 mb-4 text-white bg-green-500">
                {{ session('success') }}
            </div>
        @endif

        <form action="{{ route('attendance.import') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="mb-4">
                <label for="file" class="block text-gray-700">Upload File:</label>
                <input type="file" name="file" id="file"
                    class="block w-full mt-1 border-gray-300 rounded-md shadow-sm" required>
                @error('file')
                    <div class="mt-1 text-sm text-red-500">{{ $message }}</div>
                @enderror
            </div>
            <button type="submit" class="px-4 py-2 text-white bg-blue-500 rounded">Import</button>
        </form>

        <div class="overflow-auto">
            <table id="agencyTable" class="min-w-full bg-white border border-gray-200 rounded shadow-md ">
                <thead>
                    <tr class="text-sm leading-normal h-12 text-white uppercase bg-[#1d1d1d]">
                        <th>Employee ID</th>
                        <th>Name Employee</th>
                        <th>Time In</th>
                        <th>Time Out</th>
                        <th>Notes</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody class="text-sm font-light text-center text-gray-600">
                    <!-- DataTables will populate this body -->
                </tbody>
            </table>
        </div>
    @else
        <div class="my-2 flex h-full w-full justify-center items-center">
            <div>
                <i class="text-3xl bx bx-lock mr-2"></i> <!-- Large lock icon indicating no access -->
                <span class="text-gray-500">You don't have privilege to access this page</span>
            </div>

        </div>
    @endif
    <script>
        $(document).ready(function() {
            $('#agencyTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('attendance.index1') }}", // Pointing to the index route
                columns: [{
                        data: 'employee_id',
                        name: 'employee_id'
                    },

                    {
                        data: function(row) {
                            return row.employee.first_name + ' ' + row.employee.middle_name + ' ' +
                                row.employee.last_name;
                        },
                        name: 'employee.first_name', // You can use any field name for sorting or searching
                        render: function(data, type, row) {
                            // Concatenate first, middle, and last name for display
                            return row.employee.first_name + ' ' + row.employee.middle_name + ' ' +
                                row.employee.last_name;
                        }
                    },
                    {
                        data: 'time_in',
                        name: 'time_in'
                    },
                    {
                        data: 'time_out',
                        name: 'time_out'
                    },
                    {
                        data: 'notes',
                        name: 'notes'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    } // No sorting/searching on action column
                ]
            });
        });
    </script>
@endsection
