@extends('layouts.sidebar')
@section('title', 'DTR Request')

@section('content')
    @if (in_array('Dtr Request', $privileges))
        <div class="p-6 bg-white shadow-md rounded-xl">
            <!-- Header -->
            <div class="flex flex-col md:flex-row md:items-center justify-between gap-4 mb-6">
                <!-- Title -->
                <h1 class="text-2xl font-bold text-gray-800">📑 DTR Requests</h1>

                <!-- Controls -->
                <div class="flex items-center gap-3">
                    <!-- Filter -->
                    <select id="statusFilter"
                        class="p-2.5 border border-gray-300 rounded-lg text-sm focus:ring-2 focus:ring-blue-400 focus:border-blue-400 transition">
                        <option value="">All Status</option>
                        <option value="Approved">✅ Approved</option>
                        <option value="Rejected">❌ Rejected</option>
                        <option value="Pending">⏳ Pending</option>
                    </select>

                    <!-- Add Request Button -->
                    <button onclick="openModal('dtrModal')"
                        class="flex items-center gap-2 px-4 py-2 bg-blue-600 text-white rounded-lg shadow hover:bg-blue-700 transition">
                        Add Request
                    </button>
                </div>
            </div>

            <!-- Table -->
            <div class="overflow-x-auto">
                <table class="w-full border border-gray-200 rounded-lg text-sm text-gray-700" id="dtrRequestsTable">
                    <thead class="bg-gray-100 text-gray-600 uppercase text-xs">
                        <tr>
                            <th class="px-4 py-3 text-left">Employee Name</th>
                            <th class="px-4 py-3 text-left">Date</th>
                            <th class="px-4 py-3 text-left">Type</th>
                            <th class="px-4 py-3 text-left">Time</th>
                            <th class="px-4 py-3 text-left">Status</th>
                            <th class="px-4 py-3 text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100 bg-white"></tbody>
                </table>
            </div>
        </div>


        <!-- Modal -->
        <div id="dtrModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden z-50">
            <div class="bg-white rounded-lg w-full max-w-md p-6 shadow-lg">
                <form id="dtrForm" method="POST" class="space-y-4">
                    @csrf

                    <h2 class="text-lg font-semibold mb-4">Add DTR Request</h2>

                    <!-- Date -->
                    <div>
                        <label class="block text-sm font-medium mb-1">Date</label>
                        <input type="date" name="date" required
                            class="w-full p-2 border rounded-md focus:ring focus:ring-blue-300">
                    </div>

                    <!-- Type -->
                    <div>
                        <label class="block text-sm font-medium mb-1">Type</label>
                        <select name="type" required class="w-full p-2 border rounded-md focus:ring focus:ring-blue-300">
                            <option value="">-- Select --</option>
                            <option value="time_in">Time In</option>
                            <option value="time_out">Time Out</option>
                            <option value="Overtime">Overtime</option>
                        </select>
                    </div>

                    <!-- Time -->
                    <div>
                        <label class="block text-sm font-medium mb-1">Time</label>
                        <input type="time" name="time" required
                            class="w-full p-2 border rounded-md focus:ring focus:ring-blue-300">
                    </div>

                    <!-- Employee dropdown (only for non-role 9) -->
                    @if (auth()->user()->role_id != 9)
                        <div>
                            <label class="block text-sm font-medium mb-1">Employee</label>
                            <select name="employee_id" required
                                class="w-full p-2 border rounded-md focus:ring focus:ring-blue-300">
                                <option value="">-- Select Employee --</option>
                                @foreach ($employees as $employee)
                                    <option value="{{ $employee->id }}">{{ $employee->first_name }}</option>
                                @endforeach
                            </select>
                        </div>
                    @endif

                    <!-- Buttons -->
                    <div class="flex justify-end space-x-2 pt-2">
                        <button onclick="closeModal('dtrModal')"
                            class="px-4 py-2 border rounded-md text-gray-600 hover:bg-gray-100 transition">
                            Cancel
                        </button>
                        <button type="submit"
                            class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 transition">
                            Save
                        </button>
                    </div>
                </form>
            </div>
        </div>
        <div id="deleteModal" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center hidden z-50">
            <div class="bg-white rounded-lg p-6 w-full max-w-sm shadow-lg">
                <h2 class="text-lg font-semibold mb-4">Confirm Delete</h2>
                <p class="text-gray-600 mb-4">Are you sure you want to delete this DTR Request?</p>

                <div class="flex justify-end space-x-2">
                    <button onclick="closeModal('deleteModal')"
                        class="px-4 py-2 border rounded-md text-gray-600 hover:bg-gray-100">
                        Cancel
                    </button>
                    <button id="confirmDelete" class="px-4 py-2 bg-red-600 text-white rounded-md hover:bg-red-700">
                        Delete
                    </button>
                </div>
            </div>
        </div>
    @else
        <span></span>
    @endif
    <script>
        let deleteId = null;

        // Open modal
        document.addEventListener("click", e => {
            if (e.target.classList.contains("delete-btn")) {
                deleteId = e.target.dataset.id;
                openModal("deleteModal");
            }
        });

        // Confirm delete
        document.getElementById("confirmDelete").onclick = () => {
            if (!deleteId) return;

            // Use route() with placeholder then replace :id
            let deleteUrl = `{{ route('dtr_requests.destroy', ':id') }}`.replace(':id', deleteId);

            axios.post(deleteUrl, {
                    _method: "DELETE",
                    _token: document.querySelector('meta[name="csrf-token"]').content
                })
                .then(res => {
                    if (res.data.success) {
                        closeModal("deleteModal");
                        $('#dtrRequestsTable').DataTable().ajax.reload(null, false);
                        alert(res.data.message);
                    }
                })
                .catch(err => {
                    console.error(err);
                    alert("Failed to delete record.");
                });
        };
    </script>

    <script>
        document.addEventListener('click', function(e) {
            if (e.target.classList.contains('status-btn')) {
                let id = e.target.dataset.id;
                let status = e.target.dataset.status;

                fetch("{{ route('dtr_requests.updateStatus', ':id') }}".replace(':id', id), {
                        method: "PATCH",
                        headers: {
                            "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').content,
                            "Content-Type": "application/json",
                        },
                        body: JSON.stringify({
                            status: status
                        })
                    })
                    .then(res => res.json())
                    .then(data => {
                        if (data.success) {
                            $('#dtrRequestsTable').DataTable().ajax.reload(null, false);
                        } else {
                            alert("Failed to update status");
                        }
                    })
                    .catch(err => console.error(err));
            }
        });
    </script>

    <script>
        function openModal(modalId) {
            let modal = document.getElementById(modalId);
            modal.classList.remove('hidden');
            modal.classList.add('flex');
        }

        function closeModal(modalId) {
            let modal = document.getElementById(modalId);
            modal.classList.add('hidden');
            modal.classList.remove('flex');
        }
    </script>
    <script>
        $(document).ready(function() {
            let table = $('#dtrRequestsTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('dtr_requests.index') }}",
                    data: function(d) {
                        d.status = $('#statusFilter').val(); // 👈 pass filter value
                    }
                },
                columns: [{
                        data: 'employee',
                        name: 'employee',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'date',
                        name: 'date'
                    },
                    {
                        data: 'type',
                        name: 'type'
                    },
                    {
                        data: 'time',
                        name: 'time'
                    },
                    {
                        data: 'status',
                        name: 'status'
                    },
                    {
                        data: 'actions',
                        name: 'actions',
                        orderable: false,
                        searchable: false
                    }
                ]
            });

            // Redraw table when filter changes
            $('#statusFilter').on('change', function() {
                table.ajax.reload();
            });
        });
    </script>
    <script>
        document.getElementById('dtrForm').addEventListener('submit', function(e) {
            e.preventDefault();

            const form = e.target;
            const formData = new FormData(form);

            axios.post("{{ route('dtr_requests.store') }}", formData)
                .then(res => {
                    if (res.data.success) {
                        closeModal('dtrModal'); // ✅ use your modal toggle function
                        form.reset(); // ✅ reset the form
                        $('#dtrRequestsTable').DataTable().ajax.reload(null, false); // ✅ reload table
                    }
                })
                .catch(err => {
                    console.error(err);
                    let msg = 'An error occurred. Please try again.';
                    if (err.response?.data?.message) msg = err.response.data.message;
                    alert(msg);
                });
        });
    </script>

@endsection
