@extends('layouts.sidebar')
@section('title', 'Users')
@section('content')
    <div class="grid grid-cols-1 gap-4 xl:grid-cols-6">
        <div class="col-span-2">
            <div class="max-w-3xl p-2 mx-auto border-2 border-black rounded-lg">
                <h2 class="font-bold">
                    {{ isset($bankProfile) ? 'Edit Bank Profile' : 'Create Bank Profile' }}
                </h2>

                <form id="bankProfileForm" method="POST" enctype="multipart/form-data" class="p-3"
                    action="{{ isset($bankProfile) ? route('bank-profiles.update', $bankProfile->id) : route('store_clientbank.store') }}">
                    @csrf
                    @if (isset($bankProfile))
                        @method('PUT')
                    @endif

                    <div class="grid grid-cols-1 gap-6 md:grid-cols-2">
                        <div>
                            <label for="bankprofile_id" class="block text-sm font-medium text-gray-700">Bank</label>
                            <select name="bankprofile_id" id="bankprofile_id" class="w-full border-2 border-black" required>
                                <option value="">Select Bank</option>
                                @foreach ($banks as $bank)
                                    <option value="{{ $bank->id }}">{{ $bank->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div>
                            <label for="department_id" class="block text-sm font-medium text-gray-700">Client</label>
                            <select name="department_id" id="department_id" class="w-full border-2 border-black" required>
                                <option value="">Select Client</option>
                                @foreach ($clients as $client)
                                    <option value="{{ $client->id }}">{{ $client->department_name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700">Bank Code</label>
                            <input type="text" name="company_code"
                                value="{{ old('company_code', $bankProfile->company_code ?? '') }}"
                                class="w-full border-2 border-black">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Branch Code</label>
                            <input type="text" name="branch_code"
                                value="{{ old('company_code', $bankProfile->company_code ?? '') }}"
                                class="w-full border-2 border-black">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Filler</label>
                            <input type="text" name="filler"
                                value="{{ old('company_code', $bankProfile->company_code ?? '') }}"
                                class="w-full border-2 border-black">
                        </div>
                    </div>

                    <div class="flex justify-between mt-6">
                        <button type="submit" class="px-6 py-2 text-white bg-blue-600 rounded-md shadow hover:bg-blue-700">
                            {{ isset($bankProfile) ? 'Update' : 'Create' }}
                        </button>
                    </div>
                </form>


            </div>
        </div>
        <div class="col-span-4 p-6 rounded-md shadow-md">
            <h2 class="mb-4 text-2xl font-semibold text-gray-700">Bank Profiles</h2>

            <table id="bankProfilesTable" class="min-w-full text-center border border-gray-200 rounded-md table-auto">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="px-4 py-2">ID</th>
                        <th class="px-4 py-2">Bank Name</th>
                        <th class="px-4 py-2">Client</th>
                        <th class="px-4 py-2">Bank Code</th>
                        <th class="px-4 py-2">Branch Code</th>
                        <th class="px-4 py-2">Filler</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>



    <div class="p-2 overflow-auto border-2 border-black rounded-md ">
        <table id="billing-table" class="min-w-full bg-white border border-gray-200 rounded shadow-md">
            <thead>
                <tr class="text-sm leading-normal text-white bg-black">
                    <th class="px-6 ">Batch Code</th>
                    <th class="px-6 ">Client</th>
                    <th class="px-6 ">Bank</th>
                    <th class="px-6 ">Payroll Prepared by</th>
                    <th class="px-6 ">Payroll Approved by</th>
                    <th class="px-6 ">Pay Period </th>

                    <th class="px-6 ">Number of Employee</th>

                    <th class="px-6 ">Actions</th>
                </tr>
            </thead>
            <tbody class="text-sm font-light text-center text-gray-600">
            </tbody>
        </table>
    </div>




    @include('Admin.BankProfiles.clientbankjs')





@endsection
