<style>
    .selected-row {
        background-color: #e0f7fa !important;
    }
</style>

<!-- Scripts -->
<script>
    $(document).ready(function() {
        const table = $('#bankProfilesTable').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('client_bankprofile') }}",
            columns: [{
                    data: 'id',
                    name: 'id'
                },
                {
                    data: 'bank',
                    name: 'bank'
                },
                {
                    data: 'client',
                    name: 'client'
                },
                {
                    data: 'company_code',
                    name: 'company_code'
                },
                {
                    data: 'branch_code',
                    name: 'branch_code'
                },
                {
                    data: 'filler',
                    name: 'filler',

                }
            ]
        });

        $('#bankProfileForm').on('submit', function(e) {
            e.preventDefault();
            let form = $(this);
            let formData = new FormData(this);

            let methodOverride = form.find('input[name="_method"]').val();
            if (methodOverride && methodOverride.toUpperCase() === 'PUT') {
                formData.append('_method', 'PUT');
            }

            $.ajax({
                url: form.attr('action'),
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    alert('Bank Profile saved successfully!');
                    table.ajax.reload();

                    $('#billing-table').DataTable().ajax.reload();

                    form[0].reset();
                    form.attr('action', "{{ route('store_clientbank.store') }}");
                    form.find('input[name="_method"]').remove();
                    $('h2').first().text('Create Bank Profile');
                    form.find('button[type="submit"]').text('Create');
                },
                error: function(xhr) {
                    let errors = xhr.responseJSON?.errors;
                    if (errors) {
                        let errorMessages = '';
                        for (const key in errors) {
                            if (errors.hasOwnProperty(key)) {
                                errorMessages += `${errors[key].join('\n')}\n`;
                            }
                        }
                        alert('Validation errors:\n' + errorMessages);
                    } else {
                        alert('An unexpected error occurred.');
                    }
                }
            });
        });

        $('#bankProfilesTable tbody').on('click', 'tr', function() {
            $('#bankProfilesTable tbody tr').removeClass('selected-row');
            $(this).addClass('selected-row');

            let selectedRowData = table.row(this).data();
            if (!selectedRowData) return;

            const form = $('#bankProfileForm');
            const formAction = `{{ route('update_clientbank.update', ':id') }}`.replace(':id',
                selectedRowData.id);
            form.attr('action', formAction);

            if (form.find('input[name="_method"]').length) {
                form.find('input[name="_method"]').val('PUT');
            } else {
                form.append('<input type="hidden" name="_method" value="PUT">');
            }

            form.find('[name="bankprofile_id"]').val(selectedRowData.bankprofile_id);
            form.find('[name="department_id"]').val(selectedRowData.department_id);
            form.find('[name="company_code"]').val(selectedRowData.company_code);
            form.find('[name="branch_code"]').val(selectedRowData.branch_code);
            form.find('[name="filler"]').val(selectedRowData.filler);

            $('h2').first().text('Edit Bank Profile');
            form.find('button[type="submit"]').text('Update');
        });
    });
</script>

<script>
    $(document).ready(function() {
        var employedTable = $('#billing-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('bankpayrolllist') }}",
                data: function(d) {
                    // Custom data if needed
                }
            },
            columns: [{
                    data: 'id',
                    name: 'id',
                    width: '10%' // Set the width for the ID column
                },

                {
                    data: 'client.department_name',
                    name: 'client.department_name',
                    width: '10%' // Set the width for the Client Business Name column
                },
                {
                    data: 'bank',
                    name: 'bank',
                    width: '10%' // Set the width for the Approve By column
                },
                {
                    data: 'approve_by',
                    name: 'approve_by',
                    width: '10%' // Set the width for the Approve By column
                },
                {
                    data: 'approve_by1',
                    name: 'approve_by1',
                    width: '10%' // Set the width for the Approve By column
                },
                {
                    data: 'pay_period',
                    name: 'pay_period',
                    width: '10%' // Set the width for the Pay Period Start column
                },

                {
                    data: 'employee_count',
                    name: 'employee_count',
                    width: '10%' // Set the width for the Employee Count column
                },


                {
                    data: 'action', // Matches the action column from your server response
                    name: 'action',
                    orderable: false,
                    searchable: false,
                    width: '10%' // Set the width for the Action column
                }
            ],
            order: [
                [0, 'desc'] // Orders by the first column (ID) in descending order
            ]
        });
    });
</script>
