<script>
    $(document).ready(function() {
        $('#bankProfileForm').on('submit', function(e) {
            e.preventDefault(); // Prevent default form submission

            let form = $(this);
            let formData = new FormData(this);

            // If _method is set to PUT, manually append it to FormData
            let methodOverride = form.find('input[name="_method"]').val();
            if (methodOverride && methodOverride.toUpperCase() === 'PUT') {
                formData.append('_method', 'PUT');
            }

            $.ajax({
                url: form.attr('action'), // Correct form action
                type: 'POST', // Always POST; Laravel uses _method to distinguish
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    alert('Bank Profile saved successfully!');
                    $('#bankProfilesTable').DataTable().ajax.reload();

                    // Reset form to create mode
                    $('#bankProfileForm')[0].reset();
                    form.attr('action', "{{ route('bank-profiles.store') }}");
                    form.find('input[name="_method"]').remove(); // Remove PUT override
                    $('h2').first().text('Create Bank Profile');
                    $('button[type="submit"]').text('Create');
                },
                error: function(xhr) {
                    let errors = xhr.responseJSON?.errors;
                    if (errors) {
                        let errorMessages = '';
                        for (const key in errors) {
                            if (errors.hasOwnProperty(key)) {
                                errorMessages += `${errors[key].join('\n')}\n`;
                            }
                        }
                        alert('Validation errors:\n' + errorMessages);
                    } else {
                        alert('An unexpected error occurred.');
                    }
                }
            });
        });
    });
</script>

<style>
    .selected-row {
        background-color: #e0f7fa !important;
        /* Light cyan */
    }
</style>
<script>
    $(function() {
        let table = $('#bankProfilesTable').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('bank-profiles.index') }}",
            columns: [{
                    data: 'id',
                    name: 'id'
                },

                {
                    data: 'name',
                    name: 'name'
                },

                {
                    data: 'code',
                    name: 'code'
                },
                {
                    data: 'swift_code',
                    name: 'swift_code'
                },
                {
                    data: 'contact_phone',
                    name: 'contact_phone'
                },
                {
                    data: 'image',
                    name: 'image'

                },


            ],
        });

        // Enable clicking a row to populate the form
        $('#bankProfilesTable tbody').on('click', 'tr', function() {
            // Highlight selected row
            $('#bankProfilesTable tbody tr').removeClass('selected-row');
            $(this).addClass('selected-row');

            selectedRowData = table.row(this).data();
            if (!selectedRowData) return;

            // Populate the form with the data from the selected row
            const form = $('#bankProfileForm');
            const form1 = $('#formfilter');
            const formAction = `{{ route('bank-profiles.update', ':id') }}`.replace(':id',
                selectedRowData.id);


            // Set form action and method for updating
            form.attr('action', formAction);
            if (form.find('input[name="_method"]').length) {
                form.find('input[name="_method"]').val('PUT');
            } else {
                form.append('<input type="hidden" name="_method" value="PUT">');
            }

            form1.find('[name="id"]').val(selectedRowData.id);

            form.find('[name="name"]').val(selectedRowData.name);
            form.find('[name="code"]').val(selectedRowData.code);
            form.find('[name="swift_code"]').val(selectedRowData.swift_code);
            form.find('[name="head_office"]').val(selectedRowData.head_office ?? '');
            form.find('[name="contact_email"]').val(selectedRowData.contact_email ?? '');
            form.find('[name="contact_phone"]').val(selectedRowData.contact_phone ?? '');
            form.find('[name="website"]').val(selectedRowData.website ?? '');
            form.find('[name="description"]').val(selectedRowData.description ?? '');

            // Update logo preview
            if (selectedRowData.logo_path) {
                const logoPreview =
                    `<img src="{{ asset('${selectedRowData.logo_path}') }}" class="h-20 mt-2 rounded shadow">`;
                const logoWrapper = form.find('[name="sample"]').closest('div');
                logoWrapper.find('img').remove(); // Remove the old image if it exists
                logoWrapper.prepend(logoPreview); // Prepend new logo preview
            }

            // Update header and button text for Update
            $('h2').first().text('Edit Bank Profile');
            form.find('button[type="submit"]').text('Update');

            // Show the Delete button
            const deleteForm = form.find('#deleteForm');
            deleteForm.show(); // Make the delete form visible
            deleteForm.attr('action', `{{ url('bank-profiles') }}/${selectedRowData.id}`);
        });

    });
</script>
