@extends('frontend.layouts.app')

@section('title')
    Home
@endsection

@section('seo')
@endsection

@section('content')
    <link rel="stylesheet" href="{{ asset('css/brands.css') }}">
    <link rel="stylesheet" href="{{ asset('css/home.css') }}">
    <div id="carouselExampleIndicators" class="carousel slide" data-bs-ride="true">
        <div class="carousel-indicators">
            <button type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to="0" class="active"
                aria-current="true" aria-label="Slide 1"></button>
            <button type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to="1"
                aria-label="Slide 2"></button>
            <button type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to="2"
                aria-label="Slide 3"></button>
        </div>
        <div class="carousel-inner">
            @foreach ($bans as $index => $banns)
                <div class="carousel-item {{ $index === 0 ? 'active' : '' }}">
                    <img src="{{ asset('uploads/bans/' . $banns->image) }}" class="d-block w-100 img-fluid" alt="images">
                    {{-- <p class="banner-text-home color-red text-font home-banner text-red fw-bold">We are committed to providing high-quality products to our customers</p> --}}
                </div>
            @endforeach

        </div>

    </div>

    <div class="d-lg-none d-block d-sm-block">
        <br><br>
    </div>

    <div class="container px-4 text-center" style="width: 100%; height: auto;">
        <div class="row gx-5 gy-3">


            <div class="col-md-6 col-lg-3">
                <div class="p-3 curtain"
                    style="background-image: url({{ asset('img/home-image/sentry-safe.jpg') }}); background-size: cover;">
                    <div class="pt-3 opacity-100 curtain-inner">
                        <div class="opacity-100">
                            <img src="{{ asset('/img/new-buttons/SentryLogo.png') }}" class="px-2 opacity-100 img-fluid"
                                alt="" style="width: 150px;">
                            <p class="p-3 text-black hover-text">
                                Founded in 1930, Sentry<span style="position: relative; top:  .3em;"><sub
                                        style="font-size: 1.5em;">®</sub></span>Safe is the world leader in fire-resistant
                                and
                                security storage solutions for important documents and valuables.
                            </p>
                            <div class="d-flex align-items-end ms-3">
                                <a href="{{ url('/sentrySafe') }}" class="text-decoration-none">
                                    <p class="fw-bold btn-learn text-red"><i
                                            class="fa-solid fa-arrow-right-long me-1"></i>Learn more</p>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-3">
                <div class="p-3 curtain"
                    style="background-image: url({{ asset('img/home-image/TitanSafeUpdated.png') }});  background-size: cover;">
                    <div class="pt-3 opacity-100 curtain-inner">
                        <div class="opacity-100">
                            <img src="{{ asset('img/new-buttons/Titan Safes logo R.png') }}"
                                class="opacity-100 img-fluid ps-3" alt="" style="width: 120px;">
                            <p class="p-3 text-black hover-text">
                                Titan Safes was established in 2015 to allow Zenorex to offer a full range
                                of high-quality high-value safes to the Philippine market.
                            </p>
                            <div class="d-flex align-items-end ms-3">
                                <a href="{{ url('/titanSafe') }}" class="text-decoration-none">
                                    <p class="fw-bold btn-learn text-red"><i
                                            class="fa-solid fa-arrow-right-long me-1"></i>Learn more</p>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-3">
                <div class="p-3 curtain" style="background-image: url({{ asset('img/home-image/titan-elite.png') }});">
                    <div class="pt-3 opacity-100 curtain-inner">
                        <div class="opacity-100">
                            <img src="{{ asset('img/logo-titan_elite.png') }}" class="opacity-100 img-fluid" alt=""
                                style="width: 100px;">
                            <p class="p-3 text-black hover-text">
                                In 2017, Zenorex launched Titan Elite under the Titan brand to provide the
                                Philippine market with an extensive range of top-of-the-line safes that offer both
                                exceptional quality and value.
                            </p>
                            <div class="d-flex align-items-end ms-3">
                                <a href="{{ url('/titanElite') }}" class="text-decoration-none">
                                    <p class="fw-bold btn-learn text-red"><i
                                            class="fa-solid fa-arrow-right-long me-1"></i>Learn more</p>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-3">
                <div class="p-3 curtain"
                    style="background-image: url({{ asset('img/home-image/x-sense.png') }}); background-size: cover;">
                    <div class="pt-3 opacity-100 curtain-inner">
                        <div class="opacity-100">
                            <img src="{{ asset('/img/home-image/x-sense-logo.png') }}" class="opacity-100 img-fluid"
                                alt="" style="width: 100px;">
                            <p class="p-3 text-black hover-text">
                                Founded in 2014, X-Sense is a global leader in home safety products, including smoke alarms.
                                All alarms are tested and calibrated to meet the highest quality standards, backed by third
                                parties, including TÜV Rheinland.
                            </p>
                            <div class="d-flex align-items-end ms-3">
                                <a href="{{ url('/X-Sense') }}" class="text-decoration-none">
                                    <p class="fw-bold btn-learn text-red"><i
                                            class="fa-solid fa-arrow-right-long me-1"></i>Learn more</p>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <section class="featured-products">
        <div class="container mt-5">
            <div>
                <div class="font-cinzel color-red fw-bold">Zenorex Products</div>
                <div class="d-flex justify-content-between">
                    <div class="d-flex align-items-center">
                        <p class="pt-0 fw-bold fs-3 featured-title">Featured Products</p>
                    </div>
                    <a class="text-decoration-none" href="{{ url('/shop') }}">
                        <p class="btn btn-first padding see-products">SEE ALL PRODUCTS</p>
                    </a>
                </div>
                <img src="{{ asset('img/bar-line.png') }}" alt="" width="100%">
            </div>
        </div>
        <div class="container pb-5 mb-5 ">
            <div class="container pb-5 mb-5 ">
                <div id="featured" class="carousel slide" data-bs-ride="carousel" data-bs-interval="5000">
                    <div class="carousel-inner">
                        <div class="carousel-item active">





                            <div class="row">
                                @foreach ($offer as $offers)
                                    <div class="mb-5 col-12 col-lg-5 d-flex align-items-center mb-lg-0">
                                        <div class="special-offer position-relative w-100">
                                            <img src="{{ asset('uploads/product/' . $offers->thumbnail_image) }}"
                                                alt="" class="img-fluid w-100"
                                                style="object-fit: contain; object-position: center; aspect-ratio: 1 / 1;">
                                            <div class="top-0 p-4 position-absolute w-100 h-100 bg-transparent-black">
                                                <div class="px-2 main-featured-box">
                                                    <div class="mb-2 item-status-label status-label-yellow mb-sm-5">
                                                        <p class="text-white">SPECIAL OFFER</p>
                                                    </div>
                                                    <div class="text-box">
                                                        <p class="title">
                                                            FEATURED SENTRYSAFE
                                                        </p>
                                                        <h1 class="product-name">{{ $offers->model }}</h1>
                                                        {{--  --}}
                                                        <p class="product-price">
                                                            @if (isset($offers->sellPrice))
                                                                <span class="product-price-no-discount">P
                                                                    {{ $offers->price }}</span>
                                                                <span class="product-price">P
                                                                    {{ $offers->sellPrice }}</span>
                                                            @else
                                                                <span class="product-price-no-discount d-none">P
                                                                    25,120.00</span>
                                                                <span class="product-price">P
                                                                    {{ number_format($offers->price) }}</span>
                                                            @endif
                                                        </p>
                                                    </div>
                                                    <div>
                                                        <a href={{ url('productView/' . $offers->id) }}>
                                                            <p class="btn btn-first big d-inline-block">
                                                                REQUEST A QUOTE</p>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                                <div class="col-12 col-lg-7 d-flex align-items-center">
                                    <div class="container text-center">
                                        <div class="d-md-block d-none">
                                            <div class="row" style="row-gap: 40px;">
                                                @foreach ($feature as $featured)
                                                    <div class="mb-4 col-6 col-sm-4 product-item">
                                                        <div class="position-relative">
                                                            <a href="{{ url('productView/' . $featured->id) }}"><img
                                                                    src="{{ asset('uploads/product/' . $featured->thumbnail_image) }}"
                                                                    alt="" class="img-fluid w-100"></a>
                                                            <div>
                                                                <p class="product-name">{{ $featured->model }}</p>
                                                                <p class="m-0 product-price">
                                                                    @if (isset($featured->sellPrice))
                                                                        <span class="product-price-no-discount">P
                                                                            {{ $featured->price }}</span>
                                                                        <span class="product-price">P
                                                                            {{ $featured->sellPrice }}</span>
                                                                    @else
                                                                        <span class="product-price-no-discount d-none">P
                                                                            25,120.00</span>
                                                                        <span class="product-price">P
                                                                            {{ number_format($featured->price) }}</span>
                                                                    @endif
                                                                </p>
                                                            </div>
                                                            @if ($featured->sellPrice != null && $featured->backStock == 'yes')
                                                                <div class="item-status-label pos-absolute">
                                                                    <p class="m-0 text-white">SALE</p>
                                                                </div>
                                                            @elseif($featured->backStock === 'yes')
                                                                <div class="item-status-label pos-absolute">
                                                                    <p class="m-0 text-white">BACK IN STOCK</p>
                                                                </div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                        <div class="d-md-none d-block">
                                            <div class="row">
                                                @foreach ($feature as $featured)
                                                    <div class="mb-4 col-6 col-sm-4 product-item">
                                                        <div class="position-relative">
                                                            <a href="{{ url('productView/' . $featured->id) }}"><img
                                                                    src="{{ asset('uploads/product/' . $featured->thumbnail_image) }}"
                                                                    alt="" class="img-fluid w-100"></a>
                                                            <div>
                                                                <p class="product-name">{{ $featured->model }}</p>
                                                                <p class="m-0 product-price">
                                                                    @if (isset($featured->sellPrice))
                                                                        <span class="product-price-no-discount">P
                                                                            {{ $featured->price }}</span>
                                                                        <span class="product-price">P
                                                                            {{ $featured->sellPrice }}</span>
                                                                    @else
                                                                        <span class="product-price-no-discount d-none">P
                                                                            25,120.00</span>
                                                                        <span class="product-price">P
                                                                            {{ number_format($featured->price) }}</span>
                                                                    @endif
                                                                </p>
                                                            </div>
                                                            @if ($featured->sellPrice != null && $featured->backStock == 'yes')
                                                                <div class="item-status-label pos-absolute">
                                                                    <p class="m-0 text-white">SALE</p>
                                                                </div>
                                                            @elseif($featured->backStock === 'yes')
                                                                <div class="item-status-label pos-absolute">
                                                                    <p class="m-0 text-white">BACK IN STOCK</p>
                                                                </div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>




                        </div>
                        <div class="carousel-item">

                            <div class="row">
                                @foreach ($offer3 as $offers)
                                    <div class="mb-5 col-12 col-lg-5 d-flex align-items-center mb-lg-0">
                                        <div class="special-offer position-relative w-100">
                                            <img src="{{ asset('uploads/product/' . $offers->thumbnail_image) }}"
                                                alt="" class="img-fluid w-100"
                                                style="object-fit: contain; object-position: center; aspect-ratio: 1 / 1;">
                                            <div class="top-0 p-4 position-absolute w-100 h-100 bg-transparent-black">
                                                <div class="px-2 main-featured-box">
                                                    <div class="mb-2 item-status-label status-label-yellow mb-sm-5">
                                                        <p class="text-white">SPECIAL OFFER</p>
                                                    </div>
                                                    <div class="text-box">
                                                        <p class="title">
                                                            FEATURED X-SENSE
                                                        </p>
                                                        <h1 class="product-name">{{ $offers->model }}</h1>
                                                        {{--  --}}
                                                        <p class="product-price">
                                                            @if (isset($offers->sellPrice))
                                                                <span class="product-price-no-discount">P
                                                                    {{ $offers->price }}</span>
                                                                <span class="product-price">P
                                                                    {{ $offers->sellPrice }}</span>
                                                            @else
                                                                <span class="product-price-no-discount d-none">P
                                                                    25,120.00</span>
                                                                <span class="product-price">P
                                                                    {{ number_format($offers->price) }}</span>
                                                            @endif
                                                        </p>
                                                    </div>
                                                    <div>
                                                        <a href={{ url('productView/' . $offers->id) }}>
                                                            <p class="btn btn-first big d-inline-block">
                                                                REQUEST A QUOTE</p>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                                <div class="col-12 col-lg-7 d-flex align-items-center">
                                    <div class="container text-center">
                                        <div class="d-md-block d-none">
                                            <div class="row" style="row-gap: 40px;">
                                                @foreach ($xSense as $featured)
                                                    <div class="mb-4 col-6 col-sm-4 product-item">
                                                        <div class="position-relative">
                                                            <a href="{{ url('productView/' . $featured->id) }}"><img
                                                                    src="{{ asset('uploads/product/' . $featured->thumbnail_image) }}"
                                                                    alt="" class="img-fluid w-100"></a>
                                                            <div>
                                                                <p class="product-name">{{ $featured->model }}</p>
                                                                <p class="m-0 product-price">
                                                                    @if (isset($featured->sellPrice))
                                                                        <span class="product-price-no-discount">P
                                                                            {{ $featured->price }}</span>
                                                                        <span class="product-price">P
                                                                            {{ $featured->sellPrice }}</span>
                                                                    @else
                                                                        <span class="product-price-no-discount d-none">P
                                                                            25,120.00</span>
                                                                        <span class="product-price">P
                                                                            {{ number_format($featured->price) }}</span>
                                                                    @endif
                                                                </p>
                                                            </div>
                                                            @if ($featured->sellPrice != null && $featured->backStock == 'yes')
                                                                <div class="item-status-label pos-absolute">
                                                                    <p class="m-0 text-white">SALE</p>
                                                                </div>
                                                            @elseif($featured->backStock === 'yes')
                                                                <div class="item-status-label pos-absolute">
                                                                    <p class="m-0 text-white">BACK IN STOCK</p>
                                                                </div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                        <div class="d-md-none d-block">
                                            <div class="row">
                                                @foreach ($xSense as $featured)
                                                    <div class="mb-4 col-6 col-sm-4 product-item">
                                                        <div class="position-relative">
                                                            <a href="{{ url('productView/' . $featured->id) }}"><img
                                                                    src="{{ asset('uploads/product/' . $featured->thumbnail_image) }}"
                                                                    alt="" class="img-fluid w-100"></a>
                                                            <div>
                                                                <p class="product-name">{{ $featured->model }}</p>
                                                                <p class="m-0 product-price">
                                                                    @if (isset($featured->sellPrice))
                                                                        <span class="product-price-no-discount">P
                                                                            {{ $featured->price }}</span>
                                                                        <span class="product-price">P
                                                                            {{ $featured->sellPrice }}</span>
                                                                    @else
                                                                        <span class="product-price-no-discount d-none">P
                                                                            25,120.00</span>
                                                                        <span class="product-price">P
                                                                            {{ number_format($featured->price) }}</span>
                                                                    @endif
                                                                </p>
                                                            </div>
                                                            @if ($featured->sellPrice != null && $featured->backStock == 'yes')
                                                                <div class="item-status-label pos-absolute">
                                                                    <p class="m-0 text-white">SALE</p>
                                                                </div>
                                                            @elseif($featured->backStock === 'yes')
                                                                <div class="item-status-label pos-absolute">
                                                                    <p class="m-0 text-white">BACK IN STOCK</p>
                                                                </div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="carousel-item">

                            <div class="row">
                                @foreach ($offer2 as $offers)
                                    <div class="mb-5 col-12 col-lg-5 d-flex align-items-center mb-lg-0">
                                        <div class="special-offer position-relative w-100">
                                            <img src="{{ asset('uploads/product/' . $offers->thumbnail_image) }}"
                                                alt="" class="img-fluid w-100"
                                                style="object-fit: contain; object-position: center; aspect-ratio: 1 / 1;">
                                            <div class="top-0 p-4 position-absolute w-100 h-100 bg-transparent-black">
                                                <div class="px-2 main-featured-box">
                                                    <div class="mb-2 item-status-label status-label-yellow mb-sm-5">
                                                        <p class="text-white">SPECIAL OFFER</p>
                                                    </div>
                                                    <div class="text-box">
                                                        <p class="title">
                                                            FEATURED TITAN ELITE
                                                        </p>
                                                        <h1 class="product-name">{{ $offers->model }}</h1>
                                                        {{--  --}}
                                                        <p class="product-price">
                                                            @if (isset($offers->sellPrice))
                                                                <span class="product-price-no-discount">P
                                                                    {{ $offers->price }}</span>
                                                                <span class="product-price">P
                                                                    {{ $offers->sellPrice }}</span>
                                                            @else
                                                                <span class="product-price-no-discount d-none">P
                                                                    25,120.00</span>
                                                                <span class="product-price">P
                                                                    {{ number_format($offers->price) }}</span>
                                                            @endif
                                                        </p>
                                                    </div>
                                                    <div>
                                                        <a href={{ url('productView/' . $offers->id) }}>
                                                            <p class="btn btn-first big d-inline-block">
                                                                REQUEST A QUOTE</p>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                                <div class="col-12 col-lg-7 d-flex align-items-center">
                                    <div class="container text-center">
                                        <div class="d-md-block d-none">
                                            <div class="row" style="row-gap: 40px;">
                                                @foreach ($titanElite as $featured)
                                                    <div class="mb-4 col-6 col-sm-4 product-item">
                                                        <div class="position-relative">
                                                            <a href="{{ url('productView/' . $featured->id) }}"><img
                                                                    src="{{ asset('uploads/product/' . $featured->thumbnail_image) }}"
                                                                    alt="" class="img-fluid w-100"></a>
                                                            <div>
                                                                <p class="product-name">{{ $featured->model }}</p>
                                                                <p class="m-0 product-price">
                                                                    @if (isset($featured->sellPrice))
                                                                        <span class="product-price-no-discount">P
                                                                            {{ $featured->price }}</span>
                                                                        <span class="product-price">P
                                                                            {{ $featured->sellPrice }}</span>
                                                                    @else
                                                                        <span class="product-price-no-discount d-none">P
                                                                            25,120.00</span>
                                                                        <span class="product-price">P
                                                                            {{ number_format($featured->price) }}</span>
                                                                    @endif
                                                                </p>
                                                            </div>
                                                            @if ($featured->sellPrice != null && $featured->backStock == 'yes')
                                                                <div class="item-status-label pos-absolute">
                                                                    <p class="m-0 text-white">SALE</p>
                                                                </div>
                                                            @elseif($featured->backStock === 'yes')
                                                                <div class="item-status-label pos-absolute">
                                                                    <p class="m-0 text-white">BACK IN STOCK</p>
                                                                </div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                        <div class="d-md-none d-block">
                                            <div class="row">
                                                @foreach ($titanElite as $featured)
                                                    <div class="mb-4 col-6 col-sm-4 product-item">
                                                        <div class="position-relative">
                                                            <a href="{{ url('productView/' . $featured->id) }}"><img
                                                                    src="{{ asset('uploads/product/' . $featured->thumbnail_image) }}"
                                                                    alt="" class="img-fluid w-100"></a>
                                                            <div>
                                                                <p class="product-name">{{ $featured->model }}</p>
                                                                <p class="m-0 product-price">
                                                                    @if (isset($featured->sellPrice))
                                                                        <span class="product-price-no-discount">P
                                                                            {{ $featured->price }}</span>
                                                                        <span class="product-price">P
                                                                            {{ $featured->sellPrice }}</span>
                                                                    @else
                                                                        <span class="product-price-no-discount d-none">P
                                                                            25,120.00</span>
                                                                        <span class="product-price">P
                                                                            {{ number_format($featured->price) }}</span>
                                                                    @endif
                                                                </p>
                                                            </div>
                                                            @if ($featured->sellPrice != null && $featured->backStock == 'yes')
                                                                <div class="item-status-label pos-absolute">
                                                                    <p class="m-0 text-white">SALE</p>
                                                                </div>
                                                            @elseif($featured->backStock === 'yes')
                                                                <div class="item-status-label pos-absolute">
                                                                    <p class="m-0 text-white">BACK IN STOCK</p>
                                                                </div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="carousel-item">

                            <div class="row">
                                @foreach ($offer1 as $offers)
                                    <div class="mb-5 col-12 col-lg-5 d-flex align-items-center mb-lg-0">
                                        <div class="special-offer position-relative w-100">
                                            <img src="{{ asset('uploads/product/' . $offers->thumbnail_image) }}"
                                                alt="" class="img-fluid w-100"
                                                style="object-fit: contain; object-position: center; aspect-ratio: 1 / 1;">
                                            <div class="top-0 p-4 position-absolute w-100 h-100 bg-transparent-black">
                                                <div class="px-2 main-featured-box">
                                                    <div class="mb-2 item-status-label status-label-yellow mb-sm-5">
                                                        <p class="text-white">SPECIAL OFFER</p>
                                                    </div>
                                                    <div class="text-box">
                                                        <p class="title">
                                                            FEATURED TITAN SAFE
                                                        </p>
                                                        <h1 class="product-name">{{ $offers->model }}</h1>
                                                        {{--  --}}
                                                        <p class="product-price">
                                                            @if (isset($offers->sellPrice))
                                                                <span class="product-price-no-discount">P
                                                                    {{ $offers->price }}</span>
                                                                <span class="product-price">P
                                                                    {{ $offers->sellPrice }}</span>
                                                            @else
                                                                <span class="product-price-no-discount d-none">P
                                                                    25,120.00</span>
                                                                <span class="product-price">P
                                                                    {{ number_format($offers->price) }}</span>
                                                            @endif
                                                        </p>
                                                    </div>
                                                    <div>
                                                        <a>
                                                            <p class="btn btn-first big d-inline-block"
                                                                data-bs-toggle="modal"
                                                                data-bs-target="#exampleModal{{ $offers->id }}">
                                                                REQUEST A QUOTE</p>
                                                        </a>
                                                    </div>
                                                    <div class="modal fade" id="exampleModal{{ $offers->id }}"
                                                        tabindex="-1" aria-labelledby="exampleModalLabel"
                                                        aria-hidden="true">
                                                        <div class="modal-dialog modal-dialog-centered">
                                                            <div class="modal-content">
                                                                <div class="modal-header border-bottom-0">
                                                                    <button type="button" class="btn-close"
                                                                        data-bs-dismiss="modal"
                                                                        aria-label="Close"></button>
                                                                </div>
                                                                <div class="text-center modal-body">
                                                                    <h1>Continue to Quote?</h1>
                                                                </div>
                                                                <div
                                                                    class="modal-footer border-top-0 d-flex justify-content-center">
                                                                    <a href="{{ url('cart/' . $offers->id) }}"><button
                                                                            type="button"
                                                                            class="p-2 bg-white btns btn-confirm rounded-5">Add
                                                                            to Quote</button></a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <script>
                                                        $(document).ready(function() {
                                                            $('#item'
                                                                {{ $offers->id }} '').hover(function() {
                                                                $('#btn-item'
                                                                    {{ $offers->id }} '').toggle();
                                                            });
                                                        });
                                                    </script>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                                <div class="col-12 col-lg-7 d-flex align-items-center">
                                    <div class="container text-center">
                                        <div class="d-md-block d-none">
                                            <div class="row" style="row-gap: 40px;">
                                                @foreach ($titanSafe as $featured)
                                                    <div class="mb-4 col-6 col-sm-4 product-item">
                                                        <div class="position-relative">
                                                            <a href="{{ url('productView/' . $featured->id) }}"><img
                                                                    src="{{ asset('uploads/product/' . $featured->thumbnail_image) }}"
                                                                    alt="" class="img-fluid w-100"></a>
                                                            <div>
                                                                <p class="product-name">{{ $featured->model }}</p>
                                                                <p class="m-0 product-price">
                                                                    @if (isset($featured->sellPrice))
                                                                        <span class="product-price-no-discount">P
                                                                            {{ $featured->price }}</span>
                                                                        <span class="product-price">P
                                                                            {{ $featured->sellPrice }}</span>
                                                                    @else
                                                                        <span class="product-price-no-discount d-none">P
                                                                            25,120.00</span>
                                                                        <span class="product-price">P
                                                                            {{ number_format($featured->price) }}</span>
                                                                    @endif
                                                                </p>
                                                            </div>
                                                            @if ($featured->sellPrice != null && $featured->backStock == 'yes')
                                                                <div class="item-status-label pos-absolute">
                                                                    <p class="m-0 text-white">SALE</p>
                                                                </div>
                                                            @elseif($featured->backStock === 'yes')
                                                                <div class="item-status-label pos-absolute">
                                                                    <p class="m-0 text-white">BACK IN STOCK</p>
                                                                </div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                        <div class="d-md-none d-block">
                                            <div class="row">
                                                @foreach ($titanSafe as $featured)
                                                    <div class="mb-4 col-6 col-sm-4 product-item">
                                                        <div class="position-relative">
                                                            <a href="{{ url('productView/' . $featured->id) }}"><img
                                                                    src="{{ asset('uploads/product/' . $featured->thumbnail_image) }}"
                                                                    alt="" class="img-fluid w-100"></a>
                                                            <div>
                                                                <p class="product-name">{{ $featured->model }}</p>
                                                                <p class="m-0 product-price">
                                                                    @if (isset($featured->sellPrice))
                                                                        <span class="product-price-no-discount">P
                                                                            {{ $featured->price }}</span>
                                                                        <span class="product-price">P
                                                                            {{ $featured->sellPrice }}</span>
                                                                    @else
                                                                        <span class="product-price-no-discount d-none">P
                                                                            25,120.00</span>
                                                                        <span class="product-price">P
                                                                            {{ number_format($featured->price) }}</span>
                                                                    @endif
                                                                </p>
                                                            </div>
                                                            @if ($featured->sellPrice != null && $featured->backStock == 'yes')
                                                                <div class="item-status-label pos-absolute">
                                                                    <p class="m-0 text-white">SALE</p>
                                                                </div>
                                                            @elseif($featured->backStock === 'yes')
                                                                <div class="item-status-label pos-absolute">
                                                                    <p class="m-0 text-white">BACK IN STOCK</p>
                                                                </div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                    <button class="carousel-control-prev" type="button" data-bs-target="#featured"
                        data-bs-slide="prev">
                        <div class="">
                            <div class="icon-box" style="margin-right: 30px; padding: 20px;">
                                <i class="fa-solid fa-angle-left color-red"></i>
                            </div>
                        </div>
                    </button>
                    <button class="carousel-control-next" type="button" data-bs-target="#featured"
                        data-bs-slide="next">
                        <div class="">
                            <div class="icon-box" style="margin-left: 30px; padding: 20px;">
                                <i class="fa-solid fa-angle-right color-red"></i>
                            </div>
                        </div>
                    </button>

                </div>
            </div>
        </div>
    </section>




    <div class="container">
        <div class="sec-bg d-lg-block d-none d-sm-none" style="background-image: url('{{ asset('img/sec-bg1.png') }}')">
            <div class="mb-3 d-flex flex-column align-items-end not-suree " style="padding-top: 19rem;">
                <div class="p-2 notsure font-size-h1 " style="font-size:30px !important">Not Sure What You're Looking For?
                </div>
                <div class="p-2 find font-size-h2">We'll help you find the right product for your needs.</div>
                <a href="{{ url('/guidedQuestion') }}"
                    class="p-2 text-decoration-none getStarted btns-white rounded-5">GET
                    STARTED</a>
                <div class="d-lg-none d-block d-sm-block">
                    <br><br><br>
                </div>
            </div>
        </div>
        <div class="d-lg-none d-block d-sm-block img-mob position-relative">
            <div class="text-black notsure font-size-h1">
                Not Sure What You're Looking For?
            </div>
            <div class="mt-2 text-black find font-size-h2">
                We'll help you find the right product for your needs.
            </div>
            <img src="{{ asset('img/sec-bg1_mobile.png') }}" class="img-fluid w-100" alt="Background Image">

            <!-- Overlay Text on Image -->
            <div class=" d" style="margin-top: -5rem;">
                <div class="mt-1 d-flex justify-content-end">
                    <a href="{{ url('/guidedQuestion') }}"
                        class="p-2 text-decoration-none getStarted btns-white rounded-5 " style="width: 50%;">GET
                        STARTED</a>
                </div>
                <div class="d-lg-none d-block d-sm-block">
                    <br><br><br>
                </div>
            </div>
        </div>
    </div>



    <br><br>
    <div class="contact-banner d-lg-block d-none d-sm-none"
        style="background-image: url('{{ asset('img/sec-bg2.jpg') }}')">
        <div class=bot-bannerText>
            <div class="container">
                <p class="wecare" style="font-family: 'Cinzel', serif;">WE CARE FOR CUSTOMERS</p>
                <p class="needHelp fs-1">Need help?</p>
                {{-- <p class="or fs-1">or</p> --}}
                <p class="check fs-1">
                    Visit <a href="{{ url('/customer-care') }}" class="text-decoration-none"><span
                            class="care fs-1">Customer Care</span></a> <br>
                    or<br>
                    <a href="{{ url('/contactUs') }}" class="text-decoration-none"><span class="care fs-1">Contact
                            Us</span></a>
                </p>
            </div>
        </div>
    </div>
    {{-- style="background-image: url('{{ asset('img/sec-bg2_mobile.jpg') }}')" --}}
    <div class="contact-banner-mob d-lg-none d-block d-sm-block w-100"
        style="background-image: url('{{ asset('img/sec-bg2_mobile.jpg') }}'); 
            background-size: cover; 
            background-position: center; 
            background-repeat: no-repeat; 
            position: relative; 
            height: 300px;">
        <div class="text-center text-white bot-bannerText"
            style="position: absolute; 
                top: 40%; /* Adjust this to move the text up */
                left: 10%; /* Adjust this to move the text to the left */
                transform: translateY(-50%); /* Only move vertically */
                width: auto; /* Adjust width as needed */
                padding: 1rem;">
            <div style="margin-left: -3rem; margin-top: -10rem;">
                <p class="wecare" style="font-family: 'Cinzel', serif; text-align: left;">WE CARE FOR CUSTOMERS</p>
                <p class="needHelp fs-1" style="text-align: left;">Need help?</p>
                <p class="check fs-1" style="text-align: left;">
                    Visit <a href="{{ url('/customer-care') }}" class="text-decoration-none"><span
                            class="care fs-1">Customer Care</span></a> <br>
                    or<br>
                    <a href="{{ url('/contactUs') }}" class="text-decoration-none"><span class="care fs-1">Contact
                            Us</span></a>
                </p>
            </div>
        </div>
    </div>



    <br><br>
    <div class="container about-cont">
        <div class="row g-2">
            <div class="col-md-6">
                <div class="p-3">
                    <img src="{{ asset('img/about-img.jpg') }}" class="img-fluid" alt="...">
                </div>
            </div>
            <div class="col-md-6">
                <div class="p-3">
                    <p class="aboutZenorex fs-4 text-red fw-bold">ABOUT US</p>
                    <p class="about-tag fs-5">We distribute high-quality durable consumer products in the Philippines</p>
                    <a href="{{ url('aboutus') }}" class="text-decoration-none">
                        <p class="btns-sec btns">FIND OUT MORE ABOUT US</p>
                    </a>
                </div>
            </div>
        </div>
        <div class="mt-4">
            <div class="container box d-lg-none d-block d-sm-block">
                <div class="container p-5 contact-mob">
                    <div class="bg-light">
                        <div class="container p-5">
                            <p class="footer-contact">CONTACT US</p>
                            <p class="footer-context">We'd love to hear from you</p>
                            <div class="containers">
                                <div class="row gy-4 align-items-start">
                                    <div class="col-md-4">
                                        <input class="form-control" placeholder="Name *" type="text" required="">
                                    </div>
                                    <div class="col-md-4">
                                        <input class="form-control" placeholder="Phone No. *" type="text"
                                            required="">
                                    </div>
                                    <div class="col-md-4">
                                        <input class="form-control" placeholder="Email Address *" type="text"
                                            required="">
                                    </div>
                                </div>
                                <br>
                                <textarea class="form-control textarea" placeholder="Write a Message"></textarea>
                                <br>
                                <button class="findAbout btns" style="width: 90%;">
                                    SEND MESSAGE
                                </button>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="pt-5 pb-5 d-lg-block d-none d-sm-none">
            <div class="pt-5 pb-5"></div>
        </div>
    </div>
    @foreach ($modzal as $modzals)
        {{-- MODAL --}}
        @if ($modzals->active === 'on')
            <div class="container">
                <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel"
                    aria-hidden="true">
                    <div class="modal-dialog modal-lg modal-dialog-centered" style="margin-top: -10px;">
                        <div class="modal-content">
                            <div class="modal-header border-bottom-0">
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <div class="px-2 text-center">
                                    @foreach ($thumb as $datas)
                                        @if (!$datas->link)
                                            <img src="{{ asset('uploads/banners/' . $datas->image) }}" class="img-fluid"
                                                style="height: auto;" alt="">
                                        @else
                                            <a href="{{ $datas->link }}"><img
                                                    src="{{ asset('uploads/banners/' . $datas->image) }}"
                                                    class="img-fluid" style="height: auto;"
                                                    alt=""></a><!-- style="height: 75vh;" -->
                                        @endif
                                    @endforeach
                                </div>
                            </div>
                            <div class="modal-footer justify-content-center border-top-0">
                                <a type="button" class="btn btn-danger" href="{{ url('/shop') }}">VIEW SHOP</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    @endforeach
@endsection

@section('js')
    <script>
        $(document).ready(function() {
            // Initially, the modal is enabled


            let isModalEnabled = true;

            // Function to toggle modal state
            function toggleModal() {
                if (isModalEnabled) {
                    $("#exampleModal").modal("show");
                } else {
                    $("#exampleModal").modal("hide");
                }
            }

            // Trigger the modal
            toggleModal();

            // Function to enable or disable the modal
            function enableDisableModal(isEnabled) {
                isModalEnabled = isEnabled;
                toggleModal();
            }

            // Example: Disable the modal after a certain time (e.g., 5 seconds)
            setTimeout(function() {
                enableDisableModal(false);
            }, 15000);
        });
    </script>
@endsection
