@extends('layouts.sidebar')

@section('title', 'Clients')
@section('content')

    <div class="mx-auto">
        <div class="relative flex flex-col items-end justify-end mr-10 text-center">
            <div>
                <button type="button"
                    class="inline-flex justify-center w-full px-4 py-2 text-sm font-medium text-white bg-[#1d1d1d] border border-gray-300 rounded-md shadow-sm hover:bg-blue-900 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-100 focus:ring-blue-500"
                    id="menu-button" aria-expanded="false" aria-haspopup="true" onclick="toggleDropdown()">
                    Menu
                    <svg class="w-5 h-5 ml-2 -mr-1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor"
                        aria-hidden="true">
                        <path fill-rule="evenodd"
                            d="M5.23 7.21a.75.75 0 011.06 0L10 10.44l3.71-3.23a.75.75 0 111.04 1.08l-4.25 3.5a.75.75 0 01-1.04 0l-4.25-3.5a.75.75 0 010-1.08z"
                            clip-rule="evenodd" />
                    </svg>
                </button>
                <div class="absolute right-0 z-10 hidden w-56 mt-2 bg-white rounded-md shadow-lg ring-1 ring-black ring-opacity-5 focus:outline-none"
                    role="menu" aria-orientation="vertical" aria-labelledby="menu-button" tabindex="-1"
                    id="dropdown-menu">
                    <div class="py-1" role="none">
                        <div class="flex flex-col items-center justify-center ">
                            <button id="showemployee"
                                class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                Employee
                            </button>
                            <button id="showdepartment"
                                class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                Department
                            </button>

                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="grid grid-cols-1 xl:grid-cols-6">
            <div class="w-full mb-3 bg-white border border-gray-200 rounded shadow-md h-[22rem]">
                <p class="h-10 p-2 text-md font-bold text-white bg-[#1d1d1d]">Company Profile</p>
                <div class="p-4 text-xs overflow-auto">
                    <table class="w-full border border-collapse border-gray-200 table-auto">
                        <tbody>
                            <tr class="border-b border-gray-200">
                                <td class="px-4 py-2 font-semibold">Agency Logo</td>
                                <td class="px-4 py-2 text-red-600"><img src="{{ asset($client->agency->contact_person) }}"
                                        width="50" height="50"></td>
                            </tr>
                            <tr class="border-b border-gray-200">
                                <td class="px-4 py-2 font-semibold">Agency:</td>
                                <td class="px-4 py-2 text-red-600">{{ $client->agency->name }}</td>
                            </tr>
                            <tr class="border-b border-gray-200">
                                <td class="px-4 py-2 font-semibold">Company:</td>
                                <td class="px-4 py-2 text-red-600">{{ $client->business_name }}</td>
                            </tr>
                            <tr class="border-b border-gray-200">
                                <td class="px-4 py-2 font-semibold">Address:</td>
                                <td class="px-4 py-2 text-red-600">{{ $client->address }}</td>
                            </tr>

                            <tr>
                                <td class="px-4 py-2 font-semibold">Contact Number:</td>
                                <td class="px-4 py-2 text-red-600">{{ $client->contact_number }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="lg:col-span-5 ">
                <div class="w-full p-4 lg:w-full" id="employeeshow">
                    <h2 class="mb-6 font-bold text-md">Employee List</h2>
                    <div class="overflow-auto">
                        <table id="employed-table" class="min-w-full bg-white border border-gray-200 rounded shadow-md">
                            <thead>
                                <tr class="text-sm leading-normal text-white bg-[#1d1d1d]">
                                    <th class="px-6 py-1">ID</th>
                                    <th class="px-6 py-1">Name</th>
                                    <th class="px-6 py-1">Date Hired</th>
                                    <th class="px-6 py-1">Status</th>
                                    <th class="px-6 py-1">Position</th>
                                    <th class="px-6 py-1">Email</th>
                                    <th class="px-6 py-1">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="text-sm font-light text-center text-gray-600">
                                <!-- Data will be populated here by DataTables -->
                            </tbody>
                        </table>
                    </div>
                </div>

                <div id="departmentshow" class="hidden w-full p-4 border border-gray-200 rounded shadow-md lg:w-full">
                    @include('Admin.Client.department')
                </div>
            </div>


        </div>

        <script>
            document.addEventListener('DOMContentLoaded', function() {
                // Get button elements
                const showEmployee = document.getElementById('showemployee');
                const showDepartment = document.getElementById('showdepartment');

                // Get section elements
                const employeeShow = document.getElementById('employeeshow');
                const departmentShow = document.getElementById('departmentshow');

                // When "Employee" button is clicked, show employees and hide department section.
                showEmployee.addEventListener('click', function() {
                    employeeShow.classList.remove('hidden');
                    departmentShow.classList.add('hidden');
                });

                // When "Department" button is clicked, show department and hide employee section.
                showDepartment.addEventListener('click', function() {
                    employeeShow.classList.add('hidden');
                    departmentShow.classList.remove('hidden');
                });

                // Dropdown toggle (if your UI uses one)
                const menuButton = document.getElementById('menu-button');
                const dropdownMenu = document.getElementById('dropdown-menu');
                if (menuButton && dropdownMenu) {
                    menuButton.addEventListener('click', function() {
                        dropdownMenu.classList.toggle('hidden');
                    });
                }
            });
        </script>
        <script>
            $(document).ready(function() {
                var clientId = {{ $client->id }};

                var employedTable = $('#employed-table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: "{{ route('client.profile', ['id' => ':id']) }}".replace(':id',
                            clientId),
                        data: function(d) {

                            d.client_id = clientId;
                        }
                    },
                    columns: [{
                            data: 'employee.id',
                            name: 'employee.id'
                        },
                        {
                            data: 'name',
                            name: 'name'
                        },
                        {
                            data: 'date_hired',
                            name: 'date_hired'
                        },

                        {
                            data: 'status',
                            name: 'status'
                        },
                        {
                            data: 'position',
                            name: 'position'
                        },
                        {
                            data: 'employee.user.email',
                            name: 'employee.user.email'
                        },
                        {
                            data: 'action',
                            name: 'action',
                            orderable: false,
                            searchable: false
                        }
                    ],
                    order: [
                        [0, 'desc']
                    ]
                });
            });
        </script>
    @endsection
