@extends('layouts.sidebar')

@section('title', 'Company')
@section('content')
    @if (in_array('Manage Company', $privileges))
        @include('Admin.Client.modal')

        <div class="flex justify-between py-5 text-sm">
            <h2 class="mb-6 font-bold">Company List</h2>

            @if (in_array('Create Company', $privileges))
                <button type="button" onclick="openModal('subscribe-form-modal')"
                    class="modal-button w-40 h-10 bg-[#1d1d1d] text-white rounded-md text-xs cursor-pointer font-semibold text-center shadow-xs transition-all duration-500 hover:bg-indigo-700">
                    Add Company
                </button>
            @endif
        </div>
        @if (session('success'))
            <div class="p-4 mb-4 text-white bg-green-500">
                {{ session('success') }}
            </div>
        @endif
        <div class="overflow-auto p-6 bg-gray-100 rounded-lg shadow-md border border-gray-300">
            <table id="employee-table" class="min-w-full border border-gray-200 rounded shadow-md ">
                <thead>
                    <tr class="text-sm leading-normal  text-white  bg-[#1d1d1d]">
                        <th class="px-6 py-1">ID</th>
                        <th class="px-6 py-1">Agency</th>
                        <th class="px-6 py-1">Company Name</th>
                        <th class="px-6 py-1">Address</th>
                        <th class="px-6 py-1">Contact Number</th>

                        <th class="px-6 py-1">Actions</th>
                    </tr>
                </thead>
                <tbody class="text-sm font-light text-center text-gray-600">

                </tbody>
            </table>
        </div>
        <script type="text/javascript">
            $(document).ready(function() {
                // Initialize DataTable
                var table = $('#employee-table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: "{{ route('clients.index') }}",
                    columns: [{
                            data: 'id',
                            name: 'id'
                        },
                        {
                            data: 'agency.name',
                            name: 'agency.name'
                        },

                        {
                            data: 'business_name',
                            name: 'business_name'
                        },

                        {
                            data: 'address',
                            name: 'address'
                        },
                        {
                            data: 'contact_number',
                            name: 'contact_number'
                        },

                        {
                            data: 'action',
                            name: 'action',
                            orderable: false,
                            searchable: false
                        }
                    ],
                    order: [
                        [0, 'desc']
                    ]
                });


            });
        </script>
    @else
        <div class="flex items-center justify-center w-full h-full my-2">
            <div>
                <i class="mr-2 text-3xl bx bx-lock"></i> <!-- Large lock icon indicating no access -->
                <span class="text-gray-500">You don't have privilege to access this page</span>
            </div>

        </div>
    @endif
@endsection
