@extends('layouts.sidebar')
@section('title', 'Agency')
@section('content')

    @if (in_array('Manage Agency', $privileges))
        @include('Admin.Company.modal')

        <div class="flex justify-between py-5">
            <h1 class="mb-4 text-xl font-bold">Companies</h1>
            @if (in_array('Create Agency', $privileges))
                <button type="button"
                    class="modal-button w-40 h-10 bg-[#1d1d1d] text-white rounded-md text-xs cursor-pointer font-semibold text-center shadow-xs transition-all duration-500 hover:bg-indigo-700"
                    data-pd-overlay="#subscribe-form-modal" data-modal-target="subscribe-form-modal"
                    data-modal-toggle="subscribe-form-modal">
                    Add Companies
                </button>
            @endif
        </div>

        @if (session('success'))
            <div class="p-4 mb-4 text-white bg-green-500">
                {{ session('success') }}
            </div>
        @endif
        <div class="overflow-auto">
            <table id="companyTable"
                class="bg-white border border-collapse border-gray-200 rounded shadow-md md:min-w-full ">
                <thead>
                    <tr class="text-xs leading-normal h-10 text-white uppercase  bg-[#1d1d1d]">
                        <th>Agency Name</th>
                        <th>Company Name</th>

                        <th>Contact Person</th>
                        <th>Phone</th>
                        <th>Address</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody class="text-sm font-light text-center text-gray-600">
                    <!-- DataTables will populate this body -->
                </tbody>
            </table>
        </div>
        <script>
            $(document).ready(function() {
                $('#companyTable').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: "{{ route('companies.index') }}", // Pointing to the index route
                    columns: [{
                            data: 'agency.name',
                            name: 'agency.name'
                        },
                        {
                            data: 'name',
                            name: 'name'
                        },
                        {
                            data: 'contact_person',
                            name: 'contact_person'
                        },
                        {
                            data: 'contact_phone',
                            name: 'contact_phone'
                        },
                        {
                            data: 'address',
                            name: 'address'
                        },
                        {
                            data: 'action',
                            name: 'action',
                            orderable: false,
                            searchable: false
                        } // No sorting/searching on action column
                    ]
                });
            });
        </script>
    @else
        <div class="flex items-center justify-center w-full h-full my-2">
            <div>
                <i class="mr-2 text-3xl bx bx-lock"></i> <!-- Large lock icon indicating no access -->
                <span class="text-gray-500">You don't have privilege to access this page</span>
            </div>

        </div>
    @endif
@endsection
