@extends('layouts.sidebar')
@section('title', 'Payroll')
@section('content')
    @if (in_array('Custom Benefits Setup', $privileges))
        <div class="grid grid-cols-1 gap-5 p-5 md:grid-cols-5">

            <!-- Employee Table -->
            <div class="col-span-4 p-2 mt-2  rounded-md">
                <p class="pb-5">Employee List</p>
                <div class="bg-white p-10 overflow-auto">
                    <table id="employed-table" class="min-w-full bg-white border border-gray-200 rounded shadow-md">
                        <thead>
                            <tr class="text-sm leading-normal text-white bg-[#1d1d1d]">
                                <th class="px-6 py-1">Assign ID</th>
                                <th class="px-6 py-1">Agency</th>
                                <th class="px-6 py-1">Company</th>
                                <th class="px-6 py-1">Client</th>
                                <th class="px-6 py-1">Name</th>
                                <th class="px-6 py-1">Status</th>
                            </tr>
                        </thead>
                        <tbody class="text-sm font-light text-center text-gray-600">
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Table Row Click Script & Styling -->
            <style>
                .clickable-row {
                    cursor: pointer;
                }

                .clickable-row:hover {
                    background-color: #f0f0f0;
                }

                .selected-row {
                    background-color: #e2e8f0 !important;
                    /* light blue-gray */
                    border-left: 4px solid #1d4ed8;
                    /* blue border */
                }
            </style>

            <script type="text/javascript">
                $(document).ready(function() {
                    var employedTable = $('#employed-table').DataTable({
                        processing: true,
                        serverSide: true,
                        ajax: {
                            url: "{{ route('benefits.customeemployeelist') }}",
                            data: function(d) {
                                d.status = '1';
                                d.office_id = $('#office_id').val();
                                d.store_id = $('#store_id').val();
                                d.pwd_filter = $('#pwd_filter').val();
                            }
                        },
                        columns: [{
                                data: 'id',
                                name: 'id',
                                width: '5%'
                            },
                            {
                                data: 'agency',
                                name: 'agency',
                                width: '10%'
                            },
                            {
                                data: 'company',
                                name: 'company',
                                width: '10%'
                            },
                            {
                                data: 'client',
                                name: 'client',
                                width: '10%'
                            },
                            {
                                data: 'employee_name',
                                name: 'employee_name',
                                width: '10%'
                            },
                            {
                                data: 'status',
                                name: 'status',
                                width: '10%'
                            },
                        ],
                        order: [
                            [0, 'desc']
                        ],
                        createdRow: function(row, data, dataIndex) {
                            $(row).attr('data-id', data.id);
                            $(row).addClass('clickable-row');
                        }
                    });

                    $('#office_id, #store_id, #pwd_filter').on('change', function() {
                        employedTable.ajax.reload();
                    });

                    // Handle row click
                    $('#employed-table tbody').on('click', '.clickable-row', function() {
                        $('#employed-table tbody tr').removeClass('selected-row');
                        $(this).addClass('selected-row');

                        var employeeChannelId = $(this).data('id');
                        $('input[name="employee_channel_id"]').val(employeeChannelId);
                    });
                });
            </script>

            <!-- Benefit Form -->
            <div class="col-span-1 p-4 space-y-4 bg-white border-2 border-black rounded-md shadow-md">
                <h2 class="pb-2 text-lg font-semibold text-gray-800 border-b">Assign Benefit</h2>

                <form id="benefit-form" class="space-y-4">
                    @csrf

                    <div>
                        <label for="employee_channel_id" class="block text-sm font-medium text-gray-700">Employee
                            Channel
                            ID</label>
                        <input type="number" name="employee_channel_id" id="employee_channel_id"
                            class="block w-full mt-1 border border-gray-400 rounded-md shadow-sm focus:ring-black focus:border-black sm:text-sm"
                            required readonly>
                    </div>

                    <div>
                        <label for="type" class="block text-sm font-medium text-gray-700">Benefit Type</label>
                        <select name="type" id="type"
                            class="block w-full mt-1 border border-gray-400 rounded-md shadow-sm focus:ring-black focus:border-black sm:text-sm"
                            required>
                            <option value="" disabled selected>Select Benefit</option>
                            <option value="SSS">SSS</option>
                            <option value="Pag-IBIG">Pag-IBIG</option>
                            <option value="PhilHealth">PhilHealth</option>
                        </select>
                    </div>

                    <div>
                        <button type="submit"
                            class="inline-flex justify-center w-full px-4 py-2 text-sm font-medium text-white bg-black border border-transparent rounded-md shadow-sm hover:bg-gray-800 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-black">
                            💾 Save Benefit
                        </button>
                    </div>
                    <p class="text-xs text-gray-500 italic">Note: Please select a specific row in the table to assign
                        the
                        employee's Channel ID.</p>

                </form>

                <!-- Feedback Message -->
                <div id="form-feedback" class="hidden mt-2 text-sm"></div>
            </div>

            <script>
                $(document).ready(function() {
                    let isSubmitting = false;

                    $('#benefit-form').on('submit', function(e) {
                        e.preventDefault();
                        if (isSubmitting) return; // prevent accidental double submit
                        isSubmitting = true;

                        const formData = {
                            _token: $('input[name="_token"]').val(),
                            employee_channel_id: $('#employee_channel_id').val(),
                            type: $('#type').val()
                        };

                        const $feedback = $('#form-feedback');
                        const $submitBtn = $(this).find('button[type="submit"]');

                        $submitBtn.prop('disabled', true).text('Saving...');

                        $.ajax({
                            url: "{{ route('benefits.storeBenefits') }}",
                            method: 'POST',
                            data: formData,
                            success: function(response) {
                                $feedback
                                    .removeClass('hidden text-red-600')
                                    .addClass('text-green-600')
                                    .text('✅ ' + response.message);

                                // Reset type only
                                $('#type').val('');

                                $('#employedbenefitscustom-table').DataTable().ajax.reload(null, false);
                            },

                            error: function(xhr) {
                                let message = '❌ Failed to save benefit.';
                                if (xhr.status === 422 && xhr.responseJSON?.message) {
                                    message = `⚠️ ${xhr.responseJSON.message}`;
                                }

                                $feedback
                                    .removeClass('hidden text-green-600')
                                    .addClass('text-red-600')
                                    .text(message);
                            },
                            complete: function() {
                                isSubmitting = false;
                                $submitBtn.prop('disabled', false).html('💾 Save Benefit');
                            }
                        });
                    });
                });
            </script>


        </div>
        <div class="grid grid-cols-1 gap-5 p-5 md:grid-cols-5">


            <div class="col-span-4 p-2 mt-2 rounded-md">
                <p class="pb-5">Custom benefit List</p>
                <div class="bg-white p-10 overflow-auto">
                    <table id="employedbenefitscustom-table"
                        class="min-w-full bg-white border border-gray-200 rounded shadow-md">
                        <thead>
                            <tr class="text-sm leading-normal text-white bg-[#1d1d1d]">
                                <th class="px-6 py-1">ID</th>
                                <th class="px-6 py-1">Agency</th>
                                <th class="px-6 py-1">Company</th>
                                <th class="px-6 py-1">Client</th>
                                <th class="px-6 py-1">Name</th>
                                <th class="px-6 py-1">Benefits Type</th>
                                <th class="px-6 py-1">View</th>

                            </tr>
                        </thead>
                        <tbody class="text-sm font-light text-center text-gray-600">
                        </tbody>
                    </table>
                </div>
            </div>


            <!-- Benefit Form -->
            <div class="col-span-1 p-4 space-y-4 bg-white border-2 border-black rounded-md shadow-md">
                <h2 class="pb-2 text-lg font-semibold text-gray-800 border-b">Bracket Benefit</h2>

                <form id="benefitbracket-form" class="space-y-4">
                    @csrf

                    <!-- Benefit Assignment Target -->
                    <div>
                        <label for="custom_channel_id" class="block text-sm font-medium text-gray-700">ID</label>
                        <input type="number" name="custom_channel_id" id="custom_channel_id"
                            class="block w-full mt-1 border border-gray-400 rounded-md shadow-sm focus:ring-black focus:border-black sm:text-sm"
                            required readonly>
                    </div>

                    <!-- Mode Switch -->
                    <div>
                        <label class="block mb-1 text-sm font-medium text-gray-700">Bracket Option</label>
                        <select id="bracket_mode" name="bracket_mode"
                            class="w-full border border-gray-400 rounded-md shadow-sm focus:ring-black focus:border-black sm:text-sm">
                            <option value="existing">Select Existing Bracket</option>
                            <option value="new">Create New Bracket</option>
                        </select>
                    </div>

                    <!-- Existing Bracket Dropdown -->
                    <div id="existing-bracket-group">
                        <label for="existing_bracket_id" class="block mt-3 text-sm font-medium text-gray-700">Existing
                            Brackets</label>
                        <select name="existing_bracket_id" id="existing_bracket_id"
                            class="block w-full mt-1 border border-gray-400 rounded-md shadow-sm focus:ring-black focus:border-black sm:text-sm">
                            <option value="">Loading...</option>
                        </select>
                    </div>

                    <script>
                        document.addEventListener('DOMContentLoaded', function() {
                            function loadBrackets() {
                                const select = document.getElementById('existing_bracket_id');
                                select.innerHTML = '<option value="">Loading...</option>';

                                axios.get('{{ route('brackets.list') }}')
                                    .then(function(response) {
                                        const data = response.data;
                                        let options = '<option value="">Select...</option>';
                                        data.forEach(function(bracket) {
                                            options += `<option value="${bracket.id}">
                        ${bracket.start_range} - ${bracket.end_range} (Emp: ${bracket.employee_rate}%, Er: ${bracket.employeer_rate}%)
                    </option>`;
                                        });
                                        select.innerHTML = options;
                                    })
                                    .catch(function(error) {
                                        console.error(error);
                                        select.innerHTML = '<option value="">Failed to load brackets</option>';
                                    });
                            }

                            // Call when modal opens or page loads
                            loadBrackets();
                        });
                    </script>

                    <!-- New Bracket Inputs -->
                    <div id="new-bracket-group" class="hidden mt-3 space-y-3">
                        <div>
                            <label for="start_range" class="block text-sm font-medium text-gray-700">Bracket Range
                                Start</label>
                            <input type="number" name="start_range" id="start_range"
                                class="block w-full mt-1 border border-gray-400 rounded-md shadow-sm focus:ring-black focus:border-black sm:text-sm">
                        </div>
                        <div>
                            <label for="end_range" class="block text-sm font-medium text-gray-700">Bracket Range
                                End</label>
                            <input type="number" name="end_range" id="end_range"
                                class="block w-full mt-1 border border-gray-400 rounded-md shadow-sm focus:ring-black focus:border-black sm:text-sm">
                        </div>
                        <div>
                            <label for="employee_rate" class="block text-sm font-medium text-gray-700">Employee
                                Rate</label>
                            <input type="number" name="employee_rate" id="employee_rate"
                                class="block w-full mt-1 border border-gray-400 rounded-md shadow-sm focus:ring-black focus:border-black sm:text-sm">
                        </div>
                        <div>
                            <label for="employeer_rate" class="block text-sm font-medium text-gray-700">Employer
                                Rate</label>
                            <input type="number" name="employeer_rate" id="employeer_rate"
                                class="block w-full mt-1 border border-gray-400 rounded-md shadow-sm focus:ring-black focus:border-black sm:text-sm">
                        </div>
                    </div>

                    <!-- Submit -->
                    <div>
                        <button type="submit"
                            class="inline-flex justify-center w-full px-4 py-2 text-sm font-medium text-white bg-black border border-transparent rounded-md shadow-sm hover:bg-gray-800 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-black">
                            💾 Save Benefit
                        </button>
                    </div>

                    <!-- Feedback -->
                    <div id="formbracket-feedback" class="hidden mt-2 text-sm"></div>
                </form>
                <p class="text-xs text-gray-500 mt-4 italic">Note: Select "Existing Bracket" to choose from the
                    available
                    brackets or "Create New Bracket" to define a new range and rates.</p>
                <!-- Feedback Message -->

            </div>

            <script>
                $(document).ready(function() {
                    // Toggle bracket mode view
                    $('#bracket_mode').on('change', function() {
                        if ($(this).val() === 'new') {
                            $('#new-bracket-group').removeClass('hidden');
                            $('#existing-bracket-group').addClass('hidden');
                        } else {
                            $('#new-bracket-group').addClass('hidden');
                            $('#existing-bracket-group').removeClass('hidden');
                        }
                    });

                    $('#benefitbracket-form').on('submit', function(e) {
                        e.preventDefault();

                        const bracketMode = $('#bracket_mode').val();

                        const formData = {
                            _token: $('input[name="_token"]').val(),
                            custom_channel_id: $('#custom_channel_id').val(),
                            bracket_mode: bracketMode,
                        };

                        if (bracketMode === 'existing') {
                            formData.existing_bracket_id = $('#existing_bracket_id').val();
                        } else {
                            formData.start_range = $('#start_range').val();
                            formData.end_range = $('#end_range').val();
                            formData.employee_rate = $('#employee_rate').val();
                            formData.employeer_rate = $('#employeer_rate').val();
                        }

                        $.ajax({
                            url: "{{ route('benefits.storeBrackets') }}",
                            method: 'POST',
                            data: formData,
                            success: function(response) {
                                $('#formbracket-feedback')
                                    .removeClass('hidden text-red-600')
                                    .addClass('text-green-600')
                                    .text('✅ Benefit saved successfully!');
                                $('#benefitbracket-form')[0].reset();

                            },

                            error: function(xhr) {
                                let message = '❌ Failed to save benefit.';
                                if (xhr.status === 422 && xhr.responseJSON?.message) {
                                    message = `⚠️ ${xhr.responseJSON.message}`;
                                }

                                $('#formbracket-feedback')
                                    .removeClass('hidden text-green-600')
                                    .addClass('text-red-600')
                                    .text(message);
                            }
                        });
                    });
                });
            </script>



        </div>
        <!-- Table Row Click Script & Styling -->


        <script type="text/javascript">
            $(document).ready(function() {
                var employedTable = $('#employedbenefitscustom-table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: "{{ route('benefits.viewcustombenefits') }}",
                        data: function(d) {
                            d.status = '1';

                        }
                    },
                    columns: [{
                            data: 'id',
                            name: 'id',
                            width: '10%'
                        }, {
                            data: 'agency',
                            name: 'agency',
                            width: '10%'
                        },
                        {
                            data: 'company',
                            name: 'company',
                            width: '10%'
                        },
                        {
                            data: 'client',
                            name: 'client',
                            width: '10%'
                        },
                        {
                            data: 'employee_name',
                            name: 'employee_name',
                            width: '10%'
                        },
                        {
                            data: 'type',
                            name: 'type',
                            width: '10%'
                        },
                        {
                            data: 'view',
                            name: 'view',
                            width: '10%',
                            orderable: false,
                            searchable: false
                        }



                    ],
                    order: [
                        [0, 'desc']
                    ],
                    createdRow: function(row, data, dataIndex) {
                        $(row).attr('data-id', data.id);
                        $(row).addClass('clickable-row');
                    }
                });
                $('#employedbenefitscustom-table tbody').on('click', '.clickable-row', function() {
                    $('#employedbenefitscustom-table tbody tr').removeClass('selected-row');
                    $(this).addClass('selected-row');

                    var channel_id = $(this).data('id');
                    $('input[name="custom_channel_id"]').val(channel_id);
                });

                // Handle row click

            });
        </script>


        <script>
            document.addEventListener('DOMContentLoaded', function() {
                // Set CSRF token for Axios (important in Laravel)
                axios.defaults.headers.common['X-CSRF-TOKEN'] = document.querySelector('meta[name="csrf-token"]')
                    .getAttribute('content');

                const modal = document.getElementById('bracket-modal');
                const bracketDetails = document.getElementById('bracket-details');
                const bracketMessage = document.getElementById('bracket-message');

                // Global click handler
                document.addEventListener('click', function(e) {

                    // 1. Show Brackets Modal
                    if (e.target.classList.contains('bx-show')) {
                        const benefitId = e.target.getAttribute('data-id');
                        const url = '{{ route('Custombenefits.brackets', ':id') }}'.replace(':id', benefitId);

                        modal.classList.remove('hidden');
                        bracketDetails.innerHTML = 'Loading...';
                        bracketMessage.textContent = ''; // Clear previous message

                        axios.get(url)
                            .then(response => {
                                const data = response.data;

                                if (!data.length) {
                                    bracketDetails.innerHTML = '<p>No brackets found.</p>';
                                    return;
                                }

                                let html = `
                        <table class="min-w-full border-collapse table-auto">
                            <thead>
                                <tr class="text-sm font-medium text-left text-gray-700 bg-gray-100">
                                    <th class="px-4 py-2">Salary Bracket</th>
                                    <th class="px-4 py-2">Employee Rate</th>
                                    <th class="px-4 py-2">Employer Rate</th>
                                    <th class="px-4 py-2">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                        `;

                                data.forEach(item => {
                                    const bracket = item.bracket;
                                    const channelId = item.channel_id;

                                    html += `
                            <tr class="border-b">
                                <td class="px-4 py-2 text-sm">${bracket.start_range} - ${bracket.end_range}</td>
                                <td class="px-4 py-2 text-sm">${bracket.employee_rate}</td>
                                <td class="px-4 py-2 text-sm">${bracket.employeer_rate}</td>
                                <td class="px-4 py-2 text-sm">
                                    <button class="px-3 py-1 text-white bg-red-600 rounded delete-bracket" data-id="${channelId}">
                                        Delete
                                    </button>
                                </td>
                            </tr>
                        `;
                                });

                                html += `</tbody></table>`;
                                bracketDetails.innerHTML = html;
                            })
                            .catch(error => {
                                console.error(error);
                                bracketDetails.innerHTML =
                                    '<p class="text-red-600">Failed to load brackets.</p>';
                            });
                    }

                    // 2. Delete Bracket Handler (removes channel)
                    if (e.target.classList.contains('delete-bracket')) {
                        const channelId = e.target.getAttribute('data-id');
                        const deleteUrl = '{{ route('Custombenefits.deleteBracket', ':id') }}'.replace(':id',
                            channelId);

                        axios.delete(deleteUrl)
                            .then(response => {
                                bracketMessage.textContent = response.data.message ||
                                    'Bracket deleted successfully.';
                                bracketMessage.className = 'text-green-600 text-sm mb-2';
                                e.target.closest('tr').remove();
                            })
                            .catch(error => {
                                console.error(error);
                                bracketMessage.textContent = 'Failed to delete bracket.';
                                bracketMessage.className = 'text-red-600 text-sm mb-2';
                            });
                    }

                    // 3. Close Modal
                    if (e.target.id === 'close-modal') {
                        modal.classList.add('hidden');
                        bracketMessage.textContent = ''; // Clear message on close
                        bracketDetails.innerHTML = ''; // Optionally clear details
                    }
                });
            });
        </script>


        <div id="bracket-modal" class="fixed inset-0 z-50 flex items-center justify-center hidden bg-black bg-opacity-50">
            <div class="w-1/2 p-6 bg-white rounded-md">
                <h3 class="text-xl font-semibold">Bracket Details</h3>
                <p id="bracket-message" class="text-sm mb-2"></p>

                <div id="bracket-details" class="mt-4">Loading...</div>

                <button id="close-modal" class="px-4 py-2 mt-4 text-white bg-red-600 rounded-md">
                    Close
                </button>
            </div>
        </div>
    @else
        <div class="flex items-center justify-center w-full h-full my-2">
            <div>
                <i class="mr-2 text-3xl bx bx-lock"></i>
                <span class="text-gray-500">You don't have privilege to access this page</span>
            </div>

        </div>
    @endif

@endsection
