<div id="deleteModal" class="fixed inset-0 flex z-50 items-center justify-center hidden bg-black bg-opacity-50">
    <div class="w-1/3 p-6 bg-white rounded-lg shadow-lg">
        <h2 class="mb-4 text-xl font-bold">Confirm Delete</h2>
        <p class="mb-4">Are you sure you want to delete this record? This action cannot be undone.</p>
        <div class="flex justify-end space-x-4">
            <button type="button" id="deleteCancelBtn" class="px-4 py-2 text-white bg-gray-500 rounded">Cancel</button>
            <button type="button" id="deleteConfirmBtn" class="px-4 py-2 text-white bg-red-500 rounded">Delete</button>
        </div>
    </div>
</div>


<div id="successModal" class="fixed inset-0 z-50 flex items-center justify-center hidden bg-black bg-opacity-50">
    <div class="p-5 bg-white rounded-lg shadow-lg w-96">
        <h2 class="text-lg font-bold text-center">Success</h2>
        <p class="mt-2 text-center text-gray-700">Data record added successfully!</p>
        <div class="mt-4 text-center">
            <button onclick="closeModal('successModal')"
                class="px-4 py-2 text-white bg-blue-500 rounded-lg hover:bg-blue-700">
                OK
            </button>
        </div>
    </div>
</div>

<script>
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    function confirmDelete(payrollId) {
        $('#deleteModal').removeClass('hidden');

        $('#deleteConfirmBtn').off('click').on('click', function() {
            deletePayroll(payrollId);
        });

        $('#deleteCancelBtn').off('click').on('click', function() {
            $('#deleteModal').addClass('hidden');
        });
    }

    // Function to perform the deletion via AJAX
    function deletePayroll(payrollId) {
        $.ajax({
            url: "{{ route('departments.destroy', ':payrollId') }}".replace(':payrollId', payrollId),
            method: 'DELETE',
            success: function(response) {
                $('#deleteModal').addClass('hidden');
                $('#department-table').DataTable().ajax.reload(null, false);

            },
            error: function(xhr, status, error) {
                alert("Error deleting payroll: " + error);
            }
        });
    }
</script>







<div class="relative w-full ">
    <div id="departmentModal"
        class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
        <div class="bg-white rounded-lg shadow-lg p-2 w-auto   mt-10">
            <div class="flex flex-col px-5 py-4 bg-white rounded-2xl">
                <div class="flex items-center justify-between pb-1 border-b border-gray-200">
                    <h4 class="text-sm font-medium text-gray-900">Create Department</h4>
                    <button class="block cursor-pointer close-modal-button" onclick="closeModal('departmentModal')">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path d="M7.75732 7.75739L16.2426 16.2427M16.2426 7.75739L7.75732 16.2427" stroke="black"
                                stroke-width="1.6" stroke-linecap="round" />
                        </svg>
                    </button>
                </div>
                <div class="h-[40rem] overflow-auto">
                    <form id="create-department-form" action="{{ route('departments.store') }}" class="w-full space-y-6"
                        method="POST">
                        @csrf

                        <div class="grid grid-cols-1 gap-10 lg:grid-cols-2">
                            <div class="space-y-5 ">
                                <div class="p-2 border-2 border-black rounded-md">
                                    <div>
                                        <label for="client_id"
                                            class="block text-sm font-medium text-gray-700">Company:</label>
                                        <select name="client_id" id="client_id"
                                            class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm">
                                            <option value="" disabled selected>Select Company</option>
                                            @foreach ($clients as $client)
                                                <option value="{{ $client->id }}">{{ $client->business_name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="mt-2">
                                        <label for="department_name"
                                            class="block text-sm font-medium text-gray-700">Client
                                            Name:</label>
                                        <input type="text" name="department_name" id="department_name"
                                            class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm"
                                            placeholder="Enter Department Name" required>
                                    </div>
                                    <div class="mt-2">
                                        <label for="email" class="block text-sm font-medium text-gray-700">
                                            Email:</label>
                                        <input type="email" name="email" id="email"
                                            class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm"
                                            placeholder="Enter email" required>
                                    </div>
                                    <div class="form-group mt-2">
                                        <label for="start-date" class="block text-sm font-semibold text-gray-700">Start
                                            Date</label>
                                        <input type="date" id="start-date" name="start"
                                            class="block w-full px-4 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500"
                                            required>
                                    </div>
                                </div>
                                <div class="p-2 border-2 border-black rounded-md ">
                                    <div class="mb-4">
                                        <p class="mb-5 text-xl font-bold">ASF</p>
                                        <label class="block mb-2 font-bold text-gray-700"
                                            for="service_charge_type">Service
                                            Charge
                                            Type</label>
                                        <select name="service_charge_type" id="service_charge_type"
                                            class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm"
                                            onchange="toggleServiceChargeInput()" required>
                                            <option value="amount">Amount</option>
                                            <option value="percentage">Percentage</option>
                                        </select>
                                    </div>


                                    <div class="mb-4" id="service_charge_amount_container">

                                        <label class="block mb-2 font-bold text-gray-700" for="charge_amount">Service
                                            Charge
                                            (Amount)</label>
                                        <input type="number" name="charge_amount" id="service_charge_amount"
                                            class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm"
                                            placeholder="Enter service charge amount">
                                    </div>

                                    <!-- Service Charge Percentage Field -->
                                    <div class="mb-4" id="service_charge_percentage_container" style="display: none;">
                                        <label class="block mb-2 font-bold text-gray-700" for="service_charge">Service
                                            Charge
                                            (Percentage)</label>
                                        <input type="number" name="service_charge" id="service_charge"
                                            class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm"
                                            placeholder="Enter service charge percentage">
                                    </div>
                                    <div class="mb-4">
                                        <select id="selectOption1"
                                            class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm">
                                            <option value="default">Select an Option</option>
                                            <option value="showDiv1">Default</option>
                                            <option value="showDiv2">Special Set Up</option>
                                        </select>
                                        <div id="div11" class="p-4 mt-4 mb-4">
                                            <div class="grid grid-cols-1 gap-5 mb-5 text-sm lg:grid-cols-3">
                                                @foreach ($trx as $item)
                                                    <div class="flex items-center space-x-3">
                                                        <input type="checkbox" name="service_type[]"
                                                            value="{{ $item->id }}" id="trx_{{ $item->id }}"
                                                            class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                                                        <label for="trx_{{ $item->id }}"
                                                            class="">{{ $item->description }}</label>
                                                    </div>
                                                @endforeach
                                                <div class="flex items-center space-x-3">

                                                    <input type="checkbox" name="s_camputation_for_all"
                                                        value="1" id="all"
                                                        class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                                                    <label for="ALL" class="">all</label>

                                                </div>
                                            </div>
                                        </div>

                                        <!-- Div 2 -->
                                        <div id="div22" class="hidden mb-4">
                                            <label class="block mb-2 font-bold text-gray-700" for="vat">Special
                                                Rate</label>
                                            <input type="number" name="special_rate_service"
                                                id="special_rate_service"
                                                class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm"
                                                placeholder="Enter VAT">
                                        </div>
                                    </div>
                                    <script>
                                        document.getElementById('selectOption1').addEventListener('change', function() {
                                            const selectedValue = this.value;
                                            const div1 = document.getElementById('div11');
                                            const div2 = document.getElementById('div22');

                                            // Hide both divs initially
                                            div1.classList.add('hidden');
                                            div2.classList.add('hidden');

                                            // Show the selected div based on the option chosen
                                            if (selectedValue === 'showDiv1') {
                                                div1.classList.remove('hidden');
                                                div1.classList.add('block');
                                            } else if (selectedValue === 'showDiv2') {
                                                div2.classList.remove('hidden');
                                                div2.classList.add('block');
                                            }
                                        });
                                    </script>
                                </div>

                            </div>
                            <div>
                                <div class="p-2 mb-2 border-2 border-black rounded-md">
                                    <div class="form-group">
                                        <label for="duration-option"
                                            class="block text-sm font-semibold text-gray-700">Choose
                                            Duration</label>
                                        <select id="duration-option"
                                            class="block w-full px-4 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
                                            <option value="month">Month</option>
                                            <option value="year">Year</option>
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <label for="span"
                                            class="block text-sm font-semibold text-gray-700">Span</label>
                                        <input type="number" id="span"
                                            class="block w-full px-4 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500"
                                            min="1" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="end-date" class="block text-sm font-semibold text-gray-700">End
                                            Date</label>
                                        <input type="date" id="end-date" name="end_date"
                                            class="block w-full px-4 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500"
                                            required>
                                    </div>

                                    <script>
                                        // Function to update the end date whenever the span or other inputs are changed
                                        function updateEndDate() {
                                            const startDateInput = document.getElementById('start-date').value;
                                            const endDateInput = document.getElementById('end-date');
                                            const durationOption = document.getElementById('duration-option').value;
                                            const span = parseInt(document.getElementById('span').value);

                                            if (!startDateInput || isNaN(span)) {
                                                return; // Do nothing if the start date or span is not valid
                                            }

                                            const startDate = new Date(startDateInput);
                                            let newEndDate;

                                            // Adjust the end date based on the selected duration (month or year)
                                            if (durationOption === 'month') {
                                                newEndDate = new Date(startDate);
                                                newEndDate.setMonth(startDate.getMonth() + span);
                                            } else if (durationOption === 'year') {
                                                newEndDate = new Date(startDate);
                                                newEndDate.setFullYear(startDate.getFullYear() + span);
                                            }

                                            // Format the date to 'YYYY-MM-DD' for display in the input
                                            const formattedNewEndDate = newEndDate.toISOString().split('T')[0];

                                            // Set the calculated end date in the input field
                                            endDateInput.value = formattedNewEndDate;
                                        }

                                        // Add event listeners to trigger the calculation when inputs change
                                        document.getElementById('start-date').addEventListener('change', updateEndDate);
                                        document.getElementById('duration-option').addEventListener('change', updateEndDate);
                                        document.getElementById('span').addEventListener('input', updateEndDate);
                                    </script>
                                </div>

                                <div class="p-2 border-2 border-black rounded-md"> <!-- VAT -->
                                    <div class="mb-4">
                                        <label class="block mb-2 font-bold text-gray-700" for="vat">VAT</label>
                                        <input type="number" name="vat" id="vat"
                                            class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm"
                                            placeholder="Enter VAT" required>
                                    </div>
                                    <div class="mb-4">
                                        <select id="selectOption"
                                            class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-s">
                                            <option value="default">Select an Option</option>
                                            <option value="showDiv1">Default</option>
                                            <option value="showDiv2">Special Set Up</option>
                                        </select>
                                        <div id="div1" class="p-4 mt-4 mb-4">


                                            <div class="grid grid-cols-1 gap-5 mb-5 text-sm lg:grid-cols-3">
                                                @foreach ($trx as $item)
                                                    <div class="flex items-center space-x-3">
                                                        <input type="checkbox" name="vat_type[]"
                                                            value="{{ $item->id }}" id="trx_{{ $item->id }}"
                                                            class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                                                        <label for="trx_{{ $item->id }}"
                                                            class="">{{ $item->description }}</label>
                                                    </div>
                                                @endforeach
                                            </div>

                                            <div class="flex items-center space-x-3">

                                                <input type="checkbox" name="v_camputation_for_all" value="1"
                                                    id="all"
                                                    class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                                                <label for="ALL" class="">all</label>

                                            </div>
                                        </div>

                                        <!-- Div 2 -->
                                        <div id="div2" class="hidden mb-4">
                                            <label class="block mb-2 font-bold text-gray-700" for="vat">Special
                                                Rate</label>
                                            <input type="number" name="special_rate_vat" id="special_rate_vat"
                                                class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm"
                                                placeholder="Enter VAT">
                                        </div>

                                        <script>
                                            document.getElementById('selectOption').addEventListener('change', function() {
                                                const selectedValue = this.value;
                                                const div1 = document.getElementById('div1');
                                                const div2 = document.getElementById('div2');

                                                // Hide both divs initially
                                                div1.classList.add('hidden');
                                                div2.classList.add('hidden');

                                                // Show the selected div based on the option chosen
                                                if (selectedValue === 'showDiv1') {
                                                    div1.classList.remove('hidden');
                                                    div1.classList.add('block');
                                                } else if (selectedValue === 'showDiv2') {
                                                    div2.classList.remove('hidden');
                                                    div2.classList.add('block');
                                                }
                                            });
                                        </script>
                                    </div>
                                </div>
                                <div>
                                    <div class="mb-4">
                                        <label class="block mb-2 font-bold text-gray-700"
                                            for="withholding_tax">Withholding
                                            Tax</label>
                                        <input type="number" name="withholding_tax" id="withholding_tax"
                                            class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm"
                                            placeholder="Enter withholding tax" required>
                                    </div>

                                    <!-- Convert in Minute Checkbox -->
                                    <div class="mb-4">
                                        <label class="block mb-2 font-bold text-gray-700"
                                            for="convert_inminute">Convert
                                            to
                                            Minute</label>
                                        <input type="checkbox" name="convert_inminute" id="convert_inminute"
                                            value="1" class="mr-2 leading-tight">
                                        <span class="text-gray-700">Convert Decimal Part As Minute</span>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <!-- Submit Button -->
                        <div class="flex justify-center">
                            <button type="submit"
                                class="inline-flex justify-center px-10 py-2 text-sm font-medium text-white bg-indigo-600 border border-transparent rounded-md shadow-sm hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                                Create
                            </button>
                        </div>
                    </form>
                </div>
                <!-- Include Select2 Initialization -->
                <script>
                    document.addEventListener('DOMContentLoaded', function() {
                        // Initialize Select2 for company selection
                        $('#client_id').select2({
                            placeholder: "Select Company",
                            allowClear: true,
                            width: '100%' // Ensure it adapts to full width
                        });

                        // Initialize Select2 for service charge type
                        $('#service_charge_type').select2({
                            minimumResultsForSearch: Infinity, // Disable search bar for this dropdown
                            width: '100%' // Ensure it adapts to full width
                        });
                    });

                    // Function to toggle between the Amount and Percentage inputs
                    function toggleServiceChargeInput() {
                        var serviceChargeType = document.getElementById('service_charge_type').value;
                        var amountContainer = document.getElementById('service_charge_amount_container');
                        var percentageContainer = document.getElementById('service_charge_percentage_container');

                        if (serviceChargeType === 'amount') {
                            amountContainer.style.display = 'block';
                            percentageContainer.style.display = 'none';
                        } else if (serviceChargeType === 'percentage') {
                            amountContainer.style.display = 'none';
                            percentageContainer.style.display = 'block';
                        }
                    }
                </script>


            </div>
        </div>
    </div>
    <!-- Add Employee Modal -->
    <div id="addEmployeeModal" class="fixed inset-0 z-50 hidden overflow-y-auto bg-black bg-opacity-60">
        <div class="flex items-start justify-center min-h-screen p-4 mt-10">
            <div class="w-full p-6 bg-white rounded-lg shadow-lg">
                <div class="flex items-center justify-between pb-3 mb-5 ">
                    <h2 class="text-sm font-semibold">Assign Employee to Client</h2>
                    <button onclick="closeAddModal()"
                        class="text-gray-500 hover:text-gray-800 text-2xl">&times;</button>
                </div>

                <!-- Form -->
                <form id="assignEmployeeForm" method="POST" action="">
                    @csrf
                    <input type="hidden" id="departmentIdInput" name="department_id" value="">

                    <h2 class="text-xl text-center font-bold">
                        Assign Employee to <span id="departmentNameDisplay" class="text-green-600"></span>
                    </h2>
                    <div class="flex  justify-center w-full gap-10">
                        <div class="w-full">
                            <div class="mb-4">
                                <div>
                                    <div class="mb-4">
                                        <label for="default_rate_id" class="block text-sm font-semibold mb-1">Rate
                                        </label>
                                        <select id="default_rate_id" name="default_rate_id"
                                            class="border border-gray-300 p-2 rounded w-full focus:ring-2 focus:ring-blue-500">
                                            <option value="">-- Select Region --</option>
                                        </select>
                                    </div>
                                    <script>
                                        document.addEventListener("DOMContentLoaded", function() {
                                            axios.get("{{ route('region.name') }}")
                                                .then(response => {
                                                    const select = document.getElementById('default_rate_id');
                                                    select.innerHTML = ''; // Clear existing options if needed

                                                    response.data.forEach(region => {
                                                        const totalRate = parseFloat(region.default_rate) + parseFloat(region
                                                            .amount_added_total || 0);
                                                        const option = document.createElement('option');
                                                        option.value = region.id;
                                                        option.text = `${region.name} (₱${totalRate.toFixed(2)})`;
                                                        select.appendChild(option);
                                                    });
                                                })
                                                .catch(error => {
                                                    console.error('Error loading regions:', error);
                                                });
                                        });
                                    </script>
                                </div>

                                <div class="mb-4">
                                    <label for="storeID" class="block text-sm font-semibold text-gray-700">Assign
                                        Store to Employees
                                    </label>
                                    <select id="store-select" name="storeID"
                                        class="block w-full px-4 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
                                        >
                                        <option value="">-- Select Store --</option>
                                    </select>

                                </div>



                                <label for="employee_ids"
                                    class="block text-center text-xl  font-semibold text-gray-700 mt-5 mb-2">
                                    Select Employees <span class="text-gray-500 text-xs">(You can select
                                        multiple)</span>
                                </label>


                                <div class="overflow-auto">

                                    <div class="flex items-center justify-start gap-5 mb-5 ">

                                        <div class="">

                                            <label class="block mb-1 text-gray-600" for="office_id">Select
                                            </label>
                                            <select id="has_department_filter"
                                                class="w-full md:w-[15rem] h-8  border-2 border-black rounded-md">
                                                <option value="no">Without Department</option>
                                                <option value="yes">With Department</option>

                                            </select>
                                        </div>
                                        <div class="">

                                            <label class="block mb-1 text-gray-600" for="office_id">Select
                                                Office</label>
                                            <select id="office_id" name="office_id"
                                                class="w-full md:w-[15rem] h-8  border-2 border-black rounded-md">
                                                <option value="">Select an Office</option>
                                                @foreach ($offices as $office)
                                                    <option value="{{ $office->id }}">{{ $office->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div>
                                            <label class="block mb-1 text-gray-600" for="store_id">Select
                                                Store</label>
                                            <select id="store_id" name="store_id"
                                                class="w-full md:w-[15rem] h-8   border-2 border-black rounded-md">
                                                <option value="">Select a Store</option>
                                                @foreach ($stores as $store)
                                                    <option value="{{ $store->id }}">{{ $store->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div>
                                            <label class="block mb-1 text-gray-600" for="pwd_filter">PWD
                                                Filter</label>
                                            <select id="pwd_filter" name="pwd_filter"
                                                class="w-full md:w-[15rem] h-8   border-2 border-black rounded-md">
                                                <option value="">Select PWD Status</option>
                                                <option value="PWD">PWD</option>
                                                <option value="Not PWD">Not PWD</option>
                                            </select>
                                        </div>
                                    </div>
                                    <table id="pre-employment-table"
                                        class="min-w-full bg-white border border-gray-200 rounded shadow-md">
                                        <thead>
                                            <tr class="text-sm leading-normal text-white bg-[#1d1d1d]">
                                                <th class="px-6 py-1"><input type="checkbox" id="select_all" /></th>

                                                <th class="px-6 py-1">Name</th>
                                                <th class="px-6 py-1">Age</th>
                                                <th class="px-6 py-1">Sex</th>
                                                <th class="px-6 py-1">PWD</th>
                                                <th class="px-6 py-1">Status</th>

                                                <th class="px-6 py-1">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody class="text-sm font-light text-center text-gray-600">
                                            <!-- Populated via DataTables -->
                                        </tbody>
                                    </table>
                                </div>
                                <div id="selected-applicants"></div>
                                <script type="text/javascript">
                                    $(document).ready(function() {
                                        var selectedIds = new Set();

                                        const preEmploymentTable = $('#pre-employment-table').DataTable({
                                            processing: true,
                                            serverSide: true,
                                            ajax: {
                                                url: "{{ route('departmentempoyeeadd.index') }}",
                                                data: function(d) {
                                                    d.office_id = $('#office_id').val();
                                                    d.store_id = $('#store_id').val();
                                                    d.pwd_filter = $('#pwd_filter').val();
                                                    d.has_department = $('#has_department_filter').val();
                                                }
                                            },
                                            columns: [{
                                                    data: 'id',
                                                    orderable: false,
                                                    searchable: false,
                                                    render: function(data) {
                                                        return `<input type="checkbox" class="applicant-checkbox" value="${data}" ${selectedIds.has(data.toString()) ? 'checked' : ''} />`;
                                                    }
                                                },

                                                {
                                                    data: 'name',
                                                    name: 'name'
                                                },
                                                {
                                                    data: 'age',
                                                    name: 'age'
                                                },
                                                {
                                                    data: 'sex',
                                                    name: 'sex'
                                                }, // Assumes your backend returns 'M' or 'F'
                                                {
                                                    data: 'pwd',
                                                    name: 'pwd'
                                                },
                                                {
                                                    data: 'status',
                                                    name: 'status'
                                                },

                                                {
                                                    data: 'mrf',
                                                    name: 'mrf',
                                                    orderable: false,
                                                    searchable: false
                                                }
                                            ],
                                            order: [
                                                [1, 'desc']
                                            ],
                                            drawCallback: function() {
                                                $('.applicant-checkbox').each(function() {
                                                    const id = $(this).val();
                                                    $(this).prop('checked', selectedIds.has(id));
                                                });
                                            }
                                        });

                                        $('#office_id, #store_id, #pwd_filter, #has_department_filter').on('change', function() {
                                            preEmploymentTable.ajax.reload();
                                        });

                                        $('#pre-employment-table tbody').on('change', '.applicant-checkbox', function() {
                                            const id = $(this).val();
                                            const hiddenInputId = `#applicant-${id}`;
                                            if (this.checked) {
                                                selectedIds.add(id);
                                                if (!$(hiddenInputId).length) {
                                                    $('#selected-applicants').append(
                                                        `<input type="hidden" name="employee_ids[]" value="${id}" id="applicant-${id}">`
                                                    );
                                                }
                                            } else {
                                                selectedIds.delete(id);
                                                $(hiddenInputId).remove();
                                            }
                                        });

                                        $('#select_all').on('change', function() {
                                            const checked = this.checked;
                                            $('.applicant-checkbox').each(function() {
                                                $(this).prop('checked', checked).trigger('change');
                                            });
                                        });
                                    });
                                </script>
                                <!-- Employee Dropdown -->

                                @error('employee_ids')
                                    <div class="text-sm text-red-600">{{ $message }}</div>
                                @enderror
                            </div>


                        </div>
                        <div class="w-full">
                            <div class="mb-4">
                                <label for="position" class="block text-sm font-medium text-gray-700">Position</label>
                                <input type="text" id="position" name="position"
                                    class="block w-full px-3 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm"
                                    value="{{ old('position') }}">
                                @error('position')
                                    <div class="text-sm text-red-600">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Date Hired -->
                            <div class="mb-4">
                                <label for="date_hired" class="block text-sm font-medium text-gray-700">Date
                                    Hired</label>
                                <input type="date" id="date_hired" name="date_hired"
                                    class="block w-full px-3 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm"
                                    value="{{ old('date_hired') }}">
                                @error('date_hired')
                                    <div class="text-sm text-red-600">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="mb-4">
                                <label for="employment_start_date"
                                    class="block text-sm font-medium text-gray-700">Employment
                                    Start Date</label>
                                <input type="date" id="employment_start_date" name="employment_start_date"
                                    class="block w-full px-3 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm"
                                    value="{{ old('employment_start_date') }}">
                                @error('employment_start_date')
                                    <div class="text-sm text-red-600">{{ $message }}</div>
                                @enderror
                            </div>

                            <!-- Employment End Date -->
                            <div class="mb-4">
                                <label for="end_date_option"
                                    class="block text-sm font-medium text-gray-700">Employment
                                    End Date
                                    Calculation</label>

                                <!-- Dropdown to choose between months or years -->
                                <select id="duration_unit" name="duration_unit"
                                    class="block w-full px-3 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                                    <option value="months">Months</option>
                                    <option value="years">Years</option>
                                </select>
                            </div>

                            <!-- Duration Input (Number of months or years) -->
                            <div class="mb-4">
                                <label for="duration" class="block text-sm font-medium text-gray-700">Duration</label>
                                <input type="number" id="duration" name="duration" min="1" value="1"
                                    class="block w-full px-3 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                            </div>

                            <!-- Input for Employment End Date -->
                            <div class="mb-4">
                                <input type="date" id="employment_end_date" name="employment_end_date"
                                    class="block w-full px-3 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm">
                            </div>

                            <script>
                                // Get references to the Start Date, End Date, Duration, and Duration Unit fields
                                const startDateInput = document.getElementById('employment_start_date');
                                const endDateInput = document.getElementById('employment_end_date');
                                const durationInput = document.getElementById('duration');
                                const durationUnitSelect = document.getElementById('duration_unit');

                                // Function to calculate the End Date based on selected duration
                                function calculateEndDate() {
                                    const startDate = new Date(startDateInput.value);
                                    const duration = parseInt(durationInput.value);
                                    const durationUnit = durationUnitSelect.value;

                                    // Check if a valid Start Date and Duration are provided
                                    if (!startDateInput.value || !duration) return;

                                    // Calculate the End Date based on the selected duration unit
                                    if (durationUnit === 'years') {
                                        startDate.setFullYear(startDate.getFullYear() + duration); // Add years
                                    } else if (durationUnit === 'months') {
                                        startDate.setMonth(startDate.getMonth() + duration); // Add months
                                    }

                                    // Format the End Date to match the input field's date format (yyyy-mm-dd)
                                    const endDate = startDate.toISOString().split('T')[0];

                                    // Set the End Date input value to the calculated date
                                    endDateInput.value = endDate;
                                }

                                // Event listeners to trigger calculation when Start Date, Duration, or Unit changes
                                startDateInput.addEventListener('change', calculateEndDate);
                                durationInput.addEventListener('input', calculateEndDate);
                                durationUnitSelect.addEventListener('change', calculateEndDate);

                                // Optional: Call calculateEndDate on page load if there's a pre-filled Start Date
                                document.addEventListener('DOMContentLoaded', function() {
                                    if (startDateInput.value) {
                                        calculateEndDate();
                                    }
                                });
                            </script>


                            <div>
                                <label for="entry_time" class="block text-sm font-medium text-gray-700">Entry
                                    Time:</label>
                                <input type="time" name="entry_time" id="entry_time"
                                    class="block w-full px-3 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm"
                                    placeholder="Select Entry Time" value="{{ old('entry_time') }}">
                                @error('entry_time')
                                    <div class="text-sm text-red-600">{{ $message }}</div>
                                @enderror
                            </div>

                            <div>
                                <label for="exit_time" class="block text-sm font-medium text-gray-700">Exit
                                    Time:</label>
                                <input type="time" name="exit_time" id="exit_time"
                                    class="block w-full px-3 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 sm:text-sm"
                                    placeholder="Select Exit Time" value="{{ old('exit_time') }}">
                                @error('exit_time')
                                    <div class="text-sm text-red-600">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>


                    <div class="flex justify-center gap-10 mt-10">
                        <button type="submit" class="px-10 py-2 text-white bg-blue-600 rounded-md">Assign</button>


                    </div>
                </form>


            </div>
        </div>
    </div>
    <div id="errorModal" class="fixed inset-0 z-50 hidden bg-black bg-opacity-50 flex items-center justify-center">
        <div class="bg-white p-6 rounded-lg shadow-lg w-96">
            <h2 class="text-lg font-bold text-red-600 text-center">Validation Errors</h2>
            <ul id="errorList" class="mt-4 text-sm text-gray-700 list-disc list-inside"></ul>
            <div class="mt-6 flex justify-center">
                <button onclick="closeModal('errorModal')"
                    class="px-4 py-2 bg-red-600 text-white rounded hover:bg-red-700">
                    Close
                </button>
            </div>
        </div>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const errors = @json($errors->all());
            if (errors.length > 0) {
                const errorList = document.getElementById('errorList');
                errorList.innerHTML = ""; // clear previous
                errors.forEach(error => {
                    let li = document.createElement('li');
                    li.textContent = error;
                    errorList.appendChild(li);
                });
                openModal('errorModal');
            }
        });
    </script>

    <script>
        // Keep the modal open if there are validation errors
        document.addEventListener('DOMContentLoaded', function() {
            // Check if there are any validation errors
            const errors = @json($errors->all());
            if (errors.length > 0) {
                // Keep the modal open
                openAddModal();
            }
        });
    </script>
    <script>
        function openAddModal(departmentName, id, url) {
            document.getElementById('assignEmployeeForm').action = url;
            document.getElementById('departmentIdInput').value = id;
            document.getElementById('departmentNameDisplay').textContent = departmentName;
            document.getElementById('addEmployeeModal').classList.remove('hidden');

            const storeSelect = document.getElementById('store-select');

            // Clear previous options
            storeSelect.innerHTML = '<option value="">-- Select Store --</option>';

            // Get base route with placeholder from Blade
            const storesSelectRoute = "{{ route('stores.select', ['id' => ':id']) }}";

            // Replace placeholder with actual department ID
            const fetchUrl = storesSelectRoute.replace(':id', id);

            fetch(fetchUrl)
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        data.data.forEach(store => {
                            const option = document.createElement('option');
                            option.value = store.id;
                            option.textContent = store.name;
                            storeSelect.appendChild(option);
                        });
                    }
                })
                .catch(error => console.error('Error loading stores:', error));
        }

        function closeAddModal() {
            document.getElementById('addEmployeeModal').classList.add('hidden');
        }
    </script>

    <script>
        function openModal(modalId) {
            var modal = document.getElementById(modalId);
            modal.classList.remove('hidden');
            modal.classList.add('flex');
        }

        // Function to close a modal
        function closeModal(modalId) {
            var modal = document.getElementById(modalId);
            modal.classList.add('hidden');
            modal.classList.remove('flex');
        }
    </script>
