<div class="p-2 overflow-auto border-2 border-black rounded-md ">
    <table id="payroll-table" class="min-w-full bg-white border border-gray-200 rounded shadow-md">
        <thead>
            <tr class="text-sm leading-normal text-white bg-black">
                <th class="px-6 ">Batch Code</th>
                <th class="px-6 ">Client</th>
                <th class="px-6 ">Payroll Prepared by</th>
                <th class="px-6 ">Payroll Approved by</th>
                <th class="px-6 ">Pay Period </th>

                <th class="px-6 ">Number of Employee</th>

                <th class="px-6 ">Actions</th>
            </tr>
        </thead>
        <tbody class="text-sm font-light text-center text-gray-600">

        </tbody>
    </table>
</div>
<script>
    $(document).ready(function() {
        var employedTable = $('#payroll-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('finalpayroll.index') }}",
                data: function(d) {
                    // Custom data if needed
                }
            },
            columns: [{
                    data: 'id',
                    name: 'id',
                    width: '10%' // Set the width for the ID column
                },
                {
                    data: 'client.department_name',
                    name: 'client.department_name',
                    width: '10%' // Set the width for the Client Business Name column
                },
                {
                    data: 'approve_by',
                    name: 'approve_by',
                    width: '10%' // Set the width for the Approve By column
                },
                {
                    data: 'approve_by1',
                    name: 'approve_by1',
                    width: '10%' // Set the width for the Approve By column
                },
                {
                    data: 'pay_period',
                    name: 'pay_period',
                    width: '10%' // Set the width for the Pay Period Start column
                },

                {
                    data: 'employee_count',
                    name: 'employee_count',
                    width: '10%' // Set the width for the Employee Count column
                },


                {
                    data: 'action', // Matches the action column from your server response
                    name: 'action',
                    orderable: false,
                    searchable: false,
                    width: '10%' // Set the width for the Action column
                }
            ],
            order: [
                [0, 'desc'] // Orders by the first column (ID) in descending order
            ]
        });
    });
</script>
