<div class="overflow-x-auto">
    <div class="ml-[1rem] mb-5">
        <div>
            <label class="flex items-center space-x-2 cursor-pointer">
                <input type="checkbox" id="billingCheckbox"
                    data-route="{{ route('update.billing.status', $department->id) }}"
                    class="w-5 h-5 text-blue-600 border-gray-300 rounded focus:ring-blue-500"
                    {{ $department->billing_status == 1 ? 'checked' : '' }}>
                <span class="text-gray-700">Check if the billing setup is date-based</span>
            </label>
        </div>
    </div>

    <!-- Success Modal -->
    <div id="successModal123" class="fixed z-50 inset-0 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
        <div class="bg-white rounded-lg p-6 mt-20 shadow-lg w-96">
            <h2 class="text-xl font-semibold text-gray-800">Success</h2>
            <p class="mt-2 text-gray-600">Billing status has been updated successfully.</p>
            <div class="flex items-center justify-end mr-2"><button id="closeModal123"
                    class="mt-4 px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-700">
                    Close
                </button>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const checkbox = document.getElementById("billingCheckbox");
            const successModal = document.getElementById("successModal123");
            const closeModal = document.getElementById("closeModal123");

            if (!checkbox) {
                console.error("Billing checkbox not found.");
                return;
            }

            checkbox.addEventListener("change", function() {
                let route = this.getAttribute("data-route");
                let status = this.checked ? 1 : 0;

                fetch(route, {
                        method: "POST",
                        headers: {
                            "X-CSRF-TOKEN": "{{ csrf_token() }}",
                            "Content-Type": "application/json",
                        },
                        body: JSON.stringify({
                            billing_status: status
                        }),
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            console.log("Billing status updated.");
                            successModal.classList.remove("hidden"); // Show modal
                        } else {
                            console.error("Error updating billing status:", data.message);
                        }
                    })
                    .catch(error => console.error("Fetch error:", error));
            });
            closeModal.addEventListener("click", function() {
                successModal.classList.add("hidden"); // Hide modal
            });
        });
    </script>
    <table id="chargesTable" class="min-w-full bg-white border border-gray-200 rounded shadow-md text-center">
        <thead>
            <tr class="text-sm leading-normal text-white text-nowrap bg-[#1d1d1d]">
                <th class="">Status</th> <!-- Added status column -->
                <th class="">Setup ID</th>
                <th class="">Date</th>
                <th class="">Action</th>
            </tr>
        </thead>
        <tbody></tbody>
    </table>
</div>
<!-- Success Modal -->
<div id="statusUpdateModal" class="fixed z-50 inset-0 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
    <div class="bg-white rounded-lg p-6 mt-20 shadow-lg w-96">
        <h2 class="text-xl font-semibold text-gray-800">Success</h2>
        <p class="mt-2 text-gray-600">The status has been updated successfully!</p>
        <div class="flex items-center justify-end mr-2"> <button id="confirmClose"
                class="mt-4 px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-700">Close</button>
        </div>
    </div>
</div>
<div id="deleteConfirmModal" class="fixed inset-0 flex items-start justify-center bg-black bg-opacity-50 hidden z-50">
    <div class="bg-white rounded-lg shadow-lg w-96 mt-20">
        <div class="px-6 py-4 border-b flex justify-between items-center bg-red-600 text-white">
            <h3 class="text-lg font-semibold">Confirm Delete</h3>
            <button id="closeDeleteModal" class="text-white">&times;</button>
        </div>
        <div class="p-6 text-center">
            <p class="text-gray-700">Are you sure you want to delete this charge?</p>
        </div>
        <div class="px-6 py-4 flex justify-end border-t">
            <button id="confirmDelete"
                class="px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700">Delete</button>
            <button id="cancelDelete"
                class="px-4 py-2 ml-2 bg-gray-400 text-white rounded-lg hover:bg-gray-500">Cancel</button>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        var department_id = {{ $department->id }};
        var deleteId = null; // Store ID for delete confirmation

        var table = $('#chargesTable').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route('chargestable', ['id' => ':id']) }}'.replace(':id', department_id),
            columns: [{
                    data: 'status',
                    name: 'status',
                    orderable: false,
                    searchable: false
                },
                {
                    data: 'id',
                    name: 'id'
                },
                {
                    data: 'date',
                    name: 'date'
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                }
            ],
            drawCallback: function() {
                // Handle checkbox toggle
                $('.status-toggle').on('change', function() {
                    var id = $(this).data('id');
                    var status = $(this).is(':checked') ? 1 : 0;

                    $.ajax({
                        url: '{{ route('charges.updateStatus') }}',
                        method: 'POST',
                        data: {
                            _token: '{{ csrf_token() }}',
                            id: id,
                            status: status
                        },
                        success: function(response) {
                            $('#modalMessage').text(response.message);
                            $('#statusUpdateModal').removeClass('hidden');
                        },
                        error: function() {
                            $('#modalMessage').text(
                                'Something went wrong. Please try again.');
                            $('#statusUpdateModal').removeClass('hidden');
                        }
                    });
                });

                // Open delete confirmation modal
                $('.delete-btn').on('click', function() {
                    deleteId = $(this).data('id'); // Store ID for deletion
                    $('#deleteConfirmModal').removeClass('hidden');
                });

                // Confirm delete
                $('#confirmDelete').on('click', function() {
                    if (deleteId) {
                        $.ajax({
                            url: '{{ route('charges.delete', ':id') }}'.replace(
                                ':id', deleteId),
                            type: 'DELETE',
                            data: {
                                _token: '{{ csrf_token() }}'
                            },
                            success: function(response) {
                                if (response.success) {
                                    $('#deleteConfirmModal').addClass('hidden');
                                    table.ajax.reload(); // Refresh table
                                } else {
                                    alert('Error deleting charge.');
                                }
                            },
                            error: function() {
                                alert('Error deleting charge.');
                            }
                        });
                    }
                });

                // Cancel delete
                $('#cancelDelete, #closeDeleteModal').on('click', function() {
                    $('#deleteConfirmModal').addClass('hidden');
                });
                $('#confirmClose, #closeModal').on('click', function() {
                    $('#statusUpdateModal').addClass('hidden');
                });
            }
        });
    });
</script>
