@extends('layouts.sidebar')

@section('title', 'Departments')
@section('content')
    @if (in_array('Manage Payroll' || 'Client Interface', $privileges))

        <div class="container mx-auto  p-6">
            <div class="bg-white p-6 rounded-lg shadow-md w-full">
                <h1 class="text-2xl font-semibold mb-6">Edit Charges</h1>

                <form id="update-charge-form" action="{{ route('departments.updateCharges', $charges->id) }}"
                    class="w-full space-y-6" method="POST">
                    @csrf
                    @method('PUT') <!-- Use PUT for update operations -->

                    @if ($errors->any())
                        <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-4">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <div class="grid grid-cols-1 gap-10 lg:grid-cols-2">

                        <!-- Charge Information -->
                        <div class="space-y-5 border-2 border-black p-4">

                            <div class="mb-4">
                                <p class="mb-5 text-xl font-bold">ASF</p>
                                <label class="block mb-2 font-bold text-gray-700" for="service_charge_type">Service
                                    Charge Type</label>
                                <select name="service_charge_type" id="service_charge_type"
                                    class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm"
                                    onchange="toggleServiceChargeInput()" required>
                                    <option value="amount"
                                        {{ $charges->service_charge_type == 'amount' ? 'selected' : '' }}>
                                        Amount</option>
                                    <option value="percentage"
                                        {{ $charges->service_charge_type == 'percentage' ? 'selected' : '' }}>Percentage
                                    </option>
                                </select>
                            </div>

                            <div class="mb-4" id="service_charge_amount_container"
                                style="{{ $charges->service_charge_type == 'amount' ? 'display: block;' : 'display: none;' }}">
                                <label class="block mb-2 font-bold text-gray-700" for="charge_amount">Service Charge
                                    (Amount)</label>
                                <input type="number" name="charge_amount" id="service_charge_amount"
                                    class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm"
                                    value="{{ $charges->charge_amount }}" placeholder="Enter service charge amount">
                            </div>

                            <!-- Service Charge Percentage Field -->
                            <div class="mb-4" id="service_charge_percentage_container"
                                style="{{ $charges->service_charge_type == 'percentage' ? 'display: block;' : 'display: none;' }}">
                                <label class="block mb-2 font-bold text-gray-700" for="service_charge">Service Charge
                                    (Percentage)</label>
                                <input type="number" name="service_charge" id="service_charge"
                                    class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm"
                                    value="{{ $charges->service_charge }}" placeholder="Enter service charge percentage">
                            </div>

                            <!-- Service Type Selection -->
                            <div class="mb-4 border-2 border-black rounded-md p-5 ">
                                <select id="selectOption1"
                                    class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm">
                                    <option value="default" {{ old('selectOption1') == 'default' ? 'selected' : '' }}>Select
                                        an Option</option>
                                    <option value="showDiv1" {{ old('selectOption1') == 'showDiv1' ? 'selected' : '' }}>
                                        Default</option>
                                    <option value="showDiv2" {{ old('selectOption1') == 'showDiv2' ? 'selected' : '' }}>
                                        Special Set Up</option>
                                </select>
                                <div id="div11" class="p-4 mt-4 mb-4">
                                    <div
                                        class="grid grid-cols-1 gap-5 border-2 border-black  text-sm lg:grid-cols-3 mb-10 p-5">
                                        <div class="flex items-center space-x-3">
                                            <input type="checkbox" name="s_camputation_for_all" value="1"
                                                id="all"
                                                class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500"
                                                {{ old('s_camputation_for_all', $charges->s_camputation_for_all) ? 'checked' : '' }}>
                                            <label for="ALL" class="">All</label>
                                        </div>
                                        <div class="flex items-center space-x-3">

                                            <input type="checkbox" name="s_sss" value="1" id="all"
                                                class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500"
                                                {{ old('s_sss', $charges->s_sss) ? 'checked' : '' }}>
                                            <label for="ALL" class="">SSS Default</label>

                                        </div>
                                        <div class="flex items-center space-x-3">

                                            <input type="checkbox" name="s_phil" value="1" id="all"
                                                class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500"
                                                {{ old('s_phil', $charges->s_phil) ? 'checked' : '' }}>
                                            <label for="ALL" class="">Philhealth Default</label>

                                        </div>
                                        <div class="flex items-center space-x-3">

                                            <input type="checkbox" name="s_pagibig" value="1" id="all"
                                                {{ old('s_pagibig', $charges->s_pagibig) ? 'checked' : '' }}
                                                class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                                            <label for="ALL" class="">Pagibig Default</label>

                                        </div>
                                    </div>

                                    <div
                                        class="grid grid-cols-1 gap-5 border-2 border-black  text-sm lg:grid-cols-3 mb-10 p-5">

                                        @foreach ($allServiceTypes as $item)
                                            <div class="flex items-center space-x-3">
                                                <input type="checkbox" name="service_type[]" value="{{ $item->id }}"
                                                    id="trx_{{ $item->id }}"
                                                    class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500"
                                                    {{ in_array($item->id, old('service_type', $serviceTypes)) ? 'checked' : '' }}>
                                                <label for="trx_{{ $item->id }}">{{ $item->description }}</label>
                                            </div>
                                        @endforeach
                                    </div>

                                </div>

                                <!-- Div 2 -->
                                <div id="div22" class="hidden mb-4">
                                    <label class="block mb-2 font-bold text-gray-700" for="special_rate_service">Special
                                        Rate</label>
                                    <input type="number" name="special_rate_service" id="special_rate_service"
                                        class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm"
                                        value="{{ $charges->special_rate_service }}" placeholder="Enter Special Rate">
                                </div>

                                <script>
                                    document.getElementById('selectOption1').addEventListener('change', function() {
                                        const selectedValue = this.value;
                                        const div1 = document.getElementById('div11');
                                        const div2 = document.getElementById('div22');

                                        div1.classList.add('hidden');
                                        div2.classList.add('hidden');

                                        if (selectedValue === 'showDiv1') {
                                            div1.classList.remove('hidden');
                                            div1.classList.add('block');
                                        } else if (selectedValue === 'showDiv2') {
                                            div2.classList.remove('hidden');
                                            div2.classList.add('block');
                                        }
                                    });
                                </script>
                            </div>

                        </div>

                        <!-- Tax and Date Information -->
                        <div class="space-y-5 border-2 border-black p-4">

                            <div class="mb-4">
                                <label class="block mb-2 font-bold text-gray-700" for="vat">VAT</label>
                                <input type="number" name="vat" id="vat"
                                    class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm"
                                    value="{{ $charges->vat }}" placeholder="Enter VAT" required>
                            </div>

                            <div class="mb-4 rounded-md border-2 border-black p-5">
                                <select id="selectOption"
                                    class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm">
                                    <option value="default" {{ old('selectOption') == 'default' ? 'selected' : '' }}>
                                        Select an Option</option>
                                    <option value="showDiv1" {{ old('selectOption') == 'showDiv1' ? 'selected' : '' }}>
                                        Default</option>
                                    <option value="showDiv2" {{ old('selectOption') == 'showDiv2' ? 'selected' : '' }}>
                                        Special Set Up</option>
                                </select>
                                <div id="div1" class="p-4 mt-4 mb-4">
                                    <div
                                        class="grid grid-cols-1 gap-5 border-2 border-black  text-sm lg:grid-cols-3 mb-10 p-5">
                                        <div class="flex items-center space-x-3">
                                            <input type="checkbox" name="v_camputation_for_all" value="1"
                                                id="all"
                                                class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500"
                                                {{ old('v_camputation_for_all', $charges->v_camputation_for_all) ? 'checked' : '' }}>
                                            <label for="ALL" class="">All</label>
                                        </div>
                                        <div class="flex items-center space-x-3">

                                            <input type="checkbox" name="v_sss" value="1" id="all"
                                                {{ old('v_sss', $charges->v_sss) ? 'checked' : '' }}
                                                class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                                            <label for="ALL" class="">SSS Default</label>

                                        </div>
                                        <div class="flex items-center space-x-3">

                                            <input type="checkbox" name="v_phil" value="1" id="all"
                                                {{ old('v_phil', $charges->v_phil) ? 'checked' : '' }}
                                                class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                                            <label for="ALL" class="">Philhealth Default</label>

                                        </div>
                                        <div class="flex items-center space-x-3">

                                            <input type="checkbox" name="v_pagibig" value="1" id="all"
                                                {{ old('v_pagibig', $charges->v_pagibig) ? 'checked' : '' }}
                                                class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                                            <label for="ALL" class="">Pagibig Default</label>

                                        </div>
                                    </div>

                                    <div
                                        class="grid grid-cols-1 gap-5 border-2 border-black  text-sm lg:grid-cols-3 mb-10 p-5">

                                        @foreach ($allVatTypes as $item)
                                            <div class="flex items-center space-x-3">
                                                <input type="checkbox" name="vat_type[]" value="{{ $item->id }}"
                                                    id="trx_{{ $item->id }}"
                                                    class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500"
                                                    {{ in_array($item->id, old('vat_type', $vatTypes)) ? 'checked' : '' }}>
                                                <label for="trx_{{ $item->id }}">{{ $item->description }}</label>
                                            </div>
                                        @endforeach
                                    </div>

                                </div>

                                <!-- Div 2 -->
                                <div id="div2" class="hidden mb-4">
                                    <label class="block mb-2 font-bold text-gray-700" for="special_rate_vat">Special
                                        Rate</label>
                                    <input type="number" name="special_rate_vat" id="special_rate_vat"
                                        class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm"
                                        value="{{ $charges->special_rate_vat }}" placeholder="Enter Special VAT Rate">
                                </div>

                                <script>
                                    document.getElementById('selectOption').addEventListener('change', function() {
                                        const selectedValue = this.value;
                                        const div1 = document.getElementById('div1');
                                        const div2 = document.getElementById('div2');

                                        div1.classList.add('hidden');
                                        div2.classList.add('hidden');

                                        if (selectedValue === 'showDiv1') {
                                            div1.classList.remove('hidden');
                                            div1.classList.add('block');
                                        } else if (selectedValue === 'showDiv2') {
                                            div2.classList.remove('hidden');
                                            div2.classList.add('block');
                                        }
                                    });
                                </script>
                            </div>

                            <!-- Withholding Tax -->
                            <div class="mb-4">
                                <label class="block mb-2 font-bold text-gray-700" for="withholding_tax">Withholding
                                    Tax</label>
                                <input type="number" name="withholding_tax" id="withholding_tax"
                                    class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm"
                                    value="{{ $charges->withholding_tax }}" placeholder="Enter withholding tax" required>
                                <div id="div1" class="p-4 mt-4 mb-4">
                                    <div
                                        class="grid grid-cols-1 gap-5 border-2 border-black  text-sm lg:grid-cols-3 mb-10 p-5">
                                        <div class="flex items-center space-x-3">
                                            <input type="checkbox" name="w_camputation_for_all" value="1"
                                                id="all"
                                                class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500"
                                                {{ old('w_camputation_for_all', $charges->w_camputation_for_all) ? 'checked' : '' }}>
                                            <label for="ALL" class="">All</label>
                                        </div>
                                        <div class="flex items-center space-x-3">

                                            <input type="checkbox" name="w_sss" value="1" id="w_sss"
                                                {{ old('w_sss', $charges->w_sss) ? 'checked' : '' }}
                                                class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                                            <label for="w_sss" class="">SSS Default</label>

                                        </div>
                                        <div class="flex items-center space-x-3">

                                            <input type="checkbox" name="w_phil" value="1" id="w_phil"
                                                {{ old('w_phil', $charges->w_phil) ? 'checked' : '' }}
                                                class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                                            <label for="w_phil" class="">Philhealth Default</label>

                                        </div>
                                        <div class="flex items-center space-x-3">

                                            <input type="checkbox" name="w_pagibig" value="1" id="w_pagibig"
                                                {{ old('w_pagibig', $charges->w_pagibig) ? 'checked' : '' }}
                                                class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                                            <label for="w_pagibig" class="">Pagibig Default</label>

                                        </div>
                                    </div>

                                    <div
                                        class="grid grid-cols-1 gap-5 border-2 border-black  text-sm lg:grid-cols-3 mb-10 p-5">

                                        @foreach ($allWithTypes as $item)
                                            <div class="flex items-center space-x-3">
                                                <input type="checkbox" name="with_type[]" value="{{ $item->id }}"
                                                    id="trx_{{ $item->id }}"
                                                    class="w-5 h-5 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500"
                                                    {{ in_array($item->id, old('vat_type', $WithTypes)) ? 'checked' : '' }}>
                                                <label for="trx_{{ $item->id }}">{{ $item->description }}</label>
                                            </div>
                                        @endforeach
                                    </div>

                                </div>

                            </div>

                            <!-- Convert in Minute Checkbox -->
                            <div class="mb-4">
                                <label class="block mb-2 font-bold text-gray-700" for="convert_inminute">Convert to
                                    Minute</label>
                                <input type="checkbox" name="convert_inminute" id="convert_inminute" value="1"
                                    class="mr-2 leading-tight" {{ $charges->convert_inminute ? 'checked' : '' }}>
                                <span class="text-gray-700">Convert Decimal Part As Minute</span>
                            </div>
                        </div>
                    </div>

                    <!-- Date Range -->
                    <div class="p-5 border-2 border-black">
                        <div class="mb-4">
                            <label class="block mb-2 font-bold text-gray-700" for="start_date">Start Date</label>
                            <input type="date" name="start_date" id="start_date" value="{{ $charges->start_date }}"
                                class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm">
                        </div>

                        <div class="mb-4">
                            <label class="block mb-2 font-bold text-gray-700" for="end_date">End Date</label>
                            <input type="date" name="end_date" id="end_date" value="{{ $charges->end_date }}"
                                class="block w-full px-3 py-2 mt-1 border-2 border-black rounded-md shadow-sm sm:text-sm">
                        </div>
                    </div>

                    <button type="submit"
                        class="inline-flex justify-center px-4 py-2 text-sm font-medium text-white bg-indigo-600 border border-transparent rounded-md shadow-sm hover:bg-indigo-700">
                        Update
                    </button>
                </form>


            </div>
        </div>
    @else
        <div class="flex items-center justify-center w-full h-full my-2">
            <div>
                <i class="mr-2 text-3xl bx bx-lock"></i> <!-- Large lock icon indicating no access -->
                <span class="text-gray-500">You don't have privilege to access this page</span>
            </div>
        </div>
    @endif
@endsection
