<div class="grid grid-cols-1 gap-5 lg:grid-cols-6">
    <div>

        <form id="storeForm" enctype="multipart/form-data"
            class="max-w-md mx-auto p-6 bg-white rounded-2xl shadow-md space-y-4">
            @csrf

            <input type="hidden" name="department_id" value="{{ $department->id }}">

            <!-- Store select -->
            <div>
                <label for="storeSelect" class="block text-sm font-medium text-gray-700 mb-1">
                    Select Store
                </label>
                <select id="storeSelect" name="store_id"
                    class="block w-full px-4 py-2 mt-1 border border-gray-300 rounded bg-gray-50 focus:ring focus:ring-blue-200 focus:outline-none">
                    <option value="">-- Select Store --</option>
                </select>
            </div>

            <!-- Submit button -->
            <div class="text-center">
                <button type="submit"
                    class="w-full px-4 py-2 text-white bg-blue-600 rounded-lg shadow hover:bg-blue-700 transition duration-200">
                    Submit
                </button>
            </div>
        </form>

        <script>
            document.addEventListener("DOMContentLoaded", function() {
                let departmentId = {{ $department->id ?? 'null' }};

                if (departmentId) {
                    // Generate URL from named route
                    let url = "{{ route('departments.stores.unassigned', ':id') }}";
                    url = url.replace(':id', departmentId);

                    fetch(url)
                        .then(response => response.json())
                        .then(data => {
                            let select = document.getElementById("storeSelect");

                            // reset with default
                            select.innerHTML = '<option value="">-- Select Store --</option>';

                            // append stores
                            data.data.forEach(store => {
                                let option = document.createElement("option");
                                option.value = store.id;
                                option.textContent = store.name;
                                select.appendChild(option);
                            });
                        })
                        .catch(error => console.error("Error fetching stores:", error));
                }
            });
        </script>

    </div>

    <div class="col-span-5 overflow-x-auto">
        <table id="department-assignstores-table"
            class="min-w-full text-center bg-white border border-gray-200 rounded shadow-md">
            <thead>
                <tr class="text-sm leading-normal text-white text-nowrap bg-[#1d1d1d]">
                    <th>Name</th>

                    <th>Action</th>
                </tr>
            </thead>
            <tbody></tbody>
        </table>
    </div>
</div>

<div id="deletestoreModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-900 bg-opacity-50">
    <div class="p-6 mt-20 bg-white rounded-lg shadow-lg w-96">
        <h2 class="text-lg font-semibold">Confirm Deletion</h2>
        <p class="text-gray-700">Are you sure you want to delete this file?</p>
        <input type="hidden" id="deletestoreId">
        <div class="flex justify-end mt-4">
            <button id="cancelstoreDelete"
                class="px-4 py-2 mr-2 text-gray-700 border border-gray-300 rounded-lg hover:bg-gray-100">
                Cancel
            </button>
            <button id="confirmstoreDelete" type="submit"
                class="px-4 py-2 text-white bg-red-600 rounded-lg hover:bg-red-700">
                Delete
            </button>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {
        var department_id = {{ $department->id }};
        var table = $('#department-assignstores-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: '{{ route('index.assignstore', ['id' => ':id']) }}'.replace(':id', department_id),
            columns: [{
                    data: 'name',
                    name: 'name'
                },

                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                }
            ]
        });


        // Handle form submission via AJAX
        $('#storeForm').submit(function(e) {
            e.preventDefault();
            var formData = new FormData(this);

            $.ajax({
                url: "{{ route('store_dapartmentassignment.store') }}",
                method: "POST",
                data: formData,
                contentType: false,
                processData: false,
                success: function(response) {

                    $('#uploadFormfile')[0].reset();
                    // Reload the department files table
                    table.ajax.reload();
                },
                error: function(xhr) {
                    alert("An error occurred: " + xhr.responseText);
                }
            });
        });

        $(document).on('click', '.delete-file', function() {
            var fileId = $(this).data('id');
            $('#deletestoreId').val(fileId);
            $('#deletestoreModal').removeClass('hidden');
        });

        // Close Modal
        $('#cancelstoreDelete').click(function() {
            $('#deletestoreModal').addClass('hidden');
        });

        // Confirm Delete
        $('#confirmstoreDelete').click(function() {
            var fileId = $('#deletestoreId').val();
            $.ajax({
                url: "{{ route('store_dapartmentassignment.destroy', ':id') }}".replace(':id',
                    fileId),
                method: "DELETE",
                data: {
                    _token: "{{ csrf_token() }}"
                },
                success: function(response) {

                    $('#deletestoreModal').addClass('hidden');
                    table.ajax.reload();
                },
                error: function(xhr) {
                    alert("An error occurred: " + xhr.responseText);
                }
            });
        });
    });
</script>
