<div class="grid grid-cols-1 gap-5 lg:grid-cols-6">
    <div>
        <form id="uploadFormfile" enctype="multipart/form-data">
            @csrf

            <input type="hidden" name="employee_id" value="{{ $employee->id }}" id="employee_id">

            <div class="mb-4">
                <label for="Name" class="block text-sm font-semibold text-gray-700">File Name</label>
                <input type="text" name="Name" id="Name" required
                    class="block w-full px-4 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
            </div>

            <div class="mb-4">
                <label for="file" class="block text-sm font-semibold text-gray-700">Upload File</label>
                <input type="file" name="file" id="file"
                    class="block w-full px-4 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
            </div>

            <button type="submit" class="w-full px-4 py-2 text-white bg-blue-600 rounded-md hover:bg-blue-700">
                Upload File
            </button>
        </form>
    </div>

    <div class="col-span-5 overflow-x-auto">
        <table id="docs-table" class="min-w-full text-xs bg-white border border-gray-200 rounded shadow-md">
            <thead>
                <tr class="leading-normal text-nowrap">
                    <th>Name</th>
                    <th>File</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody class="font-light text-center text-gray-600">
            </tbody>
        </table>
    </div>
</div>
<script>
    $(document).ready(function() {
        var employeeId = {{ $employee->id }};

        $('#docs-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('employeefile.get', ['id' => '__id__']) }}".replace('__id__',
                    employeeId),
                type: 'GET',
                data: function(d) {
                    d.employee_id = employeeId;
                }
            },
            columns: [{
                    data: 'Name',
                    name: 'Name'
                },
                {
                    data: 'file',
                    name: 'file',
                    render: function(data, type, row) {
                        if (data) {
                            const url =
                                `https://workszion.sgp1.digitaloceanspaces.com/${data}`;
                            return `<a href="${url}" target="_blank" class="text-blue-500 underline">View File</a>`;
                        }

                        return '<span class="text-gray-400">No file</span>';
                    }
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                }
            ],
            order: [
                [0, 'asc']
            ]
        });
        $('#uploadFormfile').submit(function(e) {
            e.preventDefault();
            var formData = new FormData(this);

            $.ajax({
                url: "{{ route('Employee_file.store') }}",
                method: "POST",
                data: formData,
                contentType: false,
                processData: false,
                success: function(response) {

                    $('#uploadFormfile')[0].reset();
                    // Reload the department files table
                    $('#docs-table').DataTable().ajax.reload(null,
                        false);
                },
                error: function(xhr) {
                    alert("An error occurred: " + xhr.responseText);
                }
            });
        });
    });
</script>
<div id="deletedocsModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
    <div class="bg-white rounded-lg shadow-lg p-6 w-auto md:w-[30rem] mt-20">
        <h2 class="mb-4 text-lg font-bold">Delete Record</h2>
        <p>Are you sure you want to delete this record?</p>

        <form id="deletedocsForm">
            @csrf
            <input type="hidden" id="deleteRecorddocsId" name="id">
            <div class="flex justify-end mt-6">
                <button type="button" onclick="closeModal('deletedocsModal')"
                    class="px-4 py-2 mr-2 text-gray-700 bg-gray-200 rounded">
                    Cancel
                </button>
                <button type="submit" class="px-4 py-2 text-white bg-red-600 rounded">
                    Delete
                </button>
            </div>
        </form>
    </div>
</div>
<script>
    $(document).ready(function() {
        // Open delete modal and set record ID
        window.openDeletedocsModal = function(recordId) {
            $('#deleteRecorddocsId').val(recordId);
            $('#deletedocsModal').removeClass('hidden');
        };

        // Close modal utility
        window.closeModal = function(modalId) {
            $('#' + modalId).addClass('hidden');
        };

        // Handle delete form submission
        $('#deletedocsForm').on('submit', function(e) {
            e.preventDefault();

            let recordId = $('#deleteRecorddocsId').val();
            let deleteUrl = "{{ route('Employee_file.destroy', ':id') }}".replace(':id', recordId);

            $.ajax({
                url: deleteUrl,
                type: "DELETE",
                data: {
                    _token: "{{ csrf_token() }}"
                },
                success: function(response) {
                    if (response.success) {
                        // Optional success modal handling
                        $('#successMessage').text(response.success);
                        $('#successModal').removeClass('hidden');

                        $('#deletedocsForm')[0].reset();
                        $('#deletedocsModal').addClass('hidden');

                        // Reload DataTable without resetting pagination
                        $('#docs-table').DataTable().ajax.reload(null, false);
                    }
                },
                error: function(xhr) {
                    alert('Error deleting record.');
                }
            });
        });
    });
</script>
