<div class="overflow-auto">

    <table id="employeerate-table" class="min-w-full bg-white border border-gray-200 rounded shadow-md ">
        <thead>
            <tr class="text-xs leading-normal text-nowrap ">

                <th>Active</th>
                <th>Date</th>
                <th>Monthly Salary</th>
                <th>Daily Rate</th>
                <th>Cola 1</th>
                <th>Cola 2</th>
                <th>Allowance</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody class="font-light text-center text-gray-600 ">
        </tbody>
    </table>
</div>


<script>
    $(document).ready(function() {
        var employeeid = {{ $employee->id }};

        var departmentTable = $('#employeerate-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('employee_rates.index', ['id' => ':id']) }}".replace(':id', employeeid),
                data: function(d) {
                    d.employee_id = employeeid;
                }
            },
            columns: [{
                    data: 'status',
                    name: 'status',
                    width: '10px',
                    render: function(data, type, row) {
                        return `<input type="checkbox" class="status-checkbox" data-id="${row.id}" ${data == 1 ? 'checked' : ''}/>`;
                    }
                },
                {
                    data: 'date',
                    name: 'date'
                },
                {
                    data: 'monthly_salary',
                    name: 'monthly_salary'
                },
                {
                    data: 'daily_rate',
                    name: 'daily_rate'
                },
                {
                    data: 'cola_1',
                    name: 'cola_1'
                },
                {
                    data: 'cola_2',
                    name: 'cola_2'
                },
                {
                    data: 'allowance',
                    name: 'allowance'
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                }
            ],
            order: [
                [0, 'desc']
            ]
        });

        // Handle checkbox changes
        $('body').on('change', '.status-checkbox', function() {
            var rateId = $(this).data('id');
            var status = $(this).is(':checked') ? 1 : 0;
            updateStatus_rate(rateId, status);
        });

        // AJAX request to update status in database
        function updateStatus_rate(rateId, status) {
            $.ajax({
                url: "{{ route('rate.update-status', ':id') }}".replace(':id', rateId),
                method: 'POST',
                data: {
                    _token: $('meta[name="csrf-token"]').attr('content'),
                    status: status
                },
                success: function(response) {
                    if (response.success) {
                        successModal_rate('Status updated successfully');
                    } else {
                        console.log('Failed to update status');
                    }
                },
                error: function() {
                    console.log('An error occurred while updating the status');
                }
            });
        }
    });
</script>
<div id="openModal_rate" class="fixed inset-0 z-[100] flex items-start justify-center hidden bg-gray-900 bg-opacity-50">
    <div class="w-11/12 p-6 mt-20 bg-white rounded-lg shadow-lg md:w-1/2">
        <h2 class="mb-4 text-2xl font-bold">Add New TrxLoan</h2>
        <!-- Modal Form -->
        <form id="rate_employee" action="{{ route('employeerates.store') }}" method="POST">
            @csrf
            <input type="hidden" name="employee_id" value="{{ $employee->id }}"> <!-- Status -->
            <div class="grid grid-cols-1 gap-10 text-xs md:grid-cols-2">
                <!-- Date -->
                <div class="mb-4">
                    <label for="date" class="block text-sm font-medium text-gray-600">Date</label>
                    <input type="date" name="date" id="date" value="{{ old('date') }}"
                        class="w-full px-4 py-2 mt-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    @error('date')
                        <p class="mt-1 text-sm text-red-500">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Monthly Salary -->
                <div class="mb-4">
                    <label for="monthly_salary" class="block text-sm font-medium text-gray-600">Monthly Salary</label>
                    <input type="number" name="monthly_salary" id="monthly_salary" step="0.01"
                        value="{{ old('monthly_salary') }}"
                        class="w-full px-4 py-2 mt-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    @error('monthly_salary')
                        <p class="mt-1 text-sm text-red-500">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Daily Rate -->
                <div class="mb-4">
                    <label for="daily_rate" class="block text-sm font-medium text-gray-600">Daily Rate</label>
                    <input type="number" name="daily_rate" id="daily_rate" step="0.01"
                        value="{{ old('daily_rate') }}"
                        class="w-full px-4 py-2 mt-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    @error('daily_rate')
                        <p class="mt-1 text-sm text-red-500">{{ $message }}</p>
                    @enderror
                </div>

                <!-- COLA 1 -->
                <div class="mb-4">
                    <label for="cola_1" class="block text-sm font-medium text-gray-600">COLA 1</label>
                    <input type="number" name="cola_1" id="cola_1" step="0.01" value="{{ old('cola_1') }}"
                        class="w-full px-4 py-2 mt-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    @error('cola_1')
                        <p class="mt-1 text-sm text-red-500">{{ $message }}</p>
                    @enderror
                </div>

                <!-- COLA 2 -->
                <div class="mb-4">
                    <label for="cola_2" class="block text-sm font-medium text-gray-600">COLA 2</label>
                    <input type="number" name="cola_2" id="cola_2" step="0.01" value="{{ old('cola_2') }}"
                        class="w-full px-4 py-2 mt-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    @error('cola_2')
                        <p class="mt-1 text-sm text-red-500">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Allowance -->
                <div class="mb-4">
                    <label for="allowance" class="block text-sm font-medium text-gray-600">Allowance</label>
                    <input type="number" name="allowance" id="allowance" step="0.01" value="{{ old('allowance') }}"
                        class="w-full px-4 py-2 mt-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500">
                    @error('allowance')
                        <p class="mt-1 text-sm text-red-500">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <button type="submit"
                class="w-full px-4 py-2 mt-4 text-white bg-blue-500 rounded-md btn btn-primary">Save</button>
            <button type="button" onclick="closeModal('openModal_rate')"
                class="w-full px-4 py-2 mt-4 text-white bg-gray-500 rounded-md btn btn-secondary">Cancel</button>
        </form>


    </div>
</div>
<script>
    function openModal(modalId) {
        var modal = document.getElementById(modalId);
        modal.classList.remove('hidden');
        modal.classList.add('flex');
    }


    function closeModal(modalId) {
        var modal = document.getElementById(modalId);
        modal.classList.add('hidden');
        modal.classList.remove('flex');
    }


    $('#rate_employee').submit(function(e) {
        e.preventDefault();

        var formData = new FormData(this);

        $.ajax({
            url: $(this).attr('action'),
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                // Close the modal
                closeModal('openModal_rate');

                // Optionally, show a success message
                alert('TrxLoan Added Successfully!');

                // Refresh the DataTable to show the new record
                $('#employeerate-table').DataTable().ajax.reload();
            },
            error: function(xhr, status, error) {
                // Handle error (e.g., show an error message)
                alert('Error: ' + xhr.responseText);
            }
        });
    });
</script>
<script>
    $(document).ready(function() {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        // Delete button click handler
        $(document).on('click', '.delete-btn', function() {
            const deleteUrl = $(this).data('url');
            const loanId = $(this).data('id');

            // Open the modal
            $('#deleteModal_rate').removeClass('hidden');

            // Confirm delete
            $('#confirmDelete_rate').on('click', function() {
                $.ajax({
                    url: deleteUrl,
                    type: 'DELETE',
                    success: function(response) {
                        // Close the modal
                        $('#deleteModal_rate').addClass('hidden');

                        // Reload the DataTable (refreshes the table after deletion)
                        $('#employeerate-table').DataTable().ajax.reload();
                    },
                    error: function(xhr, status, error) {
                        alert('An error occurred while deleting the loan.');
                    }
                });
            });

            // Cancel delete action
            $('#cancelDelete_rate').on('click', function() {
                $('#deleteModal_rate').addClass('hidden');
            });
        });
    });
</script>

<div id="deleteModal_rate" class="fixed inset-0 flex items-start justify-center hidden bg-black bg-opacity-50 z-[100]">
    <div class="w-full max-w-md p-6 mt-20 transition-all transform scale-95 bg-white rounded-lg shadow-lg ">
        <h2 class="mb-6 text-lg font-semibold text-gray-700">Are you sure you want to delete this Rate?</h2>
        <div class="flex justify-end space-x-4">
            <button id="cancelDelete_rate"
                class="px-6 py-2 text-sm font-medium text-gray-700 transition duration-200 bg-gray-300 rounded-md hover:bg-gray-400">
                Cancel
            </button>
            <button id="confirmDelete_rate"
                class="px-6 py-2 text-sm font-medium text-white transition duration-200 bg-red-600 rounded-md hover:bg-red-700">
                Delete
            </button>
        </div>
    </div>
</div>

<!-- Success Modal -->
<div id="successModal_rate" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-500 bg-opacity-75">
    <div class="w-1/3 p-6 mt-20 bg-white rounded-lg shadow-lg">
        <h2 class="text-xl font-semibold text-green-600">Success</h2>
        <p id="successMessage" class="mt-4 text-gray-700">The operation was successful!</p>
        <div class="flex justify-end mt-4">
            <button onclick="closeSuccessModal_rate()"
                class="px-4 py-2 text-white bg-blue-600 rounded-md btn btn-primary">Close</button>
        </div>
    </div>
</div>

<script>
    // Function to open the success modal
    function successModal_rate(message) {
        // Set the success message dynamically
        document.getElementById("successMessage").innerText = message;

        // Show the modal by removing the 'hidden' class and adding 'flex' class
        document.getElementById("successModal_rate").classList.remove("hidden");
        document.getElementById("successModal_rate").classList.add("flex");
    }

    // Function to close the success modal
    function closeSuccessModal_rate() {
        document.getElementById("successModal_rate").classList.add("hidden");
        document.getElementById("successModal_rate").classList.remove("flex");
    }
</script>
