@extends('layouts.sidebar')

@section('title', 'Employee')
@section('content')
    @include('Admin.Employee.modal')
    <div class="flex flex-col items-center justify-between text-sm md:flex-row ">
        <div>
            <h2 class="mb-2 font-bold">Applicants</h2>
        </div>

    </div>
    <div>
    </div>
    <div class="overflow-auto  p-6 bg-gray-100 rounded-lg shadow-md border border-gray-300">
        <div class="flex justify-between bg-white p-6 rounded-lg">
            <div class="flex items-center justify-start gap-5 mb-5 ">
                <div class="">
                    <label class="block mb-1 text-gray-600" for="office_id">Select Office</label>
                    <select id="office_id" name="office_id" class="w-full md:w-[15rem] h-8  border-2 border-black rounded-md">
                        <option value="">Select an Office</option>
                        @foreach ($offices as $office)
                            <option value="{{ $office->id }}">{{ $office->name }}</option>
                        @endforeach
                    </select>
                </div>

                <div>
                    <label class="block mb-1 text-gray-600" for="store_id">Select Store</label>
                    <select id="store_id" name="store_id"
                        class="w-full md:w-[15rem] h-8   border-2 border-black rounded-md">
                        <option value="">Select a Store</option>
                        @foreach ($stores as $store)
                            <option value="{{ $store->id }}">{{ $store->name }}</option>
                        @endforeach
                    </select>
                </div>

                <div>
                    <label class="block mb-1 text-gray-600" for="pwd_filter">PWD Filter</label>
                    <select id="pwd_filter" name="pwd_filter"
                        class="w-full md:w-[15rem] h-8   border-2 border-black rounded-md">
                        <option value="">Select PWD Status</option>
                        <option value="PWD">PWD</option>
                        <option value="Not PWD">Not PWD</option>
                    </select>
                </div>
            </div>
            <form id="importForm" enctype="multipart/form-data">
                @csrf
                <div class="p-6 rounded-lg">
                    <h2 class="mb-4 font-semibold text-md">Import Employee Data</h2>
                    <div class="flex items-center">
                        <div class="mb-4">
                            <label for="file" class="block text-sm font-medium text-gray-700">Choose Excel File</label>
                            <input type="file" name="file" id="file"
                                class="block w-full mt-1 text-sm text-gray-800" required>
                            <div id="error-message" class="mt-1 text-sm text-red-500"></div>
                        </div>

                        <div>
                            <button type="submit" id="importButton"
                                class="px-4 py-2 text-white bg-blue-500 rounded-md hover:bg-blue-600 flex items-center">
                                <span id="button-text">Import</span>
                                <span id="loading-spinner"
                                    class="hidden ml-2 border-2 border-white border-t-transparent rounded-full w-4 h-4 animate-spin"></span>
                            </button>
                        </div>
                    </div>
                </div>
            </form>
            <div id="successModal" class="fixed inset-0 z-50 flex items-start justify-center hidden ">
                <div class="bg-white rounded-lg shadow-xl w-auto mt-10 p-6 h-[50rem] overflow-y-auto">
                    <h2 class="text-lg font-semibold text-green-700 mb-2">Import Successful</h2>
                    <div id="modal-message" class="text-sm text-gray-700"></div>

                    <div class="flex items-end justify-end p-2">
                        <button onclick="closeModal12()" class="px-4 py-2 bg-green-600 text-white rounded hover:bg-green-700">
                            Close
                        </button>
                    </div>
                </div>
            </div>
            <script>
                function openModal(messageHTML) {
                    const modal = document.getElementById('successModal');
                    const messageContainer = document.getElementById('modal-message');
                    messageContainer.innerHTML = messageHTML;
                    modal.classList.remove('hidden');
                }

                function closeModal12() {
                    document.getElementById('successModal').classList.add('hidden');
                }

                document.getElementById('importForm').addEventListener('submit', function(e) {
                    e.preventDefault();

                    const form = document.getElementById('importForm');
                    const formData = new FormData(form);
                    const button = document.getElementById('importButton');
                    const buttonText = document.getElementById('button-text');
                    const loadingSpinner = document.getElementById('loading-spinner');
                    const fileInput = document.getElementById('file').files[0];
                    document.getElementById('error-message').innerText = '';

                    if (!fileInput) {
                        document.getElementById('error-message').innerText = "Please select a file.";
                        return;
                    }
                    button.disabled = true;
                    buttonText.innerText = "Importing...";
                    loadingSpinner.classList.remove('hidden');

                    axios.post('{{ route('employee.import') }}', formData, {
                        headers: {
                            'Content-Type': 'multipart/form-data'
                        }
                    }).then(response => {
                        const importedData = response.data.imported || [];
                        const skippedData = response.data.skipped || [];
                        const message = response.data.message || "File imported successfully!";

                        let modalContent = `<div class="mb-2 overflow-auto">${message}</div>`;

                        // Build table for imported employees
                        function buildImportedTable(data) {
                            if (data.length === 0) return '';
                            let html = `<h3 class="font-semibold mt-4 mb-2">Imported Employees</h3>`;
                            html += `
                <div class="overflow-auto h-[20rem] border border-gray-300">
                    <table class="min-w-full text-sm border-collapse border border-gray-300">
                        <thead class="bg-gray-100 sticky top-0">
                            <tr>
                                <th class="border p-1 text-left">Name</th>
                                <th class="border p-1 text-left">Email</th>
                                <th class="border p-1 text-left">DOB</th>
                                <th class="border p-1 text-left">Mobile</th>
                                <th class="border p-1 text-left">Address</th>
                            </tr>
                        </thead>
                        <tbody>
                `;
                            data.forEach(row => {
                                html += `
                    <tr>
                        <td class="border p-1">${row.name}</td>
                        <td class="border p-1">${row.email}</td>
                        <td class="border p-1">${row.dob || '-'}</td>
                        <td class="border p-1">${row.mobile}</td>
                        <td class="border p-1">${row.address}</td>
                    </tr>
                    `;
                            });
                            html += `
                        </tbody>
                    </table>
                </div>
                `;
                            return html;
                        }

                        // Build table for skipped employees
                        function buildSkippedTable(data) {
                            if (data.length === 0) return '';
                            let html = `<h3 class="font-semibold mt-4 mb-2">Skipped Employees</h3>`;
                            html += `
                <div class="overflow-auto h-[20rem] border border-gray-300">
                    <table class="min-w-full text-sm border-collapse border border-gray-300">
                        <thead class="bg-gray-100 sticky top-0">
                            <tr>
                                <th class="border p-1 text-left">Name</th>
                                <th class="border p-1 text-left">Mobile</th>
                                <th class="border p-1 text-left">Reason</th>
                            </tr>
                        </thead>
                        <tbody>
                `;
                            data.forEach(row => {
                                html += `
                    <tr>
                        <td class="border p-1">${row.name}</td>
                        <td class="border p-1">${row.mobile || '-'}</td>
                        <td class="border p-1">${row.reason || '-'}</td>
                    </tr>
                    `;
                            });
                            html += `
                        </tbody>
                    </table>
                </div>
                `;
                            return html;
                        }

                        modalContent += buildImportedTable(importedData);
                        modalContent += buildSkippedTable(skippedData);

                        openModal(modalContent);
                        $('#pre-employment-table').DataTable().ajax.reload(null, false);
                    }).catch(error => {
                        if (error.response?.data?.errors?.file) {
                            document.getElementById('error-message').innerText = error.response.data.errors.file[0];
                        } else if (error.response?.data?.message) {
                            document.getElementById('error-message').innerText = error.response.data.message;
                        } else {
                            document.getElementById('error-message').innerText = "An unexpected error occurred.";
                        }
                    }).finally(() => {
                        button.disabled = false;
                        buttonText.innerText = "Import";
                        loadingSpinner.classList.add('hidden');
                    });
                });
            </script>


            <div>
                <span>Excel Template:<a href="{{ asset('uploads/Employee_template.xlsx') }}" target="_black"
                        class="text-blue-500"> Download
                    </a></span>
            </div>
        </div>


        <div class="overflow-auto bg-white p-6 rounded-lg">
            <table id="pre-employment-table" class="min-w-full bg-white border border-gray-200 rounded shadow-md ">
                <thead>
                    <tr class="text-sm leading-normal  text-white  bg-[#1d1d1d]">
                        <th class="px-6 py-1">ID</th>


                        <th class="px-6 py-1">Name</th>
                        <th class="px-6 py-1">Date of Birth</th>
                        <th class="px-6 py-1">Status</th>
                        <th class="px-6 py-1">Email</th>
                        <th class="px-6 py-1">Actions</th>
                    </tr>
                </thead>
                <tbody class="text-sm font-light text-center text-gray-600">
                </tbody>
            </table>
        </div>

    </div>





    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Get the buttons
            const showEmployeeDetailsButton = document.getElementById('show-employee-details');
            const showTerminatedEmployeesButton = document.getElementById('show-terminated-employees');
            const showPreEmploymentButton = document.getElementById('show-pre-employment');

            // Get the content sections
            const employeeDetailsSection = document.getElementById('employee-details-section');
            const terminatedEmployeesSection = document.getElementById('terminated-employees-section');
            const preEmploymentSection = document.getElementById('pre-employment-section');

            // Show terminated employees section and hide others
            showTerminatedEmployeesButton.addEventListener('click', function() {
                terminatedEmployeesSection.classList.remove('hidden');
                employeeDetailsSection.classList.add('hidden');
                preEmploymentSection.classList.add('hidden');
            });

            // Show pre-employment section and hide others
            showPreEmploymentButton.addEventListener('click', function() {
                preEmploymentSection.classList.remove('hidden');
                employeeDetailsSection.classList.add('hidden');
                terminatedEmployeesSection.classList.add('hidden');
            });

            // Show employee details section and hide others
            showEmployeeDetailsButton.addEventListener('click', function() {
                employeeDetailsSection.classList.remove('hidden');
                terminatedEmployeesSection.classList.add('hidden');
                preEmploymentSection.classList.add('hidden');
            });

            // Dropdown toggle functionality
            document.getElementById('menu-button').addEventListener('click', function() {
                const menu = document.getElementById('dropdown-menu');
                menu.classList.toggle('hidden');
            });
        });
    </script>
    <script type="text/javascript">
        $(document).ready(function() {
            var preEmploymentTable = $('#pre-employment-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('forapproval.index') }}",
                    data: function(d) {
                        d.office_id = $('#office_id').val();
                        d.store_id = $('#store_id').val();
                        d.pwd_filter = $('#pwd_filter').val();
                    }
                },
                columns: [{
                        data: 'id',
                        name: 'id'
                    },

                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'date_of_birth',
                        name: 'date_of_birth'
                    },
                    {
                        data: 'status',
                        name: 'status'
                    },
                    {
                        data: 'user.email',
                        name: 'user.email'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ],
                order: [
                    [0, 'desc']
                ]
            });

            // Filter Data on Dropdown Change
            $('#office_id, #store_id, #pwd_filter').on('change', function() {
                preEmploymentTable.ajax.reload();
            });
        });
    </script>

    <div id="deleteModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
        <div class="bg-white rounded-lg shadow-lg p-6 w-auto md:w-[30rem] mt-20">
            <h2 class="mb-4 text-lg font-bold">Delete Record</h2>
            <p>Are you sure you want to delete this record?</p>
            <form id="deleteForm">
                @csrf
                <input type="hidden" id="deleteRecordId" name="id">
                <div class="flex justify-end mt-6">
                    <button type="button" onclick="closeModal('deleteModal')"
    class="px-4 py-2 mr-2 text-gray-700 bg-gray-200 rounded">Cancel</button>
                    <button type="submit" class="px-4 py-2 text-white bg-red-600 rounded">Delete</button>
                </div>
            </form>
        </div>
    </div>



    <div id="successModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
        <div class="p-5 mt-20 bg-white rounded-lg shadow-lg w-96">
            <h2 class="text-lg font-bold text-center">Success</h2>
            <p class="mt-2 text-center text-gray-700">Attendance record added successfully!</p>
            <div class="mt-4 text-center">
                <button id="closeSuccessModal" class="px-4 py-2 text-white bg-blue-500 rounded-lg hover:bg-blue-700">
                    OK
                </button>
            </div>
        </div>
    </div>


    <script>
    $(document).ready(function() {
        // Open Delete Modal
        window.openDeleteModal = function(recordId) {
            $('#deleteRecordId').val(recordId);
            $('#deleteModal').removeClass('hidden');
        };

        // Close Modal
        window.closeModal = function(modalId) {
            $('#' + modalId).addClass('hidden');
        };

        // Submit Delete Form
        $('#deleteForm').on('submit', function(e) {
            e.preventDefault();
            let recordId = $('#deleteRecordId').val();
            let deleteUrl = "{{ route('employees.destroy', ':id') }}".replace(':id', recordId);

            $.ajax({
                url: deleteUrl,
                type: "DELETE",
                data: {
                    _token: "{{ csrf_token() }}"
                },
                success: function(response) {
                    if (response.success) {
                        $('#deleteForm')[0].reset();
                        closeModal('deleteModal'); // ✅ close after success
                        $('#pre-employment-table').DataTable().ajax.reload(null, false);
                    }
                },
                error: function(xhr) {
                    alert('Error deleting record.');
                }
            });
        });

        // If you also have a success modal
        $('#closeSuccessModal').click(function() {
            closeModal('successModal');
        });
    });
</script>


@endsection
