@extends('layouts.sidebar')

@section('title', 'Employee')
@section('content')
    <div class="container p-5 mx-auto">
        <h2 class="mb-5 text-2xl font-bold text-center">HR FORM</h2>

        <form action="{{ route('employees.store') }}" enctype="multipart/form-data" method="POST">
            @csrf
            <input type="text" hidden name="status" value="1">
            <div class="flex flex-col w-full gap-10 mt-10 md:flex-row">
                <div class="p-2 mt-4  h-[55rem] w-auto md:w-[35rem]">
                    <div class="">
                        <p class="text-xl font-bold mr-44">PERSONAL DATA</p>
                        <div class="flex flex-row gap-2 bg-white p-2">

                            <div class="flex items-center justify-center border-2 border-black rounded-md">
                                <div id="imagePreview" class="mt-2 flex flex-col px-5 items-center justify-center ">

                                    <img id="preview" src="#" alt="Image Preview"
                                        class="object-cover w-[10rem] rounded-md  h-44 border-2 border-black" />


                                    <!-- Image Attachment Section -->
                                    <div class="mt-4">
                                        <label for="imageUpload" class="block mb-2 text-sm font-medium text-gray-700">Attach
                                            Image:</label>
                                        <input type="file" id="imageUpload" name="profile" accept="image/*"
                                            class="w-full p-2 mb-4 border border-gray-300" required
                                            onchange="previewImage(event)">

                                        <!-- Image Preview Container -->

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>



                    <div class="bg-white p-2 mt-5 border-2 border-black rounded-md">
                        <!-- Select Offices -->
                        <div class="mb-4">
                            <label class="block mb-1 text-gray-600" for="office_id">Select Office</label>
                            <select id="office_id" name="office_id" class="w-full p-2 border-2 border-black rounded-md"
                                required>
                                <option value="" disabled {{ old('office_id') ? '' : 'selected' }}>Select an Office
                                </option>
                                @foreach ($offices as $office)
                                    <option value="{{ $office->id }}"
                                        {{ old('office_id') == $office->id ? 'selected' : '' }}>
                                        {{ $office->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('office_id')
                                <span class="text-sm text-red-500">{{ $message }}</span>
                            @enderror
                        </div>

                        <!-- Select Store -->
                        <div>
                            <label class="block mb-1 text-gray-600" for="store_id">Select Store</label>
                            <select id="store_id" name="store_id" class="w-full p-2 border-2 border-black rounded-md"
                                required>
                                <option value="" disabled {{ old('store_id') ? '' : 'selected' }}>Select a Store
                                </option>
                                @foreach ($stores as $store)
                                    <option value="{{ $store->id }}"
                                        {{ old('store_id') == $store->id ? 'selected' : '' }}>
                                        {{ $store->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('store_id')
                                <span class="text-sm text-red-500">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>

                    <div class="bg-white p-2 mt-5 border-2 border-black rounded-md">
                        <div>
                            <label class="block mb-1 text-gray-600" for="pwd">Select Disability Status</label>
                            <select id="pwd" name="pwd" class="w-full p-2 border-2 border-black rounded-md"
                                required onchange="toggleFileInput()">
                                <option value="" disabled {{ old('pwd') == '' ? 'selected' : '' }}>Please select an
                                    option</option>
                                <option value="PWD" {{ old('pwd') == 'PWD' ? 'selected' : '' }}>Person with Disability
                                    (PWD)</option>
                                <option value="Not PWD" {{ old('pwd') == 'Not PWD' ? 'selected' : '' }}>Not a Person with
                                    Disability</option>
                            </select>
                            @error('pwd')
                                <span class="text-sm text-red-500">{{ $message }}</span>
                            @enderror
                        </div>

                        <!-- This is the file input, initially hidden -->
                        <div id="file-input-container" class="hidden mt-4">
                            <label class="block mb-1 text-gray-600" for="file">Upload Supporting Document
                                (Optional)</label>
                            <input type="file" id="file" name="file"
                                class="w-full p-2 border-2 border-black rounded-md">
                            @error('file')
                                <span class="text-sm text-red-500">{{ $message }}</span>
                            @enderror
                        </div>

                    </div>
                    <script>
                        function toggleFileInput() {
                            var pwdSelect = document.getElementById('pwd');
                            var fileInputContainer = document.getElementById('file-input-container');

                            // Show the file input if "PWD" is selected
                            if (pwdSelect.value === 'PWD') {
                                fileInputContainer.classList.remove('hidden');
                            } else {
                                fileInputContainer.classList.add('hidden');
                            }
                        }

                        // Call the function on page load in case "PWD" was selected previously
                        window.onload = function() {
                            toggleFileInput();
                        };
                    </script>

                </div>
                <div class="w-full p-2 ">


                    <script>
                        function previewImage(event) {
                            const preview = document.getElementById('preview');
                            const imagePreview = document.getElementById('imagePreview');

                            // Get the file from the input
                            const file = event.target.files[0];

                            if (file) {
                                // Create a FileReader to read the file
                                const reader = new FileReader();

                                // Set the image source when the file is loaded
                                reader.onload = function(e) {
                                    preview.src = e.target.result;
                                    preview.classList.remove('hidden'); // Show the image
                                };

                                // Read the file as a data URL
                                reader.readAsDataURL(file);
                            } else {
                                // If no file is selected, hide the image
                                preview.src = "#";
                                preview.classList.add('hidden');
                            }
                        }
                    </script>
                    <div class="border-2 p-2 border-black rounded-md">

                        <div class="grid grid-cols-2 gap-4 mb-4">
                            <div class="h-24 p-2 mt-2 ">
                                <label for="position_applied" class="block mb-1 text-sm">Position Applied For:</label>
                                <input type="text" name="position_applied" id="position_applied"
                                    class="w-full p-2 border-2 border-black" value="{{ old('position_applied') }}" />
                                @error('position_applied')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="h-24 p-2 mt-2 ">
                                <label for="desired_working_area" class="block mb-1 text-sm">Desired Working
                                    Area:</label>
                                <input type="text" name="desired_working_area" id="desired_working_area"
                                    class="w-full p-2  border-2 border-black" value="{{ old('desired_working_area') }}" />
                                @error('desired_working_area')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                    </div>
                    <h3 class="mb-4 text-xl font-semibold">Personal Details</h3>
                    <div class="">
                        <div class="border-2 border-black bg-white  rounded-md">
                            <div class="grid grid-cols-2 gap-4 mb-4 md:grid-cols-2">
                                <div class="h-24 p-2 mt-2 ">
                                    <label for="last_name" class="block mb-1 text-sm">Last Name:</label>
                                    <input type="text" name="last_name" id="last_name"
                                        class="w-full p-2 border-2 border-black"
                                        placeholder="Surname, Given Name, Extension, Middle Name"
                                        value="{{ old('last_name') }}" />
                                    @error('last_name')
                                        <span class="text-sm text-red-500">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="h-24 p-2 mt-2 ">
                                    <label for="first_name" class="block mb-1 text-sm">First Name:</label>
                                    <input type="text" name="first_name" id="first_name"
                                        class="w-full p-2  border-2 border-black"
                                        placeholder="Surname, Given Name, Extension, Middle Name"
                                        value="{{ old('first_name') }}" />
                                    @error('first_name')
                                        <span class="text-sm text-red-500">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="h-24 p-2 mt-2 ">
                                    <label for="middle_name" class="block mb-1 text-sm">Middle Name
                                        (optional):</label>
                                    <input type="text" name="middle_name" id="middle_name"
                                        class="w-full p-2 border-2 border-black"
                                        placeholder="Surname, Given Name, Extension, Middle Name"
                                        value="{{ old('middle_name') }}" />
                                    @error('middle_name')
                                        <span class="text-sm text-red-500">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="h-24 p-2 mt-2 ">
                                    <label for="email" class="block mb-1 text-sm">Email:</label>
                                    <input type="email" name="email" id="email"
                                        class="w-full p-2 border-2 border-black"
                                        placeholder="Surname, Given Name, Extension, Middle Name"
                                        value="{{ old('email') }}" />
                                    @error('email')
                                        <span class="text-sm text-red-500">{{ $message }}</span>
                                    @enderror
                                </div>

                            </div>
                        </div>
                        <div
                            class="grid grid-cols-1 xl:grid-cols-2 gap-4 mb-4 bg-white rounded-md border-2 border-black mt-5">
                            <div class="h-24 p-2 mt-2 ">
                                <label for="present_address" class="block mb-1 text-sm">Present Address:</label>
                                <input type="text" name="present_address" id="present_address"
                                    class="w-full p-2 border-2 border-black" value="{{ old('present_address') }}" />
                                @error('present_address')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="h-24 p-2 mt-2 ">
                                <label for="provincial_address" class="block mb-1 text-sm">Provincial Address:</label>
                                <input type="text" name="provincial_address" id="provincial_address"
                                    class="w-full p-2  border-2 border-black" value="{{ old('provincial_address') }}" />
                                @error('provincial_address')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="h-24 p-2 mt-2 ">
                                <label for="mobile_number" class="block mb-1 text-sm">Mobile No:</label>
                                <input type="text" name="mobile_number" id="mobile_number"
                                    class="w-full p-2  border-2 border-black" value="{{ old('mobile_number') }}" />
                                @error('mobile_number')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="h-24 p-2 mt-2 ">
                                <label for="alternative_number" class="block mb-1 text-sm">Alternative Number:</label>
                                <input type="text" name="alternative_number" id="alternative_number"
                                    class="w-full p-2  border-2 border-black" value="{{ old('alternative_number') }}" />
                                @error('alternative_number')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        <div class="border-2 border-black bg-white rounded-md mb-4">
                            <div class="grid grid-cols-1  md:grid-cols-3 gap-4 ">

                                <div class="h-24 p-2 mt-2">
                                    <label for="date_of_birth" class="block mb-1 text-sm">Date of Birth:</label>
                                    <input type="date" name="date_of_birth" id="date_of_birth"
                                        class="w-full p-2 border-2 border-black" value="{{ old('date_of_birth') }}" />
                                    @error('date_of_birth')
                                        <span class="text-sm text-red-500">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="h-24 p-2 mt-2">
                                    <label for="age" class="block mb-1 text-sm">Age:</label>
                                    <input type="number" name="age" id="age"
                                        class="w-full p-2 border-2 border-black" value="{{ old('age') }}" readonly />
                                    @error('age')
                                        <span class="text-sm text-red-500">{{ $message }}</span>
                                    @enderror
                                </div>

                                <!-- JS to calculate age -->
                                <script>
                                    function calculateAge(dob) {
                                        const birthDate = new Date(dob);
                                        const today = new Date();
                                        let age = today.getFullYear() - birthDate.getFullYear();
                                        const monthDiff = today.getMonth() - birthDate.getMonth();

                                        if (monthDiff < 0 || (monthDiff === 0 && today.getDate() < birthDate.getDate())) {
                                            age--;
                                        }

                                        return age;
                                    }

                                    document.addEventListener("DOMContentLoaded", function() {
                                        const dobInput = document.getElementById('date_of_birth');
                                        const ageInput = document.getElementById('age');

                                        function updateAge() {
                                            if (dobInput.value) {
                                                const age = calculateAge(dobInput.value);
                                                ageInput.value = !isNaN(age) ? age : '';
                                            } else {
                                                ageInput.value = '';
                                            }
                                        }

                                        dobInput.addEventListener('change', updateAge);

                                        // Calculate on load in case date is pre-filled (e.g. after validation error)
                                        updateAge();
                                    });
                                </script>

                                <div class="h-24 p-2 mt-2 ">
                                    <label for="place_of_birth" class="block mb-1 text-sm">Place of Birth:</label>
                                    <input type="text" name="place_of_birth" id="place_of_birth"
                                        class="w-full p-2 border-2 border-black" value="{{ old('place_of_birth') }}" />
                                    @error('place_of_birth')
                                        <span class="text-sm text-red-500">{{ $message }}</span>
                                    @enderror
                                </div>

                            </div>

                            <div class="p-4">
                                <div class="space-y-2 flex items-center flex-col justify-center">
                                    <p class="text-sm font-medium text-gray-700">Sex</p>
                                    <div class="flex flex-col space-y-2 md:flex-row md:space-y-0 md:space-x-4">
                                        <label for="male"
                                            class="flex items-center px-4 py-2 border-2 border-black rounded-md cursor-pointer">
                                            <input type="radio" name="sex" id="male" value="M"
                                                class="form-radio text-blue-600" {{ old('sex') == 'M' ? 'checked' : '' }}>
                                            <span class="ml-2 text-gray-800">Male</span>
                                        </label>

                                        <label for="F"
                                            class="flex items-center px-4 py-2 border-2 border-black rounded-md cursor-pointer">
                                            <input type="radio" name="sex" id="F" value="F"
                                                class="form-radio text-pink-600" {{ old('sex') == 'F' ? 'checked' : '' }}>
                                            <span class="ml-2 text-gray-800">Female</span>
                                        </label>
                                    </div>
                                </div>
                            </div>

                        </div>
                        <div class="grid grid-cols-1 gap-4 border-2 border-black mb-4  bg-white rounded-md">
                            <div class="h-auto p-2 mt-2   md:h-24">
                                <label class="block mb-1">Civil Status:</label>

                                <div class="flex flex-col justify-between px-20 space-x-4 md:flex-row ">
                                    <div class="flex items-center border-2 border-black px-5">
                                        <input type="radio" name="civil_status" class="" value="single"
                                            id="single" {{ old('civil_status') == 'single' ? 'checked' : '' }}>
                                        <label for="single" class="ml-2">Single</label>
                                    </div>
                                    <div class="flex items-center border-2 border-black px-5">
                                        <input type="radio" name="civil_status" value="married" id="married"
                                            {{ old('civil_status') == 'married' ? 'checked' : '' }}>
                                        <label for="married" class="ml-2">Married</label>
                                    </div>
                                    <div class="flex items-center border-2 border-black px-5">
                                        <input type="radio" name="civil_status" value="head_of_family"
                                            id="head_of_family"
                                            {{ old('civil_status') == 'head_of_family' ? 'checked' : '' }}>
                                        <label for="head_of_family" class="ml-2">Head of the Family</label>
                                    </div>
                                    <div class="flex items-center border-2 border-black px-5">
                                        <input type="radio" name="civil_status" value="widow" id="widow"
                                            {{ old('civil_status') == 'widow' ? 'checked' : '' }}>
                                        <label for="widow" class="ml-2">Widow/er</label>
                                    </div>
                                </div>

                                @error('civil_status')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>


                        </div>

                        <div class="grid grid-cols-2 gap-4 mb-4 md:grid-cols-4 border-2 border-black bg-white rounded-md">
                            

                            <div class="h-24 p-2 mt-2 ">
                                <label for="nationality" class="block mb-1">Nationality:</label>
                                <select name="nationality" id="nationality"
                                    class="w-full p-2 border border-black rounded-md">
                                    <option value="">Loading nationalities...</option>
                                </select>
                                @error('nationality')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>



                            <script>
                                document.addEventListener('DOMContentLoaded', function() {
                                    fetch('https://restcountries.com/v3.1/all?fields=name,demonyms')
                                        .then(response => response.json())
                                        .then(data => {
                                            const select = document.getElementById('nationality');
                                            select.innerHTML = '<option value="">-- Select Nationality --</option>';

                                            // Create a Set to avoid duplicates
                                            const nationalities = new Set();

                                            data.forEach(country => {
                                                const demonym = country?.demonyms?.eng?.m;
                                                if (demonym) nationalities.add(demonym);
                                            });

                                            // Sort and add to select
                                            Array.from(nationalities).sort().forEach(nationality => {
                                                const option = document.createElement('option');
                                                option.value = nationality;
                                                option.textContent = nationality;
                                                select.appendChild(option);
                                            });
                                        })
                                        .catch(error => {
                                            console.error('Error fetching nationalities:', error);
                                            document.getElementById('nationality').innerHTML =
                                                '<option value="">Failed to load nationalities</option>';
                                        });
                                });
                            </script>


                            <div class="h-24 p-2 mt-2 ">
                                <label for="religion" class="block mb-1">Religion:</label>
                                <select name="religion" id="religion" class="w-full p-2 border-2 border-black">
                                    <option value="">-- Select Religion --</option>

                                    <option value="Roman Catholic"
                                        {{ old('religion') == 'Roman Catholic' ? 'selected' : '' }}>
                                        Roman Catholic
                                    </option>

                                    <option value="Iglesia ni Cristo"
                                        {{ old('religion') == 'Iglesia ni Cristo' ? 'selected' : '' }}>
                                        Iglesia ni Cristo
                                    </option>

                                    <option value="Evangelical Christianity"
                                        {{ old('religion') == 'Evangelical Christianity' ? 'selected' : '' }}>
                                        Evangelical Christianity
                                    </option>

                                    <option value="Protestant" {{ old('religion') == 'Protestant' ? 'selected' : '' }}>
                                        Protestant
                                    </option>

                                    <option value="Islam" {{ old('religion') == 'Islam' ? 'selected' : '' }}>
                                        Islam (Muslim)
                                    </option>

                                    <option value="Aglipayan" {{ old('religion') == 'Aglipayan' ? 'selected' : '' }}>
                                        Aglipayan (Philippine Independent Church)
                                    </option>

                                    <option value="Buddhism" {{ old('religion') == 'Buddhism' ? 'selected' : '' }}>
                                        Buddhism
                                    </option>

                                    <option value="Hinduism" {{ old('religion') == 'Hinduism' ? 'selected' : '' }}>
                                        Hinduism
                                    </option>

                                    <option value="Judaism" {{ old('religion') == 'Judaism' ? 'selected' : '' }}>
                                        Judaism
                                    </option>

                                    <option value="Atheism" {{ old('religion') == 'Atheism' ? 'selected' : '' }}>
                                        Atheism / Non-religious
                                    </option>

                                    <option value="Other" {{ old('religion') == 'Other' ? 'selected' : '' }}>
                                        Other
                                    </option>
                                </select>

                                @error('religion')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>



                            <div class="h-24 p-2 mt-2 ">
                                <label for="height" class="block mb-1">Height:</label>
                                <input type="text" name="height" id="height"
                                    class="w-full p-2 border-2 border-black" value="{{ old('height') }}" />
                                @error('height')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="h-24 p-2 mt-2">
                                <label for="weight" class="block mb-1">Weight:</label>
                                <input type="text" name="weight" id="weight"
                                    class="w-full p-2 border-2 border-black" value="{{ old('weight') }}" />
                                @error('weight')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        <div class="grid grid-cols-2 gap-4 mb-4 border-2 border-black bg-white rounded-md">
                            <div class="h-24 p-2 mt-2 ">
                                <label for="spouse_name" class="block mb-1">Name of Spouse (if married):</label>
                                <input type="text" name="spouse_name" id="spouse_name"
                                    class="w-full p-2 border-2 border-black" value="{{ old('spouse_name') }}" />
                                @error('spouse_name')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="h-24 p-2 mt-2 ">
                                <label for="spouse_occupation" class="block mb-1">Occupation:</label>
                                <input type="text" name="spouse_occupation" id="spouse_occupation"
                                    class="w-full p-2 border-2 border-black" value="{{ old('spouse_occupation') }}" />
                                @error('spouse_occupation')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="h-24 p-2 mt-2 ">
                                <label for="mother_maiden_name" class="block text-sm font-medium text-gray-700">Mother's
                                    Maiden
                                    Name</label>
                                <input type="text" name="mother_maiden_name" id="mother_maiden_name" required
                                    class="mt-1 border-2 border-black p-2 w-full rounded-md focus:outline-none focus:ring-2 focus:ring-indigo-500 {{ $errors->has('mother_maiden_name') ? 'border-red-500' : '' }}"
                                    value="{{ old('mother_maiden_name') }}" />
                                @if ($errors->has('mother_maiden_name'))
                                    <span class="text-sm text-red-500">{{ $errors->first('mother_maiden_name') }}</span>
                                @endif
                            </div>

                            <div class="h-24 p-2 mt-2 ">
                                <label for="mother_occupation" class="block text-sm font-medium text-gray-700">Mother's
                                    Occupation</label>
                                <input type="text" name="mother_occupation" id="mother_occupation" required
                                    class="mt-1 border-2 border-black p-2 w-full rounded-md focus:outline-none focus:ring-2 focus:ring-indigo-500 {{ $errors->has('mother_occupation') ? 'border-red-500' : '' }}"
                                    value="{{ old('mother_occupation') }}" />
                                @if ($errors->has('mother_occupation'))
                                    <span class="text-sm text-red-500">{{ $errors->first('mother_occupation') }}</span>
                                @endif
                            </div>

                            <div class="h-24 p-2 mt-2 ">
                                <label for="father_name" class="block text-sm font-medium text-gray-700">Father's
                                    Name</label>
                                <input type="text" name="father_name" id="father_name" required
                                    class="mt-1 border-2 border-black p-2 w-full rounded-md focus:outline-none focus:ring-2 focus:ring-indigo-500 {{ $errors->has('father_name') ? 'border-red-500' : '' }}"
                                    value="{{ old('father_name') }}" />
                                @if ($errors->has('father_name'))
                                    <span class="text-sm text-red-500">{{ $errors->first('father_name') }}</span>
                                @endif
                            </div>

                            <div class="h-24 p-2 mt-2 ">
                                <label for="father_occupation" class="block text-sm font-medium text-gray-700">Father's
                                    Occupation</label>
                                <input type="text" name="father_occupation" id="father_occupation" required
                                    class="mt-1 border-2 border-black p-2 w-full rounded-md focus:outline-none focus:ring-2 focus:ring-indigo-500 {{ $errors->has('father_occupation') ? 'border-red-500' : '' }}"
                                    value="{{ old('father_occupation') }}" />
                                @if ($errors->has('father_occupation'))
                                    <span class="text-sm text-red-500">{{ $errors->first('father_occupation') }}</span>
                                @endif
                            </div>

                            <div class="h-24 p-2 mt-2 ">
                                <label for="sss_no" class="block text-sm font-medium text-gray-700">SSS No.</label>
                                <input type="text" name="sss_no" id="sss_no" required
                                    class="mt-1 border-2 border-black p-2 w-full rounded-md focus:outline-none focus:ring-2 focus:ring-indigo-500 {{ $errors->has('sss_no') ? 'border-red-500' : '' }}"
                                    value="{{ old('sss_no') }}" />
                                @if ($errors->has('sss_no'))
                                    <span class="text-sm text-red-500">{{ $errors->first('sss_no') }}</span>
                                @endif
                            </div>

                            <div class="h-24 p-2 mt-2 ">
                                <label for="tin_no" class="block text-sm font-medium text-gray-700">TIN No.</label>
                                <input type="text" name="tin_no" id="tin_no" required
                                    class="mt-1 border-2 border-black p-2 w-full rounded-md focus:outline-none focus:ring-2 focus:ring-indigo-500 {{ $errors->has('tin_no') ? 'border-red-500' : '' }}"
                                    value="{{ old('tin_no') }}" />
                                @if ($errors->has('tin_no'))
                                    <span class="text-sm text-red-500">{{ $errors->first('tin_no') }}</span>
                                @endif
                            </div>

                            <div class="h-24 p-2 mt-2 ">
                                <label for="pagibig_no" class="block text-sm font-medium text-gray-700">Pag-IBIG
                                    No.</label>
                                <input type="text" name="pagibig_no" id="pagibig_no" required
                                    class="mt-1 border-2 border-black p-2 w-full rounded-md focus:outline-none focus:ring-2 focus:ring-indigo-500 {{ $errors->has('pagibig_no') ? 'border-red-500' : '' }}"
                                    value="{{ old('pagibig_no') }}" />
                                @if ($errors->has('pagibig_no'))
                                    <span class="text-sm text-red-500">{{ $errors->first('pagibig_no') }}</span>
                                @endif
                            </div>

                            <div class="h-24 p-2 mt-2 ">
                                <label for="dependents" class="block text-sm font-medium text-gray-700">Dependents</label>
                                <input type="text" name="dependents" id="dependents" required
                                    class="mt-1 border-2 border-black p-2 w-full rounded-md focus:outline-none focus:ring-2 focus:ring-indigo-500 {{ $errors->has('dependents') ? 'border-red-500' : '' }}"
                                    value="{{ old('dependents') }}" />
                                @if ($errors->has('dependents'))
                                    <span class="text-sm text-red-500">{{ $errors->first('dependents') }}</span>
                                @endif
                            </div>

                            <div class="h-24 p-2 mt-2 ">
                                <label for="philhealth_no" class="block text-sm font-medium text-gray-700">PhilHealth
                                    No.</label>
                                <input type="text" name="philhealth_no" id="philhealth_no" required
                                    class="mt-1 border-2 border-black p-2 w-full rounded-md focus:outline-none focus:ring-2 focus:ring-indigo-500 {{ $errors->has('philhealth_no') ? 'border-red-500' : '' }}"
                                    value="{{ old('philhealth_no') }}" />
                                @if ($errors->has('philhealth_no'))
                                    <span class="text-sm text-red-500">{{ $errors->first('philhealth_no') }}</span>
                                @endif
                            </div>
                            <div class="h-24 p-2 mt-2 ">
                                <label for="blood_type" class="block text-sm font-medium text-gray-700">Blood
                                    Type</label>
                                <input type="text" name="blood_type" id="blood_type" required
                                    class="mt-1 border-2 border-black p-2 w-full rounded-md focus:outline-none focus:ring-2 focus:ring-indigo-500 {{ $errors->has('blood_type') ? 'border-red-500' : '' }}"
                                    value="{{ old('blood_type') }}" />
                                @if ($errors->has('blood_type'))
                                    <span class="text-sm text-red-500">{{ $errors->first('blood_type') }}</span>
                                @endif
                            </div>
                        </div>




                    </div>




                    <h3 class="mt-10 mb-4 text-xl font-semibold">Educational Background</h3>
                    <div class="border-2 border-black bg-white rounded-md">
                        <div class="grid grid-cols-2 gap-4 mb-4">
                            <div class="h-24 p-2 mt-2 ">
                                <label for="education_school"
                                    class="block text-sm font-medium text-gray-700">School</label>
                                <input type="text" name="education_school" id="education_school" required
                                    class="mt-1 border-2 border-black p-2 w-full rounded-md focus:outline-none focus:ring-2 focus:ring-indigo-500 {{ $errors->has('education_school') ? 'border-red-500' : '' }}"
                                    value="{{ old('education_school') }}" />
                                @if ($errors->has('education_school'))
                                    <span class="text-sm text-red-500">{{ $errors->first('education_school') }}</span>
                                @endif
                            </div>

                            <div class="h-24 p-2 mt-2 ">
                                <label for="education_course_level" class="block text-sm font-medium text-gray-700">Course
                                    Level</label>
                                <input type="text" name="education_course_level" id="education_course_level" required
                                    class="mt-1 border-2 border-black p-2 w-full rounded-md focus:outline-none focus:ring-2 focus:ring-indigo-500 {{ $errors->has('education_course_level') ? 'border-red-500' : '' }}"
                                    value="{{ old('education_course_level') }}" />
                                @if ($errors->has('education_course_level'))
                                    <span
                                        class="text-sm text-red-500">{{ $errors->first('education_course_level') }}</span>
                                @endif
                            </div>

                            <div class="h-24 p-2 mt-2 ">
                                <label for="education_year" class="block text-sm font-medium text-gray-700">Year of
                                    Graduation</label>
                                <input type="text" name="education_year" id="education_year" required
                                    class="mt-1 border-2 border-black p-2 w-full rounded-md focus:outline-none focus:ring-2 focus:ring-indigo-500 {{ $errors->has('education_year') ? 'border-red-500' : '' }}"
                                    value="{{ old('education_year') }}" />
                                @if ($errors->has('education_year'))
                                    <span class="text-sm text-red-500">{{ $errors->first('education_year') }}</span>
                                @endif
                            </div>

                            <div class="h-24 p-2 mt-2 ">
                                <label for="relevant_qualifications"
                                    class="block text-sm font-medium text-gray-700">Relevant
                                    Qualifications</label>
                                <input type="text" name="relevant_qualifications" id="relevant_qualifications"
                                    required
                                    class="mt-1 border-2 border-black p-2 w-full rounded-md focus:outline-none focus:ring-2 focus:ring-indigo-500 {{ $errors->has('relevant_qualifications') ? 'border-red-500' : '' }}"
                                    value="{{ old('relevant_qualifications') }}" />
                                @if ($errors->has('relevant_qualifications'))
                                    <span
                                        class="text-sm text-red-500">{{ $errors->first('relevant_qualifications') }}</span>
                                @endif
                            </div>

                        </div>
                    </div>
                    <h3 class="mt-10 mb-4 text-xl font-semibold">Emergency Contact Information</h3>
                    <div class=" border-2 border-black bg-white rounded-md">
                        <div class="grid grid-cols-2 gap-4 mb-4">
                            <div class="h-24 p-2 mt-2 ">
                                <label for="emergency_contact_name" class="block mb-1">Name:</label>
                                <input type="text" name="emergency_contact_name" id="emergency_contact_name"
                                    class="w-full p-2 border-2 border-black"
                                    value="{{ old('emergency_contact_name') }}" />
                                @error('emergency_contact_name')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="h-24 p-2 mt-2 ">
                                <label for="emergency_contact_relationship" class="block mb-1">Relationship:</label>
                                <input type="text" name="emergency_contact_relationship"
                                    id="emergency_contact_relationship" class="w-full p-2 border-2 border-black"
                                    value="{{ old('emergency_contact_relationship') }}" />
                                @error('emergency_contact_relationship')
                                    <span class="text-sm text-red-500">{{ $message }}</span>
                                @enderror
                            </div>





                            <div class="h-24 p-2 mt-2 ">
                                <label for="emergency_contact_number"
                                    class="block text-sm font-medium text-gray-700">Emergency
                                    Contact Number</label>
                                <input type="text" name="emergency_contact_number" id="emergency_contact_number"
                                    required
                                    class="mt-1 border-2 border-black p-2 w-full rounded-md focus:outline-none focus:ring-2 focus:ring-indigo-500 {{ $errors->has('emergency_contact_number') ? 'border-red-500' : '' }}"
                                    value="{{ old('emergency_contact_number') }}" />
                                @if ($errors->has('emergency_contact_number'))
                                    <span
                                        class="text-sm text-red-500">{{ $errors->first('emergency_contact_number') }}</span>
                                @endif
                            </div>

                            <div class="h-24 p-2 mt-2 ">
                                <label for="emergency_contact_address"
                                    class="block text-sm font-medium text-gray-700">Emergency
                                    Contact Address</label>
                                <input type="text" name="emergency_contact_address" id="emergency_contact_address"
                                    required
                                    class="mt-1 border-2 border-black p-2 w-full rounded-md focus:outline-none focus:ring-2 focus:ring-indigo-500 {{ $errors->has('emergency_contact_address') ? 'border-red-500' : '' }}"
                                    value="{{ old('emergency_contact_address') }}" />
                                @if ($errors->has('emergency_contact_address'))
                                    <span
                                        class="text-sm text-red-500">{{ $errors->first('emergency_contact_address') }}</span>
                                @endif
                            </div>

                            <div class="h-24 p-2 mt-2 ">
                                <label for="emergency_contact_occupation"
                                    class="block text-sm font-medium text-gray-700">Emergency
                                    Contact Occupation</label>
                                <input type="text" name="emergency_contact_occupation"
                                    id="emergency_contact_occupation" required
                                    class="mt-1 border-2 border-black p-2 w-full rounded-md focus:outline-none focus:ring-2 focus:ring-indigo-500 {{ $errors->has('emergency_contact_occupation') ? 'border-red-500' : '' }}"
                                    value="{{ old('emergency_contact_occupation') }}" />
                                @if ($errors->has('emergency_contact_occupation'))
                                    <span
                                        class="text-sm text-red-500">{{ $errors->first('emergency_contact_occupation') }}</span>
                                @endif
                            </div>



                            <div class="h-24 p-2 mt-2 ">
                                <label for="emergency_contact_company"
                                    class="block text-sm font-medium text-gray-700">Emergency
                                    Contact Company</label>
                                <input type="text" name="emergency_contact_company" id="emergency_contact_company"
                                    class="mt-1 border-2 border-black p-2 w-full rounded-md focus:outline-none focus:ring-2 focus:ring-indigo-500 {{ $errors->has('emergency_contact_company') ? 'border-red-500' : '' }}"
                                    value="{{ old('emergency_contact_company') }}" />
                                @if ($errors->has('emergency_contact_company'))
                                    <span
                                        class="text-sm text-red-500">{{ $errors->first('emergency_contact_company') }}</span>
                                @endif
                            </div>

                            <div class="h-24 p-2 mt-2 ">
                                <label for="emergency_contact_business_tel"
                                    class="block text-sm font-medium text-gray-700">Emergency
                                    Contact Business Tel</label>
                                <input type="text" name="emergency_contact_business_tel"
                                    id="emergency_contact_business_tel"
                                    class="mt-1 border-2 border-black  p-2 w-full rounded-md focus:outline-none focus:ring-2 focus:ring-indigo-500 {{ $errors->has('emergency_contact_business_tel') ? 'border-red-500' : '' }}"
                                    value="{{ old('emergency_contact_business_tel') }}" />
                                @if ($errors->has('emergency_contact_business_tel'))
                                    <span
                                        class="text-sm text-red-500">{{ $errors->first('emergency_contact_business_tel') }}</span>
                                @endif
                            </div>

                        </div>
                    </div>

                    <div class="mt-6">
                        <button type="submit" class="p-2 text-white bg-blue-500 rounded">Submit</button>
                    </div>
                </div>
            </div>
        </form>
    </div>






@endsection
