<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Portrait Employee ID</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #fff;
            margin: 0;
            padding: 0;
        }

        .id-card {
            width: 336px;
            height: 504px;
            border: 2px solid #1f2937;
            border-radius: 12px;
            padding: 20px;
            box-sizing: border-box;
            display: flex;
            flex-direction: column;
            align-items: center;
            background-color: #ffffff;
        }

        .centered-box {
            margin-left: 6rem
        }

        .centered-qr {
            margin-left: 7rem
        }

        .company-logo {
            width: 120px;
            height: 90px;


            object-fit: cover;
        }

        .company-name {
            font-size: 18px;
            font-weight: bold;
            color: #1f2937;
            margin-bottom: 10px;
            text-align: center;
        }

        .photo {
            width: 120px;
            height: 120px;
            border-radius: 8px;
            border: 2px solid #ccc;
            object-fit: cover;
        }

        .details {
            text-align: center;
            margin-bottom: 20px;
        }

        .details h2 {
            margin: 0;
            font-size: 20px;
            color: #111827;
        }

        .details p {
            margin: 4px 0;
            font-size: 14px;
            color: #374151;
        }

        .qr-code {
            width: 100px;
            height: 100px;
            border-radius: 6px;
            border: 1px solid #ccc;
        }

        .id-number {
            margin-top: 8px;
            font-size: 12px;
            color: #6b7280;
            text-align: center;
        }
    </style>
</head>

<body>

    <div class="id-card">
        {{-- Company Logo --}}
        <div class="centered-box">
            @if ($employee->department->client->agency->contact_person)
                <img src="{{ $employee->department->client->agency->contact_person }}" alt="Company Logo"
                    class="company-logo">
            @endif
        </div>

        {{-- Company Name --}}
        <div class="company-name">
            {{ $employee->department->client->business_name }}
        </div>

        {{-- Employee Photo --}}
        <div class="centered-box">
            @if (!empty($base64Image))
                <img src="{{ $base64Image }}" alt="Employee Photo" class="photo">
            @else
                <p>No photo available</p>
            @endif
        </div>



        {{-- Employee Info --}}
        <div class="details">
            <h2>{{ $employee->employee->first_name }} {{ $employee->employee->last_name }}</h2>
            <p>{{ $employee->employee->position }}</p>
            <p>{{ $employee->department->department_name }}</p>
        </div>

        {{-- QR Code --}}
        @php
            use SimpleSoftwareIO\QrCode\Facades\QrCode;
        @endphp
        <div class="centered-qr">

            <img src="data:image/svg+xml;base64,{{ base64_encode(QrCode::format('svg')->size(100)->generate($employee->id)) }}"
                alt="QR Code" class="qr-code">


        </div>
        {{-- ID Number --}}
        <div class="id-number">
            ID: EMP{{ $employee->employee_id }}
        </div>
    </div>

</body>

</html>
