@extends('layouts.sidebar')

@section('title', 'Employee')
@section('content')
    @if (in_array('Manage Employee', $privileges))
        @include('Admin.Employee.modal')
        <div class="mx-auto px-4 py-6">
            <!-- Header Section -->
            <div class="flex flex-col md:flex-row items-center justify-between mb-4">
                <h2 class="text-lg font-bold text-gray-800">Employee List</h2>

                <div class="flex flex-col md:flex-row gap-3 items-center">
                    @if (in_array('Create Employee', $privileges))
                        <a href="{{ route('employees.create') }}"
                            class="w-40 px-4 py-2.5 text-sm text-white bg-black rounded-md font-semibold hover:bg-indigo-700 transition-all duration-300 text-center shadow">
                            Add Employee
                        </a>
                    @endif
                </div>
            </div>

            <!-- Success Alert -->
            @if (session('success'))
                <div class="mb-4 p-4 bg-green-500 text-white text-sm rounded shadow">
                    {{ session('success') }}
                </div>
            @endif

            <!-- Filters -->
            <div class="w-full mb-4 p-6 bg-gray-100 rounded-lg shadow-md border border-gray-300 bg-white ">
                <div class="flex flex-col md:flex-row justify-between items-center gap-4">
                    <div class="w-full md:w-auto">
                        <label class="block mb-1 text-gray-600 font-medium" for="office_id">Select Office</label>
                        <select id="office_id" name="office_id"
                            class="w-full md:w-60 h-9 border border-gray-300 rounded-md px-2 focus:ring-2 focus:ring-indigo-500">
                            <option value="">Select an Office</option>
                            @foreach ($offices as $office)
                                <option value="{{ $office->id }}">{{ $office->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="w-full md:w-auto">
                        <label class="block mb-1 text-gray-600 font-medium" for="store_id">Select Store</label>
                        <select id="store_id" name="store_id"
                            class="w-full md:w-60 h-9 border border-gray-300 rounded-md px-2 focus:ring-2 focus:ring-indigo-500">
                            <option value="">Select a Store</option>
                            @foreach ($stores as $store)
                                <option value="{{ $store->id }}">{{ $store->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="w-full md:w-auto">
                        <label class="block mb-1 text-gray-600 font-medium" for="pwd_filter">PWD Filter</label>
                        <select id="pwd_filter" name="pwd_filter"
                            class="w-full md:w-60 h-9 border border-gray-300 rounded-md px-2 focus:ring-2 focus:ring-indigo-500">
                            <option value="">Select PWD Status</option>
                            <option value="PWD">PWD</option>
                            <option value="Not PWD">Not PWD</option>
                        </select>
                    </div>
                </div>
            </div>

            <!-- Table Section -->
            <div class="overflow-x-auto p-6 bg-gray-100 rounded-lg shadow-md border border-gray-300 bg-white shadow">
                <table id="employed-table" class="min-w-full table-auto text-sm text-left text-gray-700">
                    <thead class="bg-black text-white">
                        <tr>
                            <th class="px-6 py-2">ID</th>
                            <th class="px-6 py-2">Agency</th>
                            <th class="px-6 py-2">Company</th>
                            <th class="px-6 py-2">Client</th>
                            <th class="px-6 py-2">Name</th>
                            <th class="px-6 py-2">Status</th>
                            <th class="px-6 py-2 text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200 text-center">
                        <!-- Table rows are rendered dynamically -->
                    </tbody>
                </table>
            </div>
        </div>


        <script type="text/javascript">
            $(document).ready(function() {
                // Initialize DataTable for Pre-Employment Employees


                // Initialize DataTable for Employed Employees
                var employedTable = $('#employed-table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: "{{ route('employees.index') }}",
                        data: function(d) {
                            d.status = '1'; // Filter by Employed status
                            d.office_id = $('#office_id').val();
                            d.store_id = $('#store_id').val();
                            d.pwd_filter = $('#pwd_filter').val();
                        }
                    },
                    columns: [{
                            data: 'id',
                            name: 'id',
                            width: '5%'
                        },
                        {
                            data: 'agency',
                            name: 'agency',
                            width: '10%'
                        },
                        {
                            data: 'company',
                            name: 'company',
                            width: '10%'
                        },
                        {
                            data: 'client',
                            name: 'client',
                            width: '10%'
                        },

                        {
                            data: 'employee_name',
                            name: 'employee_name',
                            width: '10%'
                        },

                        {
                            data: 'status',
                            name: 'status',
                            width: '10%'
                        },


                        {
                            data: 'action',
                            name: 'action',
                            orderable: false,
                            searchable: false,
                            width: '10%'

                        }
                    ],
                    order: [
                        [0, 'desc']
                    ]
                });
                $('#office_id, #store_id, #pwd_filter').on('change', function() {
                    employedTable.ajax.reload();
                });



            });
        </script>
        <div id="deleteModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
            <div class="bg-white rounded-lg shadow-lg p-6 w-auto md:w-[30rem] mt-20">
                <h2 class="mb-4 text-lg font-bold">Delete Record</h2>
                <p>Are you sure you want to delete this record?</p>
                <form id="deleteForm">
                    @csrf
                    <input type="hidden" id="deleteRecordId" name="id">
                    <div class="flex justify-end mt-6">
                        <button type="button" onclick="closeModal('deleteModal')"
                            class="px-4 py-2 mr-2 text-gray-700 bg-gray-200 rounded">Cancel</button>
                        <button type="submit" class="px-4 py-2 text-white bg-red-600 rounded">Delete</button>
                    </div>
                </form>
            </div>
        </div>



        <div id="successModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
            <div class="p-5 mt-20 bg-white rounded-lg shadow-lg w-96">
                <h2 class="text-lg font-bold text-center">Success</h2>
                <p class="mt-2 text-center text-gray-700">Attendance record added successfully!</p>
                <div class="mt-4 text-center">
                    <button id="closeSuccessModal" class="px-4 py-2 text-white bg-blue-500 rounded-lg hover:bg-blue-700">
                        OK
                    </button>
                </div>
            </div>
        </div>


        <script>
            $(document).ready(function() {
                // Open Delete Modal
                window.openDeleteModal = function(recordId) {
                    $('#deleteRecordId').val(recordId);
                    $('#deleteModal').removeClass('hidden');
                };

                // Submit Delete Form
                $('#deleteForm').on('submit', function(e) {
                    e.preventDefault();
                    let recordId = $('#deleteRecordId').val();
                    let deleteUrl = "{{ route('employees.destroy', ':id') }}".replace(':id', recordId);

                    $.ajax({
                        url: deleteUrl,
                        type: "DELETE",
                        data: {
                            _token: "{{ csrf_token() }}"
                        },
                        success: function(response) {
                            if (response.success) {
                                $('#successModal').removeClass('hidden'); // Show success modal
                                $('#deleteForm')[0].reset(); // Reset form
                                $('#deleteModal').addClass('hidden'); // Close modal
                                $('#employed-table').DataTable().ajax.reload(null,
                                    false); // Reload table without resetting pagination
                            }
                        },
                        error: function(xhr) {
                            alert('Error deleting record.');
                        }
                    });
                });

                function closeModal(modalId, reopenButtonId) {
                    $(modalId).addClass('hidden');
                }
                $('#closeSuccessModal').click(function() {
                    closeModal('#successModal');
                });

            });
        </script>
    @else
        <div class="flex items-center justify-center w-full h-full my-2">
            <div>
                <i class="mr-2 text-3xl bx bx-lock"></i> <!-- Large lock icon indicating no access -->
                <span class="text-gray-500">You don't have privilege to access this page</span>
            </div>

        </div>
    @endif
@endsection
