@include('Admin.Employee.info.leavemodal')



@if (session('success'))
    <div class="p-4 mb-4 text-white bg-green-500">
        {{ session('success') }}
    </div>
@endif
<div class="overflow-auto">
    <table id="agencyTable" class="min-w-full bg-white border border-collapse border-gray-200 rounded shadow-md">
        <thead>
            <tr class="text-sm leading-normal  text-white uppercase bg-[#1d1d1d]">
                <th>Leave Type</th>
                <th>Start Date</th>
                <th>End Date</th>
                <th>Days</th>
                <th>Status</th>
                <th>Reason</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody class="text-sm font-light text-center text-gray-600">
            <!-- DataTables will populate this body -->
        </tbody>
    </table>
</div>


<script>
    $(document).ready(function() {
        var employeeid = {{ $employee->id }};

        $('#agencyTable').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('employeeleave.index', ['id' => ':id']) }}".replace(':id', employeeid),
                type: 'GET',
            },
            columns: [{
                    data: 'leave_type',
                    name: 'leave_type'
                },
                {
                    data: 'start_date',
                    name: 'start_date'
                },
                {
                    data: 'end_date',
                    name: 'end_date'
                },
                {
                    data: 'days',
                    name: 'days'
                },
                {
                    data: 'paid',
                    name: 'paid'

                },
                {
                    data: 'reason',
                    name: 'reason'
                },
                {
                    data: 'status',
                    name: 'status',
                    render: function(data) {
                        let statusText =
                            data == 2 ? 'Leave Applied to Payroll' :
                            data == 1 ? 'Approved' :
                            'Pending';

                        let textColor =
                            data == 1 ? 'text-green-500' :
                            data == 2 ? 'text-gray-500' :
                            'text-black';

                        return `<span class="${textColor} font-semibold">${statusText}</span>`;
                    }
                }

            ],
            language: {
                processing: '<img src="path/to/loading.gif" alt="Loading..."/>', // Add your loading indicator if needed
            },
            order: [
                [1, 'desc']
            ], // Optional: default order by start_date descending
        });
    });
</script>
