<!-- Tailwind Modal -->
<div id="successModal123" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-900 bg-opacity-50">
    <div class="w-11/12 max-w-md mt-20 bg-white rounded-lg shadow-lg">
        <div class="px-4 py-2 border-b">
            <h5 class="text-xl font-semibold">Success</h5>
        </div>
        <div class="p-4">
            <p id="modalMessage123">Status updated successfully!</p>
        </div>
        <div class="flex justify-end px-4 py-2 border-t">
            <button id="closeModal" class="px-3 py-1 text-white bg-gray-500 rounded hover:bg-gray-600">Close</button>
        </div>
    </div>
</div>
<script>
    const bankProfiles = @json($bankProfiles);
    const defaultrate = @json($defaultrate);
</script>
<!-- DataTable -->
<div class="overflow-auto ">
    @if (in_array('Employee UserInterface', $privileges))
        <table id="employeehistorystatus-table"
            class="min-w-full text-nowrap bg-white border border-gray-200 rounded shadow-md">
            <thead>
                <tr class="text-sm leading-normal">
                    <th class="px-6 py-3">Status</th>

                    <th class="px-6 py-3">Client</th>
                    <th class="px-6 py-3">VIew</th>
                    <!-- <th class="px-6 py-3">Action</th> -->
                </tr>
            </thead>
            <tbody class="text-sm font-light text-center text-gray-600">
            </tbody>
        </table>


        <script>
            document.addEventListener('DOMContentLoaded', function() {
                let employeeId = {{ $employee->id }};
                let updateStatusUrl = @json(route('history.update_status'));
                let updateDtrUrl = @json(route('history.update_dtr'));
                let updateRateUrl = @json(route('history.update_default_rate'));

                let csrfToken = @json(csrf_token());

                let departmentTable = $('#employeehistorystatus-table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: "{{ route('history.index', ['id' => ':id']) }}".replace(':id', employeeId),
                        data: function(d) {
                            d.employee_id = employeeId;
                        }
                    },
                    columns: [{
                            data: 'employeestatus',
                            name: 'employeestatus'
                        },



                        {
                            data: 'client_name',
                            name: 'client_name'
                        },
                        {
                            data: null,
                            name: 'action',
                            orderable: false,
                            searchable: false,
                            render: function(data, type, row) {
                                return `
            <button class="view-btn bg-indigo-600 text-white px-3 py-1 rounded text-xs" 
                data-id="${row.id}" 
                data-status="${row.employeestatus}"
                data-dtr="${row.dtr_id}"
              
                data-bankaccount="${row.bankaccount}"
                data-agency="${row.agency_name}"
                data-company="${row.company_name}"
                data-client="${row.client_name}"
                data-datehired="${row.date_hired}"
                data-entry="${row.entry_time}"
                data-exit="${row.exit_time}"
                data-start="${row.employment_start_date}"
                data-end="${row.employment_end_date}">
                View
            </button>
        `;
                            }
                        }

                    ],
                    order: [
                        [0, 'desc']
                    ]
                });


                $('#employeehistorystatus-table').on('click', '.view-btn', function() {
                    const btn = $(this);
                    const id = btn.data('id');

                    // QR code and data fields
                    $('#modal-qr').attr('src',
                        `https://api.qrserver.com/v1/create-qr-code/?data=${encodeURIComponent(id)}&size=150x150`
                    );

                    $('#modal-status').text(btn.data('status'));
                    $('#modal-dtr').text(btn.data('dtr'));
                    $('#modal-bankaccount').text(btn.data('bankaccount'));
                    $('#modal-agency').text(btn.data('agency'));
                    $('#modal-company').text(btn.data('company'));
                    $('#modal-client').text(btn.data('client'));
                    $('#modal-datehired').text(btn.data('datehired'));
                    $('#modal-entry').text(btn.data('entry'));
                    $('#modal-exit').text(btn.data('exit'));
                    $('#modal-start').text(btn.data('start'));
                    $('#modal-end').text(btn.data('end'));

                    // Update dynamic download link using route placeholder
                    const routeTemplate = $('#download-idcard-link').data('route'); // Laravel-generated string
                    const finalLink = routeTemplate.replace('__ID__', id);
                    $('#download-idcard-link').attr('href', finalLink);

                    $('#viewModal').removeClass('hidden');
                });

            });
        </script>
    @else
        <div class="overflow-auto">
            <table id="department-table"
                class="min-w-full overflow-auto text-nowrap bg-white border border-gray-200 rounded shadow-md">
                <thead>
                    <tr class="text-sm leading-normal">

                        <th class="px-6 py-3">Status <br><small>(Check to Activate Client)</small></th>
                        <th class="px-6 py-3">Benefits Custom Setup <br><small>(Check to Use Custom Setup)</small></th>
                        <th class="px-6 py-3">SSS <br><small>(Check to Exclude from Payroll)</small></th>
                        <th class="px-6 py-3">Pag-IBIG <br><small>(Check to Exclude from Payroll)</small></th>
                        <th class="px-6 py-3">PhilHealth <br><small>(Check to Exclude from Payroll)</small></th>
                        <th class="px-6 py-3">Dtr ID</th>
                        <th class="px-6 py-3">Bank</th>
                        <th class="px-6 py-3">Bank Account</th>
                        <th class="px-6 py-3">Rate Reference</th>
                        <th class="px-6 py-3">Client</th>
                        <th class="px-6 py-3">VIew</th>
                    </tr>
                </thead>
                <tbody class="text-sm font-light text-center text-gray-600">
                </tbody>
            </table>
        </div>


        <script>
            document.addEventListener('DOMContentLoaded', function() {
                let employeeId = {{ $employee->id }};
                let updateStatusUrl = @json(route('history.update_status'));
                let updateDtrUrl = @json(route('history.update_dtr'));
                let updateRateUrl = @json(route('history.update_default_rate'));

                let csrfToken = @json(csrf_token());

                let departmentTable = $('#department-table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: "{{ route('history.index', ['id' => ':id']) }}".replace(':id', employeeId),
                        data: function(d) {
                            d.employee_id = employeeId;
                        }
                    },
                    columns: [{
                            data: 'status',
                            name: 'status',
                            render: function(data, type, row) {
                                return `<input type="checkbox" class="status-checkbox" data-id="${row.id}" data-field="status" ${data == "1" ? 'checked' : ''}>`;
                            }
                        },
                        {
                            data: 'cutomsetup',
                            name: 'cutomsetup',
                            render: function(data, type, row) {
                                return `<input type="checkbox" class="status-checkbox" data-id="${row.id}" data-field="cutomsetup" ${data == "1" ? 'checked' : ''}>`;
                            }
                        },
                        {
                            data: 'sss',
                            name: 'sss',
                            render: function(data, type, row) {
                                return `<input type="checkbox" class="status-checkbox" data-id="${row.id}" data-field="sss" ${data == "1" ? 'checked' : ''}>`;
                            }
                        },
                        {
                            data: 'pagibig',
                            name: 'pagibig',
                            render: function(data, type, row) {
                                return `<input type="checkbox" class="status-checkbox" data-id="${row.id}" data-field="pagibig" ${data == "1" ? 'checked' : ''}>`;
                            }
                        },
                        {
                            data: 'philhealth',
                            name: 'philhealth',
                            render: function(data, type, row) {
                                return `<input type="checkbox" class="status-checkbox" data-id="${row.id}" data-field="philhealth" ${data == "1" ? 'checked' : ''}>`;
                            }
                        },
                        {
                            data: 'dtr_id',
                            name: 'dtr_id',
                            render: function(data, type, row) {
                                return `
                        <div class="flex items-center justify-center space-x-2">
                            <input type="text" class="px-2 py-1 border border-gray-300 rounded
                            w-[7rem] dtr-input" data-id="${row.id}" value="${data || ''}">
                            <button class="px-2 py-1 text-white bg-blue-500 rounded hover:bg-blue-700 save-dtr-btn" data-id="${row.id}">Save</button>
                        </div>
                    `;
                            }
                        },
                        {
                            data: 'bankprofile_id',
                            name: 'bankprofile_id',
                            render: function(data, type, row) {
                                let options =
                                    `<option value="">-- Select Bank --</option>`;

                                options += bankProfiles.map(profile => {
                                    const selected = profile.id === data ? 'selected' : '';
                                    return `<option value="${profile.id}" ${selected}>${profile.name}</option>`;
                                }).join('');

                                return `
            <div class="flex items-center justify-center space-x-2">
                <select class="px-2 py-1 border border-gray-300 rounded bank-select" data-id="${row.id}">
                    ${options}
                </select>
                <button class="px-2 py-1 text-white bg-blue-500 rounded hover:bg-blue-700 save-dtr-btn" data-id="${row.id}">Save</button>
            </div>
        `;
                            }
                        },

                        {
                            data: 'bankaccount',
                            name: 'bankaccount',
                            render: function(data, type, row) {
                                return `
                        <div class="flex items-center justify-center space-x-2">
                            <input type="text" class="px-2 py-1 border border-gray-300 rounded
                            w-[7rem] account-input" data-id="${row.id}" value="${data || ''}">
                            <button class="px-2 py-1 text-white bg-blue-500 rounded hover:bg-blue-700 save-dtr-btn" data-id="${row.id}">Save</button>
                        </div>
                    `;
                            }
                        },


                        {
                            data: 'default_rate_id',
                            name: 'default_rate_id',
                            render: function(data, type, row) {
                                let options =
                                    `<option value="">-- Select Rate --</option>`; // Empty option at top

                                options += defaultrate.map(rate => {
                                    const selected = rate.id === data ? 'selected' : '';
                                    return `<option value="${rate.id}" ${selected}>${rate.name} - (${rate.default_rate})</option>`;
                                }).join('');

                                return `
            <div class="flex items-center justify-center space-x-2">
                <select class="px-2 py-1 border border-gray-300 rounded rate-select" data-id="${row.id}">
                    ${options}
                </select>
                <button class="px-2 py-1 text-white bg-blue-500 rounded hover:bg-blue-700 save-rate-btn" data-id="${row.id}">Save</button>
            </div>
        `;
                            }
                        },


                        {
                            data: 'client_name',
                            name: 'client_name'
                        },
                        {
                            data: null,
                            name: 'action',
                            orderable: false,
                            searchable: false,
                            render: function(data, type, row) {
                                return `
            <button class="view-btn bg-indigo-600 text-white px-3 py-1 rounded text-xs" 
                data-id="${row.id}" 
                data-status="${row.employeestatus}"
                data-dtr="${row.dtr_id}"
              
                data-bankaccount="${row.bankaccount}"
                data-agency="${row.agency_name}"
                data-company="${row.company_name}"
                data-client="${row.client_name}"
                data-datehired="${row.date_hired}"
                data-entry="${row.entry_time}"
                data-exit="${row.exit_time}"
                data-start="${row.employment_start_date}"
                data-end="${row.employment_end_date}">
                View
            </button>
        `;
                            }
                        }

                    ],
                    order: [
                        [0, 'desc']
                    ]
                });

                function showSuccessModal(message) {
                    $('#modalMessage123').text(message);
                    $('#successModal123').removeClass('hidden');

                    setTimeout(() => {
                        $('#successModal123').addClass('hidden');
                    }, 3000);
                }
                $('#department-table').on('click', '.save-rate-btn', function() {
                    let rowId = $(this).data('id');
                    let $parent = $(this).closest('div'); // Get the wrapper around inputs

                    let newBankProfileId = $parent.find('.rate-select').val(); // Get bank profile if present

                    let payload = {
                        _token: csrfToken,
                        id: rowId
                    };


                    payload.default_rate_id = newBankProfileId;


                    $.ajax({
                        url: updateRateUrl,
                        type: "POST",
                        data: payload,
                        success: function(response) {
                            showSuccessModal(response.message);
                        },
                        error: function() {
                            alert('Error updating employee data.');
                        }
                    });
                });
                // ✅ Handle status update on checkbox toggle
                $('#department-table').on('change', '.status-checkbox', function() {
                    let isChecked = $(this).is(':checked') ? '1' : '0';
                    let rowId = $(this).data('id');
                    let field = $(this).data('field');

                    let requestData = {
                        _token: csrfToken,
                        id: rowId
                    };

                    requestData[field] = isChecked;

                    console.log("Sending request:", requestData); // 🔍 Debug line

                    $.ajax({
                        url: updateStatusUrl,
                        type: "POST",
                        data: requestData,
                        success: function(response) {
                            console.log("Response:", response); // 🔍 Debug line
                            showSuccessModal(response.message);
                        },
                        error: function(xhr) {
                            console.error("AJAX error:", xhr.responseText); // 🔍 Debug line
                            alert('Error updating status');
                        }
                    });
                });

                // ✅ Handle DTR ID update when clicking "Save" button
                $('#department-table').on('click', '.save-dtr-btn', function() {
                    let rowId = $(this).data('id');
                    let $parent = $(this).closest('div'); // Get the wrapper around inputs

                    let newDtrId = $parent.find('.dtr-input').val(); // Get DTR ID if present
                    let newBankProfileId = $parent.find('.bank-select').val(); // Get bank profile if present
                    let newBankAccount = $parent.find('.account-input').val(); // Get bank profile if present

                    let payload = {
                        _token: csrfToken,
                        id: rowId
                    };

                    if (newDtrId !== undefined) {
                        payload.dtr_id = newDtrId;
                    }

                    if (newBankProfileId !== undefined) {
                        payload.bankprofile_id = newBankProfileId;
                    }
                    if (newBankAccount !== undefined) {
                        payload.bankaccount = newBankAccount;
                    }

                    $.ajax({
                        url: updateDtrUrl,
                        type: "POST",
                        data: payload,
                        success: function(response) {
                            showSuccessModal(response.message);
                        },
                        error: function() {
                            alert('Error updating employee data.');
                        }
                    });
                });

                // ✅ Close modal button
                $('#closeModal').on('click', function() {
                    $('#successModal123').addClass('hidden');
                });
                $('#department-table').on('click', '.view-btn', function() {
                    const btn = $(this);
                    const id = btn.data('id');

                    // QR code and data fields
                    $('#modal-qr').attr('src',
                        `https://api.qrserver.com/v1/create-qr-code/?data=${encodeURIComponent(id)}&size=150x150`
                    );

                    $('#modal-status').text(btn.data('status'));
                    $('#modal-dtr').text(btn.data('dtr'));
                    $('#modal-bankaccount').text(btn.data('bankaccount'));
                    $('#modal-agency').text(btn.data('agency'));
                    $('#modal-company').text(btn.data('company'));
                    $('#modal-client').text(btn.data('client'));
                    $('#modal-datehired').text(btn.data('datehired'));
                    $('#modal-entry').text(btn.data('entry'));
                    $('#modal-exit').text(btn.data('exit'));
                    $('#modal-start').text(btn.data('start'));
                    $('#modal-end').text(btn.data('end'));

                    // Update dynamic download link using route placeholder
                    const routeTemplate = $('#download-idcard-link').data('route'); // Laravel-generated string
                    const finalLink = routeTemplate.replace('__ID__', id);
                    $('#download-idcard-link').attr('href', finalLink);

                    $('#viewModal').removeClass('hidden');
                });

            });
        </script>
    @endif
</div>
<!-- Tailwind Success Modal -->
<div id="successModal123" class="fixed inset-0 z-50 flex items-center justify-center hidden bg-gray-900 bg-opacity-50">
    <div class="w-11/12 max-w-md bg-white rounded-lg shadow-lg">
        <div class="px-4 py-2 border-b">
            <h5 class="text-xl font-semibold text-green-600">Success</h5>
        </div>
        <div class="p-4">
            <p id="modalMessage123">Operation completed successfully!</p>
        </div>
        <div class="flex justify-end px-4 py-2 border-t">
            <button id="closeModal" class="px-3 py-1 text-white bg-green-500 rounded hover:bg-green-600">Close</button>
        </div>
    </div>
</div>

<!-- Modal -->
<div id="viewModal" class="fixed inset-0 z-50 hidden overflow-y-auto bg-black bg-opacity-50">
    <div class="relative w-full max-w-2xl p-6 mx-auto mt-20 bg-white rounded shadow-lg">
        <div class="flex justify-between">
            <div>
                <h2 class="mb-4 text-xl font-semibold">Employee History Detail</h2>
            </div>
            <div><a id="download-idcard-link" href="#" data-route="{{ route('employeeid', ['id' => '__ID__']) }}"
                    class="inline-block px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded hover:bg-blue-700">
                    Download ID Card
                </a></div>

        </div>

        <div class="flex justify-center items-center mb-4">
            <img id="modal-qr" src="" alt="QR Code for Employee ID" title="QR Code for Employee ID"
                class="max-w-full h-auto" style="width: 150px; height: 150px;">

        </div>
        <div class="text-center mb-5">QR Code For Attendance</div>
        <div class="grid grid-cols-2 gap-4 text-sm">
            <div><strong>Status:</strong> <span id="modal-status"></span></div>
            <div><strong>DTR ID:</strong> <span id="modal-dtr"></span></div>

            <div><strong>Bank Account:</strong> <span id="modal-bankaccount"></span></div>
            <div><strong>Agency:</strong> <span id="modal-agency"></span></div>
            <div><strong>Company:</strong> <span id="modal-company"></span></div>
            <div><strong>Client:</strong> <span id="modal-client"></span></div>
            <div><strong>Date Hired:</strong> <span id="modal-datehired"></span></div>
            <div><strong>Shift Start:</strong> <span id="modal-entry"></span></div>
            <div><strong>Shift End:</strong> <span id="modal-exit"></span></div>
            <div><strong>Start Date:</strong> <span id="modal-start"></span></div>
            <div><strong>End Date:</strong> <span id="modal-end"></span></div>
        </div>
        <div class="flex justify-end mt-6">
            <button onclick="document.getElementById('viewModal').classList.add('hidden')"
                class="px-4 py-2 text-white bg-gray-600 rounded hover:bg-gray-700">
                Close
            </button>
        </div>

    </div>
</div>
