<p class="mt-10 text-xl font-bold text-nowrap md:text-3xl mr-44">PERSONAL DATA</p>
<div class="text-sm ">
    <div class="p-4 ">
        <div class="grid grid-cols-1 gap-10 lg:grid-cols-5 ">
            <div class="p-2 bg-white border-2 border-black rounded-xl">
                <div class="flex flex-row items-center justify-center gap-2 ">

                    <div id="imagePreview" class="mt-2">

                        <img id="preview"
                            src="{{ $employee->profile ? Storage::disk('spaces')->url($employee->profile) : '' }}"
                            name="" alt="Image Preview"
                            class="object-cover w-full border-2 border-black h-44 rounded-xl" />
                        <!-- Image Attachment Section -->
                        <div class="mt-4">
                            <label for="imageUpload" class="block mb-2 font-medium text-gray-700">Attach
                                Image:</label>

                            <label for="imageUpload" class="flex items-center mb-4 cursor-pointer">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                    stroke="currentColor" class="w-8 h-8 text-gray-600 hover:text-green-600">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M3 16.5V21h18v-4.5M12 4.5v9m-3-3l3-3 3 3m-3-3v9" />
                                </svg>
                                <span class="ml-2 text-gray-600 hover:text-green-600">Upload Image</span>
                            </label>
                            <input type="file" id="imageUpload" name="profile" accept="image/*"
                                class="hidden p-2 mb-4 border border-gray-300" value="{{ $employee->profile }}"
                                onchange="previewImage(event)">
                        </div>
                    </div>

                </div>
            </div>

            <div
                class="grid grid-cols-1 col-span-4 gap-4 p-5 mb-4 bg-white border-2 border-black rounded-md lg:grid-cols-2 md:grid-cols-4">
    


                <div class="p-2 mt-4 ">

                    <label for="last_name" class="block mb-1">Last Name:</label>
                    <input type="text" name="last_name" id="last_name"
                        class="w-full p-2 border border-black rounded-md"
                        placeholder="Surname, Given Name, Extension, Middle Name" value="{{ $employee->last_name }}" />
                    @error('last_name')
                        <span class="text-sm text-red-500">{{ $message }}</span>
                    @enderror
                </div>
                <div class="p-2 mt-4 ">

                    <label for="first_name" class="block mb-1">First Name:</label>
                    <input type="text" name="first_name" id="first_name"
                        class="w-full p-2 border border-black rounded-md"
                        placeholder="Surname, Given Name, Extension, Middle Name"
                        value="{{ $employee->first_name }}" />
                    @error('first_name')
                        <span class="text-sm text-red-500">{{ $message }}</span>
                    @enderror
                </div>
                <div class="p-2 mt-4 ">

                    <label for="middle_name" class="block mb-1">Middle Name (optional):</label>
                    <input type="text" name="middle_name" id="middle_name"
                        class="w-full p-2 border border-black rounded-md"
                        placeholder="Surname, Given Name, Extension, Middle Name"
                        value="{{ $employee->middle_name }}" />
                    @error('middle_name')
                        <span class="text-sm text-red-500">{{ $message }}</span>
                    @enderror
                </div>
                 <div class="p-2 mt-4 ">

                    <label for="Sex" class="block mb-1">Sex:</label>
                    
                    <select id="sex" name="sex" class="w-full p-2 border border-black rounded-md">
    <option value="">Select Sex</option>
    <option value="M" {{ $employee->sex === 'M' ? 'selected' : '' }}>Male</option>
    <option value="F" {{ $employee->sex === 'F' ? 'selected' : '' }}>Female</option>
</select>
                    
                    
                </div>
                <div class="p-2 mt-4 ">

                    <label for="email" class="block mb-1">Email:</label>
                    <input type="email" name="email" id="email"
                        class="w-full p-2 border border-black rounded-md"
                        placeholder="Surname, Given Name, Extension, Middle Name"
                        value="{{ $employee->user->email }}" />
                    @error('email')
                        <span class="text-sm text-red-500">{{ $message }}</span>
                    @enderror
                </div>

            </div>
        </div>
        <div class="grid grid-cols-1 gap-4 p-5 mt-5 mb-4 bg-white border-2 border-black rounded-xl lg:grid-cols-2">
            <div class="p-2 ">
                <label for="present_address" class="block mb-1">Present Address:</label>
                <input type="text" name="present_address" id="present_address"
                    class="w-full p-2 border border-black rounded-md" value="{{ $employee->present_address }}" />
                @error('present_address')
                    <span class="text-sm text-red-500">{{ $message }}</span>
                @enderror
            </div>
            <div class="p-2 ">
                <label for="provincial_address" class="block mb-1">Provincial Address:</label>
                <input type="text" name="provincial_address" id="provincial_address"
                    class="w-full p-2 border border-black rounded-md"value="{{ $employee->provincial_address }}" />
                @error('provincial_address')
                    <span class="text-sm text-red-500">{{ $message }}</span>
                @enderror
            </div>
            <div class="p-2 ">
                <label for="mobile_number" class="block mb-1">Mobile No:</label>
                <input type="text" name="mobile_number" id="mobile_number"
                    class="w-full p-2 border border-black rounded-md" value="{{ $employee->mobile_number }}" />
                @error('mobile_number')
                    <span class="text-sm text-red-500">{{ $message }}</span>
                @enderror
            </div>
            <div class="p-2 ">
                <label for="alternative_number" class="block mb-1">Alternative Number:</label>
                <input type="text" name="alternative_number" id="alternative_number"
                    class="w-full p-2 border border-black rounded-md" value="{{ $employee->alternative_number }}" />
                @error('alternative_number')
                    <span class="text-sm text-red-500">{{ $message }}</span>
                @enderror
            </div>
        </div>
        <div class="grid grid-cols-1 gap-10 mt-10 lg:grid-cols-5 ">
            <div
                class="grid grid-cols-1 col-span-3 gap-4 p-5 bg-white border-2 border-black rounded-xl lg:grid-cols-2">


                <div class="p-2 ">
                    <label for="date_of_birth" class="block mb-1">Date of Birth:</label>
                    <input type="date" name="date_of_birth" id="date_of_birth"
                        class="w-full p-2 border border-black rounded-md" value="{{ $employee->date_of_birth }}" />
                    @error('date_of_birth')
                        <span class="text-sm text-red-500">{{ $message }}</span>
                    @enderror
                </div>
                <div class="p-2 ">
                    <label for="age" class="block mb-1">Age:</label>
                    <input type="number" name="age" id="age"
                        class="w-full p-2 border border-black rounded-md" value="{{ $employee->age }}" />
                    @error('age')
                        <span class="text-sm text-red-500">{{ $message }}</span>
                    @enderror
                </div>
                <div class="p-2 ">
                    <label for="place_of_birth" class="block mb-1">Place of Birth:</label>
                    <input type="text" name="place_of_birth" id="place_of_birth"
                        class="w-full p-2 border border-black rounded-md" value="{{ $employee->place_of_birth }}" />
                    @error('place_of_birth')
                        <span class="text-sm text-red-500">{{ $message }}</span>
                    @enderror
                </div>
            </div>



            <div class="grid grid-cols-1 col-span-2 gap-4 border-2 border-black rounded-xl">

                <div class="flex items-center justify-center">
                    <div>
                        <p class="flex items-center justify-center">Civil Status</p>
                        <div class="grid grid-cols-2 gap-10 mt-5 xl:grid-cols-2 ">
                            <div class="flex items-center justify-center w-[14rem] border-2 py-2">
                                <input type="radio" name="civil_status" value="single" id="single"
                                    {{ $employee->civil_status == 'single' ? 'checked' : '' }}>
                                <label for="single" class="ml-2">Single</label>
                            </div>
                            <div class="flex items-center justify-center w-[14rem] border-2 py-2">
                                <input type="radio" name="civil_status" value="married" id="married"
                                    {{ $employee->civil_status == 'married' ? 'checked' : '' }}>
                                <label for="married" class="ml-2">Married</label>
                            </div>
                            <div class="flex items-center justify-center w-[14rem] border-2 py-2">
                                <input type="radio" name="civil_status" value="head_of_family" id="head_of_family"
                                    {{ $employee->civil_status == 'head_of_family' ? 'checked' : '' }}>
                                <label for="head_of_family" class="ml-2">Head of the Family</label>
                            </div>
                            <div class="flex items-center justify-center w-[14rem] border-2 py-2">
                                <input type="radio" name="civil_status" value="widow" id="widow"
                                    {{ $employee->civil_status == 'widow' ? 'checked' : '' }}>
                                <label for="widow" class="ml-2">Widow/er</label>
                            </div>
                        </div>
                    </div>

                    @error('civil_status')
                        <span class="text-sm text-red-500">{{ $message }}</span>
                    @enderror
                </div>


            </div>
        </div>
        <div class="grid grid-cols-1 gap-10 lg:grid-cols-2">
            <div
                class="grid grid-cols-1 gap-4 p-5 mt-10 mb-4 bg-white border-2 border-black rounded-xl lg:grid-cols-2">
                <div class="p-2 ">
                    <label for="nationality" class="block mb-1">Nationality:</label>
                    <input type="text" name="nationality" id="nationality"
                        class="w-full p-2 border border-black rounded-md" value="{{ $employee->nationality }}" />
                    @error('nationality')
                        <span class="text-sm text-red-500">{{ $message }}</span>
                    @enderror
                </div>
                <div class="p-2 ">
                    <label for="religion" class="block mb-1">Religion:</label>
                    <input type="text" name="religion" id="religion"
                        class="w-full p-2 border border-black rounded-md" value="{{ $employee->religion }}" />
                    @error('religion')
                        <span class="text-sm text-red-500">{{ $message }}</span>
                    @enderror
                </div>
                <div class="p-2 ">
                    <label for="height" class="block mb-1">Height:</label>
                    <input type="text" name="height" id="height"
                        class="w-full p-2 border border-black rounded-md" value="{{ $employee->height }}" />
                    @error('height')
                        <span class="text-sm text-red-500">{{ $message }}</span>
                    @enderror
                </div>
                <div class="p-2 ">
                    <label for="weight" class="block mb-1">Weight:</label>
                    <input type="text" name="weight" id="weight"
                        class="w-full p-2 border border-black rounded-md" value="{{ $employee->weight }}" />
                    @error('weight')
                        <span class="text-sm text-red-500">{{ $message }}</span>
                    @enderror
                </div>
            </div>
            <div
                class="grid grid-cols-1 gap-4 p-5 mt-10 mb-4 bg-white border-2 border-black rounded-xl lg:grid-cols-2">
                <div class="p-2 ">
                    <label for="spouse_name" class="block mb-1">Name of Spouse (if married):</label>
                    <input type="text" name="spouse_name" id="spouse_name"
                        class="w-full p-2 border border-black rounded-md" value="{{ $employee->spouse_name }}" />
                    @error('spouse_name')
                        <span class="text-sm text-red-500">{{ $message }}</span>
                    @enderror
                </div>
                <div class="p-2 ">
                    <label for="spouse_occupation" class="block mb-1">Occupation:</label>
                    <input type="text" name="spouse_occupation" id="spouse_occupation"
                        class="w-full p-2 border border-black rounded-md"
                        value="{{ $employee->spouse_occupation }}" />
                    @error('spouse_occupation')
                        <span class="text-sm text-red-500">{{ $message }}</span>
                    @enderror
                </div>
                <!--<div class="p-2 ">-->
                <!--    <label for="mother_maiden_name" class="block text-sm font-medium text-gray-700">Mother's-->
                <!--        Maiden-->
                <!--        Name</label>-->
                <!--    <input type="text" name="mother_maiden_name" id="mother_maiden_name"-->
                <!--        class="w-full p-2 border border-black rounded-md"-->
                <!--        value="{{ $employee->mother_maiden_name }}" />-->
                <!--    @if ($errors->has('mother_maiden_name'))-->
                <!--        <span class="text-sm text-red-500">{{ $errors->first('mother_maiden_name') }}</span>-->
                <!--    @endif-->
                <!--</div>-->

                <!--<div class="p-2 ">-->
                <!--    <label for="mother_occupation" class="block text-sm font-medium text-gray-700">Mother's-->
                <!--        Occupation</label>-->
                <!--    <input type="text" name="mother_occupation" id="mother_occupation"-->
                <!--        class="w-full p-2 border border-black rounded-md"-->
                <!--        value="{{ $employee->mother_occupation }}" />-->
                <!--    @if ($errors->has('mother_occupation'))-->
                <!--        <span class="text-sm text-red-500">{{ $errors->first('mother_occupation') }}</span>-->
                <!--    @endif-->
                <!--</div>-->
            </div>
        </div>
        <div class="grid grid-cols-1 gap-10 lg:grid-cols-2">
            <div
                class="grid grid-cols-1 gap-4 p-5 mt-10 mb-4 bg-white border-2 border-black rounded-xl lg:grid-cols-2">
                <div class="p-2 ">
                    <label for="mother_maiden_name" class="block text-sm font-medium text-gray-700">Mother's
                        Maiden
                        Name</label>
                    <input type="text" name="mother_maiden_name" id="mother_maiden_name"
                        class="w-full p-2 border border-black rounded-md"
                        value="{{ $employee->mother_maiden_name }}" />
                    @if ($errors->has('mother_maiden_name'))
                        <span class="text-sm text-red-500">{{ $errors->first('mother_maiden_name') }}</span>
                    @endif
                </div>

                <div class="p-2">
                    <label for="mother_occupation" class="block text-sm font-medium text-gray-700">Mother's
                        Occupation</label>
                    <input type="text" name="mother_occupation" id="mother_occupation"
                        class="w-full p-2 border border-black rounded-md"
                        value="{{ $employee->mother_occupation }}" />
                    @if ($errors->has('mother_occupation'))
                        <span class="text-sm text-red-500">{{ $errors->first('mother_occupation') }}</span>
                    @endif
                </div>

                <div class="p-2 ">
                    <label for="father_name" class="block text-sm font-medium text-gray-700">Father's
                        Name</label>
                    <input type="text" name="father_name" id="father_name"
                        class="w-full p-2 border border-black rounded-md" value="{{ $employee->father_name }}" />
                    @if ($errors->has('father_name'))
                        <span class="text-sm text-red-500">{{ $errors->first('father_name') }}</span>
                    @endif
                </div>

                <div class="p-2 ">
                    <label for="father_occupation" class="block text-sm font-medium text-gray-700">Father's
                        Occupation</label>
                    <input type="text" name="father_occupation" id="father_occupation"
                        class="mt-1 border-2 border-gray-300 p-2 w-full rounded-md focus:outline-none focus:ring-2 focus:ring-indigo-500 {{ $errors->has('father_occupation') ? 'border-red-500' : '' }}"
                        value="{{ $employee->father_occupation }}" />
                    @if ($errors->has('father_occupation'))
                        <span class="text-sm text-red-500">{{ $errors->first('father_occupation') }}</span>
                    @endif
                </div>
            </div>
            <div
                class="grid grid-cols-1 gap-4 p-5 mt-10 mb-4 bg-white border-2 border-black rounded-xl lg:grid-cols-2">
                <div class="p-2 ">
                    <label for="dependents" class="block text-sm font-medium text-gray-700">Dependents</label>
                    <input type="text" name="dependents" id="dependents"
                        class="w-full p-2 border border-black rounded-md" value="{{ $employee->dependents }}" />
                    @if ($errors->has('dependents'))
                        <span class="text-sm text-red-500">{{ $errors->first('dependents') }}</span>
                    @endif
                </div>

                <div class="p-2 ">
                    <label for="philhealth_no" class="block text-sm font-medium text-gray-700">PhilHealth
                        No.</label>
                    <input type="text" name="philhealth_no" id="philhealth_no"
                        class="w-full p-2 border border-black rounded-md" value="{{ $employee->philhealth_no }}" />
                    @if ($errors->has('philhealth_no'))
                        <span class="text-sm text-red-500">{{ $errors->first('philhealth_no') }}</span>
                    @endif
                </div>
                <div class="p-2 ">
                    <label for="blood_type" class="block text-sm font-medium text-gray-700">Blood
                        Type</label>
                    <input type="text" name="blood_type" id="blood_type"
                        class="w-full p-2 border border-black rounded-md" value="{{ $employee->blood_type }}" />
                    @if ($errors->has('blood_type'))
                        <span class="text-sm text-red-500">{{ $errors->first('blood_type') }}</span>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>`




<script>
    function previewImage(event) {
        const preview = document.getElementById('preview');
        const imagePreview = document.getElementById('imagePreview');

        // Get the file from the input
        const file = event.target.files[0];

        if (file) {
            // Create a FileReader to read the file
            const reader = new FileReader();

            // Set the image source when the file is loaded
            reader.onload = function(e) {
                preview.src = e.target.result;
                preview.classList.remove('hidden'); // Show the image
            };

            // Read the file as a data URL
            reader.readAsDataURL(file);
        } else {
            // If no file is selected, hide the image
            preview.src = "#";
            preview.classList.add('hidden');
        }
    }
</script>
