@extends('layouts.sidebar')
@section('title', 'Edit Overtime Request')
@section('content')

    @if (in_array('Manage Employee', $privileges))

        <div class="relative flex flex-col items-end justify-end mb-2 mr-10 text-center">

            <div>
                <button type="button"
                    class="inline-flex justify-center w-60 px-4 py-2 text-sm font-medium text-white bg-[#1d1d1d]  border border-gray-300 rounded-md shadow-sm hover:bg-blue-900 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-100 focus:ring-blue-500"
                    id="menu-button" aria-expanded="false" aria-haspopup="true" onclick="toggleDropdown()">
                    Menu
                    <svg class="w-5 h-5 ml-2 -mr-1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor"
                        aria-hidden="true">
                        <path fill-rule="evenodd"
                            d="M5.23 7.21a.75.75 0 011.06 0L10 10.44l3.71-3.23a.75.75 0 111.04 1.08l-4.25 3.5a.75.75 0 01-1.04 0l-4.25-3.5a.75.75 0 010-1.08z"
                            clip-rule="evenodd" />
                    </svg>
                </button>

                <div class="absolute right-0 z-10 hidden w-56 mt-2 bg-white rounded-md shadow-lg ring-1 ring-black ring-opacity-5 focus:outline-none"
                    role="menu" aria-orientation="vertical" aria-labelledby="menu-button" tabindex="-1"
                    id="dropdown-menu">
                    <div class="py-1" role="none">
                        <div class="flex flex-col items-center justify-center ">

                            <button id="showeditform"
                                class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                Edit
                            </button>
                            <button id="showView"
                                class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                View
                            </button>

                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div id="editformshow" class="hidden w-full p-4 lg:w-full">
            <div class="max-w-4xl mx-auto bg-white p-10 rounded shadow border border-gray-300">
                <h2 class="text-3xl font-semibold text-gray-900 text-center mb-6">Leave Request Form</h2>

                <form action="{{ route('leaves.update', $leave->id) }}" method="POST">
                    @csrf
                    @method('PUT')

                    <!-- Employee Name -->
                    <div class="mb-6">
                        <label for="employee_id" class="block text-gray-700 text-lg font-semibold">Employee Name:</label>
                        <select name="employee_id" id="employee_id" class="w-full border-b border-gray-700 px-2 py-1"
                            required>
                            <option value="" disabled>Select Employee</option>
                            @foreach ($employees as $employee)
                                <option value="{{ $employee->id }}"
                                    {{ $leave->employee_id == $employee->id ? 'selected' : '' }}>
                                    {{ $employee->last_name }}, {{ $employee->first_name }}
                                    {{ $employee->middle_name ? substr($employee->middle_name, 0, 1) . '.' : '' }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Leave Type -->
                    <div class="mb-6">
                        <label for="leave_type" class="block text-gray-700 text-lg font-semibold">Type of Leave:</label>
                        <select name="leave_type" id="leave_type" class="w-full border-b border-gray-700 px-2 py-1"
                            required>
                            <option value="Sick Leave" {{ $leave->leave_type == 'Sick Leave' ? 'selected' : '' }}>Sick Leave
                            </option>
                            <option value="Vacation Leave" {{ $leave->leave_type == 'Vacation Leave' ? 'selected' : '' }}>
                                Vacation
                                Leave</option>
                            <option value="Emergency Leave" {{ $leave->leave_type == 'Emergency Leave' ? 'selected' : '' }}>
                                Emergency Leave</option>
                            <option value="Maternity/Paternity Leave"
                                {{ $leave->leave_type == 'Maternity/Paternity Leave' ? 'selected' : '' }}>
                                Maternity/Paternity Leave
                            </option>
                            <option value="Other" {{ $leave->leave_type == 'Other' ? 'selected' : '' }}>Other</option>
                        </select>
                    </div>

                    <!-- Leave Duration -->
                    <div class="grid grid-cols-2 gap-4 mb-6">
                        <div>
                            <label for="start_date" class="block text-gray-700 text-lg font-semibold">Start Date:</label>
                            <input type="date" name="start_date" id="start_date" value="{{ $leave->start_date }}"
                                class="w-full border-b border-gray-700 px-2 py-1" required>
                        </div>
                        <div>
                            <label for="end_date" class="block text-gray-700 text-lg font-semibold">End Date:</label>
                            <input type="date" name="end_date" id="end_date" value="{{ $leave->end_date }}"
                                class="w-full border-b border-gray-700 px-2 py-1" required>
                        </div>
                    </div>

                    <!-- Total Days -->
                    <div class="mb-6">
                        <label class="block text-gray-700 text-lg font-semibold">Total Days:</label>
                        <input type="number" name="days" id="days" value="{{ $leave->days }}"
                            class="w-full border-b border-gray-700 px-2 py-1" readonly required>
                    </div>

                    <!-- Reason for Leave -->
                    <div class="mb-6">
                        <label for="reason" class="block text-gray-700 text-lg font-semibold">Reason for Leave:</label>
                        <textarea name="reason" id="reason" rows="4" class="w-full border-b border-gray-700 px-2 py-1" required>{{ $leave->reason }}</textarea>
                    </div>

                    <!-- Paid Leave Checkbox -->
                    <div class="mb-6">
                        <label class="block text-gray-700 text-lg font-semibold">Paid Leave:</label>
                        <input type="checkbox" name="paid" value="1" class="form-checkbox text-blue-600"
                            {{ $leave->paid ? 'checked' : '' }}>
                        <span class="ml-2 text-gray-700">This is a paid leave</span>
                    </div>

                    <!-- Signature Section -->
                    <div class="grid grid-cols-2 gap-10 mt-8">
                        <div class="text-center">
                            <p class="border-t border-gray-700 w-full py-1 font-semibold">Employee Signature</p>
                        </div>
                        <div class="text-center">
                            <p class="border-t border-gray-700 w-full py-1 font-semibold">Manager's Approval</p>
                        </div>
                    </div>

                    <!-- Submit Button -->
                    <div class="mt-10 text-center">
                        <button type="submit"
                            class="bg-blue-600 text-white text-lg px-6 py-2 rounded hover:bg-blue-700">Update
                            Leave</button>
                    </div>
                </form>
            </div>

            <!-- Select2 & Auto Calculation Script -->
            <script>
                $(document).ready(function() {
                    $('#employee_id').select2({
                        placeholder: "Select Employee",
                        allowClear: true,
                        width: '100%'
                    });

                    // Auto-calculate days between dates
                    $('#start_date, #end_date').on('change', function() {
                        let startDate = new Date($('#start_date').val());
                        let endDate = new Date($('#end_date').val());

                        if (startDate && endDate && endDate >= startDate) {
                            let difference = Math.ceil((endDate - startDate) / (1000 * 60 * 60 * 24)) + 1;
                            $('#days').val(difference);
                        } else {
                            $('#days').val('');
                        }
                    });
                });
            </script>
        </div>


        <div id="viewshow" class="w-full md:p-4 lg:w-full">

            <div
                class="max-w-3xl mx-auto bg-white border border-gray-300 shadow-md rounded print:shadow-none print:border-none print:p-0 print:bg-white">

                <div class="mt-8 flex justify-end print:hidden px-4">
                    <a href="{{ route('leaves.index') }}"
                        class="mr-4 px-4 py-2 text-sm text-white bg-gray-700 rounded hover:bg-gray-800">Back</a>

                    <a href="{{ route('printleave', ['id' => $leave->id]) }}"
                        class="px-4 py-2 text-sm text-white bg-blue-600 rounded hover:bg-blue-700">
                        Download
                    </a>

                </div>

                <div class=" p-10">
                    <div class="text-center mb-10">
                        <h1 class="text-2xl font-bold uppercase tracking-widest">Leave Request Form</h1>
                        <p class="text-sm text-gray-600">Document ID:
                            LV-{{ str_pad($leave->id, 5, '0', STR_PAD_LEFT) }}</p>
                    </div>

                    <table class="w-full text-sm text-left text-gray-700 border border-collapse border-gray-300">
                        <tbody>
                            <tr class="border-b">
                                <td class="font-semibold bg-gray-100 p-2 w-1/3">Employee Name:</td>
                                <td class="p-2">
                                    {{ $leave->employee->last_name }}, {{ $leave->employee->first_name }}
                                    {{ $leave->employee->middle_name ? substr($leave->employee->middle_name, 0, 1) . '.' : '' }}
                                </td>
                            </tr>
                            <tr class="border-b">
                                <td class="font-semibold bg-gray-100 p-2 w-1/3">Employee ID:</td>
                                <td class="p-2">{{ $leave->employee_id ?? 'N/A' }}</td>
                            </tr>
                            {{-- <tr class="border-b">
                            <td class="font-semibold bg-gray-100 p-2">Department:</td>
                            <td class="p-2">{{ $leave->department->department_name ?? 'N/A' }}</td>
                        </tr> --}}
                            <tr class="border-b">
                                <td class="font-semibold bg-gray-100 p-2">Type of Leave:</td>
                                <td class="p-2">{{ $leave->leave_type }}</td>
                            </tr>
                            <tr class="border-b">
                                <td class="font-semibold bg-gray-100 p-2">Start Date:</td>
                                <td class="p-2">{{ \Carbon\Carbon::parse($leave->start_date)->format('F d, Y') }}
                                </td>
                            </tr>
                            <tr class="border-b">
                                <td class="font-semibold bg-gray-100 p-2">End Date:</td>
                                <td class="p-2">{{ \Carbon\Carbon::parse($leave->end_date)->format('F d, Y') }}
                                </td>
                            </tr>
                            <tr class="border-b">
                                <td class="font-semibold bg-gray-100 p-2">Total Days:</td>
                                <td class="p-2">{{ $leave->days }}</td>
                            </tr>
                            <tr class="border-b">
                                <td class="font-semibold bg-gray-100 p-2">Reason:</td>
                                <td class="p-2">{{ $leave->reason }}</td>
                            </tr>
                            <tr class="border-b">
                                <td class="font-semibold bg-gray-100 p-2">Paid Leave:</td>
                                <td class="p-2">{{ $leave->paid ? 'Yes' : 'No' }}</td>
                            </tr>
                            <tr>
                                <td class="font-semibold bg-gray-100 p-2">Status:</td>
                                <td class="p-2 capitalize">
                                    @if ($leave->is_approved === 1)
                                        Approved
                                    @elseif ($leave->is_approved === 0)
                                        Pending
                                    @else
                                        Rejected
                                    @endif
                                </td>
                            </tr>
                            @if ($leave->approved_at && $leave->approver)
                                <tr>
                                    <td class="font-semibold bg-gray-100 p-2">Approved By:</td>
                                    <td class="p-2">
                                        {{ $leave->approver->name }} on
                                        {{ \Carbon\Carbon::parse($leave->approved_at)->format('F d, Y h:i A') }}
                                    </td>
                                </tr>
                            @endif
                        </tbody>
                    </table>

                    <!-- Signature Section -->
                    <div class="flex justify-between mt-16">
                        <div class="text-center w-1/2">
                            <div class="border-t border-gray-700 w-3/4 mx-auto h-8"></div>
                            <p class="mt-1 text-sm font-semibold">Employee Signature</p>
                        </div>
                        <div class="text-center w-1/2">
                            <div class="border-t border-gray-700 w-3/4 mx-auto h-8"></div>
                            <p class="mt-1 text-sm font-semibold">Manager's Approval</p>
                        </div>
                    </div>

                    <!-- Footer -->
                    <div class="text-right text-xs text-gray-500 mt-10">
                        Printed on: {{ now()->format('F d, Y') }}
                    </div>

                </div>



            </div>
        </div>






        <script>
            document.addEventListener('DOMContentLoaded', function() {
                // Buttons that trigger the sections
                const sections = {
                    showeditform: 'editformshow',
                    showView: 'viewshow'
                };

                // Function to show a section and hide others
                function showSection(sectionToShow) {
                    Object.values(sections).forEach(section => {
                        document.getElementById(section).classList.add('hidden');
                    });
                    document.getElementById(sectionToShow).classList.remove('hidden');
                }

                // Attach event listeners to buttons
                Object.keys(sections).forEach(buttonId => {
                    const button = document.getElementById(buttonId);
                    if (button) {
                        button.addEventListener('click', function() {
                            showSection(sections[buttonId]);
                        });
                    }
                });

                // Dropdown toggle
                const menuButton = document.getElementById('menu-button');
                const dropdownMenu = document.getElementById('dropdown-menu');

                if (menuButton && dropdownMenu) {
                    menuButton.addEventListener('click', function() {
                        dropdownMenu.classList.toggle('hidden');
                    });
                }
            });
        </script>


    @endif
@endsection
