<div class="relative w-full bg-black bg-opacity-80">
    <div id="addLeaveModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
        <div class="bg-white rounded-lg shadow-lg w-auto md:w-[25rem] mt-10">
            <div class="flex flex-col px-2 py-4 bg-white rounded-2xl">
                <div class="flex items-center justify-between pb-4 border-b border-gray-200">
                    <h4 class="text-sm font-medium text-gray-900">File Leave</h4>
                    <button class="block cursor-pointer close-modal-button" onclick="closeModal('addLeaveModal')">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path d="M7.75732 7.75739L16.2426 16.2427M16.2426 7.75739L7.75732 16.2427" stroke="black"
                                stroke-width="1.6" stroke-linecap="round" />
                        </svg>
                    </button>
                </div>

                <form id="leave-form" class="bg-white shadow-md rounded px-8 pt-6 pb-8 mb-4">
                    @csrf

                    <!-- Employee ID -->
                    <div class="mb-4">
                        <label for="employee_id" class="block text-gray-700 text-sm font-bold mb-2">Employee</label>
                        <select name="employee_id" id="employee_id" class="select2 w-full border rounded px-3 py-2"
                            required>
                            <option value="" disabled selected>Select Employee</option>
                            @foreach ($employees as $employee)
                                <option value="{{ $employee->employee_id }}">
                                    {{ $employee->employee->last_name }}, {{ $employee->employee->first_name }}
                                    {{ $employee->employee->middle_name ? substr($employee->employee->middle_name, 0, 1) . '.' : '' }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <script>
                        $(document).ready(function() {
                            $('#employee_id').select2({
                                placeholder: "Select Employee",
                                allowClear: true,
                                width: '100%' // Ensure it takes full width
                            });
                        });
                    </script>
                    <!-- Leave Type -->
                    <div class="mb-4">
                        <label for="leave_type" class="block text-gray-700 text-sm font-bold mb-2">Leave Type</label>
                        <select name="leave_type" id="leave_type" class="w-full border rounded px-3 py-2" required>
                            <option value="" disabled selected>Select Leave Type</option>
                            <option value="sick">Sick Leave</option>
                            <option value="vacation">Vacation Leave</option>
                            <option value="emergency">Emergency Leave</option>
                            <option value="maternity">Maternity Leave</option>
                            <option value="paternity">Paternity Leave</option>
                            <option value="unpaid">Unpaid Leave</option>
                        </select>
                    </div>

                    <!-- Start Date -->
                    <div class="mb-4">
                        <label for="start_date" class="block text-gray-700 text-sm font-bold mb-2">Start Date</label>
                        <input type="date" name="start_date" id="start_date" class="w-full border rounded px-3 py-2"
                            required>
                    </div>

                    <!-- End Date -->
                    <div class="mb-4">
                        <label for="end_date" class="block text-gray-700 text-sm font-bold mb-2">End Date</label>
                        <input type="date" name="end_date" id="end_date" class="w-full border rounded px-3 py-2"
                            required>
                    </div>

                    <!-- Days -->
                    <div class="mb-4">
                        <label for="days" class="block text-gray-700 text-sm font-bold mb-2">Days</label>
                        <input type="number" name="days" id="days" class="w-full border rounded px-3 py-2"
                            required>
                    </div>
                    <script>
                        document.getElementById('start_date').addEventListener('change', calculateDays);
                        document.getElementById('end_date').addEventListener('change', calculateDays);

                        function calculateDays() {
                            let startDate = document.getElementById('start_date').value;
                            let endDate = document.getElementById('end_date').value;
                            let daysInput = document.getElementById('days');

                            if (startDate && endDate) {
                                let start = new Date(startDate);
                                let end = new Date(endDate);

                                if (end >= start) {
                                    let timeDiff = end - start;
                                    let daysDiff = Math.ceil(timeDiff / (1000 * 60 * 60 * 24)) + 1; // Add 1 to include the start date
                                    daysInput.value = daysDiff;
                                } else {
                                    daysInput.value = '';
                                    alert("End date must be later than or equal to the start date.");
                                }
                            }
                        }
                    </script>

                    <!-- Paid -->
                    <div class="mb-4">
                        <label for="paid" class="block text-gray-700 text-sm font-bold mb-2">Paid</label>
                        <select name="paid" id="paid" class="w-full border rounded px-3 py-2" required>
                            <option value="1">Yes</option>
                            <option value="0">No</option>
                        </select>
                    </div>

                    <!-- Reason -->
                    <div class="mb-6">
                        <label for="reason" class="block text-gray-700 text-sm font-bold mb-2">Reason</label>
                        <textarea name="reason" id="reason" class="w-full border rounded px-3 py-2" rows="4"></textarea>
                    </div>

                    <!-- Submit Button -->
                    <div class="flex items-center justify-between">
                        <button type="button" id="submit-btn"
                            class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                            Save
                        </button>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>

<div id="confirm-modal" class="fixed inset-0 z-50 flex items-center justify-center hidden bg-black bg-opacity-50">
    <div class="p-5 bg-white rounded-lg shadow-lg w-96">
        <h2 class="text-lg font-bold text-center">Confirm Deletion</h2>
        <p class="mt-2 text-center text-gray-700">Are you sure you want to delete this leave record?</p>

        <div class="mt-4 text-center">
            <button id="confirm-delete" class="px-4 py-2 text-white bg-red-500 rounded-lg hover:bg-red-700">
                Delete
            </button>
            <button onclick="closeModal('confirm-modal')"
                class="px-4 py-2 text-white bg-gray-500 rounded-lg hover:bg-gray-700">
                Cancel
            </button>
        </div>
    </div>
</div>



<!-- Success Modal -->
<div id="success-modal" class="fixed inset-0 z-50 flex items-center justify-center hidden bg-black bg-opacity-50">
    <div class="p-5 bg-white rounded-lg shadow-lg w-96">
        <h2 class="text-lg font-bold text-center">Success</h2>
        <p id="success-modal-message" class="mt-2 text-center text-gray-700"></p>

        <div class="mt-4 text-center">
            <button onclick="closeModal('success-modal')"
                class="px-4 py-2 text-white bg-blue-500 rounded-lg hover:bg-blue-700">
                OK
            </button>
        </div>
    </div>
</div>

<script>
    function openModal(modalId) {
        var modal = document.getElementById(modalId);
        modal.classList.remove('hidden');
        modal.classList.add('flex');
    }

    function closeModal(modalId) {
        var modal = document.getElementById(modalId);
        modal.classList.add('hidden');
        modal.classList.remove('flex');
    }
</script>

<script>
    let deleteId = null;

    function openDeleteModal(id) {
        deleteId = id;
        openModal('confirm-modal');
    }

    document.getElementById('confirm-delete').addEventListener('click', function() {
        if (deleteId) {
            axios.delete("{{ route('leaves.destroy', '') }}/" + deleteId)
                .then(response => {
                    closeModal('confirm-modal');
                    document.getElementById('success-modal-message').innerText =
                        "Leave record deleted successfully!";
                    openModal('success-modal');
                    $('#agencyTable').DataTable().ajax.reload(null, false);
                })
                .catch(error => {
                    alert("Something went wrong. Please try again.");
                });
        }
    });
</script>


<script>
    document.getElementById('submit-btn').addEventListener('click', function() {
        let formData = new FormData(document.getElementById('leave-form'));

        axios.post("{{ route('leaves.store') }}", formData)
            .then(response => {
                // Show success message inside the modal
                document.getElementById('success-modal-message').innerText = response.data.message;
                openModal('success-modal'); // Open success modal

                // Close the add leave modal
                closeModal('addLeaveModal');

                // Reload the DataTable
                $('#agencyTable').DataTable().ajax.reload(null, false);

                // Clear the form after successful submission
                document.getElementById('leave-form').reset();
            })
            .catch(error => {
                if (error.response && error.response.data.errors) {
                    let errors = error.response.data.errors;
                    let errorMessages = Object.values(errors).map(msg => msg[0]).join("\n");
                    alert("Error:\n" + errorMessages);
                } else {
                    alert("Something went wrong. Please try again.");
                }
            });
    });
</script>
