<div class="overflow-auto">



    <table id="others-table" class="min-w-full text-xs bg-white border border-gray-200 rounded shadow-md ">
        <thead>
            <tr class="leading-normal text-nowrap ">

                <th>1st</th>
                <th>2nd</th>

                <th>Active</th>
                <th>TRX Name</th>

                <th>description</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody class="font-light text-center text-gray-600 ">
        </tbody>
    </table>
</div>


<script>
    $(document).ready(function() {
        var employeeid = {{ $employee->id }};
        var departmentTable = $('#others-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('other_trx.others', ['id' => ':id']) }}".replace(':id', employeeid),
                data: function(d) {
                    d.employee_id = employeeid;
                }
            },
            columns: [{
                    data: '1st',
                    name: '1st',
                    width: '10px'
                },
                {
                    data: '2st',
                    name: '2st',
                    width: '10px'
                },

                {
                    data: 'status',
                    name: 'status',
                    width: '10px'
                },

                {
                    data: 'group_code_id',
                    name: 'group_code_id'
                },


                {
                    data: 'description',
                    name: 'description'
                },
                {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                }
            ],
            order: [
                [0, 'desc']
            ],

            "createdRow": function(row, data, dataIndex) {

                $('td:eq(0)', row).html(data['1st'] == 1 ?
                    '<input type="checkbox" class="1st-checkbox" data-id="' + data.id +
                    '" checked />' : '<input type="checkbox" class="1st-checkbox" data-id="' +
                    data.id + '" />');
                $('td:eq(1)', row).html(data['2st'] == 1 ?
                    '<input type="checkbox" class="2st-checkbox" data-id="' + data.id +
                    '" checked />' : '<input type="checkbox" class="2st-checkbox" data-id="' +
                    data.id + '" />');

                $('td:eq(3)', row).html(data.status == 1 ?
                    '<input type="checkbox" class="status-checkbox" data-id="' + data.id +
                    '" checked />' :
                    '<input type="checkbox" class="status-checkbox" data-id="' + data.id +
                    '" />');
            }
        });

        // Event listeners for checkbox changes
        $('body').on('change', '.status-checkbox', function() {
            var trxLoanId = $(this).data('id');
            var status = $(this).is(':checked') ? 1 : 0;
            updateCheckbox(trxLoanId, 'status', status);
        });

        $('body').on('change', '.1st-checkbox', function() {
            var trxLoanId = $(this).data('id');
            var status = $(this).is(':checked') ? 1 : 0;
            updateCheckbox(trxLoanId, '1st', status);
        });

        $('body').on('change', '.2st-checkbox', function() {
            var trxLoanId = $(this).data('id');
            var status = $(this).is(':checked') ? 1 : 0;
            updateCheckbox(trxLoanId, '2st', status);
        });


        function updateCheckbox(id, column, value) {
            $.ajax({
                url: "{{ route('trx-constantloans.update-checkbox', ':id') }}".replace(':id', id),
                method: 'POST',
                data: {
                    _token: $('meta[name="csrf-token"]').attr('content'),
                    column: column,
                    value: value
                },
                success: function(response) {
                    if (response.success) {
                        openSuccessModal12('The checkbox has been updated successfully!');
                    } else {
                        console.log('Failed to update.');
                    }
                },
                error: function() {
                    console.log('An error occurred.');
                }
            });
        }
    });
</script>
<div id="openModal_others" class="fixed inset-0 z-[100] flex items-start justify-center hidden bg-gray-900 bg-opacity-50">
    <div class="w-11/12 p-6 mt-20 bg-white rounded-lg shadow-lg md:w-1/2">
        <h2 class="mb-4 text-2xl font-bold">Add New TrxLoan</h2>
        <!-- Modal Form -->
        <form id="trxothersForm" action="{{ route('other_trx_options.store') }}" method="POST">
            @csrf
            <div class="grid grid-cols-1 gap-2 text-xs md:grid-cols-3">
                <div class="hidden mb-4 form-group">
                    <label for="employee_id" class="block font-medium text-gray-700">Employee ID</label>
                    <input type="number" name="employee_id"
                        class="w-full p-2 mt-2 border border-gray-300 rounded-md form-control" id="employee_id" required
                        value="{{ $employee->id }}">
                </div>
                <div class="mb-4 form-group">
                    <label for="group_code_id" class="block font-medium text-gray-700">Transaction Name</label>

                    <select name="group_code_id" id="trx_name"
                        class="w-full p-2 border border-gray-300 rounded-md form-control">
                        <option value="" disabled selected>Select a Transaction</option>
                        @foreach ($trx as $transaction)
                            <option value="{{ $transaction->id }}">{{ $transaction->description }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="mb-4 form-group">
                    <label for="date" class="block font-medium text-gray-700">Date</label>
                    <input type="date" name="date"
                        class="w-full p-2 mt-2 border border-gray-300 rounded-md form-control" id="date">
                </div>
                <div class="mb-4 form-group">
                    <label for="description" class="block font-medium text-gray-700">Reference</label>
                    <input type="text" name="description"
                        class="w-full p-2 mt-2 border border-gray-300 rounded-md form-control" id="reference">
                </div>

            </div>
            <button type="submit"
                class="w-full px-4 py-2 mt-4 text-white bg-blue-500 rounded-md btn btn-primary">Save</button>
            <button type="button" onclick="closeModal('openModal_others')"
                class="w-full px-4 py-2 mt-4 text-white bg-gray-500 rounded-md btn btn-secondary">Cancel</button>
        </form>
    </div>
</div>
<script>
    // Handle the form submission via AJAX
    $('#trxothersForm').submit(function(e) {
        e.preventDefault(); // Prevent the default form submission

        var formData = new FormData(this); // Gather form data

        $.ajax({
            url: $(this).attr('action'),
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                // Close the modal
                closeModal('openModal_others');

                // Optionally, show a success message
                alert('TrxLoan Added Successfully!');

                // Refresh the DataTable to show the new record
                $('#others-table').DataTable().ajax.reload();
            },
            error: function(xhr, status, error) {
                // Handle error (e.g., show an error message)
                alert('Error: ' + xhr.responseText);
            }
        });
    });
</script>
<script>
    $(document).ready(function() {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        // Delete button click handler
        $(document).on('click', '.delete-btn', function() {
            const deleteUrl = $(this).data('url');
            const loanId = $(this).data('id');

            // Open the modal
            $('#deleteModal').removeClass('hidden');

            // Confirm delete
            $('#confirmDelete').on('click', function() {
                $.ajax({
                    url: deleteUrl,
                    type: 'DELETE',
                    success: function(response) {
                        // Close the modal
                        $('#deleteModal').addClass('hidden');

                        // Reload the DataTable (refreshes the table after deletion)
                        $('#others-table').DataTable().ajax.reload();
                    },
                    error: function(xhr, status, error) {
                        alert('An error occurred while deleting the loan.');
                    }
                });
            });

            // Cancel delete action
            $('#cancelDelete').on('click', function() {
                $('#deleteModal').addClass('hidden');
            });
        });
    });
</script>

<div id="deleteModal" class="fixed inset-0 flex items-start justify-center hidden bg-black bg-opacity-50 z-[100]">
    <div class="w-full max-w-md p-6 mt-20 transition-all transform scale-95 bg-white rounded-lg shadow-lg ">
        <h2 class="mb-6 text-lg font-semibold text-gray-700">Are you sure you want to delete this loan?</h2>
        <div class="flex justify-end space-x-4">
            <button id="cancelDelete" class="px-4 py-2 text-white bg-gray-400 rounded-md">Cancel</button>
            <button id="confirmDelete" class="px-4 py-2 text-white bg-red-600 rounded-md">Delete</button>
        </div>
    </div>
</div>

<!-- Success Modal -->
<div id="successModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-500 bg-opacity-75">
    <div class="w-1/3 p-6 mt-20 bg-white rounded-lg shadow-lg">
        <h2 class="text-xl font-semibold text-green-600">Success</h2>
        <p id="successMessage" class="mt-4 text-gray-700">The operation was successful!</p>
        <div class="flex justify-end mt-4">
            <button onclick="closeSuccessModal()"
                class="px-4 py-2 text-white bg-blue-600 rounded-md btn btn-primary">Close</button>
        </div>
    </div>
</div>
<script>
    // Function to open the success modal
    function openSuccessModal(message) {
        // Set the success message dynamically
        document.getElementById("successMessage").innerText = message;

        // Show the modal by removing the 'hidden' class and adding 'flex' class
        document.getElementById("successModal").classList.remove("hidden");
        document.getElementById("successModal").classList.add("flex");
    }

    // Function to close the success modal
    function closeSuccessModal() {
        document.getElementById("successModal").classList.add("hidden");
        document.getElementById("successModal").classList.remove("flex");
    }
</script>
