<div id="div2" class="">

    <div class="flex flex-col items-center justify-center gap-6 mt-6 text-sm md:flex-row">

        <button class="px-6 py-3 text-sm text-white transition duration-300 bg-gray-800 rounded w-60 hover:bg-gray-900"
            onclick="toggleDiv('personal')">
            Personal Details
        </button>

        <button class="px-6 py-3 text-sm text-white transition duration-300 bg-gray-800 rounded w-60 hover:bg-gray-900"
            onclick="toggleDiv('payroll')">
            Payroll
        </button>

        <button class="px-6 py-3 text-sm text-white transition duration-300 bg-gray-800 rounded w-60 hover:bg-gray-900"
            onclick="toggleDiv('others')">
            Others
        </button>
    </div>




    <script>
        function toggleDiv(divId) {
            // List of all div IDs
            const divs = ['personal', 'payroll', 'others'];

            // Loop through each div to hide it
            divs.forEach(id => {
                const div = document.getElementById(id);
                if (div) {
                    // Hide the div if it's not the one we want to show
                    if (id !== divId) {
                        div.classList.add('hidden');
                    }
                }
            });

            // Show the selected div
            const selectedDiv = document.getElementById(divId);
            if (selectedDiv) {
                selectedDiv.classList.toggle('hidden');
            } else {
                console.error(`Div with id ${divId} not found.`);
            }
        }
    </script>
    @php
        $roleId = Auth::user()?->role_id;
    @endphp

    @if ($roleId != 8 && $roleId != 9)
        <form action="{{ route('employees.update', $employee->id) }}" enctype="multipart/form-data" class=""
            method="POST">
            @csrf
            @method('PUT')
            <input type="text" hidden name="status" value="1">
            <div id="personal" class="">
                @include('Admin.Employee.info.personal')
            </div>
            <div id="others" class="hidden">
                @include('Admin.Employee.info.others')
            </div>
            <div id="payroll" class="hidden">
                @include('Admin.Employee.info.payroll')
            </div>
            <div class="flex items-center justify-center mb-10 rounded-xl">
                <button type="submit" class="p-2 text-white bg-blue-500 rounded lg:w-[40rem]">Submit</button>
            </div>

        </form>
    @else
        <div id="personal" class="">
            @include('Admin.Employee.clientside.personal')
        </div>
        <div id="others" class="hidden">
            @include('Admin.Employee.clientside.others')
        </div>
        <div id="payroll" class="hidden">
            @include('Admin.Employee.clientside.payroll')
        </div>
    @endif
