<div class="grid grid-cols-1 gap-4 md:grid-cols-4">
    <div>
        <form id="schedform"
            class="max-w-md p-6 mx-auto overflow-auto bg-white  bg-gray-100 rounded-lg shadow-md border border-gray-300">
            <div class="flex justify-between items-center">
                <h2 class="mb-4 font-semibold">Employee Schedules</h2>
            </div>
            <div id="loading-overlay" class="flex items-center justify-center hidden mt-4 mb-4">
                <div
                    class="inline-block w-12 h-12 border-4 border-blue-600 rounded-full spinner-border animate-spin border-t-transparent">
                </div>
                <p class="ml-3 text-gray-700">Processing...</p>
            </div>
            <label class="block mt-4 mb-2 text-gray-700">Employee</label>
            <select id="employee_select" name="employee_id" required
                class="w-full p-2 border border-gray-300 rounded focus:ring focus:ring-blue-300">
                <option value="">Select Employee</option>
                </option>
                @foreach ($employee as $employee)
                    <option value="{{ $employee->id }}">{{ $employee->first_name }} - {{ $employee->last_name }}
                    </option>
                @endforeach
            </select>


            <script>
                $(document).ready(function() {
                    $('#employee_select').select2({
                        placeholder: "Select Employee",
                        allowClear: true
                    });
                });
            </script>
            <label class="block mt-4 mb-2 text-gray-700">Shift</label>
            <select name="shift_id" required
                class="w-full p-2 border border-gray-300 rounded focus:ring focus:ring-blue-300 text-nowrap select2_shift">
                <option value="">Select Shift</option>
                @foreach ($shift as $shift)
                    <!-- Convert 24-hour format to 12-hour with AM/PM -->
                    @php
                        $shiftStart = \Carbon\Carbon::parse($shift->shift_start)->format('g:i A');
                        $shiftEnd = \Carbon\Carbon::parse($shift->shift_end)->format('g:i A');
                        $breakOut = \Carbon\Carbon::parse($shift->break_out)->format('g:i A');
                        $breakIn = \Carbon\Carbon::parse($shift->break_in)->format('g:i A');
                    @endphp
                    <option value="{{ $shift->id }}">
                        {{ $shift->shift_name }} (IN: {{ $shiftStart }} - OUT: {{ $shiftEnd }})
                        (Break: {{ $breakOut }} - {{ $breakIn }})
                    </option>
                @endforeach
            </select>
            @include('Admin.Employee.shedule.css')
            <script>
                $(document).ready(function() {
                    // Initialize select2 on the select element
                    $('.select2_shift').select2({
                        placeholder: "Select a Shift", // Placeholder text
                        allowClear: true
                    });
                });
            </script>
            <!-- Shift Start -->
            <label class="block mt-4 mb-2 text-gray-700">Start Date</label>
            <input type="date" name="start_date" required
                class="w-full p-2 border border-gray-300 rounded focus:ring focus:ring-blue-300" />

            <!-- Shift End -->
            <label class="block mt-4 mb-2 text-gray-700">End Date</label>
            <input type="date" name="end_date" required
                class="w-full p-2 border border-gray-300 rounded focus:ring focus:ring-blue-300" />

            <button type="submit"
                class="w-full py-2 mt-6 text-white transition bg-blue-500 rounded-lg hover:bg-blue-600">
                Submit
            </button>

            <!-- Message Display -->
            <p id="message" class="mt-4 text-sm text-center"></p>

            <div id="error-container" class="mt-4 text-sm text-red-500"></div>
        </form>

    </div>
    <div class="w-full col-span-3 overflow-auto bg-white p-6 bg-gray-100 rounded-lg shadow-md border border-gray-300">
        <div class="mb-4 flex justify-end items-center">
            <label for="statusFilter" class="mr-2 font-semibold">Filter by Status:</label>
            <select id="statusFilter" class="px-3 py-2 border rounded-lg">
                <option value="">All</option>
                <option value="Approved">Approved</option>
                <option value="Pending">Pending</option>
            </select>
        </div>
        <div class="overflow-x-auto">
            <table id="schedTable" class="min-w-full border border-collapse border-gray-200 table-auto">
                <thead class="bg-[#1d1d1d] text-white">
                    <tr>
                        <th class="px-4 py-2 border">Approve</th>
                        <th class="px-4 py-2 border">Employee</th>
                        <th class="px-4 py-2 border">Shift</th>
                        <th class="px-4 py-2 border">Break</th>
                        <th class="px-4 py-2 border">Start Date</th>
                        <th class="px-4 py-2 border">End Date</th>
                        <th class="px-4 py-2 border">status</th>
                        <th class="px-4 py-2 border">Action</th>
                    </tr>
                </thead>
                <tbody class="text-center"></tbody>
            </table>
        </div>
    </div>




    <script>
        $(document).ready(function() {
            var departmentTable = $('#schedTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('employeesched') }}",
                columns: [{
                        data: 'approve',
                        name: 'approve',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'employee_name',
                        name: 'employee_name'
                    },
                    {
                        data: 'time',
                        name: 'time'
                    },
                    {
                        data: 'break',
                        name: 'break'
                    },
                    {
                        data: 'start_date',
                        name: 'start_date'
                    },
                    {
                        data: 'end_date',
                        name: 'end_date'
                    },
                    {
                        data: 'status',
                        name: 'status'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ],
                order: [
                    [0, 'desc']
                ]
            });

            // Status filter event
            $('#statusFilter').on('change', function() {
                let val = $(this).val();

                if (val === "Pending") {
                    // Show null or pending
                    departmentTable.column(6).search("Pending|NULL", true, false).draw();
                } else {
                    departmentTable.column(6).search(val).draw();
                }
            });
        });
    </script>

    <div id="successModalsched"
        class="fixed inset-0 z-50 flex items-center justify-center hidden bg-black bg-opacity-50">
        <div class="p-5 bg-white rounded-lg shadow-lg w-96">
            <h2 class="text-lg font-bold text-center">Success</h2>
            <p class="mt-2 text-center text-gray-700">Added successfully!</p>
            <div class="mt-4 text-center">
                <button onclick="closeModal('successModalsched')"
                    class="px-4 py-2 text-white bg-blue-500 rounded-lg hover:bg-blue-700">
                    OK
                </button>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            $('#schedform').on('submit', function(e) {
                e.preventDefault(); // Prevent default form submission

                var formData = $(this).serialize(); // Serialize form data
                var errorContainer = $("#error-container");
                var loadingOverlay = $("#loading-overlay");

                // Clear previous messages
                errorContainer.html("");
                loadingOverlay.removeClass("hidden"); // Show loading

                $.ajax({
                    url: "{{ route('work-schedule.store') }}", // Ensure Laravel parses this route correctly
                    type: "POST",
                    data: formData,
                    headers: {
                        "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr(
                            "content") // CSRF protection
                    },
                    success: function(response) {
                        if (response.success) {
                            $('#successModalsched').removeClass('hidden'); // Show success modal
                            $('#schedform')[0].reset(); // Reset form
                            $('#schedTable').DataTable().ajax.reload(null,
                                false); // Reload DataTable if exists
                        }
                        loadingOverlay.addClass("hidden"); // Hide loading
                    },
                    error: function(xhr) {
                        loadingOverlay.addClass("hidden"); // Hide loading

                        if (xhr.status === 422) { // Laravel validation error
                            let errors = xhr.responseJSON.errors;
                            let errorMessages = Object.values(errors).map(err =>
                                `<p>${err[0]}</p>`).join("");
                            errorContainer.html(errorMessages);
                        } else {
                            alert('Error occurred! Please try again.');
                        }
                    }




                });
            });

            // Close Success Modal
            $("#closeModal").on("click", function() {
                $("#successModalsched").addClass("hidden");
            });
        });
    </script>

    <div id="deleteschedModal"
        class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
        <div class="bg-white rounded-lg shadow-lg p-6 w-auto md:w-[30rem] mt-20">
            <h2 class="mb-4 text-lg font-bold">Delete Record</h2>
            <p>Are you sure you want to delete this record?</p>
            <form id="deleteschedForm">
                @csrf
                <input type="hidden" id="deleteRecordId" name="id">
                <div class="flex justify-end mt-6">
                    <button type="button" onclick="closeModal('deleteschedModal')"
                        class="px-4 py-2 mr-2 text-gray-700 bg-gray-200 rounded">Cancel</button>
                    <button type="submit" class="px-4 py-2 text-white bg-red-600 rounded">Delete</button>
                </div>
            </form>
        </div>
    </div>



    <script>
        $(document).ready(function() {
            // Open Delete Modal
            window.openDeleteModalsched = function(recordId) {
                $('#deleteRecordId').val(recordId);
                $('#deleteschedModal').removeClass('hidden');
            };

            // Submit Delete Form
            $('#deleteschedForm').on('submit', function(e) {
                e.preventDefault();
                let recordId = $('#deleteRecordId').val();
                let deleteUrl = "{{ route('work-schedule.destroy', ':id') }}".replace(':id', recordId);

                $.ajax({
                    url: deleteUrl,
                    type: "DELETE",
                    data: {
                        _token: "{{ csrf_token() }}"
                    },
                    success: function(response) {
                        if (response.success) {
                            $('#successModalsched').removeClass('hidden'); // Show success modal
                            $('#deleteschedForm')[0].reset(); // Reset form
                            $('#deleteschedModal').addClass('hidden'); // Close modal
                            $('#schedTable').DataTable().ajax.reload(null,
                                false); // Reload table without resetting pagination
                        }
                    },
                    error: function(xhr) {
                        alert('Error deleting record.');
                    }
                });
            });

            // Close Modal Function
            window.closeModal = function(modalId) {
                $('#' + modalId).addClass('hidden');
            };

        });
    </script>
    <div id="approveModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
        <div class="p-6 mt-10 bg-white rounded-lg shadow-lg w-96">
            <h2 class="mb-4 text-lg font-semibold">Confirm Approval</h2>
            <p>Are you sure you want to approve this schedule?</p>
            <input type="hidden" id="approveScheduleId">
            <div class="flex justify-end mt-4">
                <button onclick="closeModal('approveModal')"
                    class="px-4 py-2 text-white bg-gray-500 rounded-md">Cancel</button>
                <button onclick="confirmApprove()"
                    class="px-4 py-2 ml-2 text-white bg-green-600 rounded-md">Approve</button>
            </div>
        </div>
    </div>

    <script>
        let scheduleIdToApprove = null;

        function openApproveModal(id) {
            scheduleIdToApprove = id;
            document.getElementById("approveModal").classList.remove("hidden");
            document.getElementById("approveScheduleId").value = id;
        }

        function confirmApprove() {
            let id = scheduleIdToApprove;
            $.ajax({
                url: "{{ route('schedule.approve') }}", // Named route
                type: "POST",
                data: {
                    id: id,
                    _token: "{{ csrf_token() }}"
                },
                success: function(response) {
                    $('#successModalsched').removeClass('hidden'); // Show success modal
                    $('#approveModal').addClass('hidden'); // Close modal
                    $('#schedTable').DataTable().ajax.reload(null,
                        false); // Reload table without resetting pagination
                },
                error: function(response) {
                    alert("Error approving schedule");
                }
            });
        }
    </script>




</div>
