@extends('layouts.sidebar')

@section('title', 'Employee')
@section('content')
    <div class="flex items-end justify-end pb-2 md:flex-row">
        <div class="flex justify-between items-center gap-6 mb-6">
            <!-- Import Button -->
            <button onclick="openImportModal()"
                class="w-[20rem] bg-indigo-600 hover:bg-indigo-700 text-white font-semibold px-5 py-2.5 rounded-lg shadow-md transition">
                Import Schedules
            </button>

            <!-- Navigation Buttons -->
            <div class="flex space-x-3">
                <!-- Shift List Button -->
                <button id="shiftListBtn" onclick="showDiv('div1')"
                    class="w-[20rem] px-5 py-2.5 font-semibold text-gray-700 bg-gray-100 rounded-lg shadow-md hover:bg-gray-200 transition">
                    Shift List
                </button>

                <!-- Employee Schedules Button -->
                <button id="employeeScheduleBtn" onclick="showDiv('div2')"
                    class="w-[20rem] px-5 py-2.5 font-semibold text-gray-700 bg-gray-100 rounded-lg shadow-md hover:bg-gray-200 transition">
                    Next → Employee Schedules
                </button>
            </div>
        </div>


        <script>
            function showDiv(divId) {
                let div1 = document.getElementById("div1");
                let div2 = document.getElementById("div2");
                let shiftBtn = document.getElementById("shiftListBtn");
                let scheduleBtn = document.getElementById("employeeScheduleBtn");

                if (divId === "div1") {
                    div1.classList.remove("hidden");
                    div2.classList.add("hidden");

                    // Active button styling
                    shiftBtn.classList.add("bg-indigo-600", "text-white");
                    shiftBtn.classList.remove("bg-gray-100", "text-gray-700");

                    scheduleBtn.classList.add("bg-gray-100", "text-gray-700");
                    scheduleBtn.classList.remove("bg-indigo-600", "text-white");
                } else {
                    div2.classList.remove("hidden");
                    div1.classList.add("hidden");

                    // Active button styling
                    scheduleBtn.classList.add("bg-indigo-600", "text-white");
                    scheduleBtn.classList.remove("bg-gray-100", "text-gray-700");

                    shiftBtn.classList.add("bg-gray-100", "text-gray-700");
                    shiftBtn.classList.remove("bg-indigo-600", "text-white");
                }
            }

            // Default active (Shift List shown first)
            showDiv('div1');
        </script>
    </div>

    <div id="importModal" class="hidden fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 z-50">
        <div class="bg-white rounded-xl shadow-lg w-full max-w-lg">
            <div class="flex justify-between items-center bg-blue-600 text-white px-4 py-2 rounded-t-xl">
                <h5 class="text-lg font-bold">Import Work Schedules</h5>
                <button onclick="closeImportModal()" class="text-white hover:text-gray-200">&times;</button>
            </div>

            <form id="importForm" enctype="multipart/form-data" class="p-6 space-y-4">
                @csrf
                <div>
                    <label class="block text-sm font-medium text-gray-700">Start Date</label>
                    <input type="date" name="start_date" required
                        class="mt-1 block w-full rounded-lg border-gray-300 shadow-sm focus:ring-blue-500 focus:border-blue-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">End Date</label>
                    <input type="date" name="end_date"
                        class="mt-1 block w-full rounded-lg border-gray-300 shadow-sm focus:ring-blue-500 focus:border-blue-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">Excel File</label>
                    <input type="file" name="file" required
                        class="mt-1 block w-full text-gray-700 border border-gray-300 rounded-lg cursor-pointer bg-gray-50 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
                </div>

                <div class="flex justify-end space-x-2 pt-4 border-t">
                    <button type="button" onclick="closeImportModal()"
                        class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg">Cancel</button>
                    <button type="submit" id="importBtn"
                        class="bg-blue-600 hover:bg-blue-700 text-white font-medium px-4 py-2 rounded-lg shadow flex items-center justify-center space-x-2">
                        <span id="importBtnText">Import</span>
                        <svg id="importBtnSpinner" class="w-5 h-5 text-white animate-spin hidden"
                            xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor"
                                stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v8z"></path>
                        </svg>
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Failed Rows Modal -->
    <div id="importResultsModal" class="hidden fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 z-50">
        <div class="bg-white rounded-xl shadow-lg w-full max-w-6xl h-[50rem] overflow-auto">
            <div class="flex justify-between items-center bg-blue-600 text-white px-4 py-2 rounded-t-xl">
                <h5 class="text-lg font-bold">Import Results</h5>
                <button onclick="closeImportResultsModal()" class="text-white hover:text-gray-200">&times;</button>
            </div>
            <div class="p-6 overflow-auto max-h-[70vh]">
                <table id="importResultsTable" class="w-full border border-gray-300 text-sm text-left">
                    <thead class="bg-gray-100">
                        <tr></tr>
                    </thead>
                    <tbody id="importResultsBody"></tbody>
                </table>
            </div>
            <div class="flex justify-end space-x-2 p-4 border-t">
                <button type="button" onclick="closeImportResultsModal()"
                    class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg">Close</button>
            </div>
        </div>
    </div>
    <script>
        function openImportModal() {
            document.getElementById('importModal').classList.remove('hidden');
        }

        function closeImportModal() {
            document.getElementById('importModal').classList.add('hidden');
        }

        function closeImportResultsModal() {
            document.getElementById('importResultsModal').classList.add('hidden');
        }

        function openImportResultsModal(rows) {
            let tbody = document.getElementById('importResultsBody');
            let thead = document.querySelector('#importResultsTable thead tr');

            thead.innerHTML = '';
            tbody.innerHTML = '';

            if (rows.length === 0) return;

            // 🔹 Build headers dynamically based on Excel columns
            let keys = Object.keys(rows[0].row);
            thead.innerHTML = `<th class="border px-3 py-2">Remarks</th>` +
                keys.map(k => `<th class="border px-3 py-2">${k}</th>`).join('');

            // 🔹 Build rows with remarks + Excel-like data
            rows.forEach(r => {
                let remarkClass = "text-gray-600";
                if (r.remark.includes("✅")) remarkClass = "text-green-600 font-semibold";
                if (r.remark.includes("❌")) remarkClass = "text-red-600 font-semibold";
                if (r.remark.includes("⚠️")) remarkClass = "text-yellow-600 font-semibold";

                let rowHtml = `<td class="border px-3 py-2 ${remarkClass}">${r.remark}</td>`;
                keys.forEach(k => {
                    rowHtml += `<td class="border px-3 py-2">${r.row[k] ?? ''}</td>`;
                });
                tbody.innerHTML += `<tr>${rowHtml}</tr>`;
            });

            document.getElementById('importResultsModal').classList.remove('hidden');
        }

        const importForm = document.getElementById('importForm');
        const importBtn = document.getElementById('importBtn');
        const importBtnText = document.getElementById('importBtnText');
        const importBtnSpinner = document.getElementById('importBtnSpinner');

        importForm.addEventListener('submit', function(e) {
            e.preventDefault();
            importBtnText.classList.add('hidden');
            importBtnSpinner.classList.remove('hidden');
            importBtn.disabled = true;

            let formData = new FormData(this);

            axios.post("{{ route('schedules.import') }}", formData, {
                    headers: {
                        'Content-Type': 'multipart/form-data'
                    }
                })
                .then(response => {
                    closeImportModal();
                    if (response.data.rows) {
                        openImportResultsModal(response.data.rows);
                        $('#shiftTable').DataTable().ajax.reload();
                    }
                })
                .catch(() => {
                    closeImportModal();
                    alert("Import failed. Please try again.");
                })
                .finally(() => {
                    importBtnText.classList.remove('hidden');
                    importBtnSpinner.classList.add('hidden');
                    importBtn.disabled = false;
                });
        });
    </script>

    <div id="div1" class="">
        <div class="grid grid-cols-1 gap-4 md:grid-cols-4">
            <div>
                <form id="shiftForm"
                    class="max-w-md p-6 mx-auto overflow-auto bg-white  bg-gray-100 rounded-lg shadow-md border border-gray-300">
                    <h2 class="mb-4 text-xl font-semibold">Shift list</h2>
                    <div id="loading-overlay" class="flex items-center justify-center hidden mt-4 mb-4">
                        <div
                            class="inline-block w-12 h-12 border-4 border-blue-600 rounded-full spinner-border animate-spin border-t-transparent">
                        </div>
                        <p class="ml-3 text-gray-700">Processing...</p>
                    </div>
                    <!-- Shift Name -->
                    <label class="block mb-2 text-gray-700">Shift Name</label>
                    <input type="text" name="shift_name" required
                        class="w-full p-2 border border-gray-300 rounded focus:ring focus:ring-blue-300" />

                    <!-- Shift Start -->
                    <label class="block mt-4 mb-2 text-gray-700">Shift Start</label>
                    <input type="time" name="shift_start" required
                        class="w-full p-2 border border-gray-300 rounded focus:ring focus:ring-blue-300" />

                    <!-- Shift End -->
                    <label class="block mt-4 mb-2 text-gray-700">Shift End</label>
                    <input type="time" name="shift_end" required
                        class="w-full p-2 border border-gray-300 rounded focus:ring focus:ring-blue-300" />


                    <label class="block mt-4 mb-2 text-gray-700">Break Out</label>
                    <input type="time" name="break_out" required
                        class="w-full p-2 border border-gray-300 rounded focus:ring focus:ring-blue-300" />

                    <label class="block mt-4 mb-2 text-gray-700">Break In</label>
                    <input type="time" name="break_in" required
                        class="w-full p-2 border border-gray-300 rounded focus:ring focus:ring-blue-300" />

                    <!-- Status -->
                    <label class="block mt-4 mb-2 text-gray-700">Status</label>
                    <select name="status" required
                        class="w-full p-2 border border-gray-300 rounded focus:ring focus:ring-blue-300">
                        <option value="day">Day Shift</option>
                        <option value="night">Night Shift</option>
                    </select>


                    <!-- Submit Button -->
                    <button type="submit"
                        class="w-full py-2 mt-6 text-white transition bg-blue-500 rounded-lg hover:bg-blue-600">
                        Submit
                    </button>

                    <!-- Message Display -->
                    <p id="message" class="mt-4 text-sm text-center"></p>

                    <!-- Loading Overlay -->


                    <!-- Error Container -->
                    <div id="error-container" class="mt-4 text-sm text-red-500"></div>
                </form>

            </div>
            <div
                class="w-full col-span-3 p-6 mx-auto overflow-auto bg-white  bg-gray-100 rounded-lg shadow-md border border-gray-300">
                <div class="overflow-x-auto">
                    <table id="shiftTable" class="min-w-full border border-collapse border-gray-200 table-auto">
                        <thead class="bg-[#1d1d1d] text-white">
                            <tr>
                                <th class="px-4 py-2 border">ID</th>
                                <th class="px-4 py-2 border">Shift Name</th>
                                <th class="px-4 py-2 border">Shift Start</th>
                                <th class="px-4 py-2 border">Shift End</th>
                                <th class="px-4 py-2 border">Break Out</th>
                                <th class="px-4 py-2 border">Break In</th>
                                <th class="px-4 py-2 border">Status</th>
                                <th class="px-4 py-2 border">Action</th>
                            </tr>
                        </thead>
                        <tbody class="text-center"></tbody>
                    </table>
                </div>



            </div>

        </div>
    </div>
    <script>
        $(document).ready(function() {
            $('#shiftTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('shifts.index') }}",
                columns: [{
                        data: 'id',
                        name: 'id'
                    },
                    {
                        data: 'shift_name',
                        name: 'shift_name'
                    },
                    {
                        data: 'shift_start',
                        name: 'shift_start'
                    },
                    {
                        data: 'shift_end',
                        name: 'shift_end'
                    },
                    {
                        data: 'break_out',
                        name: 'break_out'
                    },
                    {
                        data: 'break_in',
                        name: 'break_in'
                    },
                    {
                        data: 'status',
                        name: 'status'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false,
                        width: '10%'
                    }
                ]
            });
        });
    </script>

    <div id="div2" class="hidden">
        @include('Admin.Employee.shedule.pendingschedule')
    </div>

    <div id="editShiftModal" class="hidden fixed inset-0 flex items-center justify-center bg-black bg-opacity-50 z-50">
        <div class="bg-white rounded-xl shadow-lg w-full max-w-md">
            <div class="flex justify-between items-center bg-blue-600 text-white px-4 py-2 rounded-t-xl">
                <h5 class="text-lg font-bold">Edit Shift</h5>
                <button onclick="closeEditModal()" class="text-white hover:text-gray-200">&times;</button>
            </div>
            <form id="editShiftForm" class="p-6 space-y-4">
                @csrf
                <input type="hidden" name="_method" value="PUT">
                <input type="hidden" name="id" id="editShiftId">

                <div>
                    <label class="block text-sm font-medium text-gray-700">Shift Name</label>
                    <input type="text" name="shift_name" id="editShiftName"
                        class="mt-1 block w-full rounded-lg border border-gray-400 shadow-sm focus:ring-blue-500 focus:border-blue-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">Shift Start</label>
                    <input type="time" name="shift_start" id="editShiftStart"
                        class="mt-1 block w-full rounded-lg border border-gray-400 shadow-sm focus:ring-blue-500 focus:border-blue-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">Shift End</label>
                    <input type="time" name="shift_end" id="editShiftEnd"
                        class="mt-1 block w-full rounded-lg border border-gray-400 shadow-sm focus:ring-blue-500 focus:border-blue-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">Break Out</label>
                    <input type="time" name="break_out" id="editBreakOut"
                        class="mt-1 block w-full rounded-lg border border-gray-400 shadow-sm focus:ring-blue-500 focus:border-blue-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">Break In</label>
                    <input type="time" name="break_in" id="editBreakIn"
                        class="mt-1 block w-full rounded-lg border border-gray-400 shadow-sm focus:ring-blue-500 focus:border-blue-500">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700">Status</label>
                    <select name="status" id="editStatus"
                        class="mt-1 block w-full rounded-lg border border-gray-400 shadow-sm focus:ring-blue-500 focus:border-blue-500">
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                    </select>
                </div>

                <div class="flex justify-end space-x-2 pt-4 border-t">
                    <button type="button" onclick="closeEditModal()"
                        class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded-lg">Cancel</button>
                    <button type="submit"
                        class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg">Update</button>
                </div>
            </form>

        </div>
    </div>
    <script>
        function openEditModal(id) {
            // Fetch shift data using named route
            axios.get("{{ route('shifts.show', ['shift' => 'SHIFT_ID']) }}".replace('SHIFT_ID', id))
                .then(res => {
                    let shift = res.data;
                    document.getElementById('editShiftId').value = shift.id;
                    document.getElementById('editShiftName').value = shift.shift_name;
                    document.getElementById('editShiftStart').value = shift.shift_start;
                    document.getElementById('editShiftEnd').value = shift.shift_end;
                    document.getElementById('editBreakOut').value = shift.break_out;
                    document.getElementById('editBreakIn').value = shift.break_in;
                    document.getElementById('editStatus').value = shift.status;

                    document.getElementById('editShiftModal').classList.remove('hidden');
                });
        }

        function closeEditModal() {
            document.getElementById('editShiftModal').classList.add('hidden');
        }

        // Handle form submission
        document.getElementById('editShiftForm').addEventListener('submit', function(e) {
            e.preventDefault();

            let id = document.getElementById('editShiftId').value;
            let formData = new FormData(this);

            axios.post(
                    "{{ route('shifts.update', ['shift' => 'SHIFT_ID']) }}".replace('SHIFT_ID', id),
                    formData
                )
                .then(res => {
                    $('#shiftTable').DataTable().ajax.reload();
                    closeEditModal();
                })
                .catch(err => {
                    alert('Update failed.');
                });
        });
    </script>

    @include('Admin.Employee.shedule.modal')

@endsection
