<script type="text/javascript">
    $(document).ready(function() {
        let selectedEmployeeIds = [];
        let selectedEmployees = {};

        const employedTable = $('#employed-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('wage.customeemployeelist') }}",
                data: function(d) {
                    d.status = '1';
                    d.office_id = $('#office_id').val();
                    d.store_id = $('#store_id').val();
                    d.pwd_filter = $('#pwd_filter').val();
                }
            },
            columns: [{
                    data: 'id',
                    name: 'id',
                    width: '5%'
                },
                {
                    data: 'agency',
                    name: 'agency',
                    width: '10%'
                },
                {
                    data: 'company',
                    name: 'company',
                    width: '10%'
                },
                {
                    data: 'client',
                    name: 'client',
                    width: '10%'
                },
                {
                    data: 'rate_name',
                    name: 'rate_name',
                    width: '10%'
                },
                {
                    data: 'rate',
                    name: 'rate',
                    width: '10%'
                },
                {
                    data: 'employee_name',
                    name: 'employee_name',
                    width: '10%'
                },

                {
                    data: 'status',
                    name: 'status',
                    width: '10%'
                },
            ],
            order: [
                [0, 'desc']
            ],
            createdRow: function(row, data) {
                $(row).attr('data-id', data.id);
                $(row).attr('data-name', data.employee_name);
                $(row).addClass('clickable-row');
            }
        });

        $('#office_id, #store_id, #pwd_filter').on('change', function() {
            employedTable.ajax.reload();
        });

        // Handle click on rows to select/deselect employees
        $('#employed-table tbody').on('click', '.clickable-row', function() {
            const $row = $(this);
            const employeeId = parseInt($row.data('id'));
            const employeeName = $row.data('name');

            const index = selectedEmployeeIds.indexOf(employeeId);

            if (index > -1) {
                selectedEmployeeIds.splice(index, 1);
                delete selectedEmployees[employeeId];
                $row.removeClass('selected-row');
            } else {
                selectedEmployeeIds.push(employeeId);
                selectedEmployees[employeeId] = employeeName;
                $row.addClass('selected-row');
            }

            renderSelectedEmployees();
        });

        // Function to re-render selected employee inputs
        function renderSelectedEmployees() {
            const container = $('#selected-employees-inputs');
            container.empty();

            selectedEmployeeIds.forEach(id => {
                const rowId = `employee-id-${id}`;
                container.append(`
                    <div id="${rowId}" class="flex items-center justify-between px-2 py-1 text-sm bg-gray-100 border rounded mb-1">
                        <input type="hidden" name="assignemployee_id[]" value="${id}">
                        <span>🆔 ${id} — ${selectedEmployees[id]}</span>
                        <button type="button" class="text-red-600 remove-employee" data-id="${id}">✖ Remove</button>
                    </div>
                `);
            });
        }

        // Handle "✖ Remove" button clicks
        $('#selected-employees-inputs').on('click', '.remove-employee', function() {
            const idToRemove = parseInt($(this).data('id'));

            selectedEmployeeIds = selectedEmployeeIds.filter(id => id !== idToRemove);
            delete selectedEmployees[idToRemove];

            $(`#employee-id-${idToRemove}`).remove();
            $(`#employed-table tbody tr[data-id="${idToRemove}"]`).removeClass('selected-row');
        });

        // FORM SUBMISSION
        let isSubmitting = false;

        $('#wage-assignment-form').on('submit', function(e) {
            e.preventDefault();
            if (isSubmitting) return;

            if (selectedEmployeeIds.length === 0) {
                $('#form-feedback')
                    .removeClass('hidden text-green-600')
                    .addClass('text-red-600')
                    .text('⚠️ Please select at least one employee.');
                return;
            }

            isSubmitting = true;

            const formData = $(this).serialize();

            const $feedback = $('#form-feedback');
            const $submitBtn = $(this).find('button[type="submit"]');

            $submitBtn.prop('disabled', true).text('Saving...');

            $.ajax({
                url: "{{ route('store.employeenewwage') }}",
                method: 'POST',
                data: formData,
                success: function(response) {
                    $feedback
                        .removeClass('hidden text-red-600')
                        .addClass('text-green-600')
                        .text('✅ ' + response.message);

                    $('#type').val('');
                    $('#selected-employees-inputs').empty();
                    selectedEmployeeIds = [];
                    selectedEmployees = {};
                    $('#employed-table tbody tr').removeClass('selected-row');
                    $('#employee-wage').DataTable().ajax.reload(null, false);

                },
                error: function(xhr) {
                    let message = '❌ Failed to save benefit.';
                    if (xhr.status === 422 && xhr.responseJSON?.message) {
                        message = `⚠️ ${xhr.responseJSON.message}`;
                    }

                    $feedback
                        .removeClass('hidden text-green-600')
                        .addClass('text-red-600')
                        .text(message);
                },
                complete: function() {
                    isSubmitting = false;
                    $submitBtn.prop('disabled', false).html('💾 Save Benefit');
                }
            });
        });
    });
</script>
