@extends('layouts.sidebar')

@section('title', 'Wage Adjustment')
@section('content')
    @if (in_array('Regional wage rates', $privileges) || in_array('wage management', $privileges))
        <div class="flex flex-col justify-between py-5 md:flex-row">
            <h1 class="mb-4 font-bold">Regional Wage Rates</h1>

        </div>
        <div class="grid grid-cols-1 lg:grid-cols-5 gap-6 p-6 bg-gray-100 rounded-lg shadow-md border border-gray-300">
            <!-- Minimum Wage Form -->
            <div class="lg:col-span-1 bg-white p-6 rounded-lg shadow border">
                <h2 class="text-lg font-bold mb-4 text-gray-700">Add Minimum Wage</h2>
                <form id="minimumWageForm">
                    <div class="mb-4">
                        <label for="regionSelect" class="block text-sm font-semibold mb-1">Region</label>
                        <select id="regionSelect"
                            class="border border-gray-300 p-2 rounded w-full focus:ring-2 focus:ring-blue-500">
                            <option value="">-- Select Region --</option>
                        </select>
                    </div>
                    <div class="mb-4">
                        <label for="amount_added" class="block text-sm font-semibold mb-1">Adjustment Amount</label>
                        <input type="number" id="amount_added" step="0.01"
                            class="w-full p-2 border border-gray-300 rounded focus:ring-2 focus:ring-blue-500">
                    </div>
                    <div class="mb-4">
                        <label for="effective_date" class="block text-sm font-semibold mb-1">Effective Date</label>
                        <input type="date" id="effective_date"
                            class="w-full p-2 border border-gray-300 rounded focus:ring-2 focus:ring-blue-500">
                    </div>

                    <button type="button" onclick="submitMinimumWage()"
                        class="w-full bg-blue-600 hover:bg-blue-700 text-white py-2 rounded font-semibold">
                        Save
                    </button>
                </form>

                <script>
                    document.addEventListener("DOMContentLoaded", function() {
                        axios.get("{{ route('region.name') }}")
                            .then(response => {
                                const select = document.getElementById('regionSelect');
                                select.innerHTML = '';

                                response.data.forEach(region => {
                                    const totalRate = parseFloat(region.default_rate) + parseFloat(region
                                        .amount_added_total || 0);
                                    const option = document.createElement('option');
                                    option.value = region.id;
                                    option.text = `${region.name} (₱${totalRate.toFixed(2)})`;
                                    select.appendChild(option);
                                });
                            })
                            .catch(error => {
                                console.error('Error loading regions:', error);
                            });
                    });
                </script>

            </div>

            <!-- Region Wage Table -->
            <div class="lg:col-span-4 overflow-x-auto bg-white p-6 rounded-lg shadow border">
                <h2 class="text-lg font-bold mb-4 text-gray-700">Minimum Wage Table</h2>
                <table id="region-table"
                    class="min-w-full text-nowrap border border-gray-200 text-sm text-center text-gray-700">
                    <thead class="bg-gray-800 text-white ">
                        <tr>
                            <th class="px-6 py-3">Region</th>
                            <th class="px-6 py-3">Adjustment Amount</th>
                            <th class="px-6 py-3">New Wage Amount</th>
                            <th class="px-6 py-3">Effective Date</th>
                            <th class="px-6 py-3">Status</th>
                            <th class="px-6 py-3">Action</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200 text-center">
                        <!-- Rows will be dynamically populated -->
                    </tbody>
                </table>
            </div>
        </div>
    @else
        <div class="flex items-center justify-center w-full h-full my-2">
            <div>
                <i class="mr-2 text-3xl bx bx-lock"></i> <!-- Large lock icon indicating no access -->
                <span class="text-gray-500">You don't have privilege to access this page</span>
            </div>

        </div>
    @endif

    @include('Admin.Employee.wage.js')
@endsection
