<div id="deleteModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
    <div class="bg-white rounded-lg shadow-lg p-6 w-auto md:w-[30rem] mt-20">
        <h2 class="mb-4 text-lg font-bold">Delete Record</h2>
        <p>Are you sure you want to delete this record?</p>
        <form id="deleteForm">
            @csrf
            <input type="hidden" id="deleteRecordId" name="id">
            <div class="flex justify-end mt-6">
                <button type="button" onclick="closeModal('deleteModal')"
                    class="px-4 py-2 mr-2 text-gray-700 bg-gray-200 rounded">Cancel</button>
                <button type="submit" class="px-4 py-2 text-white bg-red-600 rounded">Delete</button>
            </div>
        </form>
    </div>
</div>
<div id="successModal" class="fixed inset-0 z-50 flex items-center justify-center hidden bg-black bg-opacity-50">
    <div class="p-5 bg-white rounded-lg shadow-lg w-96">
        <h2 class="text-lg font-bold text-center">Success</h2>
        <p id="successModalMessage" class="mt-2 text-center text-gray-700"></p>
        <div class="mt-4 text-center">
            <button onclick="closeModal('successModal')"
                class="px-4 py-2 text-white bg-blue-500 rounded-lg hover:bg-blue-700">
                OK
            </button>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {
        var employedTable = $('#region-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('region_wage.name') }}",
                data: function(d) {
                    // Custom data if needed
                }
            },
            columns: [{
                    data: 'default_rate.name',
                    name: 'default_rate.name'
                },
                {
                    data: 'amount_added',
                    name: 'amount_added'
                },
                {
                    data: 'amount',
                    name: 'amount'
                },
                {
                    data: 'date',
                    name: 'date'
                },
                {
                    data: 'status',
                    name: 'status'
                }, {
                    data: 'action',
                    name: 'action',
                    orderable: false,
                    searchable: false
                }
            ],
            order: [
                [0, 'desc']
            ]
        });
    });
</script>

<script>
    $(document).ready(function() {
        // Open Delete Modal
        window.openDeleteModal = function(recordId) {
            $('#deleteRecordId').val(recordId);
            $('#deleteModal').removeClass('hidden');
        };

        // Submit Delete Form
        $('#deleteForm').on('submit', function(e) {
            e.preventDefault();
            let recordId = $('#deleteRecordId').val();
            let deleteUrl = "{{ route('Employee_wage.destroy', ':id') }}".replace(':id', recordId);

            $.ajax({
                url: deleteUrl,
                type: "DELETE",
                data: {
                    _token: "{{ csrf_token() }}"
                },
                success: function(response) {
                    if (response.success) {
                        $('#successModal').removeClass('hidden'); // Show success modal
                        $('#successModalMessage').text(response.message);
                        $('#deleteForm')[0].reset(); // Reset form
                        $('#deleteModal').addClass('hidden'); // Close modal
                        $('#region-table').DataTable().ajax.reload(null,
                            false); // Reload table without resetting pagination
                    }
                },
                error: function(xhr) {
                    alert('Error deleting record.');
                }
            });
        });

        // Close Modal Function
        window.closeModal = function(modalId) {
            $('#' + modalId).addClass('hidden');
        };
    });
</script>
<script>
    function submitMinimumWage() {
        const regionId = document.getElementById('regionSelect').value;
        const added_amount = document.getElementById('amount_added').value;
        const effectiveDate = document.getElementById('effective_date').value;

        axios.post("{{ route('Employee_wage.store') }}", {
                default_rate_id: regionId,
                amount_added: added_amount,
                effective_date: effectiveDate,

            }, {
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => {

                document.getElementById('minimumWageForm').reset();
                $('#region-table').DataTable().ajax.reload(null,
                    false);

            })
            .catch(error => {
                console.error(error);
                alert('Failed to save minimum wage. Please check inputs.');
            });
    }
</script>
