@extends('layouts.sidebar')
@section('title', 'request')
@section('content')

    @include('Admin.Overtime.modal')
    <div class="flex flex-col justify-between py-5 md:flex-row">
        <h1 class="mb-4 text-xl font-bold">Overtime and Undertime Request</h1>
        @if (in_array('Create Agency', $privileges))
            <button type="button" onclick="openModal('requestModal')"
                class="modal-button w-40 h-10 bg-[#1d1d1d] text-white rounded-md text-xs cursor-pointer font-semibold text-center shadow-xs transition-all duration-500 hover:bg-indigo-700">
                Add Request
            </button>
        @endif
    </div>

    @if (session('success'))
        <div class="p-4 mb-4 text-white bg-green-500">
            {{ session('success') }}
        </div>
    @endif
    <div class="overflow-auto bg-white p-6 bg-gray-100 rounded-lg shadow-md border border-gray-300">
        <table id="request_table" class="min-w-full border border-collapse border-gray-200 rounded">
            <thead>
                <tr class="text-xs font-semibold text-white bg-[#1d1d1d]">
                    <th class="px-4 py-2 border">ID</th>
                    <th class="px-4 py-2 border">Employee</th>
                    <th class="px-4 py-2 border">Department</th>
                    <th class="px-4 py-2 border">Request Type</th>
                    <th class="px-4 py-2 border">Status</th>
                    <th class="px-4 py-2 border">Action</th>
                </tr>
            </thead>
            <tbody class="text-sm font-light text-center text-gray-600">
                {{-- DataTables will populate rows here --}}
            </tbody>
        </table>
    </div>

    <script>
        $(document).ready(function() {
            $('#request_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('over_under_time_request.index') }}",
                columns: [{
                        data: 'id',
                        name: 'id'
                    },
                    {
                        data: 'employee_name',
                        name: 'employee_name'
                    },
                    {
                        data: 'department',
                        name: 'department'
                    },
                    {
                        data: 'type',
                        name: 'type'
                    },
                    {
                        data: 'status',
                        name: 'is_approved'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ]
            });
        });
    </script>
    {{-- @else
        <div class="flex items-center justify-center w-full h-full my-2">
            <div>
                <i class="mr-2 text-3xl bx bx-lock"></i>
                <span class="text-gray-500">You don't have privilege to access this page</span>
            </div>

        </div>
    @endif --}}
@endsection
