@extends('layouts.sidebar')

@section('title', 'PTSR Transactions')

@section('content')
    <div class="container mx-auto p-6  rounded-lg ">
        <table id="transactionsTable" class="min-w-full bg-white border border-collapse border-gray-200 rounded shadow-md">
            <thead>
                <tr class="text-sm leading-normal text-white bg-[#1d1d1d]">
                    <th class="">ID</th>
                    <th class="">PTSR ID</th>
                    <th class="">Description</th>
                    <th class="">Amount</th>
                    <th class="">Created At</th>
                    <th class="">Action</th>
                </tr>
            </thead>
            <tbody></tbody>
        </table>
    </div>


    <script>
        $(document).ready(function() {
            $('#transactionsTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('ptsr.show', $id) }}",
                columns: [{
                        data: 'id',
                        name: 'id'
                    },
                    {
                        data: 'ptsr_id',
                        name: 'ptsr_id'
                    },
                    {
                        data: 'name',
                        name: 'name'
                    },
                    {
                        data: 'amount',
                        name: 'amount',
                        render: $.fn.dataTable.render.number(',', '.', 2)
                    },
                    {
                        data: 'created_at',
                        name: 'created_at'
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ]
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            // Open Delete Modal
            window.openDeleteModal = function(recordId) {
                $('#deleteRecordId').val(recordId);
                $('#deleteModal').removeClass('hidden');
            };

            // Submit Delete Form
            $('#deleteForm').on('submit', function(e) {
                e.preventDefault();
                let recordId = $('#deleteRecordId').val();
                let deleteUrl = "{{ route('ptsr_trx.destroy', ':id') }}".replace(':id', recordId);

                $.ajax({
                    url: deleteUrl,
                    type: "DELETE",
                    data: {
                        _token: "{{ csrf_token() }}"
                    },
                    success: function(response) {
                        if (response.success) {
                            $('#successModal').removeClass('hidden'); // Show success modal
                            $('#deleteForm')[0].reset(); // Reset form
                            $('#deleteModal').addClass('hidden'); // Close modal
                            $('#transactionsTable').DataTable().ajax.reload(null,
                                false); // Reload table without resetting pagination
                        }
                    },
                    error: function(xhr) {
                        alert('Error deleting record.');
                    }
                });
            });

            function closeModal(modalId, reopenButtonId) {
                $(modalId).addClass('hidden');
                // Show the reopen button
            }
            $('#closeSuccessModal').click(function() {
                closeModal('#successModal');
            });
            // Close Modal Function
            window.closeModal = function(modalId) {
                $('#' + modalId).addClass('hidden');
            };
        });
    </script>
    <div id="successModal" class="fixed inset-0 z-50 flex items-center justify-center hidden bg-black bg-opacity-50">
        <div class="p-5 bg-white rounded-lg shadow-lg w-96">
            <h2 class="text-lg font-bold text-center">Success</h2>
            <p class="mt-2 text-center text-gray-700">Attendance record added successfully!</p>
            <div class="mt-4 text-center">
                <button id="closeSuccessModal" class="px-4 py-2 text-white bg-blue-500 rounded-lg hover:bg-blue-700">
                    OK
                </button>
            </div>
        </div>
    </div>
    <div id="deleteModal" class="fixed inset-0 flex z-50 items-start justify-center hidden bg-gray-800 bg-opacity-50">
        <div class="bg-white rounded-lg shadow-lg p-6 w-auto md:w-[30rem] mt-20">
            <h2 class="text-lg font-bold mb-4">Delete Record</h2>
            <p>Are you sure you want to delete this record?</p>
            <form id="deleteForm">
                @csrf
                <input type="hidden" id="deleteRecordId" name="id">
                <div class="flex justify-end mt-6">
                    <button type="button" onclick="closeModal('deleteModal')"
                        class="px-4 py-2 mr-2 text-gray-700 bg-gray-200 rounded">Cancel</button>
                    <button type="submit" class="px-4 py-2 text-white bg-red-600 rounded">Delete</button>
                </div>
            </form>
        </div>
    </div>

@endsection
