<div id="imageModal" class="fixed inset-0 flex items-center justify-center hidden bg-gray-900 bg-opacity-50">
    <div class="w-full max-w-lg p-6 bg-white rounded-lg shadow-lg">
        <div class="flex items-center justify-between">
            <h2 class="text-xl font-bold">Image Preview</h2>
            <button id="closeModal" class="text-gray-500 hover:text-gray-700">&times;</button>
        </div>
        <div class="my-4">
            <img src="https://via.placeholder.com/600x400" alt="Image Preview" class="w-full h-auto rounded-lg">
        </div>
    </div>
</div>

@if (session('success'))
    <div id="successModal" class="fixed inset-0 z-50 flex items-start justify-center bg-gray-900 bg-opacity-50">
        <div class="flex flex-col items-center justify-center w-full max-w-2xl p-6 mt-20 bg-white rounded-lg shadow-lg">
            <i class='text-6xl bx bxs-check-circle'></i>
            <p class="mb-5 text-lg font-semibold text-center">
                {{ session('success') }}
            </p>

        </div>
    </div>
    <script>
        setTimeout(function() {
            document.getElementById('successModal').style.display = 'none';
        }, 3000); // 5000 milliseconds = 5 seconds
    </script>
@endif


<div id="updateModal" class="fixed inset-0 flex items-center justify-center hidden bg-black bg-opacity-50">
    <div class="w-full max-w-3xl h-[40rem] overflow-auto p-6 bg-white rounded-lg shadow-md">
        <div class="">
            <h2 class="mb-4 text-2xl font-bold">Update TrxCode</h2>

            <form id="updateForm" action="" method="POST">
                @csrf
                @method('PUT')

                <input type="hidden" id="update_id" name="id">

                <!-- Group Code -->
                <select name="group_code_id" id="update_group_code_id" required
                    class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500">
                    <option value="" disabled selected>Select Group Code</option>
                    @foreach ($groupCodes as $groupCode)
                        <option value="{{ $groupCode->id }}">{{ $groupCode->description }}</option>
                    @endforeach
                </select>
                <div class="mb-4">
                    <label for="description" class="block text-sm font-medium text-gray-700">Description</label>
                    <input type="text" name="description" id="update_description"
                        class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500">
                </div>
                <div class="mb-4">
                    <label for="abbreviation" class="block text-sm font-medium text-gray-700">Abbreviation</label>
                    <input type="text" name="abbreviation" id="update_abbreviation"
                        class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500">
                </div>
                <div class="mb-4">
                    <label for="percentage" class="block text-sm font-medium text-gray-700">Percentage</label>
                    <input type="number" name="percentage" id="update_percentage"
                        class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500">
                </div>
                <div class="mb-4">
                    <label for="entry_order" class="block text-sm font-medium text-gray-700">Entry Order</label>
                    <input type="number" name="entry_order" id="update_entry_order"
                        class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500">
                </div>
                <div class="mb-4">
                    <label for="sub_category" class="block text-sm font-medium text-gray-700">Sub Category</label>
                    <input type="text" name="sub_category" id="update_sub_category"
                        class="block w-full mt-1 border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500">
                </div>


                <div class="mb-4">
                    <label for="option_ids" class="block text-sm font-medium text-gray-700">Options</label>
                    <div class="space-y-2">
                        @foreach ($options as $option)
                            <div>
                                <input type="checkbox" name="option_ids[]" id="option_{{ $option->id }}"
                                    value="{{ $option->id }}" class="mr-2">
                                <label for="option_{{ $option->id }}">{{ $option->name }}</label>
                            </div>
                        @endforeach
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="flex justify-end">
                    <button type="button" onclick="closeModalupdate()"
                        class="px-4 py-2 mr-2 font-semibold text-white bg-gray-500 rounded-lg shadow-md hover:bg-gray-700">
                        Cancel
                    </button>
                    <button type="submit"
                        class="px-4 py-2 font-semibold text-white bg-blue-500 rounded-lg shadow-md hover:bg-blue-700">
                        Update
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
<script>
    function openModal(button) {
        const data = button.dataset;
        document.getElementById('updateModal').classList.remove('hidden');
        document.getElementById('update_id').value = data.id;
        document.getElementById('update_group_code_id').value = data.groupCodeId;
        document.getElementById('update_description').value = data.description;
        document.getElementById('update_abbreviation').value = data.abbreviation;
        document.getElementById('update_percentage').value = data.percentage;
        document.getElementById('update_entry_order').value = data.entryOrder;
        document.getElementById('update_sub_category').value = data.subCategory;
        const selectedOptions = JSON.parse(data.options);
        const allCheckboxes = document.querySelectorAll('input[name="option_ids[]"]');
        allCheckboxes.forEach(checkbox => {
            checkbox.checked = selectedOptions.includes(parseInt(checkbox.value));
        });
        const updateForm = document.getElementById('updateForm');
        updateForm.action = `{{ route('trx_codes.update', ':id') }}`.replace(':id', data.id);
    }

    function closeModalupdate() {
        document.getElementById('updateModal').classList.add('hidden');
    }
</script>
<div id="editModal" class="fixed inset-0 flex items-center justify-center hidden bg-gray-800 bg-opacity-50">
    <div class="p-6 bg-white rounded-lg w-96">
        <h2 class="mb-4 text-2xl font-semibold">Edit Group Code</h2>
        <form id="editForm" action="" method="POST">
            @csrf
            @method('PUT')

            <div class="mb-4">
                <label for="description1" class="block text-sm font-medium text-gray-700">Description</label>
                <input type="text" id="description1" name="description"
                    class="block w-full p-2 mt-1 border border-gray-300 rounded-md" />
            </div>
            <div class="flex justify-end">
                <button type="button" id="closeModal"
                    class="px-4 py-2 mr-2 text-white bg-gray-500 rounded-md">Cancel</button>
                <button type="submit" class="px-4 py-2 text-white bg-blue-500 rounded-md">Save Changes</button>
            </div>
        </form>
    </div>
</div>
<script>
    function openEditModal(button) {
        const data = button.dataset;

        // Show the modal
        document.getElementById('editModal').classList.remove('hidden');

        // Set the input field values
        document.getElementById('description1').value = data.description;

        // Set the action URL for the form
        const updateForm = document.getElementById('editForm');
        updateForm.action = `{{ route('trx_groupcodes.update', ':id') }}`.replace(':id', data.id);
    }

    function closeModal() {
        // Close the modal
        document.getElementById('editModal').classList.add('hidden');
    }

    // Attach event listener for closing the modal
    document.getElementById('closeModal').addEventListener('click', closeModal);
</script>
