@extends('layouts.sidebar')

@section('title', 'Payroll for checking')
@section('content')
    @if (in_array('Payroll Checking', $privileges))
        <div class="flex flex-col justify-between py-5 md:flex-row">
            <h1 class="mb-4 font-bold">Payroll for checking</h1>
            @if (in_array('Create Payroll', $privileges))
                {{-- <button type="button"
                    class="modal-button w-40 h-10 bg-[#1d1d1d] text-white rounded-md text-xs cursor-pointer font-semibold text-center shadow-xs transition-all duration-500 hover:bg-indigo-700"
                    data-pd-overlay="#subscribe-form-modal" data-modal-target="subscribe-form-modal"
                    data-modal-toggle="subscribe-form-modal">
                    Create Payroll
                </button> --}}
            @endif
        </div>
        @include('Admin.Payroll.check.modal')
        @if (session('success'))
            <div class="p-4 mb-4 text-sm text-white bg-green-500">
                {{ session('success') }}
            </div>
        @endif
        @if (session('error'))
            <div class="p-4 mb-4 text-sm text-white bg-red-500">
                {{ session('error') }}
            </div>
        @endif
        <div class="p-2 overflow-auto border-2 border-black rounded-md ">
            <table id="billing-table" class="min-w-full bg-white border border-gray-200 rounded shadow-md">
                <thead>
                    <tr class="text-sm leading-normal text-white bg-black">
                        <th class="px-6 py-3">Batch Code</th>
                        <th class="px-6 py-3">Client</th>
                        <th class="px-6 py-3">Pay Period </th>

                        <th class="px-6 py-3">Number of Employee</th>
                        <th class="px-6 py-3">Actions</th>
                    </tr>
                </thead>
                <tbody class="text-sm font-light text-center text-gray-600">
                </tbody>
            </table>
        </div>
    @else
        <div class="flex items-center justify-center w-full h-full my-2">
            <div>
                <i class="mr-2 text-3xl bx bx-lock"></i> <!-- Large lock icon indicating no access -->
                <span class="text-gray-500">You don't have privilege to access this page</span>
            </div>

        </div>
    @endif

    <script>
        $(document).ready(function() {
            var employedTable = $('#billing-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('payrollchecking.index') }}",
                    data: function(d) {
                        // Custom data if needed
                    }
                },
                columns: [{
                        data: 'id', // Adjust according to your Batch Code data
                        name: 'id',
                        width: '10%' // Set the width for the ID column
                    },
                    {
                        data: 'client.department_name',
                        name: 'client.department_name',
                        width: '10%' // Set the width for the Client Business Name column
                    },
                    {
                        data: 'pay_period',
                        name: 'pay_period',
                        width: '10%' // Set the width for the Pay Period Start column
                    },

                    {
                        data: 'employee_count',
                        name: 'employee_count',
                        width: '10%' // Set the width for the Employee Count column
                    },
                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false,
                        width: '10%' // Set the width for the Action column
                    }
                ],
                order: [
                    [0, 'desc']
                ]
            });
        });
    </script>

@endsection
