<script>
    document.getElementById('payroll_type').addEventListener('change', function() {
        setPayrollPeriod();
    });

    document.getElementById('pay_period_start').addEventListener('change', function() {
        adjustEndDate();
    });

    function setPayrollPeriod() {
        const payrollType = document.getElementById('payroll_type').value;
        const startDateInput = document.getElementById('pay_period_start');
        const endDateInput = document.getElementById('pay_period_end');

        const today = new Date();

        if (payrollType === 'weekly') {
            const startOfWeek = new Date(today.setDate(today.getDate() - today.getDay())); // Start of the week (Sunday)
            const endOfWeek = new Date(startOfWeek);
            endOfWeek.setDate(startOfWeek.getDate() + 6); // End of the week (Saturday)

            startDateInput.value = startOfWeek.toISOString().split('T')[0];
            endDateInput.value = endOfWeek.toISOString().split('T')[0];
        } else if (payrollType === 'bi-weekly') {
            const startOfBiWeeklyPeriod = new Date(today.setDate(today.getDate() - (today.getDate() % 15)));
            const endOfBiWeeklyPeriod = new Date(startOfBiWeeklyPeriod);
            endOfBiWeeklyPeriod.setDate(startOfBiWeeklyPeriod.getDate() + 14); // 15 days period

            startDateInput.value = startOfBiWeeklyPeriod.toISOString().split('T')[0];
            endDateInput.value = endOfBiWeeklyPeriod.toISOString().split('T')[0];
        } else {
            startDateInput.value = '';
            endDateInput.value = '';
        }
    }

    function adjustEndDate() {
        const payrollType = document.getElementById('payroll_type').value;
        const startDateInput = document.getElementById('pay_period_start');
        const endDateInput = document.getElementById('pay_period_end');

        const startDate = new Date(startDateInput.value);
        if (payrollType === 'weekly') {
            const endDate = new Date(startDate);
            endDate.setDate(startDate.getDate() + 6); // Weekly period of 7 days
            endDateInput.value = endDate.toISOString().split('T')[0];
        } else if (payrollType === 'bi-weekly') {
            const endDate = new Date(startDate);
            endDate.setDate(startDate.getDate() + 14); // Bi-weekly period of 15 days
            endDateInput.value = endDate.toISOString().split('T')[0];
        } else {
            endDateInput.value = '';
        }
    }
</script>
