@extends('layouts.sidebar')
@section('title', 'Payroll Deduction')
@section('content')
    @if (in_array('Payroll Checking', $privileges))
        <div class="flex flex-col items-center justify-between py-5 md:flex-row">
            <h1 class="mb-4 text-xl font-bold">Deduction</h1>
            <div class="relative flex flex-col items-end justify-end mr-10 text-center">
                <div>
                    <button type="button"
                        class="inline-flex justify-center w-full px-4 py-1 text-xs font-medium text-white bg-[#1d1d1d] border border-gray-300 rounded-md shadow-sm hover:bg-blue-900 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-100 focus:ring-blue-500"
                        id="menu-button" aria-expanded="false" aria-haspopup="true" onclick="toggleDropdown()">
                        Menu
                        <svg class="w-5 h-5 ml-2 -mr-1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"
                            fill="currentColor" aria-hidden="true">
                            <path fill-rule="evenodd"
                                d="M5.23 7.21a.75.75 0 011.06 0L10 10.44l3.71-3.23a.75.75 0 111.04 1.08l-4.25 3.5a.75.75 0 01-1.04 0l-4.25-3.5a.75.75 0 010-1.08z"
                                clip-rule="evenodd" />
                        </svg>
                    </button>
                    <div class="absolute right-0 z-10 hidden w-56 mt-2 bg-white rounded-md shadow-lg ring-1 ring-black ring-opacity-5 focus:outline-none"
                        role="menu" aria-orientation="vertical" aria-labelledby="menu-button" tabindex="-1"
                        id="dropdown-menu">
                        <div class="py-1" role="none">
                            <div class="flex flex-col items-center justify-center text-nowrap ">
                                <a id="showemployee" href="{{ route('loans.index') }}"
                                    class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                    Deduction
                                </a>
                                <a id="showbilling" href="{{ route('mortuaries.index') }}"
                                    class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                    Employee Deduction Settings
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        @if (session('success'))
            <div class="p-4 mb-4 text-sm text-white bg-green-500">
                {{ session('success') }}
            </div>
        @endif
        @if (session('error'))
            <div class="p-4 mb-4 text-sm text-white bg-red-500">
                {{ session('error') }}
            </div>
        @endif
        <div class="overflow-auto">
            <table id="deduction-table" class="min-w-full bg-white border border-gray-200 rounded shadow-md">
                <thead>
                    <tr class="text-sm leading-normal text-white  bg-[#1d1d1d]">
                        <th class="px-6">Batch Code</th>
                        <th class="px-6">Client</th>
                        <th class="px-6 ">Payroll Prepared by</th>
                        <th class="px-6 ">Payroll Approved by</th>

                        <th class="px-6">Period Start</th>
                        <th class="px-6">Period End</th>
                        <th class="px-6">Number of Employee</th>
                        <th class="px-6">Actions</th>
                    </tr>
                </thead>
                <tbody class="text-sm font-light text-center text-gray-600">
                </tbody>
            </table>
        </div>
    @else
        <div class="flex items-center justify-center w-full h-full my-2">
            <div>
                <i class="mr-2 text-3xl bx bx-lock"></i>
                <span class="text-gray-500">You don't have privilege to access this page</span>
            </div>
        </div>
    @endif

    <script>
        $(document).ready(function() {
            var employedTable = $('#deduction-table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('loans.index') }}",
                    data: function(d) {

                    }
                },
                columns: [{
                        data: 'id',
                        name: 'id'
                    },
                    {
                        data: 'client.business_name',
                        name: 'client.business_name'
                    },
                    {
                        data: 'approve_by',
                        name: 'approve_by',

                    },
                    {
                        data: 'approve_by1',
                        name: 'approve_by1',

                    },
                    {
                        data: 'pay_period_start',
                        name: 'pay_period_start'
                    },
                    {
                        data: 'pay_period_end',
                        name: 'pay_period_end'
                    },
                    {
                        data: 'employee_count',
                        name: 'employee_count'
                    },

                    {
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    }
                ],
                order: [
                    [0, 'desc']
                ]
            });
        });
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const showemployee = document.getElementById('showemployee');
            const showbilling = document.getElementById('showbilling');

            const employeeshow = document.getElementById('employeeshow');
            const billingshow = document.getElementById('billingshow');


            showemployee.addEventListener('click', function() {
                employeeshow.classList.remove('hidden');
                billingshow.classList.add('hidden');
            });

            // Show Billing Section button click
            showbilling.addEventListener('click', function() {
                employeeshow.classList.add('hidden');
                billingshow.classList.remove('hidden');
            });

            // Dropdown toggle
            document.getElementById('menu-button').addEventListener('click', function() {
                const menu = document.getElementById('dropdown-menu');
                menu.classList.toggle('hidden');
            });
        });
    </script>
@endsection
