<!-- Edit Payroll Modal -->
<div id="editPayrollModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-black bg-opacity-60">
    <div class="w-auto p-6 mt-10 bg-white rounded-lg shadow-lg">

        <div class="mb-2">
            <label for="employee_name">Employee Name:</label>
            <span id="employee_name"></span>
        </div>
        <form id="editPayrollForm" onsubmit="submitPayrollForm(event)">


            <input type="hidden" name="loanId" id="loanId">
            <div class="grid items-center justify-center grid-cols-1 gap-2 lg:grid-cols-2 xl:grid-cols-4">
                <div class="mb-4">
                    <label for="capital" class="block text-sm font-medium text-gray-700">Capital</label>
                    <input type="number" name="capital" id="capital"
                        class="w-full mt-1 border border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500"
                        step="any">
                </div>

                <div class="mb-4">
                    <label for="loans" class="block text-sm font-medium text-gray-700">loans</label>
                    <input type="number" name="loans" id="loans"
                        class="w-full mt-1 border border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500"
                        step="any">
                </div>

                <div class="mb-4">
                    <label for="c_loans" class="block text-sm font-medium text-gray-700">CLoans</label>
                    <input type="number" name="c_loans" id="c_loans"
                        class="w-full mt-1 border border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500"
                        step="any">
                </div>

                <div class="mb-4">
                    <label for="mortuary" class="block text-sm font-medium text-gray-700">Mortuary
                    </label>
                    <input type="number" name="mortuary" id="mortuary"
                        class="w-full mt-1 border border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500"
                        step="any">
                </div>
            </div>
            <div class="flex justify-end gap-4">
                <button type="button" onclick="closeEditModal()"
                    class="px-4 py-2 text-gray-700 bg-gray-200 rounded-md hover:bg-gray-300 focus:outline-none">Cancel</button>
                <button type="submit"
                    class="px-4 py-2 text-white bg-blue-600 rounded-md hover:bg-blue-700 focus:outline-none">Save</button>
            </div>
        </form>
    </div>
</div>
<!-- Edit Payroll Modal -->

<!-- Delete Confirmation Modal -->
<div id="deletePayrollModal"
    class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-900 bg-opacity-50">
    <div class="w-1/3 p-6 mt-10 bg-white rounded-lg">
        <h3 class="mb-4 text-xs font-bold text-center">Are you sure you want to delete this deduction?</h3>
        <div class="flex justify-between">
            <button id="deleteCancelBtn" class="px-4 py-2 text-xs text-white bg-gray-500 rounded-md">Cancel</button>
            <button id="deleteConfirmBtn" class="px-4 py-2 text-xs text-white bg-red-500 rounded-md">Delete</button>
        </div>
    </div>
</div>

<script>
    // Set up AJAX with CSRF token
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    // Open modal and populate form
    function openEditModal(loanId) {
        $.ajax({
            url: "{{ route('loans.edit', ':loanId') }}".replace(':loanId', loanId),
            method: 'GET',
            success: function(response) {
                // Populate the fields with existing data
                $('#loanId').val(response.id);
                $('#capital').val(response.capital);
                $('#loans').val(response.loans);
                $('#c_loans').val(response.c_loans);
                $('#mortuary').val(response.mortuary);

                $('#employee_name').text(response.payroll.employee
                    .last_name);
                $('#editPayrollModal').removeClass('hidden');
            },
            error: function(xhr, status, error) {
                alert("Error loading payroll data: " + error);
            }
        });
    }


    // Submit the form via AJAX for updating payroll
    function submitPayrollForm(event) {
        event.preventDefault(); // Prevent default form submission

        var loanId = $('#loanId').val(); // Get the payroll ID from the hidden input
        var formData = $('#editPayrollForm').serialize(); // Serialize the form data (No need for FormData if no files)

        $.ajax({
            url: "{{ route('loans.update', ':loanId') }}".replace(':loanId', loanId),
            method: 'PUT', // Use PUT for update
            data: formData,
            success: function(response) {
                // Handle success (close modal, refresh data in the table row)
                closeEditModal();
                // Optionally, refresh the data table or update it with new data
                updatePayrollRow(response.data); // Call this to update the row
                alert(response.message); // Show success message
            },
            error: function(xhr, status, error) {
                // Handle error (e.g., show error messages)
                alert("Error updating payroll: " + error);
            }
        });
    }

    // Function to close the modal
    function closeEditModal() {
        $('#editPayrollModal').addClass('hidden');
    }

    // Function to update a specific row in the DataTable
    function updatePayrollRow(updatedData) {
        var table = $('#payrollsDataTable').DataTable();
        var row = table.row(function(idx, data, node) {
            return data.id === updatedData.id; // Match the row using payroll ID
        });

        // Update the row data
        row.data({
            ...row.data(), // Retain existing data
            ...updatedData, // Replace with the updated data from the response
        }).invalidate().draw(); // Invalidate and redraw the row
    }

    function confirmDeletePayroll(payrollId) {
        // Show the modal
        $('#deletePayrollModal').removeClass('hidden');

        // Handle the Confirm Delete button click
        $('#deleteConfirmBtn').off('click').on('click', function() {
            // Proceed with deletion
            $.ajax({
                url: "{{ route('loans.destroy', ':payrollId') }}".replace(':payrollId', payrollId),
                method: 'DELETE',
                success: function(response) {
                    // Hide the modal
                    $('#deletePayrollModal').addClass('hidden');

                    // Reload the DataTable
                    $('#payrollsDataTable').DataTable().ajax.reload(null,
                        false); // false to hold the current page

                    // Show success message if needed
                    alert(response.message);
                },
                error: function(xhr, status, error) {
                    alert("Error deleting payroll: " + error);
                }
            });
        });

        // Handle the Cancel button click
        $('#deleteCancelBtn').off('click').on('click', function() {
            $('#deletePayrollModal').addClass('hidden');
        });
    }
</script>
<script>
    $(document).ready(function() {
        var batch_id = "{{ $batch_id }}";
        var status = "{{ $status }}";

        $('#payrollsDataTable').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route('deduction.get', ['id' => $batch_id, 'status' => $status]) }}",
            columns: [{
                    data: 'payroll_details',
                    name: 'payroll_details'
                },
                {
                    data: 'capital',
                    name: 'capital',
                    render: function(data) {
                        return data ? parseFloat(data).toFixed(2) : '-';
                    }
                },
                {
                    data: 'loans',
                    name: 'loans',
                    render: function(data) {
                        return data ? parseFloat(data).toFixed(2) : '-';
                    }
                },
                {
                    data: 'c_loans',
                    name: 'c_loans',
                    render: function(data) {
                        return data ? parseFloat(data).toFixed(2) : '-';
                    }
                },
                {
                    data: 'mortuary',
                    name: 'mortuary',
                    render: function(data) {
                        return data ? parseFloat(data).toFixed(2) : '-';
                    }
                },
                {
                    data: 'total',
                    name: 'total',
                    render: function(data) {
                        return data ? parseFloat(data).toFixed(2) : '-';
                    }
                },
                {
                    data: 'action',
                    name: 'action',
                }
            ],
            order: [
                [0, 'asc']
            ], // Default ordering by the first column (employee.id)
            footerCallback: function(row, data, start, end, display) {
                var api = this.api();
                var totalCapital = 0;
                var totalLoans = 0;
                var totalCLoans = 0;
                var totalMortuary = 0;
                var totalDeduction = 0;

                // Calculate totals for the columns
                api.column(1).data().each(function(value, index) {
                    totalCapital += parseFloat(value) || 0;
                });
                api.column(2).data().each(function(value, index) {
                    totalLoans += parseFloat(value) || 0;
                });
                api.column(3).data().each(function(value, index) {
                    totalCLoans += parseFloat(value) || 0;
                });
                api.column(4).data().each(function(value, index) {
                    totalMortuary += parseFloat(value) || 0;
                });
                api.column(5).data().each(function(value, index) {
                    totalDeduction += parseFloat(value) || 0;
                });

                // Update the footer row
                $(api.table().footer()).find('th').eq(1).text(totalCapital.toFixed(2));
                $(api.table().footer()).find('th').eq(2).text(totalLoans.toFixed(2));
                $(api.table().footer()).find('th').eq(3).text(totalCLoans.toFixed(2));
                $(api.table().footer()).find('th').eq(4).text(totalMortuary.toFixed(2));
                $(api.table().footer()).find('th').eq(5).text(totalDeduction.toFixed(2));
            }
        });
    });
</script>
