@extends('layouts.sidebar')
@section('title', 'Mortuary Status')
@section('content')
    <div class="w-full">
        @if (session('success'))
            <div class="p-4 mb-4 text-sm text-white bg-green-500">
                {{ session('success') }}
            </div>
        @endif
        @if (session('error'))
            <div class="p-4 mb-4 text-sm text-white bg-red-500">
                {{ session('error') }}
            </div>
        @endif
        <div class="flex flex-col items-center justify-between py-5 md:flex-row">
            <h1 class="mb-4 text-xl font-bold">Record</h1>
            <div class="relative flex flex-col items-end justify-end mr-10 text-center">
                <div>
                    <button type="button"
                        class="inline-flex justify-center w-full px-4 py-1 text-xs font-medium text-white bg-[#1d1d1d] border border-gray-300 rounded-md shadow-sm hover:bg-blue-900 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-offset-gray-100 focus:ring-blue-500"
                        id="menu-button" aria-expanded="false" aria-haspopup="true" onclick="toggleDropdown()">
                        Menu
                        <svg class="w-5 h-5 ml-2 -mr-1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20"
                            fill="currentColor" aria-hidden="true">
                            <path fill-rule="evenodd"
                                d="M5.23 7.21a.75.75 0 011.06 0L10 10.44l3.71-3.23a.75.75 0 111.04 1.08l-4.25 3.5a.75.75 0 01-1.04 0l-4.25-3.5a.75.75 0 010-1.08z"
                                clip-rule="evenodd" />
                        </svg>
                    </button>
                    <div class="absolute right-0 z-10 hidden w-56 mt-2 bg-white rounded-md shadow-lg ring-1 ring-black ring-opacity-5 focus:outline-none"
                        role="menu" aria-orientation="vertical" aria-labelledby="menu-button" tabindex="-1"
                        id="dropdown-menu">
                        <div class="py-1" role="none">
                            <div class="flex flex-col items-center justify-center text-nowrap ">
                                <a id="showemployee" href="{{ route('loans.index') }}"
                                    class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                    Deduction
                                </a>
                                <a id="showbilling" href="{{ route('mortuaries.index') }}"
                                    class="block w-full px-4 py-2 text-sm text-left text-gray-700 hover:bg-gray-100">
                                    Employee Deduction Settings
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="grid w-full grid-cols-1 gap-5 xl:grid-cols-5">
            <form action="{{ route('mortuaries.store') }}" method="POST"
                class="max-w-md p-6 mx-auto mt-5 bg-white rounded-lg shadow-md h-96">
                @csrf


                <div class="mb-4 text-sm">
                    <label for="employee_id" class="block font-medium text-gray-700">Employee</label>
                    <select name="employee_id" id="employee_id"
                        class="w-full p-2 mt-1 border border-gray-300 rounded-md focus:ring focus:ring-blue-200 focus:outline-none"
                        required>
                        <option value="" disabled selected>Select an Employee</option>
                        @foreach ($employee as $emp)
                            <option value="{{ $emp->id }}">{{ $emp->first_name }}
                                {{ substr($emp->middle_name, 0, 1) }}
                                {{ $emp->last_name }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="mb-4 text-sm">
                    <label for="rate" class="block font-medium text-gray-700">Rate</label>
                    <input type="text" name="rate" value="15.18"
                        class="w-full p-2 mt-1 border border-gray-300 rounded-md focus:ring focus:ring-blue-200 focus:outline-none">
                </div>

                <button type="submit"
                    class="w-full px-4 py-2 text-sm font-semibold text-white bg-blue-600 rounded-md hover:bg-blue-700 focus:outline-none focus:ring focus:ring-blue-200">
                    Add Record
                </button>
            </form>

            <div class="overflow-auto md:col-span-4">
                <table id="mortuaryTable"
                    class="bg-white border border-collapse border-gray-200 rounded shadow-md md:min-w-full">
                    <thead>
                        <tr class="text-xs leading-normal h-10 text-white uppercase bg-[#1d1d1d]">
                            <th>Mortuary</th>
                            <th>Loans</th>
                            <th>Employee Name</th>
                            <th>Mortuary Rate</th>
                        </tr>
                    </thead>
                    <tbody class="text-sm font-light text-center text-gray-600">
                        <!-- DataTables will populate this body -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Mortuary Update Status Modal -->
    <div id="statusUpdateModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-500 bg-opacity-50">
        <div class="w-full max-w-lg p-6 mt-10 bg-white rounded-lg shadow-lg">
            <div class="flex items-center justify-between mb-4">
                <h5 class="text-xl font-semibold">Mortuary Status Update</h5>
                <button type="button" id="closeModal" class="text-gray-500 hover:text-gray-800">&times;</button>
            </div>
            <div class="text-gray-700">
                The mortuary status has been successfully updated.
            </div>
            <div class="mt-4">
                <button id="closeModalBtn" class="px-4 py-2 text-white bg-blue-500 rounded hover:bg-blue-600">Close</button>
            </div>
        </div>
    </div>

    <!-- Loan Status Update Modal -->
    <div id="statusUpdateModal1"
        class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-500 bg-opacity-50">
        <div class="w-full max-w-lg p-6 mt-10 bg-white rounded-lg shadow-lg">
            <div class="flex items-center justify-between mb-4">
                <h5 class="text-xl font-semibold">Loan Status Update</h5>
                <button type="button" id="closeModal1" class="text-gray-500 hover:text-gray-800">&times;</button>
            </div>
            <div class="text-gray-700">
                The loan status has been successfully updated.
            </div>
            <div class="mt-4">
                <button id="closeModalBtn1"
                    class="px-4 py-2 text-white bg-blue-500 rounded hover:bg-blue-600">Close</button>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            var table = $('#mortuaryTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('mortuaries.index') }}",
                columns: [{
                        data: 'mortuary',
                        name: 'mortuary',
                        render: function(data, type, row) {
                            return '<input type="checkbox"  class="mortuary-checkbox" data-id="' +
                                row.id + '" ' + (data == 1 ? 'checked' : '') + '>';
                        },
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'loan',
                        name: 'loan',
                        render: function(data, type, row) {
                            return '<input type="checkbox"  class="loan-checkbox" data-id="' +
                                row.id + '" ' + (data == 1 ? 'checked' : '') + '>';
                        },
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: function(row) {
                            return row.employee.first_name + ' ' + row.employee.middle_name + ' ' +
                                row.employee.last_name;
                        },
                        name: 'employee.first_name',
                    },
                    {
                        data: 'rate',
                        name: 'rate'
                    },
                ]
            });

            // Handle checkbox click event to toggle Mortuary status
            $('#mortuaryTable').on('change', '.mortuary-checkbox', function() {
                var checkbox = $(this);
                var mortuaryId = checkbox.data('id');
                var status = checkbox.prop('checked') ? 1 :
                    0; // Get new status (1 for checked, 0 for unchecked)

                $.ajax({
                    url: '{{ route('mortuaries.updateStatus', ':id') }}'.replace(':id',
                        mortuaryId),
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        mortuary: status
                    },
                    success: function(response) {
                        // Show the success modal
                        $('#statusUpdateModal').removeClass('hidden');
                    },
                    error: function(xhr) {
                        alert('Failed to update status');
                        checkbox.prop('checked', !checkbox.prop('checked'));
                    }
                });
            });

            // Handle checkbox click event to toggle Loan status
            $('#mortuaryTable').on('change', '.loan-checkbox', function() {
                var checkbox = $(this);
                var mortuaryId = checkbox.data('id');
                var status = checkbox.prop('checked') ? 1 : 0;

                $.ajax({
                    url: '{{ route('loans.updateStatus', ':id') }}'.replace(':id', mortuaryId),
                    type: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        loan: status
                    },
                    success: function(response) {
                        // Show the loan status update modal
                        $('#statusUpdateModal1').removeClass('hidden');
                    },
                    error: function(xhr) {
                        alert('Failed to update loan status');
                        checkbox.prop('checked', !checkbox.prop('checked'));
                    }
                });
            });

            // Close the modals when the close button is clicked
            $('#closeModal, #closeModalBtn').on('click', function() {
                $('#statusUpdateModal').addClass('hidden');
            });

            $('#closeModal1, #closeModalBtn1').on('click', function() {
                $('#statusUpdateModal1').addClass('hidden');
            });
        });
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const showemployee = document.getElementById('showemployee');
            const showbilling = document.getElementById('showbilling');

            const employeeshow = document.getElementById('employeeshow');
            const billingshow = document.getElementById('billingshow');


            showemployee.addEventListener('click', function() {
                employeeshow.classList.remove('hidden');
                billingshow.classList.add('hidden');
            });

            // Show Billing Section button click
            showbilling.addEventListener('click', function() {
                employeeshow.classList.add('hidden');
                billingshow.classList.remove('hidden');
            });

            // Dropdown toggle
            document.getElementById('menu-button').addEventListener('click', function() {
                const menu = document.getElementById('dropdown-menu');
                menu.classList.toggle('hidden');
            });
        });
    </script>
@endsection
