<!-- Delete Modal -->
<div id="deleteModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
    <div class="bg-white rounded-lg shadow-lg p-6 w-auto md:w-[30rem] mt-20">
        <h2 class="mb-4 text-lg font-bold">Delete Record</h2>
        <p>Are you sure you want to delete this record?</p>
        <form id="deleteForm">
            @csrf
            <input type="hidden" id="deleteRecordId" name="id">
            <div class="flex justify-end mt-6">
                <button type="button" onclick="closeModal('deleteModal')"
                    class="px-4 py-2 mr-2 text-gray-700 bg-gray-200 rounded">Cancel</button>
                <button type="submit" class="px-4 py-2 text-white bg-red-600 rounded">Delete</button>
            </div>
        </form>
    </div>
</div>

<div id="successModal" class="fixed inset-0 z-50 flex items-center justify-center hidden bg-black bg-opacity-50">
    <div class="p-5 bg-white rounded-lg shadow-lg w-96">
        <h2 class="text-lg font-bold text-center">Success</h2>
        <p class="mt-2 text-center text-gray-700"></p>
        <div class="mt-4 text-center">
            <button onclick="closeModal('successModal')"
                class="px-4 py-2 text-white bg-blue-500 rounded-lg hover:bg-blue-700">
                OK
            </button>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {
        // Open Delete Modal
        window.openDeleteModal = function(recordId) {
            $('#deleteRecordId').val(recordId);
            $('#deleteModal').removeClass('hidden');
        };

        // Submit Delete Form
        $('#deleteForm').on('submit', function(e) {
            e.preventDefault();
            let recordId = $('#deleteRecordId').val();
            let deleteUrl = "{{ route('delete.batch', ':id') }}".replace(':id', recordId);

            $.ajax({
                url: deleteUrl,
                type: "DELETE",
                data: {
                    _token: "{{ csrf_token() }}"
                },
                success: function(response) {
                    if (response.success) {
                        $('#successModal').removeClass('hidden'); // Show success modal
                        $('#deleteForm')[0].reset(); // Reset form
                        $('#deleteModal').addClass('hidden'); // Close modal
                        $('#billing-table').DataTable().ajax.reload(null,
                            false); // Reload table without resetting pagination
                    }
                },
                error: function(xhr) {
                    alert('Error deleting record.');
                }
            });
        });

        // Close Modal Function
        window.closeModal = function(modalId) {
            $('#' + modalId).addClass('hidden');
        };

    });
</script>
<div class="relative w-full ">
    <div id="payrollModal" class="fixed inset-0 z-50 flex items-start justify-center hidden bg-gray-800 bg-opacity-50">
        <div class="bg-white rounded-lg shadow-lg w-auto  mt-10">
            <div class="flex flex-col px-5 py-4 bg-white rounded-2xl">
                <div class="flex items-center justify-between pb-4 border-b border-gray-200">
                    <h4 class="text-sm font-medium text-gray-900">Create Payroll</h4>
                    <button class="block cursor-pointer close-modal-button" onclick="closeModal('payrollModal')">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path d="M7.75732 7.75739L16.2426 16.2427M16.2426 7.75739L7.75732 16.2427" stroke="black"
                                stroke-width="1.6" stroke-linecap="round" />
                        </svg>
                    </button>
                </div>
                <div class="w-full p-8 mx-auto mb-10 bg-white border border-gray-200 rounded-lg shadow-md">


                    <div id="success-container" class="hidden"></div> <!-- Success Message -->
                    <div id="error-container" class="hidden"></div>

                    <form id="payroll-form" action="{{ route('payrolls.store') }}" method="POST">
                        @csrf

                        <div class="flex items-center justify-end">
                            <input type="checkbox" id="additionalCheckbox" value="additional" name="additional"
                                class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 focus:ring-2" />
                            <label for="additionalCheckbox" class="ml-2 text-sm font-medium text-gray-900">
                                Additional
                            </label>
                        </div>


                        <div class="grid grid-cols-1 gap-4 md:grid-cols-2">

                            <div class="mb-2">
                                <label for="client_selection" class="block text-sm font-medium text-gray-700">Apply
                                    Payroll To</label>
                                <select name="client_selection" id="client_selection" required
                                    class="block w-full h-8 mt-1 border-2 border-black rounded-md shadow-sm"
                                    onchange="toggleClientDropdown()">
                                    <option value="">Select Option</option>
                                    <option value="all">All Client</option>
                                    <option value="department">Per Client</option>
                                </select>
                            </div>

                            <div class="mb-2" id="department_div" style="display: none;">
                                <label for="department_id" class="block text-sm font-medium text-gray-700">Select
                                    Client</label>
                                <select name="department_id" id="department_id"
                                    class="block w-full h-8 mt-1 border-2 border-black rounded-md shadow-sm">
                                    <option value="">Select a Client</option>
                                    @foreach ($departments as $department)
                                        <option value="{{ $department->id }}">{{ $department->department_name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                            <script>
                                function toggleClientDropdown() {
                                    var clientSelection = document.getElementById("client_selection").value;
                                    var departmentDiv = document.getElementById("department_div");

                                    // Hide the department dropdown initially
                                    departmentDiv.style.display = 'none';

                                    // Show the department dropdown if "Per Client" is selected
                                    if (clientSelection == "department") {
                                        departmentDiv.style.display = 'block';
                                    }
                                }
                            </script>

                            <div class="col-span-2 ">
                                <label for="pay_period_start" class="block mb-1 text-sm font-medium text-gray-700">Pay
                                    Scope of Payroll</label>
                                <div class="grid grid-cols-1 gap-10 md:grid-cols-2">
                                    <div class="mb-2 ">

                                        <input type="date" name="pay_period_start" id="pay_period_start" required
                                            class="block w-full h-8 px-4 py-2 text-gray-700 bg-white border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-transparent"
                                            placeholder="Select start date">
                                    </div>
                                    <div class="mb-2 ">

                                        <input type="date" name="pay_period_end" id="pay_period_end" required
                                            class="block w-full h-8 px-4 py-2 text-gray-700 bg-white border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-transparent"
                                            placeholder="Select end date">
                                    </div>
                                </div>
                            </div>
                            <div class="col-span-2 ">
                                <label for="" class="block mb-1 text-sm font-medium text-gray-700">Scope
                                    of Contribution</label>
                                <div class="grid grid-cols-1 gap-10 md:grid-cols-2">
                                    <div class="mb-2 ">

                                        <input type="date" name="scope_start" id=""
                                            class="block w-full h-8 px-4 py-2 text-gray-700 bg-white border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-transparent"
                                            placeholder="Select start date">
                                    </div>
                                    <div class="mb-2 ">

                                        <input type="date" name="scope_end" id=""
                                            class="block w-full h-8 px-4 py-2 text-gray-700 bg-white border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-2 focus:ring-green-500 focus:border-transparent"
                                            placeholder="Select end date">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <p id="error_message" style="color: red; display: none;">Please select at least one option
                            (1st
                            Half or 2nd Half).</p>

                        <div class="p-5">
                            <div class="flex items-center mb-3">
                                <input type="checkbox" name="first" value="1"
                                    class="w-5 h-5 text-blue-600 bg-gray-200 border-gray-300 rounded focus:ring-blue-500 focus:ring-2"
                                    id="first_checkbox" />
                                <label for="first_checkbox" class="ml-3 text-sm text-gray-700">Include 1st Half
                                    Contributions and/or Deductions</label>
                            </div>
                            <div class="flex items-center mb-3">
                                <input type="checkbox" name="second" value="2"
                                    class="w-5 h-5 text-blue-600 bg-gray-200 border-gray-300 rounded focus:ring-blue-500 focus:ring-2"
                                    id="second_checkbox" />
                                <label for="second_checkbox" class="ml-3 text-sm text-gray-700">Include 2nd Half
                                    Contributions and/or Deductions</label>
                            </div>
                            <div class="flex items-center mb-3">
                                <input type="checkbox" name="2" value="2"
                                    class="w-5 h-5 text-blue-600 bg-gray-200 border-gray-300 rounded focus:ring-blue-500 focus:ring-2"
                                    id="" />
                                <label for="second_checkbox" class="ml-3 text-sm text-gray-700">Compute for Social
                                    Security System
                                    Contribution(S.S.S)</label>
                            </div>
                            <div class="flex items-center mb-3">
                                <input type="checkbox" name="3" value="3"
                                    class="w-5 h-5 text-blue-600 bg-gray-200 border-gray-300 rounded focus:ring-blue-500 focus:ring-2"
                                    id="" />
                                <label for="second_checkbox" class="ml-3 text-sm text-gray-700">Compute for
                                    Philhealth</label>
                            </div>
                            <div class="flex items-center mb-3">
                                <input type="checkbox" name="5" value="5"
                                    class="w-5 h-5 text-blue-600 bg-gray-200 border-gray-300 rounded focus:ring-blue-500 focus:ring-2"
                                    id="" />
                                <label for="second_checkbox" class="ml-3 text-sm text-gray-700">Pag-ibig
                                    Contribution</label>
                            </div>

                            <div class="flex items-center mb-3">
                                <input type="checkbox" name="compute_13th_month" value="13"
                                    class="w-5 h-5 text-blue-600 bg-gray-200 border-gray-300 rounded focus:ring-blue-500 focus:ring-2"
                                    id="compute_13th_month" {{ old('compute_13th_month') ? 'checked' : '' }} />
                                <label for="compute_13th_month" class="ml-3 text-sm text-gray-700">Compute 13th Month
                                    Pay</label>
                            </div>

                            <div class="mb-3" id="yearContainer"
                                style="display: {{ old('compute_13th_month') ? 'block' : 'none' }};">
                                <select name="year" id="year"
                                    class="mt-1 block px-3 w-[10rem] bg-white border-2 border-black rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm">
                                    @php
                                        $currentYear = now()->year;
                                    @endphp
                                    @for ($i = $currentYear; $i >= $currentYear - 10; $i--)
                                        <option value="{{ $i }}" {{ old('year') == $i ? 'selected' : '' }}>
                                            {{ $i }}</option>
                                    @endfor
                                </select>
                            </div>

                            <script>
                                document.getElementById("compute_13th_month").addEventListener("change", function() {
                                    document.getElementById("yearContainer").style.display = this.checked ? "block" : "none";
                                });
                            </script>



                            <div class="flex items-center mb-3">
                                <input type="checkbox" name="6" value="6"
                                    class="w-5 h-5 text-blue-600 bg-gray-200 border-gray-300 rounded focus:ring-blue-500 focus:ring-2"
                                    id="" />
                                <label for="second_checkbox" class="ml-3 text-sm text-gray-700">Compute for Income Tax
                                    Withheld
                                </label>
                            </div>
                            <div class="flex items-center mb-3">
                                <input type="checkbox" name="7" value="7"
                                    class="w-5 h-5 text-blue-600 bg-gray-200 border-gray-300 rounded focus:ring-blue-500 focus:ring-2"
                                    id="" />
                                <label for="second_checkbox" class="ml-3 text-sm text-gray-700">Enable Premium Limits
                                </label>
                            </div>
                            <div class="flex items-center mb-3">
                                <input type="checkbox" name="10" value="10"
                                    class="w-5 h-5 text-blue-600 bg-gray-200 border-gray-300 rounded focus:ring-blue-500 focus:ring-2"
                                    id="" />
                                <label for="second_checkbox" class="ml-3 text-sm text-gray-700">Disable all Loans and
                                    Allowance
                                </label>
                            </div>


                        </div>
                        <div class="flex justify-center ">
                            <button type="submit" id="submit_button"
                                class="px-4 py-2 mt-4 text-white bg-blue-600 rounded-md">
                                <div class="flex items-center justify-center gap-2">
                                    <div>Create Payroll</div>

                                    <div id="loading-overlay"
                                        class="flex items-center hidden justify-center  mt-4 mb-4">
                                        <div
                                            class="inline-block w-5 h-5 border-4 border-white rounded-full spinner-border animate-spin border-t-transparent">
                                        </div>

                                    </div>
                                </div>

                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    document.getElementById('submit_button').addEventListener('click', function(event) {
        // Check if at least one checkbox is selected
        var firstChecked = document.getElementById('first_checkbox').checked;
        var secondChecked = document.getElementById('second_checkbox').checked;

        // Access the error message element
        var errorMessage = document.getElementById('error_message');

        if (!firstChecked && !secondChecked) {
            event.preventDefault(); // Prevent form submission
            errorMessage.style.display = 'block'; // Show error message
        } else {
            errorMessage.style.display = 'none'; // Hide error message if form is valid
        }
    });
</script>
@include('Admin.Payroll.check.js')
