@extends('layouts.sidebar')

@section('title', 'Final Payroll')
@section('content')
    @if (in_array('Manage Payroll', $privileges))
        <div class="flex flex-col justify-between py-5 md:flex-row">

            <p class="mb-4 font-bold">Final Payroll</p>
        </div>
        @if (session('success'))
            <div class="p-4 mb-4 text-white bg-green-500">
                {{ session('success') }}
            </div>
        @endif
        <div class="p-2 overflow-auto border-2 border-black rounded-md ">
            <table id="billing-table" class="min-w-full bg-white border border-gray-200 rounded shadow-md">
                <thead>
                    <tr class="text-sm leading-normal text-white bg-black">
                        <th class="px-6 ">Batch Code</th>
                        <th class="px-6 ">Client</th>
                        <th class="px-6 ">Payroll Prepared by</th>
                        <th class="px-6 ">Payroll Approved by</th>
                        <th class="px-6 ">Pay Period </th>

                        <th class="px-6 ">Number of Employee</th>

                        <th class="px-6 ">Actions</th>
                    </tr>
                </thead>
                <tbody class="text-sm font-light text-center text-gray-600">

                </tbody>
            </table>
        </div>

        <script>
            $(document).ready(function() {
                var employedTable = $('#billing-table').DataTable({
                    processing: true,
                    serverSide: true,
                    ajax: {
                        url: "{{ route('finalpayroll.index') }}",
                        data: function(d) {
                            // Custom data if needed
                        }
                    },
                    columns: [{
                            data: 'id',
                            name: 'id',
                            width: '10%' // Set the width for the ID column
                        },
                        {
                            data: 'client.department_name',
                            name: 'client.department_name',
                            width: '10%' // Set the width for the Client Business Name column
                        },
                        {
                            data: 'approve_by',
                            name: 'approve_by',
                            width: '10%' // Set the width for the Approve By column
                        },
                        {
                            data: 'approve_by1',
                            name: 'approve_by1',
                            width: '10%' // Set the width for the Approve By column
                        },
                        {
                            data: 'pay_period',
                            name: 'pay_period',
                            width: '10%' // Set the width for the Pay Period Start column
                        },

                        {
                            data: 'employee_count',
                            name: 'employee_count',
                            width: '10%' // Set the width for the Employee Count column
                        },


                        {
                            data: 'action', // Matches the action column from your server response
                            name: 'action',
                            orderable: false,
                            searchable: false,
                            width: '10%' // Set the width for the Action column
                        }
                    ],
                    order: [
                        [0, 'desc'] // Orders by the first column (ID) in descending order
                    ]
                });
            });
        </script>
    @else
        <div class="flex items-center justify-center w-full h-full my-2">
            <div>
                <i class="mr-2 text-3xl bx bx-lock"></i> <!-- Large lock icon indicating no access -->
                <span class="text-gray-500">You don't have privilege to access this page</span>
            </div>

        </div>
    @endif
@endsection
