@extends('layouts.sidebar')
@section('title', 'Payroll')
@section('content')
    @if (in_array('Payroll Checking', $privileges) ||
            in_array('Payroll Approve', $privileges) ||
            in_array('View Payroll', $privileges))


        <div class="py-3 text-sm text-center">
            <div class="flex items-center justify-center">
                <img class="w-32" src="{{ asset($data->client->client->agency->contact_person) }}">
            </div>
            <h1 class="font-bold ">{{ $data->client->client->agency->name }} </h1>
            <p class="font-bold ">
                {{ $data->client->department_name }} Summary Payroll report with Batch ID: {{ $batch_id }}
            </p>
            <p class="font-bold ">Period Cover: {{ \Carbon\Carbon::parse($data->pay_period_start)->format('F j, Y') }}
                to
                {{ \Carbon\Carbon::parse($data->pay_period_end)->format('F j, Y') }}</p>
        </div>

        @if (session('success'))
            <div class="p-4 mb-4 text-white bg-green-500">
                {{ session('success') }}
            </div>
        @endif
        <div class="flex justify-end p-5 text-sm gap-3">
            {{-- <div>
                <label for="display_late">
                    <input type="checkbox" id="display_late" {{ $data->display_late ? 'checked' : '' }}
                        onchange="toggleDisplayLate({{ $data->id }})">
                    Display Late
                </label>
            </div> --}}
            <script>
                function toggleDisplayLate(batchcodeId) {
                    const isChecked = document.getElementById('display_late').checked;

                    axios.post("{{ route('batchcode.toggleDisplayLate', ['id' => '__id__']) }}".replace('__id__', batchcodeId), {
                            display_late: isChecked ? 1 : 0
                        })
                        .then(response => {
                            console.log('Updated:', response.data);
                            $('#payrollsDataTable').DataTable().ajax.reload(null,
                                false);
                        })
                        .catch(error => {
                            console.error('Error updating display_late:', error);
                        });
                }
            </script>
            <div><a href="{{ route('payroll.report.download', ['batchId' => $batch_id, 'clientId' => $data->client->id]) }}"
                    class="px-4 py-2 text-white bg-blue-500 rounded-md">
                    Download Payroll Report
                </a></div>

        </div>

        <div class="overflow-hidden ">
            <table id="payrollsDataTable" class="min-w-full border border-collapse border-gray-200 rounded shadow-md">
                <thead>
                    <tr class="text-sm leading-normal uppercase ">
                        <th>ID</th>
                        <th>Employee Name</th>
                        <th class="">Rate</th>
                        <th class="">Earnings</th>
                        <th class="">Deductions</th>
                        <th class="">netpay</th>
                        <th class="bg-yellow-300">Action</th>
                    </tr>
                </thead>
                <tbody class="text-sm font-light text-center text-gray-600">
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="2" class="text-center">Total</th>
                        <th class="text-center" id="totalRate">0</th>
                        <th class="text-center" id="totalEarnings">0</th>
                        <th class="text-center" id="totalDeductions">0</th>
                        <th class="text-center" id="totalNetPay">0</th>
                        <th class="text-center"></th>
                    </tr>
                </tfoot>
            </table>
        </div>



        <div class="grid grid-cols-5 gap-10 overflow-auto ">

            <div class="col-span-3">
                <p class="mt-5 mb-2 text-xs font-bold">SUMMARY</p>
                <table class="max-w-full min-w-full rounded-lg shadow-md">
                    <thead class="border-2 border-black">
                        <tr class="text-sm text-gray-700">
                            <th class="px-4 border-b">Trx Name</th>
                            <th class="px-4 border-b">Earnings</th>
                            <th class="px-4 border-b">Deduction</th>
                        </tr>
                    </thead>
                    <tbody class="text-xs font-light text-center text-gray-600 border-b-2 border-black">
                        @php
                            $earningsRows = [];
                            $deductionRows = [];
                            $totalEarnings = 0;
                            $totalDeductions = 0;

                            // === Basic Salary (Earnings) ===
                            $basicSalaryTotal = 0;
                            $days = 0;
                            foreach ($payrolls as $payroll) {
                                $basicSalaryTotal += $payroll->basic_salary;
                                $days += $payroll->days_worked_withdeduction;
                            }
                            $earningsRows[] = [
                                'name' => 'Basic Salary - ' . number_format($days, 2),
                                'amount' => $basicSalaryTotal,
                            ];
                            $totalEarnings += $basicSalaryTotal;

                            // === Others (Earnings) ===
                            $groupedOthers = [];
                            foreach ($payrolls as $payroll) {
                                foreach ($payroll->othersForPayroll as $earning) {
                                    $key = trim($earning->name ?: 'Other');
                                    $groupedOthers[$key] = ($groupedOthers[$key] ?? 0) + $earning->amount;
                                }
                            }
                            foreach ($groupedOthers as $name => $amount) {
                                $earningsRows[] = ['name' => $name, 'amount' => $amount];
                                $totalEarnings += $amount;
                            }

                            // === Benefits (Deductions) ===
                            $groupedBenefits = [];
                            foreach ($payrolls as $payroll) {
                                foreach ($payroll->benefits as $benefit) {
                                    $key = trim($benefit->name ?: $benefit->description ?: $benefit->type);
                                    $groupedBenefits[$key] = ($groupedBenefits[$key] ?? 0) + $benefit->employee_share;
                                }
                            }
                            foreach ($groupedBenefits as $key => $totalShare) {
                                $deductionRows[] = ['name' => $key, 'amount' => $totalShare];
                                $totalDeductions += $totalShare;
                            }

                            // === Grouped Deductions & Earnings ===
                            $cleanGrouped = [];
                            foreach ($groupedDeductions as $group) {
                                $desc = trim($group['description']);
                                if (!isset($cleanGrouped[$desc])) {
                                    $cleanGrouped[$desc] = ['earnings' => 0, 'deductions' => 0];
                                }
                                $cleanGrouped[$desc]['earnings'] += $group['earnings'];
                                $cleanGrouped[$desc]['deductions'] += $group['deductions'];
                            }
                            foreach ($cleanGrouped as $desc => $values) {
                                if ($values['earnings'] > 0) {
                                    $earningsRows[] = ['name' => $desc, 'amount' => $values['earnings']];
                                    $totalEarnings += $values['earnings'];
                                }
                                if ($values['deductions'] > 0) {
                                    $deductionRows[] = ['name' => $desc, 'amount' => $values['deductions']];
                                    $totalDeductions += $values['deductions'];
                                }
                            }

                            // === Loans (Deductions) ===
                            $groupedLoans = [];
                            foreach ($payrolls as $payroll) {
                                foreach ($payroll->trxLoanDeductions as $loan) {
                                    $desc = optional(App\Models\TrxCode::find($loan->trxLoan->group_code_id))
                                        ->description;
                                    $desc = trim(preg_replace('/\s+/', ' ', $desc));
                                    $groupedLoans[$desc] = ($groupedLoans[$desc] ?? 0) + $loan->Amount;
                                }
                            }
                            foreach ($groupedLoans as $desc => $amount) {
                                $deductionRows[] = ['name' => $desc, 'amount' => $amount];
                                $totalDeductions += $amount;
                            }

                            // === Sort earnings & deductions by name ascending ===
                            usort($earningsRows, fn($a, $b) => strcasecmp($a['name'], $b['name']));
                            usort($deductionRows, fn($a, $b) => strcasecmp($a['name'], $b['name']));
                        @endphp

                        {{-- Earnings Rows --}}
                        @foreach ($earningsRows as $row)
                            <tr class="hover:bg-gray-100">
                                <td class="px-4 py-2 border-b">{{ $row['name'] }}</td>
                                <td class="px-4 py-2 border-b">₱{{ number_format($row['amount'], 2) }}</td>
                                <td class="px-4 py-2 border-b"></td>
                            </tr>
                        @endforeach

                        {{-- Deductions Rows --}}
                        @foreach ($deductionRows as $row)
                            <tr class="hover:bg-gray-100">
                                <td class="px-4 py-2 border-b">{{ $row['name'] }}</td>
                                <td class="px-4 py-2 border-b"></td>
                                <td class="px-4 py-2 border-b">₱{{ number_format($row['amount'], 2) }}</td>
                            </tr>
                        @endforeach
                    </tbody>

                    <tfoot class="text-sm font-bold text-center text-gray-700 bg-gray-100">
                        <tr>
                            <td class="px-4 py-3 border-t">Total</td>
                            <td class="px-4 py-3 border-t">₱{{ number_format($totalEarnings, 2) }}</td>
                            <td class="px-4 py-3 border-t">₱{{ number_format($totalDeductions, 2) }}</td>
                        </tr>
                    </tfoot>
                </table>






            </div>
            <div class="flex flex-col items-center justify-center col-span-2 gap-3">
                <form id="payrollForm" method="POST" action="{{ route('update.batch.status') }}">
                    @csrf
                    <div class="hidden mb-4">
                        <label for="id" class="block text-sm font-medium text-gray-700">Batch ID:</label>
                        <input type="text" name="id" id="id"
                            class="block w-full mt-1 border border-gray-300 rounded-md shadow-sm focus:ring-blue-500 focus:border-blue-500"
                            required value="{{ $batch_id }}">
                    </div>

                    @if ($data->status == '0')
                        <div class="flex items-center justify-center">
                            <button type="button" onclick="openConfirmationModal()"
                                class=" py-2 w-[15rem] font-semibold text-white bg-blue-600 rounded-md shadow-sm hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500">
                                CLOSE PAYROLL
                            </button>
                        </div>
                    @endif
                    @if (in_array('Payroll Approve', $privileges))
                        @if ($data->status == '1')
                            <div class="flex items-center justify-center">
                                <button type="button" onclick="openConfirmationModal()"
                                    class=" py-2 w-[15rem] font-semibold text-white bg-blue-600 rounded-md shadow-sm hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500">
                                    Approved
                                </button>
                            </div>
                        @endif
                    @else
                    @endif
                </form>
                @if (in_array('Payroll Approve', $privileges))
                    @if ($data->status != '0')
                        <form method="POST" action="{{ route('admin.updatebatch', $batch_id) }}">
                            @csrf
                            @method('POST')
                            <!-- This is required if you're using a PUT/PATCH request, but for POST it can be omitted -->
                            <button
                                class=" py-2 w-[15rem] font-semibold text-white bg-blue-600 rounded-md shadow-sm hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500"
                                type="submit">Back to Checking</button>
                        </form>
                    @endif
                @endif

            </div>

        </div>


        @if ($data->status !== '0')
            <div class="flex gap-20 mt-20">
                @if ($prepared && $prepared->user)
                    <p>Prepared By: <strong>{{ $prepared->user->name }}</strong></p>
                @endif

                @if ($approved && $approved->user)
                    <p>Approved By: <strong>{{ $approved->user->name }}</strong></p>
                @endif
            </div>
        @endif




        <!-- Confirmation Modal -->
        <div id="confirmationModal"
            class="fixed inset-0 z-50 flex items-start justify-center hidden bg-black bg-opacity-50">
            <div class="w-auto p-6 mt-10 bg-white rounded-lg shadow-lg">
                <h2 class="mb-4 text-lg font-bold">Confirm Action</h2>
                <p class="mb-6 text-gray-700">Are you sure you want to save this as the final payroll?</p>
                <div class="flex justify-end gap-4">
                    <button onclick="closeConfirmationModal()"
                        class="px-4 py-2 text-gray-700 bg-gray-200 rounded-md hover:bg-gray-300 focus:outline-none">
                        Cancel
                    </button>
                    <button onclick="submitPayrollForm1()"
                        class="px-4 py-2 text-white bg-blue-600 rounded-md hover:bg-blue-700 focus:outline-none">
                        Confirm
                    </button>
                </div>
            </div>
        </div>





        <script>
            // Open the confirmation modal
            function openConfirmationModal() {
                document.getElementById('confirmationModal').classList.remove('hidden');
            }

            // Close the confirmation modal
            function closeConfirmationModal() {
                document.getElementById('confirmationModal').classList.add('hidden');
            }

            // Submit the form upon confirmation
            function submitPayrollForm1() {
                document.getElementById('payrollForm').submit();
            }
        </script>
        @include('Admin.Payroll.payrollbatch.modal')
    @else
        <div class="flex items-center justify-center w-full h-full my-2">
            <div>
                <i class="mr-2 text-3xl bx bx-lock"></i> <!-- Large lock icon indicating no access -->
                <span class="text-gray-500">You don't have privilege to access this page</span>
            </div>

        </div>
    @endif





@endsection
