<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title>Benefits Report</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 11px;
            color: #333;
            margin: 20px;
        }

        h1 {
            text-align: center;
            font-size: 16px;
            margin-bottom: 4px;
        }

        p {
            text-align: center;
            font-size: 11px;
            color: #666;
            margin-bottom: 12px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
            font-size: 10px;
        }

        th,
        td {
            border: 1px solid #ccc;
            padding: 6px 8px;
            text-align: left;
        }

        th {
            background: #f3f3f3;
            font-weight: bold;
        }

        tr:nth-child(even) {
            background: #fafafa;
        }

        .text-right {
            text-align: right;
        }

        .total-row th {
            background: #eaeaea;
            font-weight: bold;
        }
    </style>
</head>

<body>
    <!-- Header -->
    <h1>Benefits Report</h1>
    <p>
        @if ($start_date && $end_date)
            Period: {{ \Carbon\Carbon::parse($start_date)->format('M d, Y') }}
            - {{ \Carbon\Carbon::parse($end_date)->format('M d, Y') }}
        @else
            All Records
        @endif

        @if ($employee)
            <br>Employee: {{ $employee->last_name }}, {{ $employee->first_name }}
        @endif

        @if ($type)
            <br>Contribution Type: {{ $type }}
        @endif
    </p>

    <!-- Table -->
    <table>
        <thead>
            <tr>
                <th style="width:5%">#</th>
                <th style="width:35%">Employee</th>
                <th style="width:20%">Type</th>
                <th style="width:20%" class="text-right">Employee Share</th>
                <th style="width:20%" class="text-right">Employer Share</th>
            </tr>
        </thead>
        <tbody>
            @php
                $totalEmployee = 0;
                $totalEmployer = 0;
            @endphp
            @foreach ($benefits as $index => $benefit)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $benefit->payroll->employee->last_name }}, {{ $benefit->payroll->employee->first_name }}</td>
                    <td>{{ $benefit->type }}</td>
                    <td class="text-right">{{ number_format($benefit->employee_share, 2) }}</td>
                    <td class="text-right">{{ number_format($benefit->employer_share, 2) }}</td>
                </tr>
                @php
                    $totalEmployee += $benefit->employee_share;
                    $totalEmployer += $benefit->employer_share;
                @endphp
            @endforeach

            <!-- Totals -->
            <tr class="total-row">
                <th colspan="3" class="text-right">TOTAL</th>
                <th class="text-right">{{ number_format($totalEmployee, 2) }}</th>
                <th class="text-right">{{ number_format($totalEmployer, 2) }}</th>
            </tr>
        </tbody>
    </table>
</body>

</html>
