<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Employee Department Report</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 11px;
            color: #333;
            margin: 20px;
        }

        h1 {
            font-size: 16px;
            text-align: center;
            margin-bottom: 4px;
        }

        p {
            text-align: center;
            font-size: 11px;
            color: #666;
            margin-bottom: 16px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 8px;
        }

        th,
        td {
            border: 1px solid #ccc;
            padding: 4px 6px;
            text-align: left;
        }

        th {
            background: #f3f3f3;
            font-weight: bold;
        }

        tr:nth-child(even) {
            background: #fafafa;
        }

        .text-center {
            text-align: center;
        }

        .italic {
            font-style: italic;
            color: #999;
        }
    </style>
</head>

<body>
    <!-- Header -->
    <h1>Employee Department Report</h1>
    <p>List of employees with their departments and key details</p>

    <!-- Table -->
    <table>
        <thead>
            <tr>
                <th style="width: 3%">#</th>
                <th style="width: 18%">Employee Name</th>
                <th style="width: 15%">Departments</th>
                <th style="width: 10%">DOB</th>
                <th style="width: 5%">Age</th>
                <th style="width: 20%">Address</th>
                <th style="width: 10%">TIN</th>
                <th style="width: 10%">SSS</th>
                <th style="width: 9%">Pag-IBIG</th>
                <th style="width: 10%">PhilHealth</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($employees as $index => $employee)
                <tr>
                    <td class="text-center">{{ $index + 1 }}</td>
                    <td>{{ $employee->last_name }}, {{ $employee->first_name }} {{ $employee->middle_name }}</td>
                    <td>
                        @if ($employee->channelclient->isEmpty())
                            <span class="italic">Not assigned</span>
                        @else
                            @foreach ($employee->channelclient as $channel)
                                {{ $channel->department->department_name ?? 'Unknown' }}
                                @if ($channel->status != 1)
                                    (Inactive)
                                @endif
                                @if (!$loop->last)
                                    ,
                                @endif
                            @endforeach
                        @endif
                    </td>
                    <td>
                        {{ $employee->date_of_birth ? \Carbon\Carbon::parse($employee->date_of_birth)->format('M d, Y') : '-' }}
                    </td>
                    <td>
                        {{ $employee->date_of_birth ? \Carbon\Carbon::parse($employee->date_of_birth)->age : '-' }}
                    </td>
                    <td>{{ $employee->present_address ?? '-' }}</td>
                    <td>{{ $employee->tin_no ?? '-' }}</td>
                    <td>{{ $employee->sss_no ?? '-' }}</td>
                    <td>{{ $employee->pagibig_no ?? '-' }}</td>
                    <td>{{ $employee->philhealth_no ?? '-' }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>

</html>
